/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.hapifhir;

import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.hapi.rest.server.ServerCapabilityStatementProvider;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.UriType;

public class SMARTServerCapabilityStatementProvider
extends ServerCapabilityStatementProvider {
    private String tokenAddress;
    private String registerAddress;
    private List<Consumer<CapabilityStatement>> postProcessSteps;

    public SMARTServerCapabilityStatementProvider(String tokenAddress, String registerAddress) {
        this.tokenAddress = tokenAddress;
        this.registerAddress = registerAddress;
        this.postProcessSteps = new LinkedList<Consumer<CapabilityStatement>>();
    }

    public SMARTServerCapabilityStatementProvider with(Consumer<CapabilityStatement> function) {
        this.postProcessSteps.add(function);
        return this;
    }

    public CapabilityStatement getServerConformance(HttpServletRequest request, RequestDetails requestDetails) {
        CapabilityStatement c = super.getServerConformance(request, requestDetails);
        CapabilityStatement.CapabilityStatementRestSecurityComponent securityComponent = this.buildSecurityComponent();
        List restComponents = c.getRest();
        CapabilityStatement.CapabilityStatementRestComponent rest = null;
        for (CapabilityStatement.CapabilityStatementRestComponent rc : restComponents) {
            if (!rc.getMode().equals((Object)CapabilityStatement.RestfulCapabilityMode.SERVER)) continue;
            rest = rc;
            break;
        }
        if (rest == null) {
            rest = new CapabilityStatement.CapabilityStatementRestComponent();
            rest.setMode(CapabilityStatement.RestfulCapabilityMode.SERVER);
            rest.setSecurity(securityComponent);
            c.addRest(rest);
        } else {
            rest.setSecurity(securityComponent);
        }
        this.postProcessSteps.forEach(step -> step.accept(c));
        return c;
    }

    private CapabilityStatement.CapabilityStatementRestSecurityComponent buildSecurityComponent() {
        CapabilityStatement.CapabilityStatementRestSecurityComponent securityComponent = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        Extension oauthExtension = new Extension();
        oauthExtension.setUrl("http://fhir-registry.smarthealthit.org/StructureDefinition/oauth-uris");
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        if (this.registerAddress != null) {
            extensions.add(new Extension("register", (IBaseDatatype)new UriType(this.registerAddress)));
        }
        extensions.add(new Extension("token", (IBaseDatatype)new UriType(this.tokenAddress)));
        oauthExtension.setExtension(extensions);
        securityComponent.addExtension(oauthExtension);
        return securityComponent;
    }
}

