/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.hapifhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.MessageHeader;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.mitre.hapifhir.MessageContext;

public class ProcessMessageProvider {
    private FhirContext fhirContext;
    private Function<MessageContext, Bundle> action;

    public ProcessMessageProvider(FhirContext fhirContext, Function<MessageContext, Bundle> action) {
        this.fhirContext = fhirContext;
        this.action = action;
    }

    public static OperationOutcome validateRequest(Bundle requestBundle) {
        if (requestBundle.getType() != Bundle.BundleType.MESSAGE) {
            OperationOutcome oo = new OperationOutcome();
            oo.addIssue().setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics("Bundle is not of type 'message'");
            return oo;
        }
        if (!requestBundle.hasEntry()) {
            OperationOutcome oo = new OperationOutcome();
            oo.addIssue().setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics("Bundle has no entries, a MessageHeader is required");
            return oo;
        }
        Resource firstResource = requestBundle.getEntryFirstRep().getResource();
        if (firstResource.getResourceType() != ResourceType.MessageHeader) {
            OperationOutcome oo = new OperationOutcome();
            oo.addIssue().setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics("First resource in message bundle must be of type 'MessageHeader'");
            return oo;
        }
        MessageHeader msgHead = (MessageHeader)firstResource;
        if (!msgHead.hasSource()) {
            OperationOutcome oo = new OperationOutcome();
            oo.addIssue().setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics("'MessageHeader' is missing source");
            return oo;
        }
        if (!msgHead.getSource().hasEndpoint()) {
            OperationOutcome oo = new OperationOutcome();
            oo.addIssue().setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics("'MessageHeader.source' is missing an endpoint");
            return oo;
        }
        return null;
    }

    @Operation(name="$process-message", manualResponse=true)
    public void processMessage(@OptionalParam(name="async") String async, @OptionalParam(name="response-url") String responseUrl, @ResourceParam Bundle bundleR4, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) {
        IParser parser = this.fhirContext.newJsonParser();
        OperationOutcome error = ProcessMessageProvider.validateRequest(bundleR4);
        if (error != null) {
            this.respondWithResource((IBaseResource)error, theServletResponse, parser);
            return;
        }
        MessageHeader msgHead = (MessageHeader)bundleR4.getEntryFirstRep().getResource();
        MessageContext messageContext = new MessageContext();
        messageContext.bundle = bundleR4;
        messageContext.messageHeader = msgHead;
        messageContext.request = theServletRequest;
        if (async != null && async.equals("true")) {
            String asyncResponseUrl = responseUrl != null ? responseUrl : msgHead.getSource().getEndpoint();
            Thread newThread = new Thread(() -> {
                Bundle response = this.action.apply(messageContext);
                String bundleString = parser.encodeResourceToString((IBaseResource)response);
                this.makePost(asyncResponseUrl, bundleString);
            });
            newThread.start();
            theServletResponse.setStatus(200);
            try {
                theServletResponse.getWriter().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Bundle response = this.action.apply(messageContext);
            this.respondWithResource((IBaseResource)response, theServletResponse, parser);
        }
    }

    private void makePost(String asyncResponseUrl, String content) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(asyncResponseUrl);
        try {
            StringEntity entity = new StringEntity(content);
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Content-type", "application/json");
            httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void respondWithResource(IBaseResource resource, HttpServletResponse theServletResponse, IParser parser) {
        theServletResponse.setContentType("application/json");
        try {
            String data = parser.encodeResourceToString(resource);
            theServletResponse.getWriter().write(data);
            theServletResponse.getWriter().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

