/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.hapifhir;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MessageHeader;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.json.JSONArray;
import org.json.JSONObject;

public class MedMorphToCIBMTR {
    private static final String CCN_SYSTEM = "http://cibmtr.org/codesystem/transplant-center";
    private static final String CRID_SYSTEM = "http://cibmtr.org/identifier/CRID";
    private static final String RESOURCE_IDENTIFIER_SYSTEM = "urn:ietf:rfc:3986";
    private String cibmtrUrl;
    private ResponseHandler<String> getResponseHandler = response -> {
        int status = response.getStatusLine().getStatusCode();
        if (status != 200) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
    };

    public MedMorphToCIBMTR(String cibmtrUrl) {
        this.cibmtrUrl = cibmtrUrl;
        if (!this.cibmtrUrl.endsWith("/")) {
            this.cibmtrUrl = this.cibmtrUrl + "/";
        }
    }

    public OperationOutcome convert(Bundle medmorphReport, MessageHeader messageHeader, String authToken) {
        if (medmorphReport.hasEntry() && medmorphReport.getEntry().size() >= 2) {
            String resourceId;
            Number crid;
            LinkedList<String> diagnostics = new LinkedList<String>();
            List reportEntries = medmorphReport.getEntry();
            Bundle contentBundle = (Bundle)((Bundle.BundleEntryComponent)reportEntries.get(1)).getResource();
            List contentEntries = contentBundle.getEntry();
            Bundle.BundleEntryComponent patientEntry = contentEntries.stream().filter(entry -> entry.getResource().getResourceType() == ResourceType.Patient).findAny().orElse(null);
            String ccn = this.getCcn(reportEntries, messageHeader);
            if (patientEntry == null || ccn == null) {
                return this.createOperationOutcome(false, "required", "Patient resource and Organization resource with ccn value are required in report bundle.", null);
            }
            Patient patient = (Patient)patientEntry.getResource();
            try {
                crid = this.getCrid(authToken, ccn, patient);
            }
            catch (Exception e) {
                return this.createOperationOutcome(false, "processing", "Request for CRID was not successful.", e);
            }
            diagnostics.add("CRID response successful - received value: " + crid);
            boolean isPatientNew = false;
            try {
                resourceId = this.checkIfPatientExists(authToken, ccn, crid.toString());
                if (resourceId == null) {
                    isPatientNew = true;
                    resourceId = this.postPatient(authToken, ccn, crid.toString());
                    diagnostics.add("Patient for CRID did not already exist");
                }
            }
            catch (Exception e) {
                return this.createOperationOutcome(false, "processing", "Posting Patient resource and retrieving resource ID was not successful.", e);
            }
            if (resourceId == null) {
                return this.createOperationOutcome(false, "processing", "Posting Patient resource and retrieving resource ID was not successful.", null);
            }
            diagnostics.add("Patient resource ID: " + resourceId);
            try {
                int numObsPosted = this.postBundle(authToken, ccn, contentEntries, resourceId, isPatientNew);
                diagnostics.add("Number of observations posted: " + numObsPosted);
            }
            catch (Exception e) {
                return this.createOperationOutcome(false, "processing", "Posting Observations as a Bundle was not successful.", e);
            }
            return this.createOperationOutcome(true, "informational", String.join((CharSequence)"\n", diagnostics), null);
        }
        return this.createOperationOutcome(false, "required", "Submitted report bundle must contain 2 entries", null);
    }

    protected Number getCrid(String authToken, String ccn, Patient patient) throws Exception {
        Throwable throwable = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPut httpPut = new HttpPut(this.cibmtrUrl + "CRID");
            httpPut.setHeader("Accept", "application/json");
            httpPut.setHeader("Content-type", "application/json");
            httpPut.setHeader("Authorization", authToken);
            JSONObject cridRequestBody = new JSONObject();
            cridRequestBody.put("ccn", (Object)ccn);
            JSONObject patientJson = new JSONObject();
            patientJson.put("firstName", ((HumanName)patient.getName().get(0)).getGiven().get(0));
            patientJson.put("lastName", (Object)((HumanName)patient.getName().get(0)).getFamily());
            patientJson.put("birthDate", (Object)patient.getBirthDate().toString());
            patientJson.put("gender", (Object)patient.getGender().getDisplay());
            cridRequestBody.put("patient", (Object)patientJson);
            StringEntity stringEntity = new StringEntity(cridRequestBody.toString());
            httpPut.setEntity((HttpEntity)stringEntity);
            ResponseHandler responseHandler = response -> {
                HttpEntity entity = response.getEntity();
                return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
            };
            String responseBody = (String)httpClient.execute((HttpUriRequest)httpPut, responseHandler);
            JSONObject responseObj = new JSONObject(responseBody.toString());
            JSONArray perfectMatch = responseObj.getJSONArray("perfectMatch");
            if (!perfectMatch.isEmpty()) {
                Number number = perfectMatch.getJSONObject(0).getNumber("crid");
                return number;
            }
            try {
                throw new Exception("Unexpected CRID response format: " + responseBody);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected String checkIfPatientExists(String authToken, String ccn, String crid) throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            JSONObject responseObj;
            HttpGet httpGet = new HttpGet(this.cibmtrUrl + "Patient?_security=" + CCN_SYSTEM + "%7Crc_" + ccn + "&identifier=" + crid);
            httpGet.setHeader("Content-Type", "application/fhir+json");
            httpGet.setHeader("Authorization", authToken);
            String responseBody = (String)httpClient.execute((HttpUriRequest)httpGet, this.getResponseHandler);
            if (responseBody != null && (responseObj = new JSONObject(responseBody.toString())).getInt("total") > 0) {
                String string = responseObj.getJSONArray("entry").getJSONObject(0).getJSONObject("resource").getString("id");
                return string;
            }
            String string = null;
            return string;
        }
    }

    protected String postPatient(String authToken, String ccn, String crid) throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.cibmtrUrl + "Patient");
            httpPost.setHeader("Content-Type", "application/fhir+json");
            httpPost.setHeader("Authorization", authToken);
            JSONObject patientRequestBody = new JSONObject();
            patientRequestBody.put("resourceType", (Object)"Patient");
            patientRequestBody.put("meta", (Object)this.buildMeta(ccn));
            patientRequestBody.put("text", (Object)new JSONObject().put("status", (Object)"empty"));
            JSONArray identifierArray = new JSONArray();
            JSONObject identifierObject = new JSONObject();
            identifierObject.put("use", (Object)"official");
            identifierObject.put("system", (Object)CRID_SYSTEM);
            identifierObject.put("value", (Object)crid);
            identifierArray.put((Object)identifierObject);
            patientRequestBody.put("identifier", (Object)identifierArray);
            StringEntity stringEntity = new StringEntity(patientRequestBody.toString());
            httpPost.setEntity((HttpEntity)stringEntity);
            ResponseHandler responseHandler = response -> {
                String location;
                int index;
                int status = response.getStatusLine().getStatusCode();
                if ((status == 200 || status == 201) && (index = (location = response.getFirstHeader("Location").getValue()).indexOf("Patient/")) > 0) {
                    return location.substring(index + 8);
                }
                return null;
            };
            String string = (String)httpClient.execute((HttpUriRequest)httpPost, responseHandler);
            return string;
        }
    }

    protected int postBundle(String authToken, String ccn, List<Bundle.BundleEntryComponent> entries, String resourceId, boolean isPatientNew) throws Exception {
        List<Bundle.BundleEntryComponent> observationEntries = entries.stream().filter(entry -> entry.getResource().getResourceType() == ResourceType.Observation).collect(Collectors.toList());
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.cibmtrUrl + "Bundle");
            httpPost.setHeader("Content-Type", "application/fhir+json");
            httpPost.setHeader("Authorization", authToken);
            JSONObject bundleRequestBody = new JSONObject();
            bundleRequestBody.put("resourceType", (Object)"Bundle");
            bundleRequestBody.put("type", (Object)"transaction");
            JSONArray observationArray = this.getObservationEntries(httpClient, authToken, ccn, observationEntries, resourceId, isPatientNew);
            if (observationArray.isEmpty()) {
                int n = 0;
                return n;
            }
            bundleRequestBody.put("entry", (Object)observationArray);
            StringEntity stringEntity = new StringEntity(bundleRequestBody.toString());
            httpPost.setEntity((HttpEntity)stringEntity);
            httpClient.execute((HttpUriRequest)httpPost);
            int n = observationArray.length();
            return n;
        }
    }

    protected JSONArray getObservationEntries(CloseableHttpClient httpClient, String authToken, String ccn, List<Bundle.BundleEntryComponent> observationEntries, String resourceId, boolean isPatientNew) throws Exception {
        JSONArray entryArray = new JSONArray();
        for (Bundle.BundleEntryComponent entry : observationEntries) {
            if (!entry.hasFullUrl()) continue;
            String fullUrl = entry.getFullUrl();
            if (!isPatientNew) {
                JSONObject responseObj;
                HttpGet httpGet = new HttpGet(this.cibmtrUrl + "Observation?identifier=" + fullUrl);
                httpGet.setHeader("Content-Type", "application/fhir+json");
                httpGet.setHeader("Authorization", authToken);
                String responseBody = (String)httpClient.execute((HttpUriRequest)httpGet, this.getResponseHandler);
                if (responseBody != null && (responseObj = new JSONObject(responseBody.toString())).getInt("total") > 0) continue;
            }
            JSONObject observationObject = new JSONObject();
            JSONObject requestObject = new JSONObject();
            requestObject.put("method", (Object)"POST");
            requestObject.put("url", (Object)"Observation");
            observationObject.put("request", (Object)requestObject);
            Observation observation = (Observation)entry.getResource();
            JSONObject observationResourceObject = new JSONObject();
            observationResourceObject.put("resourceType", (Object)"Observation");
            observationResourceObject.put("meta", (Object)this.buildMeta(ccn));
            observationResourceObject.put("subject", (Object)new JSONObject().put("reference", (Object)("Patient/" + resourceId)));
            observationResourceObject.put("effectiveDateTime", observation.getEffectiveDateTimeType().dateTimeValue().getValue());
            CodeableConcept code = observation.getCode();
            Coding coding = (Coding)code.getCoding().get(0);
            JSONObject codingObject = new JSONObject();
            codingObject.put("system", (Object)coding.getSystem());
            codingObject.put("code", (Object)coding.getCode());
            codingObject.put("display", (Object)coding.getDisplay());
            JSONObject codeObject = new JSONObject();
            codeObject.put("coding", (Object)new JSONArray().put((Object)codingObject));
            observationResourceObject.put("code", (Object)codeObject);
            Quantity quantity = observation.getValueQuantity();
            JSONObject quantityObject = new JSONObject();
            quantityObject.put("value", (Object)quantity.getValue());
            quantityObject.put("unit", (Object)quantity.getUnit());
            quantityObject.put("system", (Object)quantity.getSystem());
            quantityObject.put("code", (Object)quantity.getCode());
            observationResourceObject.put("valueQuantity", (Object)quantityObject);
            JSONObject identifierObject = new JSONObject();
            identifierObject.put("use", (Object)"official");
            identifierObject.put("system", (Object)RESOURCE_IDENTIFIER_SYSTEM);
            identifierObject.put("value", (Object)fullUrl);
            observationResourceObject.put("identifier", (Object)new JSONArray().put((Object)identifierObject));
            observationObject.put("resource", (Object)observationResourceObject);
            entryArray.put((Object)observationObject);
        }
        return entryArray;
    }

    protected JSONObject buildMeta(String ccn) {
        JSONObject metaObject = new JSONObject();
        JSONArray securityArray = new JSONArray();
        JSONObject securityObject = new JSONObject();
        securityObject.put("system", (Object)CCN_SYSTEM);
        securityObject.put("code", (Object)("rc_" + ccn));
        securityArray.put((Object)securityObject);
        metaObject.put("security", (Object)securityArray);
        return metaObject;
    }

    protected String getCcn(List<Bundle.BundleEntryComponent> bundleEntries, MessageHeader messageHeader) {
        Reference sender = messageHeader.getSender();
        String orgReference = sender.getReference();
        if (!orgReference.contains("Organization/")) {
            return null;
        }
        String orgId = orgReference.substring(13);
        Bundle.BundleEntryComponent orgEntry = bundleEntries.stream().filter(entry -> entry.getResource().getId() != null && (entry.getResource().getId().equals(orgReference) || entry.getResource().getId().equals(orgId))).findAny().orElse(null);
        if (orgEntry == null) {
            return null;
        }
        Organization orgResource = (Organization)orgEntry.getResource();
        List ids = orgResource.getIdentifier();
        if (ids != null) {
            for (Identifier id : ids) {
                String system = id.getSystem();
                String value = id.getValue();
                if (system == null || value == null || !system.equals(CCN_SYSTEM)) continue;
                return value;
            }
        }
        return null;
    }

    private OperationOutcome createOperationOutcome(boolean success, String code, String diagnostics, Exception e) {
        OperationOutcome result = new OperationOutcome();
        OperationOutcome.OperationOutcomeIssueComponent issue = result.addIssue();
        issue.getSeverityElement().setValueAsString(success ? "information" : "error");
        issue.setCode(OperationOutcome.IssueType.fromCode((String)code));
        if (e != null) {
            diagnostics = diagnostics + "\n" + e.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)e);
        }
        issue.setDiagnostics(diagnostics);
        return result;
    }
}

