/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.hapifhir;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.ResourceType;
import org.json.JSONArray;
import org.json.JSONObject;

public class MedMorphToCIBMTR {
    private String cibmtrUrl;
    private String ccn;

    public MedMorphToCIBMTR(String cibmtrUrl, String ccn) {
        this.cibmtrUrl = cibmtrUrl;
        if (!this.cibmtrUrl.endsWith("/")) {
            this.cibmtrUrl = this.cibmtrUrl + "/";
        }
        this.ccn = ccn;
    }

    public void convert(Bundle medmorphReport, String authToken) {
        if (medmorphReport.hasEntry()) {
            List entriesList = medmorphReport.getEntry();
            Bundle.BundleEntryComponent patientEntry = entriesList.stream().filter(entry -> entry.getResource().getResourceType() == ResourceType.Patient).findAny().orElse(null);
            if (patientEntry == null) {
                return;
            }
            Patient patient = (Patient)patientEntry.getResource();
            Number crid = this.getCrid(authToken, patient);
            String resourceId = this.postPatient(authToken, crid.toString());
            if (resourceId != null) {
                this.postBundle(authToken, entriesList, resourceId);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Number getCrid(String authToken, Patient patient) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPut httpPut = new HttpPut(this.cibmtrUrl + "CRID");
            httpPut.setHeader("Accept", "application/json");
            httpPut.setHeader("Content-type", "application/json");
            httpPut.setHeader("Authorization", authToken);
            JSONObject cridRequestBody = new JSONObject();
            cridRequestBody.put("ccn", (Object)this.ccn);
            JSONObject patientJson = new JSONObject();
            patientJson.put("firstName", ((HumanName)patient.getName().get(0)).getGiven().get(0));
            patientJson.put("lastName", (Object)((HumanName)patient.getName().get(0)).getFamily());
            patientJson.put("birthDate", (Object)patient.getBirthDate().toString());
            patientJson.put("gender", (Object)patient.getGender().getDisplay());
            cridRequestBody.put("patient", (Object)patientJson);
            StringEntity stringEntity = new StringEntity(cridRequestBody.toString());
            httpPut.setEntity((HttpEntity)stringEntity);
            ResponseHandler responseHandler = response -> {
                HttpEntity entity = response.getEntity();
                return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
            };
            String responseBody = (String)httpClient.execute((HttpUriRequest)httpPut, responseHandler);
            JSONObject responseObj = new JSONObject(responseBody.toString());
            JSONArray perfectMatch = responseObj.getJSONArray("perfectMatch");
            if (perfectMatch.isEmpty()) return null;
            Number number = perfectMatch.getJSONObject(0).getNumber("crid");
            return number;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String postPatient(String authToken, String crid) {
        if (crid == null) {
            return null;
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.cibmtrUrl + "Patient");
            httpPost.setHeader("Content-Type", "application/fhir+json");
            httpPost.setHeader("Authorization", authToken);
            JSONObject patientRequestBody = new JSONObject();
            patientRequestBody.put("resourceType", (Object)"Patient");
            patientRequestBody.put("meta", (Object)this.getMeta());
            patientRequestBody.put("text", (Object)new JSONObject().put("status", (Object)"empty"));
            JSONArray identifierArray = new JSONArray();
            JSONObject identifierObject = new JSONObject();
            identifierObject.put("use", (Object)"official");
            identifierObject.put("system", (Object)"http://cibmtr.org/identifier/CRID");
            identifierObject.put("value", (Object)crid);
            identifierArray.put((Object)identifierObject);
            patientRequestBody.put("identifier", (Object)identifierArray);
            StringEntity stringEntity = new StringEntity(patientRequestBody.toString());
            httpPost.setEntity((HttpEntity)stringEntity);
            ResponseHandler responseHandler = response -> {
                String location;
                int index;
                int status = response.getStatusLine().getStatusCode();
                if (status == 200 && (index = (location = response.getFirstHeader("Location").getValue()).indexOf("Patient/")) > 0) {
                    return location.substring(index + 8);
                }
                return null;
            };
            String string = (String)httpClient.execute((HttpUriRequest)httpPost, responseHandler);
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void postBundle(String authToken, List<Bundle.BundleEntryComponent> entries, String resourceId) {
        List<Bundle.BundleEntryComponent> observationEntries = entries.stream().filter(entry -> entry.getResource().getResourceType() == ResourceType.Observation).collect(Collectors.toList());
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.cibmtrUrl + "Bundle");
            httpPost.setHeader("Content-Type", "application/fhir+json");
            httpPost.setHeader("Authorization", authToken);
            JSONObject bundleRequestBody = new JSONObject();
            bundleRequestBody.put("resourceType", (Object)"Bundle");
            bundleRequestBody.put("type", (Object)"transaction");
            bundleRequestBody.put("entry", (Object)this.getObservationEntries(observationEntries, resourceId));
            StringEntity stringEntity = new StringEntity(bundleRequestBody.toString());
            httpPost.setEntity((HttpEntity)stringEntity);
            httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            return;
        }
    }

    protected JSONArray getObservationEntries(List<Bundle.BundleEntryComponent> observationEntries, String resourceId) {
        JSONArray entryArray = new JSONArray();
        for (Bundle.BundleEntryComponent entry : observationEntries) {
            JSONObject observationObject = new JSONObject();
            JSONObject requestObject = new JSONObject();
            requestObject.put("method", (Object)"POST");
            requestObject.put("url", (Object)"Observation");
            observationObject.put("request", (Object)requestObject);
            Observation observation = (Observation)entry.getResource();
            JSONObject observationResourceObject = new JSONObject();
            observationResourceObject.put("resourceType", (Object)"Observation");
            observationResourceObject.put("meta", (Object)this.getMeta());
            observationResourceObject.put("subject", (Object)new JSONObject().put("reference", (Object)("Patient/" + resourceId)));
            observationResourceObject.put("effectiveDateTime", observation.getEffectiveDateTimeType().dateTimeValue().getValue());
            CodeableConcept code = observation.getCode();
            Coding coding = (Coding)code.getCoding().get(0);
            JSONObject codingObject = new JSONObject();
            codingObject.put("system", (Object)coding.getSystem());
            codingObject.put("code", (Object)coding.getCode());
            codingObject.put("display", (Object)coding.getDisplay());
            JSONObject codeObject = new JSONObject();
            codeObject.put("coding", (Object)new JSONArray().put((Object)codingObject));
            observationResourceObject.put("code", (Object)codeObject);
            Quantity quantity = observation.getValueQuantity();
            JSONObject quantityObject = new JSONObject();
            quantityObject.put("value", (Object)quantity.getValue());
            quantityObject.put("unit", (Object)quantity.getUnit());
            quantityObject.put("system", (Object)quantity.getSystem());
            quantityObject.put("code", (Object)quantity.getCode());
            observationResourceObject.put("valueQuantity", (Object)quantityObject);
            observationObject.put("resource", (Object)observationResourceObject);
            entryArray.put((Object)observationObject);
        }
        return entryArray;
    }

    protected JSONObject getMeta() {
        JSONObject metaObject = new JSONObject();
        JSONArray securityArray = new JSONArray();
        JSONObject securityObject = new JSONObject();
        securityObject.put("system", (Object)"http://cibmtr.org/codesystem/transplant-center");
        securityObject.put("code", (Object)("rc_" + this.ccn));
        securityArray.put((Object)securityObject);
        metaObject.put("security", (Object)securityArray);
        return metaObject;
    }
}

