/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.minijax.MinijaxException;
import org.minijax.client.MinijaxClient;
import org.minijax.client.MinijaxClientHttpRequest;
import org.minijax.client.MinijaxClientInvocation;
import org.minijax.client.MinijaxClientResponse;
import org.minijax.util.EntityUtils;

public class MinijaxClientInvocationBuilder
implements Invocation.Builder {
    private static final String TRACE = "TRACE";
    private final MinijaxClient client;
    private final MinijaxClientHttpRequest httpRequest;

    public MinijaxClientInvocationBuilder(MinijaxClient client, URI uri) {
        this.client = client;
        this.httpRequest = new MinijaxClientHttpRequest();
        this.httpRequest.setURI(uri);
    }

    MinijaxClientHttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public MinijaxClientInvocationBuilder header(String name, Object value) {
        this.httpRequest.addHeader(name, value.toString());
        return this;
    }

    public MinijaxClientInvocationBuilder headers(MultivaluedMap<String, Object> headers) {
        for (Map.Entry entry : headers.entrySet()) {
            for (Object value : (List)entry.getValue()) {
                this.httpRequest.addHeader((String)entry.getKey(), value.toString());
            }
        }
        return this;
    }

    public MinijaxClientResponse get() {
        return this.buildGet().invoke();
    }

    public <T> T get(Class<T> responseType) {
        return this.buildGet().invoke(responseType);
    }

    public <T> T get(GenericType<T> responseType) {
        return this.buildGet().invoke(responseType);
    }

    public Response put(Entity<?> entity) {
        return this.buildPut((Entity)entity).invoke();
    }

    public <T> T put(Entity<?> entity, Class<T> responseType) {
        return this.buildPut((Entity)entity).invoke(responseType);
    }

    public <T> T put(Entity<?> entity, GenericType<T> responseType) {
        return this.buildPut((Entity)entity).invoke(responseType);
    }

    public Response post(Entity<?> entity) {
        return this.buildPost((Entity)entity).invoke();
    }

    public <T> T post(Entity<?> entity, Class<T> responseType) {
        return this.buildPost((Entity)entity).invoke(responseType);
    }

    public <T> T post(Entity<?> entity, GenericType<T> responseType) {
        return this.buildPost((Entity)entity).invoke(responseType);
    }

    public Response delete() {
        return this.buildDelete().invoke();
    }

    public <T> T delete(Class<T> responseType) {
        return this.buildDelete().invoke(responseType);
    }

    public <T> T delete(GenericType<T> responseType) {
        return this.buildDelete().invoke(responseType);
    }

    public Response head() {
        return this.build("HEAD").invoke();
    }

    public Response options() {
        return this.build("OPTIONS").invoke();
    }

    public <T> T options(Class<T> responseType) {
        return this.build("OPTIONS").invoke(responseType);
    }

    public <T> T options(GenericType<T> responseType) {
        return this.build("OPTIONS").invoke(responseType);
    }

    public Response trace() {
        return this.build(TRACE).invoke();
    }

    public <T> T trace(Class<T> responseType) {
        return this.build(TRACE).invoke(responseType);
    }

    public <T> T trace(GenericType<T> responseType) {
        return this.build(TRACE).invoke(responseType);
    }

    public Response method(String name) {
        return this.build(name).invoke();
    }

    public <T> T method(String name, Class<T> responseType) {
        return this.build(name).invoke(responseType);
    }

    public <T> T method(String name, GenericType<T> responseType) {
        return this.build(name).invoke(responseType);
    }

    public Response method(String name, Entity<?> entity) {
        return this.build(name, (Entity)entity).invoke();
    }

    public <T> T method(String name, Entity<?> entity, Class<T> responseType) {
        return this.build(name, (Entity)entity).invoke(responseType);
    }

    public <T> T method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.build(name, (Entity)entity).invoke(responseType);
    }

    public MinijaxClientInvocation build(String method) {
        this.httpRequest.setMethod(method);
        return new MinijaxClientInvocation(this.client, this.httpRequest);
    }

    public MinijaxClientInvocation build(String method, Entity<?> entity) {
        InputStream inputStream;
        this.httpRequest.setMethod(method);
        try {
            inputStream = EntityUtils.convertToInputStream(entity);
        }
        catch (IOException ex) {
            throw new MinijaxException("Error converting entity to input stream: " + ex.getMessage(), (Throwable)ex);
        }
        if (inputStream != null) {
            this.httpRequest.setEntity((HttpEntity)new InputStreamEntity(inputStream));
        }
        return new MinijaxClientInvocation(this.client, this.httpRequest);
    }

    public MinijaxClientInvocation buildGet() {
        return this.build("GET");
    }

    public MinijaxClientInvocation buildDelete() {
        return this.build("DELETE");
    }

    public MinijaxClientInvocation buildPost(Entity<?> entity) {
        return this.build("POST", (Entity)entity);
    }

    public MinijaxClientInvocation buildPut(Entity<?> entity) {
        return this.build("PUT", (Entity)entity);
    }

    public MinijaxClientInvocationBuilder accept(String ... mediaTypes) {
        return this.header("Accept", String.join((CharSequence)", ", mediaTypes));
    }

    public MinijaxClientInvocationBuilder accept(MediaType ... mediaTypes) {
        return this.header("Accept", Arrays.asList(mediaTypes).stream().map(MediaType::toString).collect(Collectors.joining(", ")));
    }

    public MinijaxClientInvocationBuilder acceptLanguage(String ... locales) {
        return this.header("Accept-Language", String.join((CharSequence)", ", locales));
    }

    public MinijaxClientInvocationBuilder acceptLanguage(Locale ... locales) {
        return this.header("Accept-Language", Arrays.asList(locales).stream().map(Locale::toLanguageTag).collect(Collectors.joining(", ")));
    }

    public MinijaxClientInvocationBuilder acceptEncoding(String ... encodings) {
        return this.header("Accept-Encoding", String.join((CharSequence)", ", encodings));
    }

    public MinijaxClientInvocationBuilder cookie(Cookie cookie) {
        return this.header("Cookie", cookie);
    }

    public MinijaxClientInvocationBuilder cookie(String name, String value) {
        return this.header("Cookie", new HttpCookie(name, value));
    }

    public MinijaxClientInvocationBuilder cacheControl(CacheControl cacheControl) {
        return this.header("Cache-Control", cacheControl);
    }

    public MinijaxClientInvocationBuilder property(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public AsyncInvoker async() {
        throw new UnsupportedOperationException();
    }

    public CompletionStageRxInvoker rx() {
        throw new UnsupportedOperationException();
    }

    public <T extends RxInvoker> T rx(Class<T> clazz) {
        throw new UnsupportedOperationException();
    }
}

