/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.client;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.minijax.client.ConversionUtils;
import org.minijax.delegates.MinijaxStatusInfo;

public class MinijaxClientResponse
extends Response {
    private final CloseableHttpResponse innerResponse;
    private Response.StatusType statusInfo;

    public MinijaxClientResponse(CloseableHttpResponse innerResponse) {
        this.innerResponse = innerResponse;
    }

    public int getStatus() {
        return this.innerResponse.getStatusLine().getStatusCode();
    }

    public Response.StatusType getStatusInfo() {
        if (this.statusInfo == null) {
            StatusLine sl = this.innerResponse.getStatusLine();
            this.statusInfo = Response.Status.fromStatusCode((int)sl.getStatusCode());
            if (this.statusInfo == null) {
                this.statusInfo = new MinijaxStatusInfo(sl.getStatusCode(), sl.getReasonPhrase());
            }
        }
        return this.statusInfo;
    }

    public MediaType getMediaType() {
        Header contentTypeHeader = this.innerResponse.getLastHeader("Content-Type");
        return MediaType.valueOf((String)contentTypeHeader.getValue());
    }

    public Locale getLanguage() {
        return this.innerResponse.getLocale();
    }

    public int getLength() {
        Header lengthHeader = this.innerResponse.getLastHeader("Content-Length");
        String lengthStr = lengthHeader.getValue();
        return Integer.parseInt(lengthStr);
    }

    public Object getEntity() {
        return this.innerResponse.getEntity();
    }

    public <T> T readEntity(Class<T> entityType) {
        return ConversionUtils.convertApacheToJax(this.innerResponse.getEntity(), entityType);
    }

    public <T> T readEntity(GenericType<T> entityType) {
        return ConversionUtils.convertToGenericType(this.innerResponse.getEntity(), entityType);
    }

    public void close() {
        try {
            this.innerResponse.close();
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        throw new UnsupportedOperationException();
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        throw new UnsupportedOperationException();
    }

    public boolean hasEntity() {
        throw new UnsupportedOperationException();
    }

    public boolean bufferEntity() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getAllowedMethods() {
        throw new UnsupportedOperationException();
    }

    public Map<String, NewCookie> getCookies() {
        throw new UnsupportedOperationException();
    }

    public EntityTag getEntityTag() {
        throw new UnsupportedOperationException();
    }

    public Date getDate() {
        throw new UnsupportedOperationException();
    }

    public Date getLastModified() {
        throw new UnsupportedOperationException();
    }

    public URI getLocation() {
        throw new UnsupportedOperationException();
    }

    public Set<Link> getLinks() {
        throw new UnsupportedOperationException();
    }

    public boolean hasLink(String relation) {
        throw new UnsupportedOperationException();
    }

    public Link getLink(String relation) {
        throw new UnsupportedOperationException();
    }

    public Link.Builder getLinkBuilder(String relation) {
        throw new UnsupportedOperationException();
    }

    public MultivaluedMap<String, Object> getMetadata() {
        throw new UnsupportedOperationException();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        throw new UnsupportedOperationException();
    }

    public String getHeaderString(String name) {
        throw new UnsupportedOperationException();
    }
}

