/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl;

import java.util.Queue;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.services.rs.impl.FgsmsReportGenerator;
import org.miloss.fgsms.services.rs.impl.RSProcessorSingleton;
import org.miloss.fgsms.services.rs.impl.ReportDefinitionExtension;

public class RSRunner
implements Runnable {
    private Queue<ReportDefinitionExtension> queue = null;
    static final Logger log = Logger.getLogger((String)"fgsms.RSProcessor");

    RSRunner(Queue<ReportDefinitionExtension> q) {
        this.queue = q;
    }

    @Override
    public void run() {
        ReportDefinitionExtension poll = this.queue.poll();
        while (poll != null) {
            try {
                FgsmsReportGenerator r = new FgsmsReportGenerator();
                String id = r.GenerateReport(poll.def, poll.pooled);
                r.ProcessAlerts(poll.def, id, poll.pooled);
            }
            catch (Exception e) {
                log.log((Priority)Level.ERROR, (Object)"Error trapped running the reporting job", (Throwable)e);
            }
            poll = this.queue.poll();
        }
        RSProcessorSingleton.running = false;
        log.log((Priority)Level.INFO, (Object)"fgsms RSProcessor Alerting thread is terminating, queue is empty.");
    }
}

