/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl;

import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.services.rs.impl.RSRunner;
import org.miloss.fgsms.services.rs.impl.ReportDefinitionExtension;

public class RSProcessorSingleton {
    protected static boolean running = true;
    private static Thread t = null;
    private static Queue<ReportDefinitionExtension> queue = new ConcurrentLinkedQueue<ReportDefinitionExtension>();
    static final Logger log = Logger.getLogger((String)"fgsms.RSProcessor");

    static synchronized void Enqueue(ReportDefinitionExtension alertContainer) {
        queue.add(alertContainer);
        RSProcessorSingleton.run();
    }

    private RSProcessorSingleton() {
    }

    public static RSProcessorSingleton getInstance() {
        return SLAProcessorSingletonHolder.INSTANCE;
    }

    protected static int GetQueueSize() {
        if (queue == null) {
            return -1;
        }
        return queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void run() {
        block8: {
            ReentrantLock lock = new ReentrantLock();
            lock.lock();
            try {
                if (running && t != null) break block8;
                log.log((Priority)Level.INFO, (Object)" == fgsms RS == launched new thread.");
                try {
                    t = new Thread((Runnable)new RSRunner(queue), "RS Thread " + UUID.randomUUID().toString());
                    t.start();
                    if (!t.isAlive()) {
                        throw new NullPointerException();
                    }
                }
                catch (Exception ex) {
                    log.log((Priority)Level.FATAL, (Object)("******************************************************* fgsms could not start the RS Processor Thread. This is most likely due to server overloading, memory limits or hitting the maxium thread pool for the container. Please consider revising. Purging " + queue.size() + " from the outbound queue to prevent container overload. *********************************************"), (Throwable)ex);
                    try {
                        queue.clear();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static class SLAProcessorSingletonHolder {
        private static final RSProcessorSingleton INSTANCE = new RSProcessorSingleton();

        private SLAProcessorSingletonHolder() {
        }
    }
}

