/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.DBSettingsLoader;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.ReportDefinition;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.TimeRangeDiff;
import org.miloss.fgsms.services.interfaces.common.TimeRange;
import org.miloss.fgsms.services.interfaces.policyconfiguration.KeyNameValueEnc;
import org.miloss.fgsms.services.interfaces.reportingservice.ExportCSVDataRequestMsg;
import org.miloss.fgsms.services.interfaces.reportingservice.ExportDataRequestMsg;
import org.miloss.fgsms.services.interfaces.reportingservice.ExportDataToHTMLResponseMsg;
import org.miloss.fgsms.services.rs.impl.CalendarCalculator;
import org.miloss.fgsms.services.rs.impl.CsvExporter;
import org.miloss.fgsms.services.rs.impl.RSProcessorSingleton;
import org.miloss.fgsms.services.rs.impl.ReportDefinitionExtension;
import org.miloss.fgsms.services.rs.impl.Reporting;
import org.miloss.fgsms.sla.SLACommon;

public class FgsmsReportGenerator {
    static final Logger log = Logger.getLogger((String)"fgsms.AutoReportGenerator");
    private static final String subject = "An fgsms Scheduled Report is available";
    static DatatypeFactory f = null;

    private static void sendMailAlert(String htmlencodedText, String subject, InternetAddress[] subscribers, boolean pooled) {
        Properties props = null;
        props = pooled ? SLACommon.LoadSLAPropertiesPooled() : SLACommon.LoadSLAPropertiesNotPooled();
        if (subscribers != null && subscribers.length > 0) {
            try {
                Session mailSession = Session.getDefaultInstance((Properties)props);
                MimeMessage simpleMessage = new MimeMessage(mailSession);
                InternetAddress from = new InternetAddress(props.getProperty("defaultReplyAddress"));
                for (int i2 = 0; i2 < subscribers.length; ++i2) {
                    try {
                        simpleMessage.setFrom((Address)from);
                        simpleMessage.setRecipient(Message.RecipientType.TO, (Address)subscribers[i2]);
                        simpleMessage.setSubject(subject);
                        simpleMessage.setContent((Object)(htmlencodedText + "<br><br>" + FgsmsReportGenerator.generateGuiLink(props.getProperty("fgsms.GUI.URL"))), "text/html; charset=ISO-8859-1");
                        Transport.send((Message)simpleMessage);
                        continue;
                    }
                    catch (Exception ex) {
                        log.log((Priority)Level.ERROR, (Object)("Error sending ARS alert email! " + ex.getLocalizedMessage()));
                    }
                }
            }
            catch (Exception ex) {
                log.log((Priority)Level.ERROR, (Object)("Error sending ARS alert email! " + ex.getLocalizedMessage()));
            }
        }
    }

    private static String generateGuiLink(String property) {
        return "You can access all defined reports at the following link <a href=\"" + property + "/scheduledReports.jsp\">Click here</a> to manage your scheduled reports.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static InternetAddress[] getEmailAddresses(String user, boolean pooled) {
        InternetAddress[] internetAddressArray;
        Connection con = null;
        con = pooled ? Utility.getConfigurationDBConnection() : Utility.getConfigurationDB_NONPOOLED_Connection();
        PreparedStatement prepareStatement = null;
        ResultSet rs = null;
        try {
            ArrayList<InternetAddress> emails = new ArrayList<InternetAddress>();
            prepareStatement = con.prepareStatement("select * from users where username=?;");
            prepareStatement.setString(1, user);
            rs = prepareStatement.executeQuery();
            while (rs.next()) {
                try {
                    InternetAddress a;
                    if (!Utility.stringIsNullOrEmpty((String)rs.getString("email"))) {
                        a = new InternetAddress(rs.getString("email"));
                        emails.add(a);
                    }
                    if (!Utility.stringIsNullOrEmpty((String)rs.getString("email1"))) {
                        a = new InternetAddress(rs.getString("email1"));
                        emails.add(a);
                    }
                    if (!Utility.stringIsNullOrEmpty((String)rs.getString("email2"))) {
                        a = new InternetAddress(rs.getString("email2"));
                        emails.add(a);
                    }
                    if (Utility.stringIsNullOrEmpty((String)rs.getString("email3"))) continue;
                    a = new InternetAddress(rs.getString("email3"));
                    emails.add(a);
                }
                catch (Exception ex) {
                    log.log((Priority)Level.WARN, (Object)"Error created object to send email", (Throwable)ex);
                }
            }
            InternetAddress[] d = new InternetAddress[emails.size()];
            internetAddressArray = emails.toArray(d);
        }
        catch (Exception ex) {
            try {
                log.log((Priority)Level.ERROR, null, (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(prepareStatement);
                DBUtils.safeClose((Connection)con);
                throw throwable;
            }
            DBUtils.safeClose(rs);
            DBUtils.safeClose((PreparedStatement)prepareStatement);
            DBUtils.safeClose((Connection)con);
            return null;
        }
        DBUtils.safeClose((ResultSet)rs);
        DBUtils.safeClose((PreparedStatement)prepareStatement);
        DBUtils.safeClose((Connection)con);
        return internetAddressArray;
    }

    private static TimeRange convertDiffRangeToRange(TimeRangeDiff diff) throws DatatypeConfigurationException {
        if (f == null) {
            f = DatatypeFactory.newInstance();
        }
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeInMillis(System.currentTimeMillis());
        gcal.add(14, (int)(-1L * Utility.durationToTimeInMS((Duration)diff.getStart())));
        TimeRange r = new TimeRange();
        r.setStart((Calendar)gcal);
        gcal = new GregorianCalendar();
        gcal.setTimeInMillis(System.currentTimeMillis());
        gcal.add(14, (int)(-1L * Utility.durationToTimeInMS((Duration)diff.getEnd())));
        r.setEnd((Calendar)gcal);
        return r;
    }

    public void FgsmsReportGenerator() throws DatatypeConfigurationException {
        f = DatatypeFactory.newInstance();
    }

    public String Fire(boolean pooled, String job) throws Exception {
        List<ReportDefinition> loadJobsFromDatabase = this.loadJobsFromDatabase(pooled, job);
        if (loadJobsFromDatabase == null || loadJobsFromDatabase.isEmpty()) {
            throw new Exception("report def not found");
        }
        return this.GenerateReport(loadJobsFromDatabase.get(0), pooled);
    }

    public void Fire(boolean pooled, boolean waitforfinish) {
        try {
            List<ReportDefinition> items = this.loadJobsFromDatabase(pooled);
            log.log((Priority)Level.INFO, (Object)(items.size() + " jobs defined. Processing...."));
            for (int i = 0; i < items.size(); ++i) {
                if (items.get(i).isEnabled() && CalendarCalculator.isTimeToRun(items.get(i), Calendar.getInstance())) {
                    log.log((Priority)Level.INFO, (Object)("Enqueing report generation for " + items.get(i).getJobId()));
                    if (waitforfinish) {
                        String id = this.GenerateReport(items.get(i), pooled);
                        log.log((Priority)Level.INFO, (Object)("Report generated for " + items.get(i) + " with the id of " + id));
                        this.ProcessAlerts(items.get(i), id, pooled);
                        continue;
                    }
                    this.enqueue(items.get(i), pooled);
                    continue;
                }
                log.log((Priority)Level.DEBUG, (Object)("Skipping report generation for " + items.get(i).getJobId() + " it's not time to fire"));
            }
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, null, (Throwable)ex);
        }
    }

    protected String GenerateReport(ReportDefinition get, boolean pooled) throws Exception {
        log.log((Priority)Level.INFO, (Object)("excuting ARS job " + get.getJobId() + " for " + get.getOwner()));
        Reporting r = new Reporting();
        if (get.getExportCSVDataRequestMsg() != null) {
            ExportCSVDataRequestMsg x = new ExportCSVDataRequestMsg();
            x.setClassification(get.getExportCSVDataRequestMsg().getClassification());
            x.setAllServices(Boolean.valueOf(false));
            x.setExportType(get.getExportCSVDataRequestMsg().getExportType());
            x.getURLs().addAll(get.getExportCSVDataRequestMsg().getURLs());
            x.setRange(FgsmsReportGenerator.convertDiffRangeToRange(get.getExportCSVDataRequestMsg().getRange()));
            String path = "";
            String currentFolder = "";
            File targetfolder = null;
            UUID id = UUID.randomUUID();
            try {
                boolean mkdir;
                currentFolder = System.getProperty("jboss.server.temp.dir");
                if (currentFolder == null || currentFolder.equals("") || currentFolder.equalsIgnoreCase("null")) {
                    currentFolder = System.getProperty("java.io.tmpdir");
                }
                if (!(mkdir = (targetfolder = new File(path = currentFolder + Reporting.getFilePathDelimitor() + id.toString())).mkdir())) {
                    log.log((Priority)Level.ERROR, (Object)"exportDataToHTML, unable to create temporary directory");
                    return null;
                }
                ArrayList<String> files = new ArrayList<String>();
                CsvExporter.generateCSVReport(x, path, files, get.getOwner(), null, r.getClassLevelFromDB());
                this.updateLastRanAt(get);
                return this.storeReport(Reporting.generateZipFileandDelete(files, path), get.getJobId(), pooled);
            }
            catch (Exception e) {
                log.log((Priority)Level.ERROR, (Object)"error caught generating report", (Throwable)e);
                return null;
            }
        }
        if (get.getExportDataRequestMsg() != null) {
            try {
                TimeRange ConvertDiffRangeToRange = FgsmsReportGenerator.convertDiffRangeToRange(get.getExportDataRequestMsg().getRange());
                ExportDataRequestMsg request = new ExportDataRequestMsg();
                request.getURLs().addAll(get.getExportDataRequestMsg().getURLs());
                request.setRange(ConvertDiffRangeToRange);
                request.setReportTypes(get.getExportDataRequestMsg().getReportTypes());
                request.setClassification(get.getExportDataRequestMsg().getClassification());
                ExportDataToHTMLResponseMsg exportDataToHTML = r.generateHtmlReport(get.getOwner(), request);
                this.updateLastRanAt(get);
                byte[] bits = exportDataToHTML.getZipFile();
                return this.storeReport(bits, get.getJobId(), pooled);
            }
            catch (Exception ex) {
                log.log((Priority)Level.ERROR, (Object)"error caught generating report ", (Throwable)ex);
            }
        }
        return null;
    }

    protected void ProcessAlerts(ReportDefinition get, String id, boolean pooled) {
        String link = "";
        boolean guess = false;
        try {
            KeyNameValueEnc GetPropertiesFromDB = DBSettingsLoader.GetPropertiesFromDB((boolean)pooled, (String)"defaults", (String)"ServicesWar");
            if (GetPropertiesFromDB != null && GetPropertiesFromDB.getKeyNameValue() != null) {
                if (Utility.stringIsNullOrEmpty((String)GetPropertiesFromDB.getKeyNameValue().getPropertyValue())) {
                    guess = true;
                } else {
                    link = "<a href=\"" + GetPropertiesFromDB.getKeyNameValue().getPropertyValue() + "/ReportFetch?reportid=" + URLEncoder.encode(id) + "\">" + Utility.encodeHTML((String)id) + "</a>";
                }
            }
        }
        catch (Exception ex) {
            guess = true;
            log.log((Priority)Level.WARN, (Object)"Unable to obtain the load balanced URL of the fgsmsServices war. Use the GUI to set the General Setting, key='defaults' name='ServicesWar' to clear this message. In the mean time, I'm just going to guess ", (Throwable)ex);
        }
        if (guess) {
            link = "<a href=\"http://" + Utility.getHostName() + ":8888/fgsmsServices/ReportFetch?reportid=" + URLEncoder.encode(id) + "\">" + Utility.encodeHTML((String)id) + "</a>";
        }
        FgsmsReportGenerator.sendMailAlert(get.getOwner() + ",<br>A report has been generated and is now available for download. Additional information is as follows:<br>" + "<table><tr><td>Report Name</td><td>" + Utility.encodeHTML((String)get.getFriendlyName()) + "</td></tr>" + "<tr><td>Generated Report ID</td><td>" + link + "</td></tr></table><br>" + (guess ? "The download urls above may not work because the system administrator has not defined the public url of FGSMS in general settings." : "") + "You are the owner of this report and can delete the generated report or the reporting job itself.", subject, FgsmsReportGenerator.getEmailAddresses(get.getOwner(), pooled), pooled);
        for (int i = 0; i < get.getAdditionalReaders().size(); ++i) {
            FgsmsReportGenerator.sendMailAlert((String)get.getAdditionalReaders().get(i) + ",<br>A report has been generated and is now available for download. Additional information is as follows:<br>" + "<table><tr><td>Report Name</td><td>" + Utility.encodeHTML((String)get.getFriendlyName()) + "</td></tr>" + "<tr><td>Generated Report ID</td><td>" + link + "</td></tr></table><br>" + (guess ? "The download urls above may not work because the system administrator has not defined the public url of FGSMS in general settings." : "") + "You have been granted read access to this generated report by the user " + get.getOwner(), subject, FgsmsReportGenerator.getEmailAddresses(get.getOwner(), pooled), pooled);
        }
    }

    private String storeReport(byte[] bits, String jobId, boolean pooled) throws Exception {
        String id = UUID.randomUUID().toString();
        Connection con = null;
        PreparedStatement cmd = null;
        con = pooled ? Utility.getPerformanceDBConnection() : Utility.getPerformanceDB_NONPOOLED_Connection();
        try {
            cmd = con.prepareStatement("INSERT INTO arsreports(reportid, jobid, datetime,reportcontents)    VALUES (?, ?, ?,?);");
            cmd.setString(1, id);
            cmd.setString(2, jobId);
            cmd.setLong(3, System.currentTimeMillis());
            cmd.setBytes(4, bits);
            cmd.execute();
        }
        catch (Exception ex) {
            log.log((Priority)Level.ERROR, (Object)"error storing report", (Throwable)ex);
            throw ex;
        }
        finally {
            DBUtils.safeClose((PreparedStatement)cmd);
            DBUtils.safeClose((Connection)con);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReportDefinition> loadJobsFromDatabase(boolean pooled) throws Exception {
        JAXBContext GetARSSerializationContext = Utility.getARSSerializationContext();
        Unmarshaller u = GetARSSerializationContext.createUnmarshaller();
        ArrayList<ReportDefinition> ret = new ArrayList<ReportDefinition>();
        Connection con = pooled ? Utility.getPerformanceDBConnection() : Utility.getPerformanceDB_NONPOOLED_Connection();
        PreparedStatement prepareStatement = null;
        ResultSet rs = null;
        try {
            prepareStatement = con.prepareStatement("select * from arsjobs where enabled=true;");
            rs = prepareStatement.executeQuery();
            ReportDefinition rd = null;
            while (rs.next()) {
                byte[] s = rs.getBytes("reportdef");
                ByteArrayInputStream bss = new ByteArrayInputStream(s);
                XMLInputFactory xf = XMLInputFactory.newInstance();
                XMLStreamReader r = xf.createXMLStreamReader(bss);
                JAXBElement foo = u.unmarshal(r, ReportDefinition.class);
                if (foo != null && foo.getValue() != null) {
                    rd = (ReportDefinition)foo.getValue();
                    rd.setLastRanAt(this.ConvertLong(rs.getLong("lastranat")));
                    ret.add(rd);
                }
                bss.close();
            }
        }
        catch (Exception ex) {
            try {
                log.log((Priority)Level.ERROR, null, (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(rs);
                DBUtils.safeClose((PreparedStatement)prepareStatement);
                DBUtils.safeClose((Connection)con);
                throw throwable;
            }
            DBUtils.safeClose((ResultSet)rs);
            DBUtils.safeClose((PreparedStatement)prepareStatement);
            DBUtils.safeClose((Connection)con);
        }
        DBUtils.safeClose((ResultSet)rs);
        DBUtils.safeClose((PreparedStatement)prepareStatement);
        DBUtils.safeClose((Connection)con);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReportDefinition> loadJobsFromDatabase(boolean pooled, String jobid) throws Exception {
        ArrayList<ReportDefinition> ret;
        block7: {
            JAXBContext GetARSSerializationContext = Utility.getARSSerializationContext();
            Unmarshaller u = GetARSSerializationContext.createUnmarshaller();
            ret = new ArrayList<ReportDefinition>();
            Connection con = pooled ? Utility.getPerformanceDBConnection() : Utility.getPerformanceDB_NONPOOLED_Connection();
            PreparedStatement prepareStatement = null;
            ResultSet rs = null;
            try {
                prepareStatement = con.prepareStatement("select * from arsjobs where  jobid=?;");
                prepareStatement.setString(1, jobid);
                rs = prepareStatement.executeQuery();
                ReportDefinition rd = null;
                if (rs.next()) {
                    byte[] s = rs.getBytes("reportdef");
                    ByteArrayInputStream bss = new ByteArrayInputStream(s);
                    XMLInputFactory xf = XMLInputFactory.newInstance();
                    XMLStreamReader r = xf.createXMLStreamReader(bss);
                    JAXBElement foo = u.unmarshal(r, ReportDefinition.class);
                    if (foo != null && foo.getValue() != null) {
                        rd = (ReportDefinition)foo.getValue();
                        rd.setLastRanAt(this.ConvertLong(rs.getLong("lastranat")));
                        ret.add(rd);
                    }
                    bss.close();
                }
                DBUtils.safeClose((ResultSet)rs);
            }
            catch (Exception ex) {
                log.log((Priority)Level.ERROR, null, (Throwable)ex);
                break block7;
            }
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose((PreparedStatement)prepareStatement);
                DBUtils.safeClose((Connection)con);
            }
            DBUtils.safeClose((PreparedStatement)prepareStatement);
            DBUtils.safeClose((Connection)con);
        }
        return ret;
    }

    private Calendar ConvertLong(Long aLong) throws DatatypeConfigurationException {
        if (aLong == null) {
            return null;
        }
        if (aLong == 0L) {
            return null;
        }
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeInMillis(aLong);
        return gcal;
    }

    private void enqueue(ReportDefinition rdef, boolean pooled) {
        ReportDefinitionExtension r = new ReportDefinitionExtension();
        r.def = rdef;
        r.pooled = pooled;
        RSProcessorSingleton.getInstance();
        RSProcessorSingleton.Enqueue(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastRanAt(ReportDefinition get) {
        Connection con = Utility.getPerformanceDBConnection();
        PreparedStatement cmd = null;
        try {
            cmd = con.prepareStatement("update arsjobs set lastranat=? where jobid=?");
            cmd.setLong(1, System.currentTimeMillis());
            cmd.setString(2, get.getJobId());
            cmd.executeUpdate();
        }
        catch (Exception ex) {
            log.log((Priority)Level.WARN, null, (Throwable)ex);
        }
        finally {
            DBUtils.safeClose((PreparedStatement)cmd);
            DBUtils.safeClose((Connection)con);
        }
    }
}

