/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.UserIdentityUtil;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.faults.ServiceUnavailableFaultCodes;
import org.miloss.fgsms.services.interfaces.reportingservice.ExportCSVDataRequestMsg;
import org.miloss.fgsms.services.interfaces.reportingservice.ExportDataToCSVResponseMsg;
import org.miloss.fgsms.services.interfaces.reportingservice.ExportRecordsEnum;
import org.miloss.fgsms.services.interfaces.reportingservice.ServiceUnavailableException;
import org.miloss.fgsms.services.rs.impl.Reporting;
import us.gov.ic.ism.v2.ClassificationType;

public class CsvExporter {
    static ExportDataToCSVResponseMsg exportDataToCSV(WebServiceContext ctx, String currentUser, SecurityWrapper classlevel, ExportCSVDataRequestMsg request) throws ServiceUnavailableException {
        ExportDataToCSVResponseMsg res = new ExportDataToCSVResponseMsg();
        res.setClassification(classlevel);
        String path = "";
        String currentFolder = "";
        File targetfolder = null;
        UUID id = UUID.randomUUID();
        try {
            boolean mkdir;
            currentFolder = System.getProperty("jboss.server.temp.dir");
            if (currentFolder == null || currentFolder.equals("") || currentFolder.equalsIgnoreCase("null")) {
                currentFolder = System.getProperty("java.io.tmpdir");
            }
            if (!(mkdir = (targetfolder = new File(path = currentFolder + Reporting.getFilePathDelimitor() + id.toString())).mkdir())) {
                HttpServletRequest session = (HttpServletRequest)ctx.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
                targetfolder = (File)session.getAttribute("javax.servlet.context.tmpdir");
            }
            if (!targetfolder.exists()) {
                Reporting.log.log((Priority)Level.INFO, (Object)("fgsms.ReportingServiceexportDataToHTML, unable to create temporary directory " + currentFolder + targetfolder.getAbsolutePath()));
                ServiceUnavailableException f = new ServiceUnavailableException("", null);
                f.getFaultInfo().setCode(ServiceUnavailableFaultCodes.MISCONFIGURATION);
                throw f;
            }
        }
        catch (Exception e) {
            Reporting.log.log((Priority)Level.INFO, (Object)("fgsms.ReportingServiceexportDataToHTML, load props" + e));
            ServiceUnavailableException f = new ServiceUnavailableException("", null);
            f.getFaultInfo().setCode(ServiceUnavailableFaultCodes.MISCONFIGURATION);
            throw f;
        }
        ArrayList<String> files = new ArrayList<String>();
        CsvExporter.generateCSVReport(request, path, files, currentUser, ctx, classlevel);
        res.setZipFile(Reporting.generateZipFileandDelete(files, path));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> urlListAudit(boolean allServices, List<String> requestedurls, String currentUser, SecurityWrapper sec, WebServiceContext ctx) {
        ArrayList<String> urls;
        block11: {
            block12: {
                urls = new ArrayList<String>();
                if (!allServices) break block12;
                Connection con = Utility.getConfigurationDBConnection();
                PreparedStatement cmd = null;
                ResultSet rs = null;
                try {
                    if (UserIdentityUtil.hasGlobalAdministratorRole((String)currentUser, (String)"GenerateReports", (SecurityWrapper)sec, (WebServiceContext)ctx)) {
                        cmd = con.prepareStatement("select URI from servicepolicies;");
                    } else if (UserIdentityUtil.hasGlobalAuditRole((String)currentUser, (String)"GenerateReports", (SecurityWrapper)sec, (WebServiceContext)ctx)) {
                        cmd = con.prepareStatement("select URI from servicepolicies;");
                    } else {
                        cmd = con.prepareStatement("select ObjectURI as URI from UserPermissions where username=? and AdministerObject=1 or AuditObject=1;");
                        cmd.setString(1, currentUser);
                    }
                    rs = cmd.executeQuery();
                    while (rs.next()) {
                        urls.add(rs.getString("URI"));
                    }
                }
                catch (Exception ex) {
                    try {
                        Reporting.log.log((Priority)Level.INFO, (Object)"fgsms.ReportingServiceGenerateReports", (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        DBUtils.safeClose(rs);
                        DBUtils.safeClose(cmd);
                        DBUtils.safeClose((Connection)con);
                        throw throwable;
                    }
                    DBUtils.safeClose(rs);
                    DBUtils.safeClose((PreparedStatement)cmd);
                    DBUtils.safeClose((Connection)con);
                    break block11;
                }
                DBUtils.safeClose((ResultSet)rs);
                DBUtils.safeClose((PreparedStatement)cmd);
                DBUtils.safeClose((Connection)con);
                break block11;
            }
            if (requestedurls != null && requestedurls.size() > 0) {
                for (int i = 0; i < requestedurls.size(); ++i) {
                    urls.add(requestedurls.get(i));
                    UserIdentityUtil.assertReadAccess((String)((String)urls.get(i)), (String)currentUser, (String)"urlListAudit", (SecurityWrapper)sec, (WebServiceContext)ctx);
                }
            }
        }
        return urls;
    }

    protected static void generateCSVReport(ExportCSVDataRequestMsg request, String filenameandpath, List<String> filelist, String currentuser, WebServiceContext ctx, SecurityWrapper security) {
        if (request == null) {
            throw new IllegalArgumentException("request");
        }
        if (request.getExportType() == null) {
            throw new IllegalArgumentException("report type");
        }
        CsvExporter.validateCSVRequest(request);
        if (request.getExportType().value().equalsIgnoreCase(ExportRecordsEnum.AUDIT_LOGS.value())) {
            UserIdentityUtil.assertGlobalAuditRole((String)currentuser, (String)"GenerateCSVReport", (SecurityWrapper)request.getClassification(), (WebServiceContext)ctx);
            CsvExporter.generateAuditCSVReport(request, filenameandpath, filelist, currentuser, security);
            return;
        }
        if (request.getExportType().value().equalsIgnoreCase(ExportRecordsEnum.ALL.value()) && UserIdentityUtil.hasGlobalAuditRole((String)currentuser, (String)"GenerateCSVReport", (SecurityWrapper)security, (WebServiceContext)ctx)) {
            CsvExporter.generateAuditCSVReport(request, filenameandpath, filelist, currentuser, security);
        }
        List<String> urlstoprocess = CsvExporter.urlListAudit(request.isAllServices(), request.getURLs(), currentuser, request.getClassification(), ctx);
        block8: for (int i = 0; i < urlstoprocess.size(); ++i) {
            switch (request.getExportType()) {
                case ALL: {
                    CsvExporter.generateAvailabilityCSVReport(request, filenameandpath, filelist, currentuser, urlstoprocess.get(i), security);
                    CsvExporter.generateStatisticsCSVReport(request, filenameandpath, filelist, currentuser, urlstoprocess.get(i), security);
                    CsvExporter.generateTransactionsCSVReport(request, filenameandpath, filelist, currentuser, urlstoprocess.get(i), security);
                    CsvExporter.generateMachineCSVReport(request, filenameandpath, filelist, currentuser, urlstoprocess.get(i), security);
                    CsvExporter.generateProcessCSVReport(request, filenameandpath, filelist, currentuser, urlstoprocess.get(i), security);
                    continue block8;
                }
                case AVAILABILITY: {
                    CsvExporter.generateAvailabilityCSVReport(request, filenameandpath, filelist, currentuser, urlstoprocess.get(i), security);
                    continue block8;
                }
                case STATISTICS: {
                    CsvExporter.generateStatisticsCSVReport(request, filenameandpath, filelist, currentuser, urlstoprocess.get(i), security);
                    continue block8;
                }
                case TRANSACTIONS: {
                    CsvExporter.generateTransactionsCSVReport(request, filenameandpath, filelist, currentuser, urlstoprocess.get(i), security);
                    continue block8;
                }
                case MACHINE: {
                    CsvExporter.generateMachineCSVReport(request, filenameandpath, filelist, currentuser, urlstoprocess.get(i), security);
                    continue block8;
                }
                case PROCESS: {
                    CsvExporter.generateProcessCSVReport(request, filenameandpath, filelist, currentuser, urlstoprocess.get(i), security);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateTransactionsCSVReport(ExportCSVDataRequestMsg request, String filenameandpath, List<String> filelist, String currentuser, String url, SecurityWrapper security) {
        block16: {
            if (!Reporting.isPolicyTypeOf(url, PolicyType.TRANSACTIONAL)) {
                return;
            }
            StringBuilder data = new StringBuilder();
            Connection con = Utility.getPerformanceDBConnection();
            PreparedStatement com = null;
            ResultSet rs = null;
            OutputStreamWriter out = null;
            try {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(filenameandpath + Reporting.getFilePathDelimitor() + "TransactionExport-" + Reporting.toSafeFileName(url) + ".csv"), "UTF-8");
                filelist.add(filenameandpath + Reporting.getFilePathDelimitor() + "TransactionExport-" + Reporting.toSafeFileName(url) + ".csv");
                data = data.append("%CLASSIFICATION% Generated at %DATETIME_NOW% for %DATETIME_FROM% until %DATETIME_TO% ").append(System.getProperty("line.separator"));
                data = data.append(url).append(System.getProperty("line.separator"));
                data = data.append("URI").append("|").append("Response Time (ms)").append("|").append("Recorded at (DCS Host)").append("|").append("Service Hostname").append("|").append("Consumer").append("|").append("Transaction Id").append("|").append("Action").append("|").append("Response size (bytes)").append("|").append("Request size (bytes)").append("|").append("Timestamp (ms since epoch)").append("|").append("Success").append("|").append("SLA Fault").append("|").append("Agent type").append("|").append("Original Request Url").append("|").append("memo/notes from the agent").append("|").append("Related Transaction ID").append("|").append("Thread Id").append("|").append("Request Headers").append("|").append("Response Headers").append("|").append("Request").append("|").append("Response").append(System.getProperty("line.separator"));
                Calendar time = Calendar.getInstance();
                String t = data.toString();
                String[] ampm = new String[]{"AM", "PM"};
                t = t.replaceAll("%DATETIME_NOW%", new Date().toString());
                time = request.getRange().getStart();
                t = t.replaceAll("%DATETIME_FROM%", time.getTime().toString());
                time = request.getRange().getEnd();
                t = t.replaceAll("%DATETIME_TO%", time.getTime().toString());
                if (request.getClassification() == null) {
                    request.setClassification(security);
                }
                t = t.replaceAll("%CLASSIFICATION%", Utility.ICMClassificationToString((ClassificationType)request.getClassification().getClassification()) + " Caveat: " + request.getClassification().getCaveats());
                out.write(t, 0, t.length());
                com = con.prepareStatement("select * from rawdata  where uri=? and utcdatetime > ? and utcdatetime < ? order by utcdatetime desc ;");
                com.setString(1, url);
                com.setLong(2, request.getRange().getStart().getTimeInMillis());
                com.setLong(3, request.getRange().getEnd().getTimeInMillis());
                rs = com.executeQuery();
                while (rs.next()) {
                    data = new StringBuilder();
                    data = data.append(rs.getString("uri")).append("|").append(rs.getLong("responsetimems")).append("|").append(rs.getString("monitorsource")).append("|").append(rs.getString("hostingsource")).append("|").append(rs.getString("consumeridentity")).append("|").append(rs.getString("transactionid")).append("|").append(rs.getString("soapaction")).append("|").append(rs.getLong("responsesize")).append("|").append(rs.getLong("requestsize")).append("|").append(rs.getLong("utcdatetime")).append("|");
                    data = data.append(rs.getBoolean("success")).append("|");
                    String sla = rs.getString("slafault");
                    data = Utility.stringIsNullOrEmpty((String)sla) ? data.append("false").append("|") : data.append("true").append("|");
                    data = data.append(rs.getString("agenttype")).append("|").append(rs.getString("originalurl")).append("|");
                    byte[] msg = rs.getBytes("message");
                    data = msg != null && msg.length > 0 ? data.append(new String(msg, "UTF-8")).append("|") : data.append("|");
                    data = data.append(rs.getString("relatedtransactionid")).append("|").append(rs.getString("threadid")).append("|");
                    msg = rs.getBytes("requestheaders");
                    data = msg != null && msg.length > 0 ? data.append(Utility.DE((String)new String(msg, "UTF-8")).replace('|', ' ')).append("|") : data.append("|");
                    msg = rs.getBytes("responseheaders");
                    data = msg != null && msg.length > 0 ? data.append(Utility.DE((String)new String(msg, "UTF-8")).replace('|', ' ')).append("|") : data.append("|");
                    msg = rs.getBytes("requestxml");
                    data = msg != null && msg.length > 0 ? data.append(Utility.DE((String)new String(msg, "UTF-8"))).append("|") : data.append("|");
                    msg = rs.getBytes("responsexml");
                    data = msg != null && msg.length > 0 ? data.append(Utility.DE((String)new String(msg, "UTF-8"))).append("|") : data.append("|");
                    data = data.append(System.getProperty("line.separator"));
                    t = data.toString();
                    out.write(t, 0, t.length());
                }
                DBUtils.safeClose((ResultSet)rs);
            }
            catch (Exception ex) {
                Reporting.log.log((Priority)Level.ERROR, (Object)"", (Throwable)ex);
                break block16;
            }
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose((Connection)con);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception time) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateStatisticsCSVReport(ExportCSVDataRequestMsg request, String filenameandpath, List<String> filelist, String currentuser, String url, SecurityWrapper security) {
        block16: {
            if (!Reporting.isPolicyTypeOf(url, PolicyType.STATISTICAL)) {
                return;
            }
            StringBuilder data = new StringBuilder();
            Connection con = Utility.getPerformanceDBConnection();
            PreparedStatement com = null;
            OutputStreamWriter out = null;
            ResultSet rs = null;
            try {
                filelist.add(filenameandpath + Reporting.getFilePathDelimitor() + "StatisticsExport-" + Reporting.toSafeFileName(url) + ".csv");
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(filenameandpath + Reporting.getFilePathDelimitor() + "StatisticsExport-" + Reporting.toSafeFileName(url) + ".csv"), "UTF-8");
                data = data.append("%CLASSIFICATION% Generated at %DATETIME_NOW% for %DATETIME_FROM% until %DATETIME_TO% ").append(System.getProperty("line.separator"));
                data = data.append(url).append(System.getProperty("line.separator"));
                data = data.append("Host").append("|").append("Timestamp (ms since epoch)").append("|").append("Name").append("|").append("Consumer Count").append("|").append("Active Consumer Count").append("|").append("Type").append("|").append("Agent Type").append("|").append("Messages Sent").append("|").append("Messages Recieved").append("|").append("Messages Dropped").append("|").append("Bytes Sent").append("|").append("Bytes Recieved").append("|").append("Bytes Dropped").append("|").append("Queue Depth").append("|").append("Canonical Name").append("|").append(System.getProperty("line.separator"));
                Calendar time = Calendar.getInstance();
                String[] ampm = new String[]{"AM", "PM"};
                String t = data.toString();
                t = t.replaceAll("%DATETIME_NOW%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " at " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getStart();
                t = t.replaceAll("%DATETIME_FROM%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getEnd();
                t = t.replaceAll("%DATETIME_TO%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                if (request.getClassification() == null) {
                    request.setClassification(security);
                }
                t = t.replaceAll("%CLASSIFICATION%", Utility.ICMClassificationToString((ClassificationType)request.getClassification().getClassification()) + " Caveat: " + request.getClassification().getCaveats());
                data = new StringBuilder(t);
                data = data.append(System.getProperty("line.separator"));
                t = data.toString();
                out.write(t, 0, t.length());
                com = con.prepareStatement("select * from brokerhistory where host=? and utcdatetime > ? and utcdatetime < ? order by utcdatetime desc ;");
                com.setString(1, url);
                com.setLong(2, request.getRange().getStart().getTimeInMillis());
                com.setLong(3, request.getRange().getEnd().getTimeInMillis());
                rs = com.executeQuery();
                while (rs.next()) {
                    data = new StringBuilder();
                    data.append(rs.getString("host"));
                    data.append("|");
                    data.append(rs.getLong("utcdatetime"));
                    data.append("|");
                    data.append(rs.getString("namecol"));
                    data.append("|");
                    data.append(rs.getLong("consumercount"));
                    data.append("|");
                    data.append(rs.getLong("activeconsumercount"));
                    data.append("|");
                    data.append(rs.getString("typecol"));
                    data.append("|");
                    data.append(rs.getString("agenttype"));
                    data.append("|");
                    data.append(rs.getLong("messagecount"));
                    data.append("|");
                    data.append(rs.getLong("recievedmessagecount"));
                    data.append("|");
                    data.append(rs.getLong("messagedropcount"));
                    data.append("|");
                    data.append(rs.getLong("bytesout"));
                    data.append("|");
                    data.append(rs.getLong("bytesin"));
                    data.append("|");
                    data.append(rs.getLong("bytesdropcount"));
                    data.append("|");
                    data.append(rs.getLong("queuedepth"));
                    data.append("|");
                    data.append(rs.getString("canonicalname"));
                    data.append("|");
                    data.append(System.getProperty("line.separator"));
                    t = data.toString();
                    out.write(t, 0, t.length());
                }
                DBUtils.safeClose((ResultSet)rs);
            }
            catch (Exception ex) {
                Reporting.log.log((Priority)Level.ERROR, (Object)"", (Throwable)ex);
                break block16;
            }
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose((Connection)con);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception time) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateAvailabilityCSVReport(ExportCSVDataRequestMsg request, String filenameandpath, List<String> filelist, String currentuser, String url, SecurityWrapper security) {
        block15: {
            StringBuilder data = new StringBuilder();
            Connection con = Utility.getPerformanceDBConnection();
            PreparedStatement com = null;
            OutputStreamWriter out = null;
            ResultSet rs = null;
            try {
                filelist.add(filenameandpath + Reporting.getFilePathDelimitor() + "AvailabilityExport-" + Reporting.toSafeFileName(url) + ".csv");
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(filenameandpath + Reporting.getFilePathDelimitor() + "AvailabilityExport-" + Reporting.toSafeFileName(url) + ".csv"), "UTF-8");
                data = data.append("%CLASSIFICATION% Generated at %DATETIME_NOW% for %DATETIME_FROM% until %DATETIME_TO% ").append(System.getProperty("line.separator"));
                data = data.append(url).append(System.getProperty("line.separator"));
                data = data.append("URI").append("|").append("Timestamp (ms since epoch)").append("|").append("Record Id").append("|").append("Message").append("|").append("Operational").append(System.getProperty("line.separator"));
                Calendar time = Calendar.getInstance();
                String t = data.toString();
                String[] ampm = new String[]{"AM", "PM"};
                t = t.replaceAll("%DATETIME_NOW%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " at " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getStart();
                t = t.replaceAll("%DATETIME_FROM%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getEnd();
                t = t.replaceAll("%DATETIME_TO%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                if (request.getClassification() == null) {
                    request.setClassification(security);
                }
                t = t.replaceAll("%CLASSIFICATION%", Utility.ICMClassificationToString((ClassificationType)request.getClassification().getClassification()) + " Caveat: " + request.getClassification().getCaveats());
                t = t + System.getProperty("line.separator");
                out.write(t, 0, t.length());
                com = con.prepareStatement("select * from availability where uri=? and utcdatetime  > ? and utcdatetime < ? order by utcdatetime desc ;");
                com.setString(1, url);
                com.setLong(2, request.getRange().getStart().getTimeInMillis());
                com.setLong(3, request.getRange().getEnd().getTimeInMillis());
                rs = com.executeQuery();
                while (rs.next()) {
                    data = new StringBuilder();
                    data.append(rs.getString("uri"));
                    data.append("|");
                    data.append(rs.getLong("utcdatetime"));
                    data.append("|");
                    data.append(rs.getString("id"));
                    data.append("|");
                    data.append(Reporting.stripCommas(rs.getString("message")));
                    data.append("|");
                    data.append(rs.getBoolean("status"));
                    data.append(System.getProperty("line.separator"));
                    t = data.toString();
                    out.write(t, 0, t.length());
                }
                DBUtils.safeClose((ResultSet)rs);
            }
            catch (Exception ex) {
                Reporting.log.log((Priority)Level.ERROR, (Object)"", (Throwable)ex);
                break block15;
            }
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose((Connection)con);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception time) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateAuditCSVReport(ExportCSVDataRequestMsg request, String filenameandpath, List<String> filelist, String currentuser, SecurityWrapper security) {
        block15: {
            StringBuilder data = new StringBuilder();
            Connection con = Utility.getConfigurationDBConnection();
            OutputStreamWriter out = null;
            PreparedStatement com = null;
            ResultSet rs = null;
            try {
                filelist.add(filenameandpath + Reporting.getFilePathDelimitor() + "AuditExport.csv");
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(filenameandpath + Reporting.getFilePathDelimitor() + "AuditExport.csv"), "UTF-8");
                data = data.append("%CLASSIFICATION% Generated at %DATETIME_NOW% for %DATETIME_FROM% until %DATETIME_TO% ").append(System.getProperty("line.separator"));
                data = data.append("fgsms Audit Logs").append(System.getProperty("line.separator"));
                data = data.append("Timestamp (ms since epoch)").append("|").append("Username").append("|").append("Class").append("|").append("Method").append("|").append("Memo").append("|").append("Classification").append("|").append("IP Address").append(System.getProperty("line.separator"));
                Calendar time = Calendar.getInstance();
                String t = data.toString();
                String[] ampm = new String[]{"AM", "PM"};
                t = t.replaceAll("%DATETIME_NOW%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " at " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getStart();
                t = t.replaceAll("%DATETIME_FROM%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getEnd();
                t = t.replaceAll("%DATETIME_TO%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                if (request.getClassification() == null) {
                    request.setClassification(security);
                }
                t = t.replaceAll("%CLASSIFICATION%", Utility.ICMClassificationToString((ClassificationType)request.getClassification().getClassification()) + " Caveat: " + request.getClassification().getCaveats());
                t = t + System.getProperty("line.separator");
                out.write(t, 0, t.length());
                com = con.prepareStatement("select * from auditlog where utcdatetime  > ? and utcdatetime < ? order by utcdatetime desc ;");
                com.setLong(1, request.getRange().getStart().getTimeInMillis());
                com.setLong(2, request.getRange().getEnd().getTimeInMillis());
                rs = com.executeQuery();
                while (rs.next()) {
                    data = new StringBuilder();
                    data = data.append(rs.getString("utcdatetime")).append("|").append(rs.getString("username")).append("|").append(rs.getString("classname")).append("|").append(rs.getString("method")).append("|").append(new String(rs.getBytes("memo"), "UTF-8")).append("|").append(rs.getString("classification")).append("|").append(rs.getString("ipaddress"));
                    data = data.append(System.getProperty("line.separator"));
                    t = data.toString();
                    out.write(t, 0, t.length());
                }
                DBUtils.safeClose((ResultSet)rs);
            }
            catch (Exception ex) {
                Reporting.log.log((Priority)Level.ERROR, (Object)"", (Throwable)ex);
                break block15;
            }
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose((Connection)con);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception time) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateHardDriveCSVReport(ExportCSVDataRequestMsg request, String filenameandpath, List<String> filelist, String currentuser, String url, SecurityWrapper security) {
        block16: {
            if (!Reporting.isPolicyTypeOf(url, PolicyType.MACHINE)) {
                return;
            }
            StringBuilder data = new StringBuilder();
            Connection con = Utility.getConfigurationDBConnection();
            OutputStreamWriter out = null;
            PreparedStatement com = null;
            ResultSet rs = null;
            try {
                filelist.add(filenameandpath + Reporting.getFilePathDelimitor() + "DiskExport-" + Reporting.toSafeFileName(url) + ".csv");
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(filenameandpath + Reporting.getFilePathDelimitor() + "DiskExport-" + Reporting.toSafeFileName(url) + ".csv"), "UTF-8");
                data = data.append("%CLASSIFICATION% Generated at %DATETIME_NOW% for %DATETIME_FROM% until %DATETIME_TO% ").append(System.getProperty("line.separator"));
                data = data.append(url).append(System.getProperty("line.separator"));
                data = data.append("URI").append("|").append("Timestamp (ms since epoch)").append("|").append("Record Id").append("|").append("Free space").append("|").append("Write KB/sec").append("|").append("Read KB/sec").append("|").append("Dev ID").append("|").append("Drive ID").append("|").append("Operational").append("|").append("Status Message").append(System.getProperty("line.separator"));
                Calendar time = Calendar.getInstance();
                String t = data.toString();
                String[] ampm = new String[]{"AM", "PM"};
                t = t.replaceAll("%DATETIME_NOW%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " at " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getStart();
                t = t.replaceAll("%DATETIME_FROM%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getEnd();
                t = t.replaceAll("%DATETIME_TO%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                if (request.getClassification() == null) {
                    request.setClassification(security);
                }
                t = t.replaceAll("%CLASSIFICATION%", Utility.ICMClassificationToString((ClassificationType)request.getClassification().getClassification()) + " Caveat: " + request.getClassification().getCaveats());
                t = t + System.getProperty("line.separator");
                out.write(t, 0, t.length());
                com = con.prepareStatement("select * from rawdatadrives where uri=? and utcdatetime  > ? and utcdatetime < ? order by utcdatetime desc ;");
                com.setString(1, url);
                com.setLong(2, request.getRange().getStart().getTimeInMillis());
                com.setLong(3, request.getRange().getEnd().getTimeInMillis());
                rs = com.executeQuery();
                while (rs.next()) {
                    data = new StringBuilder();
                    data = data.append(rs.getString("uri")).append("|").append(rs.getLong("utcdatetime")).append("|").append(rs.getString("id")).append("|").append(rs.getLong("freespace")).append("|").append(rs.getLong("writeKBs")).append("|").append(rs.getLong("readKBs")).append("|").append(rs.getString("deviceidentifier")).append("|").append(rs.getString("driveidentifier")).append("|").append(rs.getBoolean("status")).append("|").append(rs.getString("statusmsg"));
                    data = data.append(System.getProperty("line.separator"));
                    t = data.toString();
                    out.write(t, 0, t.length());
                }
                DBUtils.safeClose((ResultSet)rs);
            }
            catch (Exception ex) {
                Reporting.log.log((Priority)Level.WARN, null, (Throwable)ex);
                break block16;
            }
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose((Connection)con);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception time) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateNetworkCSVReport(ExportCSVDataRequestMsg request, String filenameandpath, List<String> filelist, String currentuser, String url, SecurityWrapper security) {
        block16: {
            if (!Reporting.isPolicyTypeOf(url, PolicyType.MACHINE)) {
                return;
            }
            StringBuilder data = new StringBuilder();
            Connection con = Utility.getConfigurationDBConnection();
            OutputStreamWriter out = null;
            PreparedStatement com = null;
            ResultSet rs = null;
            try {
                filelist.add(filenameandpath + Reporting.getFilePathDelimitor() + "NetworkExport-" + Reporting.toSafeFileName(url) + ".csv");
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(filenameandpath + Reporting.getFilePathDelimitor() + "NetworkExport-" + Reporting.toSafeFileName(url) + ".csv"), "UTF-8");
                data = data.append("%CLASSIFICATION% Generated at %DATETIME_NOW% for %DATETIME_FROM% until %DATETIME_TO% ").append(System.getProperty("line.separator"));
                data = data.append(url).append(System.getProperty("line.separator"));
                data = data.append("URI").append("|").append("Timestamp (ms since epoch)").append("|").append("Record Id").append("|").append("NIC id").append("|").append("RX KB/sec").append("|").append("TX KB/sec").append(System.getProperty("line.separator"));
                Calendar time = GregorianCalendar.getInstance();
                String t = data.toString();
                String[] ampm = new String[]{"AM", "PM"};
                t = t.replaceAll("%DATETIME_NOW%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " at " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getStart();
                t = t.replaceAll("%DATETIME_FROM%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getEnd();
                t = t.replaceAll("%DATETIME_TO%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                if (request.getClassification() == null) {
                    request.setClassification(security);
                }
                t = t.replaceAll("%CLASSIFICATION%", Utility.ICMClassificationToString((ClassificationType)request.getClassification().getClassification()) + " Caveat: " + request.getClassification().getCaveats());
                t = t + System.getProperty("line.separator");
                out.write(t, 0, t.length());
                com = con.prepareStatement("select * from rawdatanic where uri=? and utcdatetime  > ? and utcdatetime < ? order by utcdatetime desc ;");
                com.setString(1, url);
                com.setLong(2, request.getRange().getStart().getTimeInMillis());
                com.setLong(3, request.getRange().getEnd().getTimeInMillis());
                rs = com.executeQuery();
                while (rs.next()) {
                    data = new StringBuilder();
                    data = data.append(rs.getString("uri")).append("|").append(rs.getLong("utcdatetime")).append("|").append(rs.getString("id")).append("|").append(rs.getString("nicid")).append("|").append(rs.getLong("receiveKBs")).append("|").append(rs.getLong("sendKBs"));
                    data = data.append(System.getProperty("line.separator"));
                    t = data.toString();
                    out.write(t, 0, t.length());
                }
                DBUtils.safeClose((ResultSet)rs);
            }
            catch (Exception ex) {
                Reporting.log.log((Priority)Level.ERROR, (Object)"", (Throwable)ex);
                break block16;
            }
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose((Connection)con);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception time) {}
            }
        }
    }

    private static void validateCSVRequest(ExportCSVDataRequestMsg request) {
        if (request.getExportType() == null) {
            throw new IllegalArgumentException("specify an export type");
        }
        switch (request.getExportType()) {
            case AUDIT_LOGS: {
                break;
            }
            case AVAILABILITY: {
                if (request.isAllServices() != null || !request.getURLs().isEmpty()) break;
                throw new IllegalArgumentException("either all services needs to be set, or specify a list of urls from which to export data.");
            }
            case STATISTICS: {
                if (request.isAllServices() != null || !request.getURLs().isEmpty()) break;
                throw new IllegalArgumentException("either all services needs to be set, or specify a list of urls from which to export data.");
            }
            case TRANSACTIONS: {
                if (request.isAllServices() == null && request.getURLs().isEmpty()) {
                    throw new IllegalArgumentException("either all services needs to be set, or specify a list of urls from which to export data.");
                }
            }
            case MACHINE: 
            case PROCESS: {
                if (request.isAllServices() != null || !request.getURLs().isEmpty()) break;
                throw new IllegalArgumentException("either all services needs to be set, or specify a list of urls from which to export data.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateMachineCSVReport(ExportCSVDataRequestMsg request, String filenameandpath, List<String> filelist, String currentuser, String url, SecurityWrapper security) {
        block20: {
            if (!Reporting.isPolicyTypeOf(url, PolicyType.MACHINE)) {
                return;
            }
            StringBuilder data = new StringBuilder();
            Connection con = Utility.getConfigurationDBConnection();
            OutputStreamWriter out = null;
            PreparedStatement com = null;
            ResultSet rs = null;
            try {
                filelist.add(filenameandpath + Reporting.getFilePathDelimitor() + "MachineExport-" + Reporting.toSafeFileName(url) + ".csv");
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(filenameandpath + Reporting.getFilePathDelimitor() + "MachineExport-" + Reporting.toSafeFileName(url) + ".csv"), "UTF-8");
                data = data.append("%CLASSIFICATION% Generated at %DATETIME_NOW% for %DATETIME_FROM% until %DATETIME_TO% ").append(System.getProperty("line.separator"));
                data = data.append(url).append(System.getProperty("line.separator"));
                data = data.append("URI").append("|").append("Timestamp (ms since epoch)").append("|").append("Record Id").append("|").append("Percent CPU").append("|").append("Memory").append("|").append("Threads").append("|").append("Open Files").append("|").append("Started At").append(System.getProperty("line.separator"));
                Calendar time = Calendar.getInstance();
                String t = data.toString();
                String[] ampm = new String[]{"AM", "PM"};
                t = t.replaceAll("%DATETIME_NOW%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " at " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getStart();
                t = t.replaceAll("%DATETIME_FROM%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getEnd();
                t = t.replaceAll("%DATETIME_TO%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                if (request.getClassification() == null) {
                    request.setClassification(security);
                }
                t = t.replaceAll("%CLASSIFICATION%", Utility.ICMClassificationToString((ClassificationType)request.getClassification().getClassification()) + " Caveat: " + request.getClassification().getCaveats());
                t = t + System.getProperty("line.separator");
                out.write(t, 0, t.length());
                com = con.prepareStatement("select * from rawdatamachineprocess where uri=? and utcdatetime  > ? and utcdatetime < ? order by utcdatetime desc ;");
                com.setString(1, url);
                com.setLong(2, request.getRange().getStart().getTimeInMillis());
                com.setLong(3, request.getRange().getEnd().getTimeInMillis());
                rs = com.executeQuery();
                while (rs.next()) {
                    data = new StringBuilder();
                    data = data.append(rs.getString("uri")).append("|").append(rs.getLong("utcdatetime")).append("|").append(rs.getString("id")).append("|").append(rs.getInt("percentCPU"));
                    Long l = rs.getLong("memoryused");
                    if (l != null) {
                        data = data.append("|").append(l.toString());
                    }
                    if ((l = Long.valueOf(rs.getLong("threads"))) != null) {
                        data = data.append("|").append(l.toString());
                    }
                    if ((l = Long.valueOf(rs.getLong("openfiles"))) != null) {
                        data = data.append("|").append(l.toString());
                    }
                    if ((l = Long.valueOf(rs.getLong("startedat"))) != null) {
                        data = data.append("|").append(l.toString());
                    }
                    data = data.append(System.getProperty("line.separator"));
                    t = data.toString();
                    out.write(t, 0, t.length());
                }
                DBUtils.safeClose((ResultSet)rs);
            }
            catch (Exception ex) {
                Reporting.log.log((Priority)Level.ERROR, (Object)"", (Throwable)ex);
                break block20;
            }
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose((Connection)con);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception time) {}
            }
        }
        CsvExporter.generateHardDriveCSVReport(request, filenameandpath, filelist, currentuser, url, security);
        CsvExporter.generateNetworkCSVReport(request, filenameandpath, filelist, currentuser, url, security);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateProcessCSVReport(ExportCSVDataRequestMsg request, String filenameandpath, List<String> filelist, String currentuser, String url, SecurityWrapper security) {
        block20: {
            if (!Reporting.isPolicyTypeOf(url, PolicyType.PROCESS)) {
                return;
            }
            StringBuilder data = new StringBuilder();
            Connection con = Utility.getConfigurationDBConnection();
            OutputStreamWriter out = null;
            PreparedStatement com = null;
            ResultSet rs = null;
            try {
                filelist.add(filenameandpath + Reporting.getFilePathDelimitor() + "ProcessExport-" + Reporting.toSafeFileName(url) + ".csv");
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(filenameandpath + Reporting.getFilePathDelimitor() + "ProcessExport-" + Reporting.toSafeFileName(url) + ".csv"), "UTF-8");
                data = data.append("%CLASSIFICATION% Generated at %DATETIME_NOW% for %DATETIME_FROM% until %DATETIME_TO% ").append(System.getProperty("line.separator"));
                data = data.append(url).append(System.getProperty("line.separator"));
                data = data.append("URI").append("|").append("Timestamp (ms since epoch)").append("|").append("Record Id").append("|").append("Percent CPU").append("|").append("Memory").append("|").append("Threads").append("|").append("Open Files").append("|").append("Started At").append(System.getProperty("line.separator"));
                Calendar time = Calendar.getInstance();
                String t = data.toString();
                String[] ampm = new String[]{"AM", "PM"};
                t = t.replaceAll("%DATETIME_NOW%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " at " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getStart();
                t = t.replaceAll("%DATETIME_FROM%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                time = request.getRange().getEnd();
                t = t.replaceAll("%DATETIME_TO%", time.get(1) + "/" + (time.get(2) + 1) + "/" + time.get(5) + " " + time.get(10) + ":" + time.get(12) + ":" + time.get(13) + " " + ampm[time.get(9)]);
                if (request.getClassification() == null) {
                    request.setClassification(security);
                }
                t = t.replaceAll("%CLASSIFICATION%", Utility.ICMClassificationToString((ClassificationType)request.getClassification().getClassification()) + " Caveat: " + request.getClassification().getCaveats());
                t = t + System.getProperty("line.separator");
                out.write(t, 0, t.length());
                com = con.prepareStatement("select * from rawdatamachineprocess where uri=? and utcdatetime  > ? and utcdatetime < ? order by utcdatetime desc ;");
                com.setString(1, url);
                com.setLong(2, request.getRange().getStart().getTimeInMillis());
                com.setLong(3, request.getRange().getEnd().getTimeInMillis());
                rs = com.executeQuery();
                while (rs.next()) {
                    data = new StringBuilder();
                    data = data.append(rs.getString("uri")).append("|").append(rs.getLong("utcdatetime")).append("|").append(rs.getString("id")).append("|").append(rs.getInt("percentCPU"));
                    Long l = rs.getLong("memoryused");
                    if (l != null) {
                        data = data.append("|").append(l.toString());
                    }
                    if ((l = Long.valueOf(rs.getLong("threads"))) != null) {
                        data = data.append("|").append(l.toString());
                    }
                    if ((l = Long.valueOf(rs.getLong("openfiles"))) != null) {
                        data = data.append("|").append(l.toString());
                    }
                    if ((l = Long.valueOf(rs.getLong("startedat"))) != null) {
                        data = data.append("|").append(l.toString());
                    }
                    data = data.append(System.getProperty("line.separator"));
                    t = data.toString();
                    out.write(t, 0, t.length());
                }
                DBUtils.safeClose((ResultSet)rs);
            }
            catch (Exception ex) {
                Reporting.log.log((Priority)Level.ERROR, (Object)"", (Throwable)ex);
                break block20;
            }
            finally {
                DBUtils.safeClose(rs);
                DBUtils.safeClose(com);
                DBUtils.safeClose((Connection)con);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            DBUtils.safeClose((PreparedStatement)com);
            DBUtils.safeClose((Connection)con);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception time) {}
            }
        }
    }
}

