/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.services.rs.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.AbstractSchedule;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.DailySchedule;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.Daynames;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.ImmediateSchedule;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.MonthlySchedule;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.Monthnames;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.OneTimeSchedule;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.ReportDefinition;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.WeeklySchedule;
import org.miloss.fgsms.services.rs.impl.FgsmsReportGenerator;

public class CalendarCalculator {
    public static boolean isTimeToRun(ReportDefinition get, Calendar now) {
        if (get == null) {
            throw new IllegalArgumentException();
        }
        Calendar cal = now;
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        for (int i = 0; i < get.getSchedule().getTriggers().size(); ++i) {
            Date starton = null;
            if (((AbstractSchedule)get.getSchedule().getTriggers().get(i)).getStartingAt() != null) {
                starton = ((AbstractSchedule)get.getSchedule().getTriggers().get(i)).getStartingAt().getTime();
            }
            Date nowDate = cal.getTime();
            if (starton != null && (starton.before(cal.getTime()) || starton.equals(cal.getTime())) && ((AbstractSchedule)get.getSchedule().getTriggers().get(i)).getStartingAt().get(11) == cal.get(11) && ((AbstractSchedule)get.getSchedule().getTriggers().get(i)).getStartingAt().get(12) == cal.get(12)) {
                DailySchedule d;
                if (((AbstractSchedule)get.getSchedule().getTriggers().get(i)).getClass().getCanonicalName().equalsIgnoreCase(DailySchedule.class.getCanonicalName())) {
                    d = (DailySchedule)get.getSchedule().getTriggers().get(i);
                    if (d.getReoccurs() == BigInteger.ONE) {
                        return true;
                    }
                    if (get.getLastRanAt() == null) {
                        return true;
                    }
                    Calendar nextrun = get.getLastRanAt();
                    int compare = nextrun.compareTo(cal);
                    FgsmsReportGenerator.log.log((Priority)Level.INFO, (Object)("compare value " + compare));
                    nextrun.add(5, d.getReoccurs().intValue());
                    if (nextrun.compareTo(cal) <= 0) {
                        return true;
                    }
                } else if (((AbstractSchedule)get.getSchedule().getTriggers().get(i)).getClass().getCanonicalName().equalsIgnoreCase(WeeklySchedule.class.getCanonicalName())) {
                    d = (WeeklySchedule)get.getSchedule().getTriggers().get(i);
                    if (CalendarCalculator.isTodayATriggerDay(d.getDayOfTheWeekIs())) {
                        if (get.getLastRanAt() == null) {
                            return true;
                        }
                        if (d.getReoccurs() == null || d.getReoccurs() != null && d.getReoccurs().intValue() == 1) {
                            return true;
                        }
                        Calendar lastRanAt = get.getLastRanAt();
                        if (lastRanAt == null) {
                            return true;
                        }
                        Calendar gcal = (Calendar)lastRanAt.clone();
                        gcal.add(5, 7 * d.getReoccurs().intValue());
                        ArrayList<Integer> dates = new ArrayList<Integer>();
                        dates.add(gcal.get(5));
                        if (CalendarCalculator.isNowATriggerDate(dates, now)) {
                            return true;
                        }
                    }
                } else if (((AbstractSchedule)get.getSchedule().getTriggers().get(i)).getClass().getCanonicalName().equalsIgnoreCase(MonthlySchedule.class.getCanonicalName())) {
                    d = (MonthlySchedule)get.getSchedule().getTriggers().get(i);
                    if (CalendarCalculator.isThisMonthATriggerMonth(d.getMonthNameIs(), now) && CalendarCalculator.isNowATriggerDate(d.getDayOfTheMonthIs(), now)) {
                        return true;
                    }
                } else {
                    if (((AbstractSchedule)get.getSchedule().getTriggers().get(i)).getClass().getCanonicalName().equalsIgnoreCase(OneTimeSchedule.class.getCanonicalName())) {
                        return true;
                    }
                    FgsmsReportGenerator.log.log((Priority)Level.WARN, (Object)("unhandled schedule type" + ((AbstractSchedule)get.getSchedule().getTriggers().get(i)).getClass().getCanonicalName()));
                }
            }
            if (get.getLastRanAt() != null || !((AbstractSchedule)get.getSchedule().getTriggers().get(i)).getClass().getCanonicalName().equalsIgnoreCase(ImmediateSchedule.class.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isThisMonthATriggerMonth(List<Monthnames> monthNameIs, Calendar cal) {
        if (monthNameIs.isEmpty()) {
            return false;
        }
        int month = cal.get(2);
        for (int i = 0; i < monthNameIs.size(); ++i) {
            if (monthNameIs.get(i) == Monthnames.JANURARY && month == 0) {
                return true;
            }
            if (monthNameIs.get(i) == Monthnames.FEBURARY && month == 1) {
                return true;
            }
            if (monthNameIs.get(i) == Monthnames.MARCH && month == 2) {
                return true;
            }
            if (monthNameIs.get(i) == Monthnames.APRIL && month == 3) {
                return true;
            }
            if (monthNameIs.get(i) == Monthnames.MAY && month == 4) {
                return true;
            }
            if (monthNameIs.get(i) == Monthnames.JUNE && month == 5) {
                return true;
            }
            if (monthNameIs.get(i) == Monthnames.JULY && month == 6) {
                return true;
            }
            if (monthNameIs.get(i) == Monthnames.AUGUST && month == 7) {
                return true;
            }
            if (monthNameIs.get(i) == Monthnames.SEPTEMBER && month == 8) {
                return true;
            }
            if (monthNameIs.get(i) == Monthnames.OCTOBER && month == 9) {
                return true;
            }
            if (monthNameIs.get(i) == Monthnames.NOVEMBER && month == 10) {
                return true;
            }
            if (monthNameIs.get(i) != Monthnames.DECEMBER || month != 11) continue;
            return true;
        }
        return false;
    }

    private static boolean isTodayATriggerDay(List<Daynames> days) {
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeInMillis(System.currentTimeMillis());
        int day = gcal.get(7);
        for (int i = 0; i < days.size(); ++i) {
            if (days.get(i) == Daynames.SUNDAY && day == 1) {
                return true;
            }
            if (days.get(i) == Daynames.MONDAY && day == 2) {
                return true;
            }
            if (days.get(i) == Daynames.TUESDAY && day == 3) {
                return true;
            }
            if (days.get(i) == Daynames.WEDNESDAY && day == 4) {
                return true;
            }
            if (days.get(i) == Daynames.THURSDAY && day == 5) {
                return true;
            }
            if (days.get(i) == Daynames.FRIDAY && day == 6) {
                return true;
            }
            if (days.get(i) != Daynames.SATURDAY || day != 7) continue;
            return true;
        }
        return false;
    }

    private static boolean isNowATriggerHour(List<Integer> hours) {
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeInMillis(System.currentTimeMillis());
        int hour = gcal.get(11);
        for (int i = 0; i < hours.size(); ++i) {
            if (hours.get(i) != hour) continue;
            return true;
        }
        return false;
    }

    private static boolean isNowATriggerDate(List<Integer> dayofmonth, Calendar now) {
        int day = now.get(5);
        for (int i = 0; i < dayofmonth.size(); ++i) {
            if (dayofmonth.get(i) != day) continue;
            return true;
        }
        return false;
    }
}

