/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.wsn;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.oasis_open.docs.wsn.b_2.TopicExpressionType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WSNUtility {
    static final Logger log = Logger.getLogger("WS-NotificationBroker");

    public static List<String> topicExpressionToList(TopicExpressionType te) {
        ArrayList<String> items = new ArrayList<String>();
        if (te == null) {
            return items;
        }
        if (te.getDialect().equalsIgnoreCase("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple")) {
            for (int k = 0; k < te.getContent().size(); ++k) {
                items.add(((String)te.getContent().get(k)).trim());
            }
        }
        return items;
    }

    public static String getWSAAddress(W3CEndpointReference ref) {
        try {
            Document xmlDocument = null;
            xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = xmlDocument.createElement("elem");
            ref.writeTo((Result)new DOMResult(element));
            NodeList nl = element.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address");
            if (nl != null && nl.getLength() > 0) {
                Element e = (Element)nl.item(0);
                log.log(Level.DEBUG, "return " + e.getTextContent().trim() + " for a callback address");
                return e.getTextContent().trim();
            }
        }
        catch (Exception ex) {
            log.log(Level.WARN, "unable to obtain a WS-Addressing endpoint", ex);
            ex.printStackTrace();
        }
        return null;
    }

    public static String listStringtoString(List<String> data) {
        if (data == null || data.isEmpty()) {
            return "";
        }
        String s = "";
        for (int i = 0; i < data.size(); ++i) {
            if (WSNUtility.stringIsNullOrEmpty(data.get(i))) continue;
            String t = data.get(i);
            if (WSNUtility.stringIsNullOrEmpty(t = t.trim())) continue;
            s = s + t + " ";
        }
        return s.substring(0, s.length() - 1);
    }

    public static boolean stringIsNullOrEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }
}

