/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.discovery.dns;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Level;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.plugins.agents.IEndpointDiscovery;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;

public class DNSDiscovery
implements IEndpointDiscovery {
    static final Logger log = Logger.getLogger("fgsms.DNSDiscovery");
    boolean DNSenabled = true;
    long lastlookup = 0L;

    private static List<String> DnsProbeTXT(String value) {
        log.log(Level.INFO, "Discovering endpoints for " + value + " via DNS TXT record search");
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Lookup up = null;
            Record[] run = null;
            up = new Lookup(value, 16);
            run = up.run();
            if (run != null) {
                for (int i = 0; i < run.length; ++i) {
                    TXTRecord tr = (TXTRecord)run[i];
                    String v = tr.rdataToString();
                    try {
                        if (tr.rdataToString().startsWith("\"") && tr.rdataToString().endsWith("\"")) {
                            v = v.substring(1, v.length() - 1);
                        }
                        if (v.toLowerCase().startsWith("http://") || v.toLowerCase().startsWith("https://")) {
                            ret.add(v);
                            continue;
                        }
                        log.log(Level.WARN, "throwing out value " + v + " as it is not parsable as a URL");
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.WARN, "throwing out value " + v + " as it is not parsable as a URL");
                    }
                }
            }
            if (up.getResult() != 0) {
                log.log(Level.ERROR, "Unable to discovery endpoints for " + value + " via DNS error: " + up.getErrorString());
            }
        }
        catch (Exception ex) {
            log.log(Level.ERROR, "Unable to discovery endpoints for " + value + " via DNS error", ex);
        }
        return ret;
    }

    @Override
    public void LoadConfig(Properties p) {
        try {
            this.DNSenabled = Boolean.parseBoolean(p.getProperty("discovery.dns.enabled").trim());
        }
        catch (Exception ex) {
            this.DNSenabled = false;
            log.log(Level.WARN, null, ex);
        }
    }

    @Override
    public List<String> GetDASURLs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void SetLastLookup(long timeinms) {
        this.lastlookup = timeinms;
    }

    @Override
    public long GetLastLookup() {
        return this.lastlookup;
    }

    @Override
    public boolean IsEnabled() {
        return this.DNSenabled;
    }

    private static List<String> DiscoverViaDNS(DiscoverType type) {
        return DNSDiscovery.DnsProbeTXT("fgsms-" + type.toString().toLowerCase());
    }

    @Override
    public List<String> GetPCSURLs() {
        return DNSDiscovery.DiscoverViaDNS(DiscoverType.PCS);
    }

    @Override
    public List<String> GetDCSURLs() {
        return DNSDiscovery.DiscoverViaDNS(DiscoverType.DCS);
    }

    @Override
    public List<String> GetSSURLs() {
        return DNSDiscovery.DiscoverViaDNS(DiscoverType.SS);
    }

    @Override
    public List<String> GetRSURLs() {
        return DNSDiscovery.DiscoverViaDNS(DiscoverType.RS);
    }

    @Override
    public List<String> GetARSURLs() {
        return DNSDiscovery.DiscoverViaDNS(DiscoverType.ARS);
    }

    @Override
    public List<String> GetURLs(String lookupkey) {
        return DNSDiscovery.DnsProbeTXT(lookupkey);
    }

    static enum DiscoverType {
        DAS,
        PCS,
        RS,
        ARS,
        SS,
        DCS;

    }
}

