/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.discovery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.ws.BindingProvider;
import org.apache.juddi.v3.client.UDDIService;
import org.apache.log4j.Level;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.plugins.agents.IEndpointDiscovery;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceList;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class UDDIDiscovery
implements IEndpointDiscovery {
    private static final Logger log = Logger.getLogger("fgsms.Discovery.UDDI");
    private UDDIService uddi = null;
    private UDDIInquiryPortType inquiry = this.uddi.getUDDIInquiryPort();
    private UDDISecurityPortType security = this.uddi.getUDDISecurityPort();
    private boolean LoginRequired = false;
    private String PCSlookupkey = "";
    private String DCSlookupkey = "";
    private String SSlookupkey = "";
    boolean uddiauth = true;
    boolean good;
    protected String username = "";
    protected String encryptedpassword = "";
    long lastlookup = 0L;
    boolean UddiEnabled = true;
    private findType currentFind = findType.EndpointBindingKey;

    private List<String> DiscoveryServiceEndpoints(String lookupkey, findType findType2) {
        ArrayList<String> list = new ArrayList<String>();
        switch (this.currentFind) {
            case EndpointBindingKey: {
                list.addAll(this.DiscoverEndpointBindingKey(lookupkey, null));
                break;
            }
            case EndpointKeyWord: {
                list.addAll(this.DiscoverEndpointKeyWord(lookupkey, null));
                break;
            }
            case ServiceEntityKey: {
                list.addAll(this.DiscoverByServiceKey(lookupkey, null));
            }
        }
        return new ArrayList<String>(new HashSet(list));
    }

    private List<String> DiscoverEndpointBindingKey(String key, String token) {
        if (Utility.stringIsNullOrEmpty(key)) {
            throw new IllegalArgumentException("bindingKey");
        }
        if (this.LoginRequired && this.uddiauth && Utility.stringIsNullOrEmpty(token)) {
            token = this.LoginWrapper();
        }
        GetBindingDetail req = new GetBindingDetail();
        req.setAuthInfo(token);
        req.getBindingKey().add(key);
        BindingDetail response = null;
        try {
            response = this.inquiry.getBindingDetail(req);
        }
        catch (Exception ex) {
            log.log(Level.ERROR, "error caught uddi agent endpoints", ex);
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (response != null && !response.getBindingTemplate().isEmpty()) {
            for (int i = 0; i < response.getBindingTemplate().size(); ++i) {
                if (response.getBindingTemplate().get(i).getAccessPoint() != null) {
                    ret.addAll(this.parseResults(response.getBindingTemplate().get(i).getAccessPoint(), token));
                }
                if (response.getBindingTemplate().get(i).getHostingRedirector() == null) continue;
                ret.addAll(this.DiscoverEndpointBindingKey(response.getBindingTemplate().get(i).getHostingRedirector().getBindingKey(), token));
            }
        }
        return ret;
    }

    private List<String> DiscoverByServiceKey(String key, String token) {
        if (key == null) {
            throw new IllegalArgumentException("keycol");
        }
        if (this.LoginRequired && this.uddiauth && Utility.stringIsNullOrEmpty(token)) {
            token = this.LoginWrapper();
        }
        GetServiceDetail req = new GetServiceDetail();
        req.getServiceKey().add(key);
        req.setAuthInfo(token);
        ServiceDetail response = null;
        try {
            response = this.inquiry.getServiceDetail(req);
        }
        catch (Exception ex) {
            log.log(Level.ERROR, "error caught discovering agent endpoints from uddi", ex);
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (response == null || response == null || response.getBusinessService() == null || response.getBusinessService().isEmpty()) {
            return ret;
        }
        for (int i = 0; i < response.getBusinessService().size(); ++i) {
            if (response.getBusinessService().get(i).getBindingTemplates() == null) continue;
            for (int k = 0; k < response.getBusinessService().get(i).getBindingTemplates().getBindingTemplate().size(); ++k) {
                if (response.getBusinessService().get(i).getBindingTemplates().getBindingTemplate().get(k).getAccessPoint() == null) continue;
                ret.addAll(this.parseResults(response.getBusinessService().get(i).getBindingTemplates().getBindingTemplate().get(k).getAccessPoint(), token));
            }
        }
        return ret;
    }

    private List<String> DiscoverEndpointKeyWord(String key, String token) {
        if (key == null) {
            throw new IllegalArgumentException("keywords");
        }
        if (this.LoginRequired && this.uddiauth && Utility.stringIsNullOrEmpty(token)) {
            token = this.LoginWrapper();
        }
        FindService req = new FindService();
        Name n = new Name();
        n.setValue(key);
        req.getName().add(n);
        req.setFindQualifiers(new FindQualifiers());
        req.getFindQualifiers().getFindQualifier().add("approximateMatch");
        req.getFindQualifiers().getFindQualifier().add("caseInsensitiveMatch");
        req.setAuthInfo(token);
        ServiceList response = null;
        ArrayList<String> ret = new ArrayList<String>();
        try {
            response = this.inquiry.findService(req);
        }
        catch (Exception ex) {
            log.log(Level.ERROR, "error discoverying agent endpoints", ex);
            return ret;
        }
        if (response == null || response.getServiceInfos() == null || response.getServiceInfos().getServiceInfo().isEmpty()) {
            log.log(Level.INFO, "Discovery from service name search in UDDI yielded no results.");
            return ret;
        }
        GetServiceDetail sreq = new GetServiceDetail();
        sreq.setAuthInfo(token);
        for (int k = 0; k < response.getServiceInfos().getServiceInfo().size(); ++k) {
            sreq.getServiceKey().add(response.getServiceInfos().getServiceInfo().get(k).getServiceKey());
        }
        ServiceDetail sresponse = null;
        try {
            sresponse = this.inquiry.getServiceDetail(sreq);
        }
        catch (Exception ex) {
            log.log(Level.ERROR, "error discoverying agent endpoints", ex);
            return ret;
        }
        if (sresponse != null && !sresponse.getBusinessService().isEmpty()) {
            log.log(Level.INFO, "Discovery from service name search in UDDI yielded " + sresponse.getBusinessService().size() + " results.");
            for (int i = 0; i < sresponse.getBusinessService().size(); ++i) {
                if (sresponse.getBusinessService().get(i).getBindingTemplates() == null) continue;
                for (int k = 0; k < sresponse.getBusinessService().get(i).getBindingTemplates().getBindingTemplate().size(); ++k) {
                    if (sresponse.getBusinessService().get(i).getBindingTemplates().getBindingTemplate().get(k).getAccessPoint() == null) continue;
                    ret.addAll(this.parseResults(sresponse.getBusinessService().get(i).getBindingTemplates().getBindingTemplate().get(k).getAccessPoint(), token));
                }
            }
        } else {
            log.log(Level.INFO, "Discovery from service name search in UDDI yielded no results");
        }
        return ret;
    }

    private List<String> parseResults(AccessPoint ap, String authtoken) {
        ArrayList<String> ret = new ArrayList<String>();
        boolean ok = false;
        if (!Utility.stringIsNullOrEmpty(ap.getUseType())) {
            if (ap.getUseType().equalsIgnoreCase("endpoint")) {
                if (ap.getValue().toLowerCase().startsWith("http")) {
                    ret.add(ap.getValue());
                }
                ok = true;
            } else if (ap.getUseType().equalsIgnoreCase("bindingtemplate") || ap.getUseType().equalsIgnoreCase("hostingredirector")) {
                try {
                    ret.addAll(this.DiscoverEndpointBindingKey(ap.getValue(), authtoken));
                }
                catch (Exception ex) {
                    log.log(Level.WARN, "trouble discoverying endpoint from UDDI." + ex);
                }
                ok = true;
            } else if (ap.getUseType().equalsIgnoreCase("bindingtemplate") || ap.getUseType().equalsIgnoreCase("hostingredirector")) {
                ret.addAll(this.DiscoverEndpointByWSDL(ap.getValue()));
                ok = true;
            }
            if (!ok && ap.getValue().toLowerCase().startsWith("http")) {
                ret.add(ap.getValue());
            }
        }
        return ret;
    }

    private List<String> DiscoverEndpointByWSDL(String value) {
        return new ArrayList<String>();
    }

    @Override
    public List<String> GetRSURLs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<String> GetARSURLs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<String> GetURLs(String lookupkey) {
        return this.DiscoveryServiceEndpoints(lookupkey, this.currentFind);
    }

    @Override
    public List<String> GetDASURLs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void SetLastLookup(long timeinms) {
        this.lastlookup = timeinms;
    }

    @Override
    public long GetLastLookup() {
        return this.lastlookup;
    }

    @Override
    public void LoadConfig(Properties props) {
        try {
            if (props == null) {
                throw new IllegalArgumentException("check for configuration file, uddi.properties");
            }
            try {
                this.UddiEnabled = Boolean.parseBoolean(props.getProperty("discovery.uddi.enabled").trim());
            }
            catch (Exception ex) {
                this.UddiEnabled = false;
                log.log(Level.WARN, null, ex);
            }
            this.inquiry = this.uddi.getUDDIInquiryPort();
            BindingProvider bpPCS = (BindingProvider)this.inquiry;
            Map contextPCS = bpPCS.getRequestContext();
            if (!Utility.stringIsNullOrEmpty(props.getProperty("discovery.uddi.inquiry.url"))) {
                contextPCS.put("javax.xml.ws.service.endpoint.address", props.getProperty("discovery.uddi.inquiry.url"));
            }
            if (Utility.stringIsNullOrEmpty(props.getProperty("discovery.uddi.lookup.dcs.servicename"))) {
                this.DCSlookupkey = "fgsms.DCS";
                log.log(Level.WARN, "fgsms discovery.uddi.lookup.dcs.servicename lookup key is not defined. defaulting to fgsms.DCS");
            } else {
                this.DCSlookupkey = props.getProperty("discovery.uddi.lookup.dcs.servicename");
            }
            if (Utility.stringIsNullOrEmpty(props.getProperty("discovery.uddi.lookup.ss.servicename"))) {
                this.DCSlookupkey = "fgsms.SS";
                log.log(Level.WARN, "fgsms discovery.uddi.lookup.ss.servicename lookup key is not defined. defaulting to fgsms.SS");
            } else {
                this.SSlookupkey = props.getProperty("discovery.uddi.lookup.ss.servicename");
            }
            if (Utility.stringIsNullOrEmpty(props.getProperty("discovery.uddi.lookup.pcs.servicename"))) {
                this.PCSlookupkey = "fgsms.PCS";
                log.log(Level.WARN, "fgsms discovery.uddi.lookup.pcs.servicename lookup key is not defined. defaulting to fgsms.PCS");
            } else {
                this.PCSlookupkey = props.getProperty("discovery.uddi.lookup.pcs.servicename");
            }
            if (Utility.stringIsNullOrEmpty(props.getProperty("discovery.uddi.inquiry.authrequired"))) {
                this.LoginRequired = false;
                log.log(Level.WARN, "fgsms discovery.uddi.lookup.dcs.servicename lookup key is not defined. defaulting to fgsms.DCS");
            } else {
                this.LoginRequired = Boolean.parseBoolean(props.getProperty("discovery.uddi.inquiry.authrequired"));
            }
            try {
                this.currentFind = findType.valueOf(props.getProperty("discovery.uddi.lookup.findType"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.LoginRequired) {
                String t = props.getProperty("discovery.uddi.inquiry.authmode");
                this.uddiauth = !t.equalsIgnoreCase("http");
                if (this.uddiauth) {
                    try {
                        this.security = this.uddi.getUDDISecurityPort();
                        bpPCS = (BindingProvider)this.security;
                        contextPCS = bpPCS.getRequestContext();
                        if (!Utility.stringIsNullOrEmpty(props.getProperty("discovery.uddi.security.url"))) {
                            contextPCS.put("javax.xml.ws.service.endpoint.address", props.getProperty("discovery.uddi.security.url"));
                        }
                        this.username = (String)props.get("discovery.uddi.security.username");
                        if (Utility.stringIsNullOrEmpty(this.username)) {
                            throw new IllegalArgumentException("username is empty");
                        }
                        this.encryptedpassword = (String)props.get("discovery.uddi.security.password");
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("UDDI Login required, but the security service could not be initialized.", e);
                    }
                } else {
                    contextPCS.put("javax.xml.ws.security.auth.username", props.getProperty("discovery.uddi.security.username"));
                    contextPCS.put("javax.xml.ws.security.auth.password", Utility.DE(props.getProperty("discovery.uddi.security.password")));
                }
            }
            this.good = true;
        }
        catch (Exception ex) {
            log.log(Level.WARN, "Unable to initialize uddi inquiry parameters for rollover or load balancing. check the agent configuration file, " + ex);
            this.good = false;
        }
    }

    @Override
    public boolean IsEnabled() {
        return this.UddiEnabled;
    }

    private String LoginWrapper() {
        return this.Login(this.username, this.encryptedpassword);
    }

    private String Login(String username, String encryptedpassword) {
        if (Utility.stringIsNullOrEmpty(username) || Utility.stringIsNullOrEmpty(encryptedpassword)) {
            return "";
        }
        GetAuthToken request = new GetAuthToken();
        request.setUserID(username);
        request.setCred(Utility.DE(encryptedpassword));
        try {
            AuthToken response = this.security.getAuthToken(request);
            return response.getAuthInfo();
        }
        catch (Exception ex) {
            log.log(Level.ERROR, "Error authenticating to the UDDI server: ", ex);
            this.good = false;
            return "";
        }
    }

    @Override
    public List<String> GetPCSURLs() {
        return this.DiscoveryServiceEndpoints(this.PCSlookupkey, this.currentFind);
    }

    @Override
    public List<String> GetDCSURLs() {
        return this.DiscoveryServiceEndpoints(this.DCSlookupkey, this.currentFind);
    }

    @Override
    public List<String> GetSSURLs() {
        return this.DiscoveryServiceEndpoints(this.SSlookupkey, this.currentFind);
    }

    public static enum findType {
        EndpointBindingKey,
        EndpointKeyWord,
        ServiceEntityKey;

    }
}

