/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.log4j.Level;
import org.miloss.fgsms.common.AuditLogger;
import org.miloss.fgsms.common.CXFUserIdentifyUtil;
import org.miloss.fgsms.common.DBUtils;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;

public class UserIdentityUtil {
    public static final String logname = "fgsms.UserIdentityUtil";
    static final Logger log = Logger.getLogger("fgsms.UserIdentityUtil");

    public static void assertReadAccess(String uri, String currentUser, String fromFunction, SecurityWrapper classification, WebServiceContext session) {
        try {
            if (session != null) {
                if (session.isUserInRole("fgsms_GLOBAL_ADMINISTRATOR")) {
                    return;
                }
                if (session.isUserInRole("fgsms_GLOBAL_WRITE")) {
                    return;
                }
                if (session.isUserInRole("fgsms_GLOBAL_READ")) {
                    return;
                }
                if (session.isUserInRole("fgsms_GLOBAL_AUDITOR")) {
                    return;
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.DEBUG, "error type casting servlet request context", ex);
        }
        Connection con = Utility.getConfigurationDBConnection();
        PreparedStatement comm = null;
        ResultSet r = null;
        try {
            comm = con.prepareStatement("Select count(*)where  ? in (\tSelect Username\tfrom UserPermissions\tWhere (UserPermissions.Username=? AND\tUserPermissions.ObjectURI=?)\tAND\t((UserPermissions.ReadObject=true OR \tUserPermissions.WriteObject=true OR\tUserPermissions.AdministerObject=true OR\tUserPermissions.AuditObject=true))\t)or 'everyone' in (\tSelect Username\tfrom UserPermissions\tWhere (UserPermissions.Username='everyone' AND\tUserPermissions.ObjectURI=?)\tAND\t((UserPermissions.ReadObject=true OR \tUserPermissions.WriteObject=true OR\tUserPermissions.AdministerObject=true OR\tUserPermissions.AuditObject=true))\t)or ?  in (\tselect Users.Username\tfrom Users\tWhere Users.Username=?\tAND Users.rolecol='admin');");
            comm.setString(1, currentUser);
            comm.setString(2, currentUser);
            comm.setString(3, uri);
            comm.setString(4, uri);
            comm.setString(5, currentUser);
            comm.setString(6, currentUser);
            r = comm.executeQuery();
            r.next();
            int right = 0;
            right = r.getInt(1);
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            if (right == 0) {
                log.log(Level.ERROR, currentUser + " does not have fgsms read rights for " + uri + " from " + fromFunction);
                AuditLogger.logItem(UserIdentityUtil.class.getCanonicalName(), fromFunction, currentUser, "read deny", classification, null);
                throw new SecurityException("Access Denied");
            }
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SecurityException) {
                    throw (SecurityException)ex;
                }
                log.log(Level.ERROR, "Error caught querying database for " + currentUser + ":fgsms read rights for " + uri + " from " + fromFunction, ex);
                throw new SecurityException("Access Denied");
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                throw throwable;
            }
        }
        DBUtils.safeClose(r);
        DBUtils.safeClose(comm);
        DBUtils.safeClose(con);
    }

    public static void assertWriteAccess(String uri, String currentUser, String fromFunction, SecurityWrapper classification, WebServiceContext session) {
        try {
            if (session != null) {
                if (session.isUserInRole("fgsms_GLOBAL_ADMINISTRATOR")) {
                    return;
                }
                if (session.isUserInRole("fgsms_GLOBAL_WRITE")) {
                    return;
                }
                if (session.isUserInRole("fgsms_GLOBAL_AUDITOR")) {
                    return;
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.DEBUG, "error type casting servlet request context", ex);
        }
        Connection con = Utility.getConfigurationDBConnection();
        PreparedStatement comm = null;
        ResultSet r = null;
        try {
            comm = con.prepareStatement("Select count(*)where  ? in (\tSelect Username\tfrom UserPermissions\tWhere (UserPermissions.Username=? AND\tUserPermissions.ObjectURI=?)\tAND\t((UserPermissions.WriteObject=true OR\tUserPermissions.AdministerObject=true OR\tUserPermissions.AuditObject=true))\t) or 'everyone' in (\tSelect Username\tfrom UserPermissions\tWhere (UserPermissions.Username='everyone' AND\tUserPermissions.ObjectURI=?)\tAND\t((UserPermissions.WriteObject=true OR\tUserPermissions.AdministerObject=true OR\tUserPermissions.AuditObject=true))\t)or ?  in (\tselect Users.Username\tfrom Users\tWhere Users.Username=?\tAND Users.rolecol='admin');");
            comm.setString(1, currentUser);
            comm.setString(2, currentUser);
            comm.setString(3, uri);
            comm.setString(4, uri);
            comm.setString(5, currentUser);
            comm.setString(6, currentUser);
            r = comm.executeQuery();
            r.next();
            int right = 0;
            right = r.getInt(1);
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            if (right == 0) {
                log.log(Level.ERROR, currentUser + " does not have fgsms write rights for " + uri + " from " + fromFunction);
                AuditLogger.logItem(UserIdentityUtil.class.getCanonicalName(), fromFunction, currentUser, "write deny", classification, null);
                throw new SecurityException("Access Denied");
            }
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SecurityException) {
                    throw (SecurityException)ex;
                }
                log.log(Level.ERROR, "Error caught querying database for " + currentUser + ":fgsms write rights for " + uri + " from " + fromFunction, ex);
                throw new SecurityException("Access Denied");
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                throw throwable;
            }
        }
        DBUtils.safeClose(r);
        DBUtils.safeClose(comm);
        DBUtils.safeClose(con);
    }

    public static void assertAuditAccess(String uri, String currentUser, String fromFunction, SecurityWrapper classification, WebServiceContext session) {
        try {
            if (session.isUserInRole("fgsms_GLOBAL_AUDITOR")) {
                return;
            }
            if (session.isUserInRole("fgsms_GLOBAL_ADMINISTRATOR")) {
                return;
            }
        }
        catch (Exception ex) {
            log.log(Level.DEBUG, "error type casting servlet request context", ex);
        }
        Connection con = Utility.getConfigurationDBConnection();
        PreparedStatement comm = null;
        ResultSet r = null;
        try {
            comm = con.prepareStatement("Select count(*)where ?  in (\tSelect Username\tfrom UserPermissions\tWhere (UserPermissions.Username=? AND\tUserPermissions.ObjectURI=?)\tAND\t((UserPermissions.AdministerObject=true OR\tUserPermissions.AuditObject=true))\t)or 'everyone'  in (\tSelect Username\tfrom UserPermissions\tWhere (UserPermissions.Username='everyone' AND\tUserPermissions.ObjectURI=?)\tAND\t((UserPermissions.AdministerObject=true OR\tUserPermissions.AuditObject=true))\t)or ?  in (\tselect Users.Username\tfrom Users\tWhere Users.Username=?\tAND (Users.rolecol='admin' OR Users.rolecol='audit'));");
            comm.setString(1, currentUser);
            comm.setString(2, currentUser);
            comm.setString(3, uri);
            comm.setString(4, uri);
            comm.setString(5, currentUser);
            comm.setString(6, currentUser);
            r = comm.executeQuery();
            r.next();
            int right = 0;
            right = r.getInt(1);
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            if (right == 0) {
                AuditLogger.logItem(UserIdentityUtil.class.getCanonicalName(), fromFunction, currentUser, "audit deny", classification, null);
                log.log(Level.ERROR, currentUser + " does not have fgsms audit rights for " + uri + " from " + fromFunction);
                throw new SecurityException("Access Denied");
            }
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SecurityException) {
                    throw (SecurityException)ex;
                }
                log.log(Level.ERROR, "Error caught querying database for " + currentUser + ":fgsms audit rights for " + uri + " from " + fromFunction, ex);
                throw new SecurityException("Access Denied");
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                throw throwable;
            }
        }
        DBUtils.safeClose(r);
        DBUtils.safeClose(comm);
        DBUtils.safeClose(con);
    }

    public static void assertAdministerAccess(String uri, String currentUser, String fromFunction, SecurityWrapper classification, WebServiceContext session) {
        try {
            if (session != null && session.isUserInRole("fgsms_GLOBAL_ADMINISTRATOR")) {
                return;
            }
        }
        catch (Exception ex) {
            log.log(Level.DEBUG, "error type casting servlet request context", ex);
        }
        Connection con = Utility.getConfigurationDBConnection();
        PreparedStatement comm = null;
        ResultSet r = null;
        try {
            comm = con.prepareStatement("Select count(*)where  ? in (\tSelect Username\tfrom UserPermissions\tWhere (UserPermissions.Username=? AND\tUserPermissions.ObjectURI=?)\tAND\t((UserPermissions.AdministerObject=true))\t)or ?  in (\tselect Users.Username\tfrom Users\tWhere Users.Username=?\tAND Users.rolecol='admin');");
            comm.setString(1, currentUser);
            comm.setString(2, currentUser);
            comm.setString(3, uri);
            comm.setString(4, currentUser);
            comm.setString(5, currentUser);
            r = comm.executeQuery();
            r.next();
            int right = 0;
            right = r.getInt(1);
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            if (right == 0) {
                log.log(Level.ERROR, currentUser + " does not have fgsms administer rights for " + uri + " from " + fromFunction);
                AuditLogger.logItem(UserIdentityUtil.class.getCanonicalName(), fromFunction, currentUser, "admin deny", classification, null);
                throw new SecurityException("Access Denied");
            }
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SecurityException) {
                    throw (SecurityException)ex;
                }
                log.log(Level.ERROR, "Error caught querying database for " + currentUser + ":fgsms administer rights for " + uri + " from " + fromFunction + "Msg: " + ex.getLocalizedMessage());
                throw new SecurityException("Access Denied");
            }
            catch (Throwable throwable) {
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                throw throwable;
            }
        }
        DBUtils.safeClose(r);
        DBUtils.safeClose(comm);
        DBUtils.safeClose(con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void assertGlobalAdministratorRole(String currentUser, String fromFunction, SecurityWrapper classification, WebServiceContext session) {
        ResultSet r;
        PreparedStatement comm;
        Connection con;
        block11: {
            block10: {
                if (Utility.stringIsNullOrEmpty(currentUser)) {
                    throw new SecurityException("Access Denied");
                }
                try {
                    if (session != null && session.isUserInRole("fgsms_GLOBAL_ADMINISTRATOR")) {
                        return;
                    }
                }
                catch (Exception ex) {
                    log.log(Level.DEBUG, "error type casting servlet request context", ex);
                }
                con = Utility.getConfigurationDBConnection();
                comm = null;
                r = null;
                try {
                    comm = con.prepareStatement("Select rolecol from Users where Username=?;");
                    comm.setString(1, currentUser);
                    r = comm.executeQuery();
                    while (r.next()) {
                        String s = r.getString(1);
                        if (Utility.stringIsNullOrEmpty(s) || !s.equalsIgnoreCase("admin")) continue;
                        DBUtils.safeClose(r);
                        DBUtils.safeClose(comm);
                        DBUtils.safeClose(con);
                        break block10;
                    }
                    break block11;
                }
                catch (Exception ex) {
                    try {
                        log.log(Level.ERROR, "Error caught determining if " + currentUser + " has fgsms global admin rights. " + fromFunction, ex);
                        throw new SecurityException("Access Denied");
                    }
                    catch (Throwable throwable) {
                        DBUtils.safeClose(r);
                        DBUtils.safeClose(comm);
                        DBUtils.safeClose(con);
                        throw throwable;
                    }
                }
            }
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return;
        }
        DBUtils.safeClose(r);
        DBUtils.safeClose(comm);
        DBUtils.safeClose(con);
        log.log(Level.ERROR, currentUser + " does not have fgsms Global Admin rights." + fromFunction);
        AuditLogger.logItem(UserIdentityUtil.class.getCanonicalName(), fromFunction, currentUser, "global admin deny", classification, null);
        throw new SecurityException("Access Denied");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasGlobalAdministratorRole(String currentUser, String fromFunction, SecurityWrapper classification, WebServiceContext session) {
        try {
            if (session != null && session.isUserInRole("fgsms_GLOBAL_ADMINISTRATOR")) {
                return true;
            }
        }
        catch (Exception ex) {
            UserIdentityUtil.log.log(Level.DEBUG, "error type casting servlet request context", ex);
        }
        con = Utility.getConfigurationDBConnection();
        comm = null;
        r = null;
        try {
            comm = con.prepareStatement("Select rolecol from Users where Username=?;");
            comm.setString(1, currentUser);
            r = comm.executeQuery();
lbl14:
            // 2 sources

            while (r.next()) {
                s = null;
                s = r.getString("rolecol");
                if (!Utility.stringIsNullOrEmpty(s)) ** GOTO lbl-1000
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                var8_10 = false;
                ** GOTO lbl33
            }
            ** GOTO lbl46
        }
        catch (Exception ex) {
            try {
                UserIdentityUtil.log.log(Level.ERROR, "Error caught determining if " + currentUser + " has fgsms global admin rights. Assuming the answer is no." + fromFunction, ex);
            }
            catch (Throwable var9_12) {
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                throw var9_12;
            }
lbl33:
            // 1 sources

            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return var8_10;
lbl-1000:
            // 1 sources

            {
                if (!s.equalsIgnoreCase("admin")) ** GOTO lbl14
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                var8_11 = true;
            }
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return var8_11;
lbl46:
            // 1 sources

            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return false;
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return false;
        }
    }

    public static String getFirstIdentityToString(WebServiceContext webctx) {
        if (webctx == null) {
            return "anonymous";
        }
        if (webctx.getUserPrincipal() != null && !Utility.stringIsNullOrEmpty(webctx.getUserPrincipal().getName())) {
            return webctx.getUserPrincipal().getName();
        }
        MessageContext mc = webctx.getMessageContext();
        try {
            String user;
            if (mc == null) {
                return "anonymous";
            }
            Object cxfAuthz = mc.get((Object)"org.apache.cxf.configuration.security.AuthorizationPolicy");
            if (cxfAuthz != null && !Utility.stringIsNullOrEmpty(user = CXFUserIdentifyUtil.getFirstIdentityToString(cxfAuthz))) {
                return user;
            }
            HttpServletRequest session = (HttpServletRequest)mc.get((Object)"javax.xml.ws.servlet.request");
            if (session == null || session.getUserPrincipal() == null) {
                return "anonymous";
            }
            if (Utility.stringIsNullOrEmpty(session.getAuthType())) {
                return "anonymous";
            }
            if (!Utility.stringIsNullOrEmpty(session.getUserPrincipal().getName())) {
                return session.getUserPrincipal().getName();
            }
        }
        catch (Exception ex) {
            log.log(Level.ERROR, "Error caught determining the current user identity. Assuming anonymous.", ex);
        }
        return "anonymous";
    }

    public static void assertAgentRole(String currentUser, String fromFunction, SecurityWrapper currentLevel, WebServiceContext session) {
        ResultSet r;
        PreparedStatement comm;
        Connection con;
        block7: {
            try {
                if (session != null && session.isUserInRole("fgsms_GLOBAL_AGENT")) {
                    return;
                }
            }
            catch (Exception ex) {
                log.log(Level.DEBUG, "error type casting servlet request context", ex);
            }
            con = Utility.getConfigurationDBConnection();
            comm = null;
            r = null;
            try {
                comm = con.prepareStatement("Select rolecol from Users where Username=?;");
                comm.setString(1, currentUser);
                r = comm.executeQuery();
                if (!r.next()) break block7;
                String s = null;
                s = r.getString(1);
                if (Utility.stringIsNullOrEmpty(s) || !s.equalsIgnoreCase("agent")) break block7;
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
            }
            catch (Exception ex) {
                try {
                    log.log(Level.ERROR, "Error caught determining if " + currentUser + " has fgsms agent rights. " + fromFunction, ex);
                    throw new SecurityException("Access Denied");
                }
                catch (Throwable throwable) {
                    DBUtils.safeClose(r);
                    DBUtils.safeClose(comm);
                    DBUtils.safeClose(con);
                    throw throwable;
                }
            }
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return;
        }
        DBUtils.safeClose(r);
        DBUtils.safeClose(comm);
        DBUtils.safeClose(con);
        log.log(Level.ERROR, currentUser + " does not have fgsms agent rights." + fromFunction);
        AuditLogger.logItem(UserIdentityUtil.class.getCanonicalName(), fromFunction, currentUser, "agent deny", currentLevel, null);
        throw new SecurityException("Access Denied");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTrustedAgent(String currentUser, String fromFunction, SecurityWrapper classification, WebServiceContext session) {
        ResultSet r;
        PreparedStatement comm;
        Connection con;
        block7: {
            boolean bl;
            try {
                if (session != null && session.isUserInRole("fgsms_GLOBAL_AGENT")) {
                    return true;
                }
            }
            catch (Exception ex) {
                log.log(Level.DEBUG, "error type casting servlet request context", ex);
            }
            con = Utility.getConfigurationDBConnection();
            comm = null;
            r = null;
            try {
                String s;
                comm = con.prepareStatement("Select rolecol from Users where Username=?;");
                comm.setString(1, currentUser);
                r = comm.executeQuery();
                if (!r.next() || Utility.stringIsNullOrEmpty(s = r.getString(1)) || !s.equalsIgnoreCase("agent")) break block7;
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                bl = true;
            }
            catch (Exception ex) {
                try {
                    log.log(Level.ERROR, "Error caught determining if " + currentUser + " has fgsms agent rights. " + fromFunction, ex);
                }
                catch (Throwable throwable) {
                    DBUtils.safeClose(r);
                    DBUtils.safeClose(comm);
                    DBUtils.safeClose(con);
                    throw throwable;
                }
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
            }
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return bl;
        }
        DBUtils.safeClose(r);
        DBUtils.safeClose(comm);
        DBUtils.safeClose(con);
        return false;
    }

    public static void assertAdminOrAgentRole(String currentUser, String fromFunction, SecurityWrapper currentLevel, WebServiceContext mc) {
        ResultSet r;
        PreparedStatement comm;
        Connection con;
        block9: {
            try {
                if (mc != null) {
                    if (mc.isUserInRole("fgsms_GLOBAL_AGENT")) {
                        return;
                    }
                    if (mc.isUserInRole("fgsms_GLOBAL_ADMINISTRATOR")) {
                        return;
                    }
                }
            }
            catch (Exception ex) {
                log.log(Level.DEBUG, "error type casting servlet request context", ex);
            }
            con = Utility.getConfigurationDBConnection();
            comm = null;
            r = null;
            try {
                String s;
                comm = con.prepareStatement("Select rolecol from Users where Username=?;");
                comm.setString(1, currentUser);
                r = comm.executeQuery();
                if (!r.next() || Utility.stringIsNullOrEmpty(s = r.getString(1)) || !s.equalsIgnoreCase("agent") && !s.equalsIgnoreCase("admin")) break block9;
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
            }
            catch (Exception ex) {
                try {
                    log.log(Level.ERROR, "Error caught determining if " + currentUser + " has fgsms agent or admin rights. " + fromFunction, ex);
                    throw new SecurityException("Access Denied");
                }
                catch (Throwable throwable) {
                    DBUtils.safeClose(r);
                    DBUtils.safeClose(comm);
                    DBUtils.safeClose(con);
                    throw throwable;
                }
            }
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return;
        }
        DBUtils.safeClose(r);
        DBUtils.safeClose(comm);
        DBUtils.safeClose(con);
        log.log(Level.ERROR, currentUser + " does not have fgsms agent or admin rights." + fromFunction);
        AuditLogger.logItem(UserIdentityUtil.class.getCanonicalName(), fromFunction, currentUser, "agent deny", currentLevel, null);
        throw new SecurityException("Access Denied");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void assertAuditRole(String currentUser, String fromFunction, SecurityWrapper classification, WebServiceContext session) {
        ResultSet r;
        PreparedStatement comm;
        Connection con;
        block13: {
            block12: {
                if (Utility.stringIsNullOrEmpty(currentUser)) {
                    throw new SecurityException("Access Denied");
                }
                try {
                    if (session != null) {
                        if (session.isUserInRole("fgsms_GLOBAL_AUDITOR")) {
                            return;
                        }
                        if (session.isUserInRole("fgsms_GLOBAL_ADMINISTRATOR")) {
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    log.log(Level.DEBUG, "error type casting servlet request context", ex);
                }
                con = Utility.getConfigurationDBConnection();
                comm = null;
                r = null;
                try {
                    comm = con.prepareStatement("Select rolecol from Users where Username=?;");
                    comm.setString(1, currentUser);
                    r = comm.executeQuery();
                    while (r.next()) {
                        String s = r.getString(1);
                        if (Utility.stringIsNullOrEmpty(s) || !s.equalsIgnoreCase("audit") && !s.equalsIgnoreCase("admin")) continue;
                        DBUtils.safeClose(r);
                        DBUtils.safeClose(comm);
                        DBUtils.safeClose(con);
                        break block12;
                    }
                    break block13;
                }
                catch (Exception ex) {
                    try {
                        log.log(Level.ERROR, "Error caught determining if " + currentUser + " has fgsms global audit rights. " + fromFunction, ex);
                        throw new SecurityException("Access Denied");
                    }
                    catch (Throwable throwable) {
                        DBUtils.safeClose(r);
                        DBUtils.safeClose(comm);
                        DBUtils.safeClose(con);
                        throw throwable;
                    }
                }
            }
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return;
        }
        DBUtils.safeClose(r);
        DBUtils.safeClose(comm);
        DBUtils.safeClose(con);
        log.log(Level.ERROR, currentUser + " does not have fgsms Global audit rights." + fromFunction);
        AuditLogger.logItem(UserIdentityUtil.class.getCanonicalName(), fromFunction, currentUser, "global audit deny", classification, null);
        throw new SecurityException("Access Denied");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasGlobalAuditRole(String currentUser, String fromFunction, SecurityWrapper classification, WebServiceContext session) {
        try {
            if (session != null) {
                if (session.isUserInRole("fgsms_GLOBAL_AUDITOR")) {
                    return true;
                }
                if (session.isUserInRole("fgsms_GLOBAL_ADMINISTRATOR")) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            UserIdentityUtil.log.log(Level.DEBUG, "error type casting servlet request context", ex);
        }
        con = Utility.getConfigurationDBConnection();
        comm = null;
        r = null;
        try {
            comm = con.prepareStatement("Select rolecol from Users where Username=?;");
            comm.setString(1, currentUser);
            r = comm.executeQuery();
lbl17:
            // 2 sources

            while (r.next()) {
                s = null;
                s = r.getString("rolecol");
                if (!Utility.stringIsNullOrEmpty(s)) ** GOTO lbl-1000
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                var8_10 = false;
                ** GOTO lbl36
            }
            ** GOTO lbl49
        }
        catch (Exception ex) {
            try {
                UserIdentityUtil.log.log(Level.ERROR, "Error caught determining if " + currentUser + " has fgsms global audit rights. Assuming the answer is no." + fromFunction, ex);
            }
            catch (Throwable var9_12) {
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                throw var9_12;
            }
lbl36:
            // 1 sources

            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return var8_10;
lbl-1000:
            // 1 sources

            {
                if (!s.equalsIgnoreCase("audit") && !s.equalsIgnoreCase("admin")) ** GOTO lbl17
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                var8_11 = true;
            }
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return var8_11;
lbl49:
            // 1 sources

            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return false;
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void assertGlobalAuditRole(String currentUser, String fromFunction, SecurityWrapper classification, WebServiceContext session) {
        ResultSet r;
        PreparedStatement comm;
        Connection con;
        block13: {
            block12: {
                if (Utility.stringIsNullOrEmpty(currentUser)) {
                    throw new SecurityException("Access Denied");
                }
                try {
                    if (session != null) {
                        if (session.isUserInRole("fgsms_GLOBAL_ADMINISTRATOR")) {
                            return;
                        }
                        if (session.isUserInRole("fgsms_GLOBAL_AUDITOR")) {
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    log.log(Level.DEBUG, "error type casting servlet request context", ex);
                }
                con = Utility.getConfigurationDBConnection();
                comm = null;
                r = null;
                try {
                    comm = con.prepareStatement("Select rolecol from Users where Username=?;");
                    comm.setString(1, currentUser);
                    r = comm.executeQuery();
                    while (r.next()) {
                        String s = r.getString(1);
                        if (Utility.stringIsNullOrEmpty(s) || !s.equalsIgnoreCase("admin") && !s.equalsIgnoreCase("audit")) continue;
                        DBUtils.safeClose(r);
                        DBUtils.safeClose(comm);
                        DBUtils.safeClose(con);
                        break block12;
                    }
                    break block13;
                }
                catch (Exception ex) {
                    try {
                        log.log(Level.ERROR, "Error caught determining if " + currentUser + " has fgsms global audit rights. " + fromFunction, ex);
                        throw new SecurityException("Access Denied");
                    }
                    catch (Throwable throwable) {
                        DBUtils.safeClose(r);
                        DBUtils.safeClose(comm);
                        DBUtils.safeClose(con);
                        throw throwable;
                    }
                }
            }
            DBUtils.safeClose(r);
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return;
        }
        DBUtils.safeClose(r);
        DBUtils.safeClose(comm);
        DBUtils.safeClose(con);
        log.log(Level.ERROR, currentUser + " does not have fgsms Global audit rights." + fromFunction);
        AuditLogger.logItem(UserIdentityUtil.class.getCanonicalName(), fromFunction, currentUser, "global audit deny", classification, null);
        throw new SecurityException("Access Denied");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasReadAccess(String currentUser, String fromFunction, String uri, SecurityWrapper classification, WebServiceContext session) {
        block12: {
            boolean bl;
            try {
                if (session != null) {
                    if (session.isUserInRole("fgsms_GLOBAL_ADMINISTRATOR")) {
                        return true;
                    }
                    if (session.isUserInRole("fgsms_GLOBAL_WRITE")) {
                        return true;
                    }
                    if (session.isUserInRole("fgsms_GLOBAL_READ")) {
                        return true;
                    }
                    if (session.isUserInRole("fgsms_GLOBAL_AUDITOR")) {
                        return true;
                    }
                }
            }
            catch (Exception ex) {
                log.log(Level.DEBUG, "error type casting servlet request context", ex);
            }
            Connection con = Utility.getConfigurationDBConnection();
            PreparedStatement comm = null;
            ResultSet r = null;
            try {
                comm = con.prepareStatement("Select count(*)where  ? in (\tSelect Username\tfrom UserPermissions\tWhere (UserPermissions.Username=? AND\tUserPermissions.ObjectURI=?)\tAND\t((UserPermissions.ReadObject=true OR \tUserPermissions.WriteObject=true OR\tUserPermissions.AdministerObject=true OR\tUserPermissions.AuditObject=true))\t)or 'everyone' in (\tSelect Username\tfrom UserPermissions\tWhere (UserPermissions.Username='everyone' AND\tUserPermissions.ObjectURI=?)\tAND\t((UserPermissions.ReadObject=true OR \tUserPermissions.WriteObject=true OR\tUserPermissions.AdministerObject=true OR\tUserPermissions.AuditObject=true))\t)or ?  in (\tselect Users.Username\tfrom Users\tWhere Users.Username=?\tAND Users.rolecol='admin');");
                comm.setString(1, currentUser);
                comm.setString(2, currentUser);
                comm.setString(3, uri);
                comm.setString(4, uri);
                comm.setString(5, currentUser);
                comm.setString(6, currentUser);
                r = comm.executeQuery();
                r.next();
                int right = r.getInt(1);
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
                bl = right != 0;
                DBUtils.safeClose(r);
            }
            catch (Exception ex) {
                log.log(Level.ERROR, "Error caught querying database for " + currentUser + ":fgsms read rights for " + uri + " from " + fromFunction, ex);
                break block12;
            }
            finally {
                DBUtils.safeClose(r);
                DBUtils.safeClose(comm);
                DBUtils.safeClose(con);
            }
            DBUtils.safeClose(comm);
            DBUtils.safeClose(con);
            return bl;
        }
        return false;
    }
}

