/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.common;

import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggingEvent;

public class Logger {
    static final String CHAR_WHITELIST = "[^A-Za-z0-9 \\?\\\\\\!@#\\$%\\^&\\*\\(\\)\\;\\:/\\.,\\+\\<\\>\\-_\\=\\{\\}\\|'\"\\[\\]]";
    final org.apache.log4j.Logger parent;

    private static String protect(Object message) {
        if (message == null) {
            return null;
        }
        String content = message.toString();
        if (content != null) {
            return content.replaceAll(CHAR_WHITELIST, "");
        }
        return null;
    }

    protected Logger(String name) {
        this.parent = org.apache.log4j.Logger.getLogger(name);
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    public static Logger getLogger(Class clazz) {
        return new Logger(clazz.getName());
    }

    public static Logger getRootLogger() {
        return new Logger("");
    }

    public static Logger getLogger(String name, LoggerFactory factory) {
        return new Logger(name);
    }

    public void trace(Object message) {
        this.parent.trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.parent.trace(message, t);
    }

    public boolean isTraceEnabled() {
        return this.parent.isTraceEnabled();
    }

    public synchronized void addAppender(Appender newAppender) {
        this.parent.addAppender(newAppender);
    }

    public void assertLog(boolean assertion, String msg) {
        this.parent.assertLog(assertion, msg);
    }

    public void callAppenders(LoggingEvent event) {
        this.parent.callAppenders(event);
    }

    public void debug(Object message) {
        this.parent.debug(Logger.protect(message));
    }

    public void debug(Object message, Throwable t) {
        this.parent.debug(Logger.protect(message), t);
    }

    public void error(Object message) {
        this.parent.error(Logger.protect(message));
    }

    public void error(Object message, Throwable t) {
        this.parent.error(Logger.protect(message), t);
    }

    public void fatal(Object message) {
        this.parent.fatal(Logger.protect(message));
    }

    public void fatal(Object message, Throwable t) {
        this.parent.fatal(Logger.protect(message), t);
    }

    public boolean getAdditivity() {
        return this.parent.getAdditivity();
    }

    public synchronized Enumeration getAllAppenders() {
        return this.parent.getAllAppenders();
    }

    public synchronized Appender getAppender(String name) {
        return this.parent.getAppender(name);
    }

    public Level getEffectiveLevel() {
        return this.parent.getEffectiveLevel();
    }

    public Priority getChainedPriority() {
        return this.parent.getChainedPriority();
    }

    public final String getName() {
        return this.parent.getName();
    }

    public final Category getParent() {
        return this.parent.getParent();
    }

    public final Level getLevel() {
        return this.parent.getLevel();
    }

    public final Level getPriority() {
        return this.parent.getPriority();
    }

    public ResourceBundle getResourceBundle() {
        return this.parent.getResourceBundle();
    }

    public void info(Object message) {
        this.parent.info(Logger.protect(message));
    }

    public void info(Object message, Throwable t) {
        this.parent.info(Logger.protect(message), t);
    }

    public boolean isAttached(Appender appender) {
        return this.parent.isAttached(appender);
    }

    public boolean isDebugEnabled() {
        return this.parent.isDebugEnabled();
    }

    public boolean isEnabledFor(Priority level) {
        return this.parent.isEnabledFor(level);
    }

    public boolean isInfoEnabled() {
        return this.parent.isInfoEnabled();
    }

    public void l7dlog(Priority priority, String key, Throwable t) {
        this.parent.l7dlog(priority, key, t);
    }

    public void l7dlog(Priority priority, String key, Object[] params, Throwable t) {
        this.parent.l7dlog(priority, key, params, t);
    }

    public void log(Priority priority, Object message, Throwable t) {
        this.parent.log(priority, Logger.protect(message), t);
    }

    public void log(Priority priority, Object message) {
        this.parent.log(priority, Logger.protect(message));
    }

    public void log(String callerFQCN, Priority level, Object message, Throwable t) {
        this.parent.log(callerFQCN, level, Logger.protect(message), t);
    }

    public synchronized void removeAllAppenders() {
        this.parent.removeAllAppenders();
    }

    public synchronized void removeAppender(Appender appender) {
        this.parent.removeAppender(appender);
    }

    public synchronized void removeAppender(String name) {
        this.parent.removeAppender(name);
    }

    public void setAdditivity(boolean additive) {
        this.parent.setAdditivity(additive);
    }

    public void setLevel(Level level) {
        this.parent.setLevel(level);
    }

    public void setPriority(Priority priority) {
        this.parent.setPriority(priority);
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.parent.setResourceBundle(bundle);
    }

    public static void shutdown() {
        org.apache.log4j.Logger.shutdown();
    }

    public void warn(Object message) {
        this.parent.warn(Logger.protect(message));
    }

    public void warn(Object message, Throwable t) {
        this.parent.warn(Logger.protect(message), t);
    }
}

