/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import org.apache.log4j.Level;
import org.miloss.fgsms.common.AesCbcWithIntegrity;
import org.miloss.fgsms.common.Logger;

public class AES {
    public static final boolean isJCEInstalled;
    public static final String logname = "fgsms.Utility";
    public static final Logger log;
    private static final String something128 = "m0b3b70CH0P4Ua7rxksnRw==:o1QNVJ/KY453VEB3VsQn39tQpu5yKovGAH/LQvyzawI=";

    public static String GEN() {
        return AES.GEN((short)128);
    }

    public static String GEN(short keysize) {
        try {
            return AesCbcWithIntegrity.generateKey().toString();
        }
        catch (GeneralSecurityException ex) {
            log.log(Level.ERROR, "There was an error generating key, this could indicate that you're making a 256 bit key on a system that does not have the Java Crypto Extensions installed. . Is JCE installed? " + (isJCEInstalled ? "yes " : "no ") + ex.getMessage());
            log.log(Level.DEBUG, "error generating key, this could indicate that you're making a 256 bit key on a system that does not have the Java Crypto Extensions installed. " + ex.getMessage(), ex);
            return null;
        }
    }

    private URI getUrl(String FileName) {
        URL pcsurl = null;
        if (pcsurl == null) {
            try {
                pcsurl = Thread.currentThread().getContextClassLoader().getResource(FileName);
                log.log(Level.DEBUG, "Loading encryption key from " + pcsurl.toString());
            }
            catch (Exception ex) {
                log.log(Level.DEBUG, "not found", ex);
            }
        }
        if (pcsurl == null) {
            try {
                pcsurl = Thread.currentThread().getContextClassLoader().getResource("/" + FileName);
                log.log(Level.DEBUG, "Loading encryption key from " + pcsurl.toString());
            }
            catch (Exception ex) {
                log.log(Level.DEBUG, "not found", ex);
            }
        }
        if (pcsurl == null) {
            try {
                pcsurl = new URL(FileName);
                log.log(Level.DEBUG, "Loading encryption key from " + pcsurl.toString());
            }
            catch (Exception ex) {
                log.log(Level.DEBUG, "not found", ex);
            }
        }
        if (pcsurl == null) {
            try {
                pcsurl = AES.class.getClassLoader().getResource(FileName);
                log.log(Level.DEBUG, "Loading encryption key from " + pcsurl.toString());
            }
            catch (Exception ex) {
                log.log(Level.DEBUG, "not found", ex);
            }
        }
        if (pcsurl == null) {
            try {
                pcsurl = AES.class.getClassLoader().getResource("/" + FileName);
                log.log(Level.DEBUG, "Loading encryption key from " + pcsurl.toString());
            }
            catch (Exception ex) {
                log.log(Level.DEBUG, "not found", ex);
            }
        }
        try {
            if (pcsurl != null) {
                return pcsurl.toURI();
            }
        }
        catch (URISyntaxException ex) {
            log.log(Level.DEBUG, null, ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readAllText(File file) {
        if (file == null || !file.exists()) {
            log.log(Level.WARN, "Referenced key does not exist" + file.getAbsolutePath());
            return null;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            String str = AES.readAllText(stream);
            stream.close();
            String string = str;
            return string;
        }
        catch (Exception e) {
            log.log(Level.DEBUG, "error reading key", e);
            String string = null;
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {
                    log.log(Level.DEBUG, "error reading key", ex);
                }
            }
        }
    }

    private static String readAllText(InputStream stream) {
        try {
            int size = 1024;
            byte[] chars = new byte[size];
            int k = stream.read(chars);
            StringBuilder str = new StringBuilder();
            while (k > 0) {
                for (int i = 0; i < k; ++i) {
                    str.append((char)chars[i]);
                }
                k = stream.read(chars);
            }
            stream.close();
            return str.toString();
        }
        catch (Exception e) {
            log.log(Level.DEBUG, "error reading key", e);
            return null;
        }
    }

    private static String loadKey() {
        String key = null;
        if (System.getenv("fgsms.keyFile") != null) {
            key = AES.readAllText(new File(System.getenv("fgsms.keyFile")));
        } else if (key == null && System.getProperty("fgsms.keyFile") != null) {
            key = AES.readAllText(new File(System.getProperty("fgsms.keyFile")));
        } else if (key == null) {
            File f;
            try {
                f = new File(new AES().getUrl("fgsms-aes128.key"));
                key = AES.readAllText(f);
            }
            catch (Exception ex) {
                log.log(Level.DEBUG, null, ex);
            }
            if (key == null) {
                try {
                    f = new File(AES.class.getResource("fgsms-aes128.key").toURI());
                    key = AES.readAllText(f);
                }
                catch (Exception ex) {
                    log.log(Level.DEBUG, null, ex);
                }
            }
            if (key == null) {
                try {
                    InputStream is = AES.class.getResourceAsStream("fgsms-aes128.key");
                    key = AES.readAllText(is);
                    is.close();
                }
                catch (Exception ex) {
                    log.log(Level.DEBUG, null, ex);
                }
            }
        }
        if (key != null) {
            log.log(Level.DEBUG, "key loaded from file");
            return key;
        }
        log.log(Level.WARN, "Could not load the key, using hard coded default key instead. This should be considered a security risk.");
        return something128;
    }

    public static String EN(String cleartext) throws Exception {
        return AES.EN(cleartext, AES.loadKey());
    }

    public static String EN(String cleartext, String key) throws Exception {
        AesCbcWithIntegrity.SecretKeys skey = AesCbcWithIntegrity.keys(key);
        AesCbcWithIntegrity.CipherTextIvMac encrypt = AesCbcWithIntegrity.encrypt(cleartext, skey);
        return encrypt.toString();
    }

    public static String DE(String ciphertext) throws Exception {
        return AES.DE(ciphertext, AES.loadKey());
    }

    public static String DE(String ciphertext, String key) throws Exception {
        AesCbcWithIntegrity.SecretKeys skey = AesCbcWithIntegrity.keys(key);
        AesCbcWithIntegrity.CipherTextIvMac civ = new AesCbcWithIntegrity.CipherTextIvMac(ciphertext);
        return AesCbcWithIntegrity.decryptString(civ, skey);
    }

    public static boolean validateKey(String key) {
        try {
            String src = "abcdefghijklmopqrstuvwxyz123567890!@#$%^&*()_+{}|:\">?<,";
            String x = AES.EN(src, key);
            String y = AES.DE(x, key);
            return y.equals(src) && !x.equals(y);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static {
        log = Logger.getLogger(logname);
        String key = AES.GEN((short)256);
        isJCEInstalled = AES.validateKey(key);
    }
}

