/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agents;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.utils.LockableHashtable;
import org.apache.log4j.Level;
import org.miloss.fgsms.agentcore.IMessageProcessor;
import org.miloss.fgsms.agentcore.MessageProcessor;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Axis1MonitorOutbound
implements Handler {
    private Logger log = Logger.getLogger("fgsms.Agents");
    protected boolean makeLockable = false;
    protected Hashtable options;
    protected String name;

    public void invoke(MessageContext mc) throws AxisFault {
        this.log.log(Level.INFO, "Current VM Memory : total = " + Runtime.getRuntime().totalMemory() + " free = " + Runtime.getRuntime().freeMemory());
        Boolean isRequest = false;
        isRequest = !mc.getPastPivot();
        if (isRequest.booleanValue()) {
            try {
                this.ProcessOutboundRequest(mc);
            }
            catch (Exception ex) {
                this.log.log(Level.WARN, "fgsms Error processing outbound message", ex);
            }
        } else {
            try {
                this.ProcessOutboundResponse(mc, false);
            }
            catch (Exception ex) {
                this.log.log(Level.WARN, "fgsms Error processing outbound message", ex);
            }
        }
    }

    protected void setOptionsLockable(boolean makeLockable) {
        this.makeLockable = makeLockable;
    }

    protected void initHashtable() {
        this.options = this.makeLockable ? new LockableHashtable() : new Hashtable();
    }

    public void init() {
    }

    public void cleanup() {
    }

    public boolean canHandleBlock(QName qname) {
        return false;
    }

    public void onFault(MessageContext mc) {
        Boolean isRequest = false;
        isRequest = !mc.getPastPivot();
        if (isRequest.booleanValue()) {
            try {
                this.ProcessOutboundRequest(mc);
            }
            catch (Exception ex) {
                this.log.log(Level.WARN, "fgsms Error processing outbound message", ex);
            }
        } else {
            try {
                this.ProcessOutboundResponse(mc, true);
            }
            catch (Exception ex) {
                this.log.log(Level.WARN, "fgsms Error processing outbound message", ex);
            }
        }
    }

    public void setOption(String name, Object value) {
        if (this.options == null) {
            this.initHashtable();
        }
        this.options.put(name, value);
    }

    public boolean setOptionDefault(String name, Object value) {
        boolean val;
        boolean bl = val = (this.options == null || this.options.get(name) == null) && value != null;
        if (val) {
            this.setOption(name, value);
        }
        return val;
    }

    public Object getOption(String name) {
        if (this.options == null) {
            return null;
        }
        return this.options.get(name);
    }

    public Hashtable getOptions() {
        return this.options;
    }

    public void setOptions(Hashtable opts) {
        this.options = opts;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Element getDeploymentData(Document doc) {
        this.log.log(Level.INFO, "Enter: BasicHandler::getDeploymentData");
        Element root = doc.createElementNS("", "handler");
        root.setAttribute("class", this.getClass().getName());
        this.options = this.getOptions();
        if (this.options != null) {
            Enumeration e = this.options.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                Object v = this.options.get(k);
                Element e1 = doc.createElementNS("", "option");
                e1.setAttribute("name", k);
                e1.setAttribute("value", v.toString());
                root.appendChild(e1);
            }
        }
        this.log.log(Level.INFO, "Exit: BasicHandler::getDeploymentData");
        return root;
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
    }

    public List getUnderstoodHeaders() {
        return null;
    }

    private void ProcessOutboundRequest(MessageContext messageContext) {
        long now = System.currentTimeMillis();
        try {
            IMessageProcessor iMessageProcessor = MessageProcessor.getSingletonObject();
        }
        catch (Exception ex) {
            this.log.log(Level.ERROR, "Unable to get a reference to the Message Processor singleton object", ex);
        }
        this.log.log(Level.DEBUG, "Current VM Memory : total = " + Runtime.getRuntime().totalMemory() + " free = " + Runtime.getRuntime().freeMemory());
        UUID id = UUID.randomUUID();
        messageContext.setProperty("fgsms.messagekey", (Object)id);
        Message msg = messageContext.getCurrentMessage();
        String transactionthreadid = "";
        String action = "";
        HashMap<String, Object> headers = new HashMap<String, Object>();
        try {
            MimeHeaders me = messageContext.getMessage().getMimeHeaders();
            Iterator it = me.getAllHeaders();
            while (it.hasNext()) {
                MimeHeader h = (MimeHeader)it.next();
                if (h == null) continue;
                headers.put(h.getName(), h.getValue());
                if (!h.getName().equalsIgnoreCase("SOAPAction")) continue;
                action = h.getValue();
            }
        }
        catch (Exception ex) {
            this.log.log(Level.WARN, "unexpected error caught obtaining http headers from message context" + ex.getLocalizedMessage());
        }
        action = messageContext.getOperation().getName();
        if (!Utility.stringIsNullOrEmpty(action)) {
            action = action.replace("\"", "");
            action = action.replace("'", "");
        }
        if (Utility.stringIsNullOrEmpty(action) && messageContext.useSOAPAction() && !Utility.stringIsNullOrEmpty(action = messageContext.getSOAPActionURI())) {
            action = action.replace("\"", "");
            action = action.replace("'", "");
        }
        if (action.toLowerCase().trim().equals("{urn:org:miloss:fgsms:services:interfaces:dataCollector}AddMoreData".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for DCS AddData to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        if (action.toLowerCase().trim().equals("urn:org:miloss:fgsms:services:interfaces:dataCollector/dataCollectorService/AddMoreData".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for DCS AddData to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        if (action.toLowerCase().trim().equals("urn:org:miloss:fgsms:services:interfaces:dataCollector/dataCollectorService/AddData".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for DCS AddData to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        if (action.toLowerCase().trim().equals("urn:org:miloss:fgsms:services:interfaces:policyConfiguration/policyConfigurationService/GetServicePolicy".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for PCS GetServicePolicy to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        if (action.toLowerCase().trim().equals("{urn:org:miloss:fgsms:services:interfaces:dataCollector}AddData".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for DCS AddData to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        if (action.toLowerCase().trim().equals("{urn:org:miloss:fgsms:services:interfaces:policyConfiguration}GetServicePolicy".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for PCS GetServicePolicy to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        String requestURL = (String)messageContext.getProperty("transport.url");
        String messagexml = "";
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            msg.writeTo((OutputStream)b);
            messagexml = b.toString("UTF-8");
        }
        catch (Exception ex) {
            this.log.log(Level.WARN, "fgsms, error obtaining request message.", ex);
        }
        if (Utility.stringIsNullOrEmpty(action) || action.equals("/DDS")) {
            action = Utility.getActionNameFromXML(messagexml);
            if (Utility.stringIsNullOrEmpty(action)) {
                action = "urn:undeterminable";
            }
            action = action.replace("\"", "");
            action = action.replace("'", "");
        }
        if (Utility.stringIsNullOrEmpty(action)) {
            action = "urn:undeterminable";
        }
        String ip = "";
        try {
            ip = (String)messageContext.getProperty("remoteaddr");
        }
        catch (Exception exception) {
            // empty catch block
        }
        transactionthreadid = MessageProcessor.getSingletonObject().getTransactionThreadId(Thread.currentThread().getId());
        if (Utility.stringIsNullOrEmpty(transactionthreadid)) {
            try {
                transactionthreadid = UUID.randomUUID().toString();
            }
            catch (Exception ex) {
                this.log.log(Level.WARN, "error caught build transaction thread id", ex);
            }
        }
        if (MessageProcessor.getSingletonObject().isDependencyInjectionEnabled()) {
            ArrayList<String> t = new ArrayList<String>();
            t.add(transactionthreadid);
            headers.put("fgsms.transactionthreadid", t);
            t = new ArrayList();
            t.add(id.toString());
            headers.put("fgsms.messageid", t);
            msg.getMimeHeaders().addHeader("fgsms.transactionthreadid", transactionthreadid);
            msg.getMimeHeaders().addHeader("fgsms.messageid", id.toString());
        }
        this.log.log(Level.DEBUG, "fgsms Agent for Axis 1.x, inbound message for " + requestURL + " action " + action);
        String relatedTransaction = null;
        String user = "";
        if (!Utility.stringIsNullOrEmpty((String)messageContext.getProperty("authenticatedUser"))) {
            user = (String)messageContext.getProperty("authenticatedUser");
        }
        messageContext.setProperty("fgsms.requesturl", (Object)requestURL);
        MessageProcessor.getSingletonObject().processMessageInput(messagexml, messagexml.length(), requestURL, action, user, id.toString(), headers, ip, this.getClass().getCanonicalName() + "client", relatedTransaction, transactionthreadid);
    }

    private void ProcessOutboundResponse(MessageContext messageContext, boolean fault) throws SOAPException {
        MimeHeaders mimeHeaders;
        long now = System.currentTimeMillis();
        UUID id = (UUID)messageContext.getProperty("fgsms.messagekey");
        String requrl = (String)messageContext.getProperty("fgsms.requesturl");
        if (id == null) {
            this.log.log(Level.WARN, "fgsms outbound response message did not have context variable added. This is unexpected. This transaction will be ignored");
            return;
        }
        if (Utility.stringIsNullOrEmpty(requrl)) {
            this.log.log(Level.WARN, "fgsms outbound response message did not have the URL context variable added. This is unexpected. This transaction will be ignored");
            MessageProcessor.getSingletonObject().removeFromQueue(id);
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        Message msg = messageContext.getCurrentMessage();
        String threadid = MessageProcessor.getSingletonObject().getTransactionThreadId(Thread.currentThread().getId());
        if (Utility.stringIsNullOrEmpty(threadid)) {
            threadid = UUID.randomUUID().toString();
        }
        if ((mimeHeaders = msg.getMimeHeaders()) != null) {
            if (MessageProcessor.getSingletonObject().isDependencyInjectionEnabled()) {
                mimeHeaders.addHeader("fgsms.relatedtransaction", id.toString());
                mimeHeaders.addHeader("fgsms.transactionthreadid", threadid);
            }
            Iterator allHeaders = mimeHeaders.getAllHeaders();
            while (allHeaders.hasNext()) {
                MimeHeader h = (MimeHeader)allHeaders.next();
                if (h == null) continue;
                headers.put(h.getName(), h.getValue());
            }
        }
        String messagexml = "";
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            msg.writeTo((OutputStream)b);
            messagexml = b.toString("UTF-8");
        }
        catch (IOException ex) {
            this.log.log(Level.WARN, null, ex);
        }
        this.log.log(Level.DEBUG, "fgsms Message intercepted, this is a response message to " + requrl + " transaction id:" + id.toString() + " Fault=" + fault);
        if (fault) {
            this.log.log(Level.WARN, "fgsms, this message to " + requrl + " transaction id:" + id.toString() + " has faulted.");
        }
        MessageProcessor.getSingletonObject().processMessageOutput(id.toString(), messagexml, messagexml.length(), fault, now, headers);
        MessageProcessor.getSingletonObject().clearTransactionThreadId(Thread.currentThread().getId());
    }
}

