/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agents;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.utils.LockableHashtable;
import org.apache.log4j.Level;
import org.miloss.fgsms.agentcore.IMessageProcessor;
import org.miloss.fgsms.agentcore.MessageProcessor;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Axis1MonitorInbound
implements Handler {
    private Logger log = Logger.getLogger("fgsms.Agents");
    protected boolean makeLockable = false;
    protected Hashtable options;
    protected String name;

    public void invoke(MessageContext mc) throws AxisFault {
        this.log.log(Level.INFO, "Current VM Memory : total = " + Runtime.getRuntime().totalMemory() + " free = " + Runtime.getRuntime().freeMemory());
        Boolean isRequest = true;
        isRequest = !mc.getPastPivot();
        if (isRequest.booleanValue()) {
            try {
                this.ProcessInboundRequestMessage(mc);
            }
            catch (Exception ex) {
                this.log.log(Level.WARN, "fgsms Error processing inbound message", ex);
            }
        } else {
            try {
                this.ProcessInboundResponseMessage(mc, false);
            }
            catch (Exception ex) {
                this.log.log(Level.WARN, "fgsms Error processing inbound message", ex);
            }
        }
    }

    protected void setOptionsLockable(boolean makeLockable) {
        this.makeLockable = makeLockable;
    }

    protected void initHashtable() {
        this.options = this.makeLockable ? new LockableHashtable() : new Hashtable();
    }

    public void init() {
    }

    public void cleanup() {
    }

    public boolean canHandleBlock(QName qname) {
        return false;
    }

    public void onFault(MessageContext mc) {
        Boolean isRequest = true;
        isRequest = !mc.getPastPivot();
        if (isRequest.booleanValue()) {
            try {
                this.ProcessInboundRequestMessage(mc);
            }
            catch (Exception ex) {
                this.log.log(Level.WARN, "fgsms Error processing inbound message", ex);
            }
        } else {
            this.ProcessInboundResponseMessage(mc, true);
        }
    }

    public void setOption(String name, Object value) {
        if (this.options == null) {
            this.initHashtable();
        }
        this.options.put(name, value);
    }

    public boolean setOptionDefault(String name, Object value) {
        boolean val;
        boolean bl = val = (this.options == null || this.options.get(name) == null) && value != null;
        if (val) {
            this.setOption(name, value);
        }
        return val;
    }

    public Object getOption(String name) {
        if (this.options == null) {
            return null;
        }
        return this.options.get(name);
    }

    public Hashtable getOptions() {
        return this.options;
    }

    public void setOptions(Hashtable opts) {
        this.options = opts;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Element getDeploymentData(Document doc) {
        this.log.log(Level.INFO, "Enter: BasicHandler::getDeploymentData");
        Element root = doc.createElementNS("", "handler");
        root.setAttribute("class", this.getClass().getName());
        this.options = this.getOptions();
        if (this.options != null) {
            Enumeration e = this.options.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                Object v = this.options.get(k);
                Element e1 = doc.createElementNS("", "option");
                e1.setAttribute("name", k);
                e1.setAttribute("value", v.toString());
                root.appendChild(e1);
            }
        }
        this.log.log(Level.INFO, "Exit: BasicHandler::getDeploymentData");
        return root;
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
    }

    public List getUnderstoodHeaders() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ProcessInboundRequestMessage(MessageContext messageContext) throws SOAPException {
        long now = System.currentTimeMillis();
        try {
            IMessageProcessor iMessageProcessor = MessageProcessor.getSingletonObject();
        }
        catch (Exception ex) {
            this.log.log(Level.ERROR, "Unable to get a reference to the Message Processor singleton object", ex);
        }
        UUID id = UUID.randomUUID();
        messageContext.setProperty("fgsms.messagekey", (Object)id);
        Message msg = messageContext.getCurrentMessage();
        String transactionthreadid = "";
        String action = "";
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            MimeHeaders me = messageContext.getMessage().getMimeHeaders();
            Iterator it = me.getAllHeaders();
            while (it.hasNext()) {
                MimeHeader h = (MimeHeader)it.next();
                if (h == null) continue;
                map.put(h.getName(), h.getValue());
                if (!h.getName().equalsIgnoreCase("SOAPAction")) continue;
                action = h.getValue();
            }
        }
        catch (Exception ex) {
            this.log.log(Level.WARN, "unexpected error caught obtaining http headers from message context" + ex.getLocalizedMessage());
        }
        if (Utility.stringIsNullOrEmpty(action) && !Utility.stringIsNullOrEmpty(action = messageContext.getOperation().getName())) {
            action = action.replace("\"", "");
            action = action.replace("'", "");
        }
        if (Utility.stringIsNullOrEmpty(action) && messageContext.useSOAPAction() && !Utility.stringIsNullOrEmpty(action = messageContext.getSOAPActionURI())) {
            action = action.replace("\"", "");
            action = action.replace("'", "");
        }
        if (action.toLowerCase().trim().equals("urn:org:miloss:fgsms:services:interfaces:dataCollector/dataCollectorService/AddData".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for DCS AddData to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        if (action.toLowerCase().trim().equals("{urn:org:miloss:fgsms:services:interfaces:dataCollector}AddMoreData".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for DCS AddData to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        if (action.toLowerCase().trim().equals("urn:org:miloss:fgsms:services:interfaces:dataCollector/dataCollectorService/AddMoreData".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for DCS AddData to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        if (action.toLowerCase().trim().equals("urn:org:miloss:fgsms:services:interfaces:policyConfiguration/policyConfigurationService/GetServicePolicy".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for PCS GetServicePolicy to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        if (action.toLowerCase().trim().equals("{urn:org:miloss:fgsms:services:interfaces:dataCollector}AddData".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for DCS AddData to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        if (action.toLowerCase().trim().equals("{urn:org:miloss:fgsms:services:interfaces:policyConfiguration}GetServicePolicy".toLowerCase().trim())) {
            this.log.log(Level.DEBUG, "fgsms, skipping the request for PCS GetServicePolicy to prevent recursive looping. This is normal and no action is required.");
            return;
        }
        String requestURL = (String)messageContext.getProperty("transport.url");
        String messagexml = "";
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            msg.writeTo((OutputStream)b);
            messagexml = b.toString("UTF-8");
        }
        catch (IOException ex) {
            this.log.log(Level.WARN, "fgsms, error obtaining request message.", ex);
        }
        finally {
            try {
                b.close();
            }
            catch (Exception ex) {}
        }
        if (Utility.stringIsNullOrEmpty(action) || action.equals("/DDS")) {
            action = Utility.getActionNameFromXML(messagexml);
            if (Utility.stringIsNullOrEmpty(action)) {
                action = "urn:undeterminable";
            }
            action = action.replace("\"", "");
            action = action.replace("'", "");
        }
        if (Utility.stringIsNullOrEmpty(action)) {
            action = "urn:undeterminable";
        }
        action = action.replace("\"", "");
        action = action.replace("'", "");
        this.log.log(Level.DEBUG, "fgsms Agent for Axis 1.x, inbound message for " + requestURL + " action " + action);
        String ip = "";
        try {
            ip = (String)messageContext.getProperty("remoteaddr");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String relatedTransaction = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        MimeHeaders mimeHeaders = msg.getMimeHeaders();
        if (mimeHeaders != null) {
            Iterator it = mimeHeaders.getAllHeaders();
            while (it.hasNext()) {
                MimeHeader header = (MimeHeader)it.next();
                if (header == null) continue;
                headers.put(header.getName(), header.getValue());
            }
        }
        if (headers.containsKey("fgsms.messageid")) {
            relatedTransaction = (String)headers.get("fgsms.messageid");
        }
        if (headers.containsKey("fgsms.transactionthreadid")) {
            transactionthreadid = (String)headers.get("fgsms.transactionthreadid");
        }
        if (Utility.stringIsNullOrEmpty(transactionthreadid)) {
            transactionthreadid = UUID.randomUUID().toString();
        }
        try {
            MessageProcessor.getSingletonObject().setTransactionThreadId(Thread.currentThread().getId(), transactionthreadid);
        }
        catch (Exception it) {
            // empty catch block
        }
        String user = "";
        if (!Utility.stringIsNullOrEmpty((String)messageContext.getProperty("authenticatedUser"))) {
            user = (String)messageContext.getProperty("authenticatedUser");
        }
        messageContext.setProperty("fgsms.requesturl", (Object)requestURL);
        messageContext.setProperty("fgsms.relatedtransaction", (Object)relatedTransaction);
        MessageProcessor.getSingletonObject().processMessageInput(messagexml, messagexml.length(), requestURL, action, user, id.toString(), map, ip, this.getClass().getCanonicalName(), relatedTransaction, transactionthreadid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ProcessInboundResponseMessage(MessageContext messageContext, boolean fault) {
        UUID id = (UUID)messageContext.getProperty("fgsms.messagekey");
        String requrl = (String)messageContext.getProperty("fgsms.requesturl");
        if (id == null) {
            this.log.log(Level.WARN, "fgsms InboundResponse message did not have context variable added. This is unexpected. This transaction will be ignored");
            return;
        }
        if (Utility.stringIsNullOrEmpty(requrl)) {
            this.log.log(Level.WARN, "fgsms InboundResponse message did not have the URL context variable added. This is unexpected. This transaction will be ignored");
            MessageProcessor.getSingletonObject().removeFromQueue(id);
            return;
        }
        Message msg = messageContext.getCurrentMessage();
        HashMap<String, String[]> headers = new HashMap<String, String[]>();
        try {
            MimeHeaders mimeHeaders = msg.getMimeHeaders();
            Iterator allHeaders = mimeHeaders.getAllHeaders();
            while (allHeaders.hasNext()) {
                String key = (String)allHeaders.next();
                headers.put(key, mimeHeaders.getHeader(key));
            }
        }
        catch (Exception ex) {
            this.log.log(Level.ERROR, "Unexpected error caught when searching for fgsms soap header", ex);
        }
        String messagexml = "not availabile.";
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            msg.writeTo((OutputStream)b);
            messagexml = b.toString("UTF-8");
        }
        catch (Exception ex) {
            this.log.log(Level.WARN, null, ex);
        }
        finally {
            try {
                b.close();
            }
            catch (Exception exception) {}
        }
        this.log.log(Level.DEBUG, "fgsms Message intercepted, this is a response message to " + requrl + " transaction id:" + id.toString() + " Fault=" + fault);
        if (fault) {
            this.log.log(Level.WARN, "fgsms, this message to " + requrl + " transaction id:" + id.toString() + " has faulted.");
        }
        MessageProcessor.getSingletonObject().processMessageOutput(id.toString(), messagexml, messagexml.length(), fault, System.currentTimeMillis(), headers);
    }
}

