/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore.mp;

import java.io.ByteArrayInputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Level;
import org.miloss.fgsms.agentcore.ConfigLoader;
import org.miloss.fgsms.agentcore.ConfigurationException;
import org.miloss.fgsms.agentcore.DataPusher;
import org.miloss.fgsms.agentcore.IMessageProcessor;
import org.miloss.fgsms.agentcore.MessageCorrelator;
import org.miloss.fgsms.agentcore.PolicyHelper;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.datacollector.AddDataRequestMsg;
import org.miloss.fgsms.services.interfaces.policyconfiguration.AndOrNot;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ArrayOfUserIdentity;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ArrayOfXPathExpressionType;
import org.miloss.fgsms.services.interfaces.policyconfiguration.RuleBaseType;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SLA;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SLARuleGeneric;
import org.miloss.fgsms.services.interfaces.policyconfiguration.TransactionalWebServicePolicy;
import org.w3c.dom.Document;

public class DefaultMessageProcessor
implements IMessageProcessor {
    private static final Logger log = Logger.getLogger("fgsms.Agents");
    private Thread[] pool = new Thread[Runtime.getRuntime().availableProcessors()];
    private final HashMap messageMap = new HashMap();
    private final HashMap ThreadIdMap = new HashMap();
    private final ConcurrentLinkedQueue outboundQueue = new ConcurrentLinkedQueue();
    private final HashMap policyCache = new HashMap();
    private long deadMessageInterval = 600000L;
    private boolean isDependencyInjectionEnabled = true;
    private String lasterror = "";
    private final Map<String, String> URLaddressMap = new HashMap<String, String>();
    private ConfigLoader cfg = null;
    private boolean running = true;
    private long totalmessagesprocessed = 0L;
    private final Set<String> ignoreList = new HashSet<String>();
    private String myHostname = null;

    public DefaultMessageProcessor() {
        try {
            this.cfg = new ConfigLoader();
        }
        catch (ConfigurationException ex) {
            log.fatal("Error loading config file!", ex);
            this.lasterror = ex.getMessage();
            System.err.println("Error loading config file!");
            ex.printStackTrace();
            log.log(Level.FATAL, "Unable to load configuration, messages will not be transmitted", ex);
            this.deadMessageInterval = 10000L;
            this.isDependencyInjectionEnabled = false;
        }
    }

    @Override
    public int getThreadMapSize() {
        return this.ThreadIdMap.size();
    }

    @Override
    public void purgeThreadMap() {
        this.ThreadIdMap.clear();
    }

    @Override
    public void abort() {
        this.outboundQueue.clear();
        this.messageMap.clear();
    }

    protected String ipWrapAndCacher(String URL2) {
        if (this.URLaddressMap.containsKey(URL2)) {
            return this.URLaddressMap.get(URL2);
        }
        return URL2;
    }

    @Override
    public void clearTransactionThreadId(long ThreadId) {
        this.ThreadIdMap.remove(ThreadId);
    }

    @Override
    public void forceNewDataPusherThread() {
        try {
            log.log(Level.INFO, " == fgsms Message Processor== launched new thread to push out data to DCS.");
            Thread t = new Thread(new DataPusher(this.policyCache, this.outboundQueue));
            t.start();
            this.running = true;
        }
        catch (Exception ex) {
            log.log(Level.FATAL, "******************************************************* fgsms could not start the Data Pusher Thread. This is most likely due to server overloading, memory limits or hitting the maxium thread pool for the container. Please consider revising. Purging " + this.messageMap.size() + " records from MsgMap and " + this.outboundQueue.size() + " from the outbound queue to prevent container overload. *********************************************", ex);
            try {
                this.messageMap.clear();
                this.outboundQueue.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public ConfigLoader getConfig() {
        return this.cfg;
    }

    @Override
    public String getHostName() {
        return Utility.getHostName();
    }

    @Override
    public String getLastErrorMessage() {
        return this.lasterror;
    }

    @Override
    public int getPolicyCache() {
        if (this.policyCache == null) {
            return 0;
        }
        return this.policyCache.size();
    }

    @Override
    public TransactionalWebServicePolicy getPolicyIfAvailable(String url) {
        Object j = this.policyCache.get(url);
        if (j == null) {
            return null;
        }
        PolicyHelper pol = (PolicyHelper)j;
        if (pol == null || pol.policy == null) {
            return null;
        }
        return pol.policy;
    }

    @Override
    public long getTotalmessagesprocessed() {
        return this.totalmessagesprocessed;
    }

    @Override
    public String getTransactionThreadId(Long ThreadId) {
        return (String)this.ThreadIdMap.get(ThreadId);
    }

    @Override
    public ArrayList<String> getUserIdentities(TransactionalWebServicePolicy p, MessageCorrelator mc) {
        if (p == null) {
            throw new NullPointerException("policy is null");
        }
        if (mc == null) {
            throw new NullPointerException("MessageCorrelator is null");
        }
        ArrayList<String> users = new ArrayList<String>();
        if (!Utility.stringIsNullOrEmpty(mc.ipaddress)) {
            users.add(mc.ipaddress);
        }
        if (!Utility.stringIsNullOrEmpty(mc.HttpIdentity)) {
            users.add(mc.HttpIdentity);
        }
        if (p.getUserIdentification() == null || p.getUserIdentification().getUserIdentity() == null || p.getUserIdentification().getUserIdentity().isEmpty()) {
            return users;
        }
        ArrayOfUserIdentity id = p.getUserIdentification();
        for (int i = 0; i < id.getUserIdentity().size(); ++i) {
            if (id.getUserIdentity().get(i).isUseHttpHeader() != null && id.getUserIdentity().get(i).isUseHttpHeader().booleanValue()) {
                try {
                    users.add((String)mc.Headers.get(id.getUserIdentity().get(i).getHttpHeaderName()));
                }
                catch (Exception ex) {
                    log.log(Level.WARN, "Error retrieving Requestor identity via http header name: " + ex.getLocalizedMessage());
                }
            }
            if (id.getUserIdentity().get(i).getXPaths() == null) continue;
            ArrayOfXPathExpressionType xpaths = id.getUserIdentity().get(i).getXPaths();
            ArrayList<String> tlocal = this.getUsersfromXpath(xpaths, mc.RequestMessage);
            for (int k = 0; k < tlocal.size(); ++k) {
                users.add(tlocal.get(k));
            }
        }
        log.log(Level.INFO, "getUserIdentities returning " + users.size() + " requestor identities");
        return users;
    }

    @Override
    public ArrayList<String> getUsersfromXpath(ArrayOfXPathExpressionType xpaths, String message) {
        ArrayList<String> userlist = new ArrayList<String>();
        if (xpaths == null || xpaths.getXPathExpressionType() == null || xpaths.getXPathExpressionType().isEmpty()) {
            return new ArrayList<String>();
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(message.getBytes("UTF-8"));
            Document xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            for (int i = 0; i < xpaths.getXPathExpressionType().size(); ++i) {
                XPath xpath = XPathFactory.newInstance().newXPath();
                XPathExpression xp = xpath.compile(xpaths.getXPathExpressionType().get(i).getXPath());
                String t2 = (String)xp.evaluate(xmlDocument, XPathConstants.STRING);
                if (Utility.stringIsNullOrEmpty(t2)) continue;
                userlist.add(t2);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARN, "Error evaluating xpath expression for consumer identification", ex);
        }
        return userlist;
    }

    @Override
    public void incMessagesProcessed(int size) {
        this.totalmessagesprocessed += (long)size;
    }

    @Override
    public int internalMessageMapSize() {
        if (this.messageMap == null) {
            return 0;
        }
        return this.messageMap.size();
    }

    @Override
    public int outboundQueueSize() {
        if (this.outboundQueue == null) {
            return 0;
        }
        return this.outboundQueue.size();
    }

    @Override
    public void processMessageInput(String XMLrequest, int requestSize, String url, String soapAction, String HttpUsername, String HashCode, HashMap headers, String ipaddress, String agentclassname, String relatedtransaction, String threadid) {
        if (!this.running) {
            return;
        }
        if (XMLrequest == null) {
            XMLrequest = "";
        }
        long now = System.currentTimeMillis();
        log.log(Level.TRACE, "MessageProcessor.ProcessMessageInput0 timer: " + (System.currentTimeMillis() - now) + " thread:" + Thread.currentThread().getId());
        if (this.isOnIgnoreList(url) || Utility.stringIsNullOrEmpty(url)) {
            log.log(Level.INFO, "fgsms, message for " + url + " is on the ignore list or is null or empty. A valid URL must be specified.");
            return;
        }
        long start = System.currentTimeMillis();
        MessageCorrelator mc = new MessageCorrelator();
        mc.RecievedAt = System.currentTimeMillis();
        mc.Headers = headers;
        mc.RelatedMsgId = relatedtransaction;
        mc.TransactionThreadId = threadid;
        mc.reqsize = requestSize;
        mc.URL = mc.originalurl = url;
        log.log(Level.TRACE, "MessageProcessor.ProcessMessageInput1 timer: " + (System.currentTimeMillis() - now) + " thread:" + Thread.currentThread().getId());
        TransactionalWebServicePolicy tp = this.getPolicyIfAvailable(url);
        if (tp != null) {
            if (tp.isRecordRequestMessage() || tp.isRecordFaultsOnly() || this.containsSLAXpathOrUserIdentXpath(tp)) {
                mc.RequestMessage = XMLrequest;
            }
        } else {
            mc.RequestMessage = XMLrequest;
        }
        log.log(Level.TRACE, "MessageProcessor.ProcessMessageInput2 timer: " + (System.currentTimeMillis() - now) + " thread:" + Thread.currentThread().getId());
        mc.soapAction = soapAction;
        mc.MessageID = HashCode;
        mc.HttpIdentity = HttpUsername;
        mc.ipaddress = ipaddress;
        mc.agent_class_name = agentclassname;
        this.messageMap.put(HashCode, mc);
        log.log(Level.TRACE, "MessageProcessor.ProcessMessageInput2 timer: " + (System.currentTimeMillis() - now) + " thread:" + Thread.currentThread().getId());
        log.log(Level.DEBUG, "fgsms, processMessageInput, MsgMap:" + this.messageMap.size() + " Outbound Queue:" + this.outboundQueue.size());
        log.log(Level.DEBUG, "fgsms, Input message for " + url + " action " + soapAction);
        this.removeDeadMessage();
        log.log(Level.TRACE, "MessageProcessor.ProcessMessageInput3 timer: " + (System.currentTimeMillis() - now) + " thread:" + Thread.currentThread().getId());
    }

    @Override
    public void processMessageOutput(String HashCode, String responseXML, int responseSize, boolean isFault, Long dod, HashMap headers, String relatedTransaction) {
        long now = System.currentTimeMillis();
        log.log(Level.TRACE, "MessageProcessor.ProcessMessageOutput0 timer: " + (System.currentTimeMillis() - now) + " thread:" + Thread.currentThread().getId());
        MessageCorrelator mc = (MessageCorrelator)this.messageMap.get(HashCode);
        if (mc == null) {
            log.log(Level.DEBUG, "fgsms ProcessOutboundMessage, MsgMap:" + this.messageMap.size() + " Outbound Queue:" + this.outboundQueue.size());
            log.log(Level.WARN, "fgsms on processMessageOutput, a corresponding request could not be paired to the response with id " + HashCode + ". It's possible that property message.processor.dead.message.queue.duration is set too low in the" + " fgsms-agent.properties file. This shouldn't happen often, if it does, please contact the fgsms developers at https://github.com/mil-oss/fgsms");
            this.removeDeadMessage();
            this.run();
            return;
        }
        if (!Utility.stringIsNullOrEmpty(relatedTransaction)) {
            mc.RelatedMsgId = relatedTransaction;
        }
        this.processMessageOutput(HashCode, responseXML, responseSize, isFault, dod, headers);
    }

    @Override
    public void processMessageOutput(String HashCode, String responseXML, int responseSize, boolean isFault, Long dod, HashMap headers) {
        if (!this.running) {
            return;
        }
        if (responseXML == null) {
            responseXML = "";
        }
        long now = System.currentTimeMillis();
        log.log(Level.TRACE, "MessageProcessor.ProcessMessageOutput0 timer: " + (System.currentTimeMillis() - now) + " thread:" + Thread.currentThread().getId());
        MessageCorrelator mc = (MessageCorrelator)this.messageMap.get(HashCode);
        if (mc == null) {
            log.log(Level.DEBUG, "fgsms ProcessOutboundMessage, MsgMap:" + this.messageMap.size() + " Outbound Queue:" + this.outboundQueue.size());
            log.log(Level.WARN, "fgsms on processMessageOutput, a corresponding request could not be paired to the response with id " + HashCode + ". It's possible that property message.processor.dead.message.queue.duration is set too low in the" + " fgsms-agent.properties file. This shouldn't happen often, if it does, please contact the fgsms developers at https://github.com/mil-oss/fgsms");
            this.removeDeadMessage();
            this.run();
            return;
        }
        mc.CompletedAt = System.currentTimeMillis();
        mc.currentMapsize = this.messageMap.size();
        log.log(Level.TRACE, "MessageProcessor.ProcessMessageOutput1 timer: " + (System.currentTimeMillis() - now) + " thread:" + Thread.currentThread().getId());
        TransactionalWebServicePolicy tp = this.getPolicyIfAvailable(mc.URL);
        if (tp != null) {
            if (tp.isRecordResponseMessage() || tp.isRecordFaultsOnly() && isFault) {
                mc.ResponseMessage = responseXML;
            }
            if (tp.isRecordFaultsOnly() && !isFault) {
                mc.RequestMessage = "";
                mc.ResponseMessage = "";
            }
        } else {
            mc.ResponseMessage = responseXML;
        }
        if (mc.ResponseMessage == null) {
            mc.ResponseMessage = "";
        }
        log.log(Level.TRACE, "MessageProcessor.ProcessMessageOutput2 timer: " + (System.currentTimeMillis() - now) + " thread:" + Thread.currentThread().getId());
        mc.IsFault = isFault;
        mc.ressize = responseSize;
        mc.Header_Response = headers;
        this.outboundQueue.add(mc);
        this.messageMap.remove(HashCode);
        log.log(Level.TRACE, "MessageProcessor.ProcessMessageOutput3 timer: " + (System.currentTimeMillis() - now) + " thread:" + Thread.currentThread().getId());
        this.run();
        log.log(Level.TRACE, "MessageProcessor.ProcessMessageOutput4 timer: " + (System.currentTimeMillis() - now) + " thread:" + Thread.currentThread().getId());
        log.log(Level.DEBUG, "fgsms, ProcessOutboundMessage: Message for URL " + mc.URL + " and action " + mc.soapAction + " is now in the outbound queue to the DCS.");
        log.log(Level.DEBUG, "fgsms, PostProcessOutboundMessage, MsgMap:" + this.messageMap.size() + " Outbound Queue:" + this.outboundQueue.size());
    }

    @Override
    public void processPreppedMessage(AddDataRequestMsg request) {
        if (!this.running) {
            return;
        }
        if (request == null) {
            throw new IllegalArgumentException("request");
        }
        this.outboundQueue.add(request);
        this.run();
    }

    @Override
    public void purgeMessageMap() {
        this.messageMap.clear();
    }

    @Override
    public void purgeOutboundQueue() {
        this.outboundQueue.clear();
    }

    @Override
    public void purgePolicyCache() {
        this.policyCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void run() {
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            for (int i = 0; i < this.pool.length; ++i) {
                if (this.pool[i] == null) {
                    this.pool[i] = new Thread((Runnable)new DataPusher(this.policyCache, this.outboundQueue), "fgsms Agent Thread " + i);
                    this.pool[i].setName("FGSMS.MP." + i);
                    this.pool[i].start();
                    continue;
                }
                if (this.pool[i].isAlive()) continue;
                this.pool[i] = new Thread((Runnable)new DataPusher(this.policyCache, this.outboundQueue), "fgsms Agent Thread " + i);
                this.pool[i].setName("FGSMS.MP." + i);
                this.pool[i].start();
            }
        }
        catch (OutOfMemoryError ex) {
            log.log(Level.FATAL, "OOM! fgsms could not start the Data Pusher Thread. This is most likely due to server overloading, memory limits or hitting the maxium thread pool for the container. Please consider revising. Purging " + this.messageMap.size() + " records from MsgMap and " + this.outboundQueue.size() + " from the outbound queue to prevent container overload. *********************************************", ex);
            try {
                this.messageMap.clear();
                this.outboundQueue.clear();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeDeadMessage() {
        if (this.messageMap.isEmpty()) {
            return;
        }
        try {
            Iterator it = this.messageMap.keySet().iterator();
            ArrayList<String> ids = new ArrayList<String>();
            while (it.hasNext()) {
                MessageCorrelator temp;
                String id = (String)it.next();
                if (Utility.stringIsNullOrEmpty(id) || (temp = (MessageCorrelator)this.messageMap.get(id)) == null || System.currentTimeMillis() - this.deadMessageInterval <= temp.RecievedAt) continue;
                ids.add(id);
            }
            if (!ids.isEmpty()) {
                log.log(Level.WARN, "fgsms, purging " + ids.size() + " dead records from MsgMap. These message could have been faults that the agent didn't see, some kind of server fault, a ?WSDL request or perhaps something else.");
                for (int i = 0; i < ids.size(); ++i) {
                    MessageCorrelator mc = (MessageCorrelator)this.messageMap.remove(ids.get(i));
                    mc.IsFault = true;
                    mc.CompletedAt = System.currentTimeMillis();
                    mc.ResponseMessage = "Message timed out, a response was not returned, or this was a WSDL request.";
                    this.outboundQueue.add(mc);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isOnIgnoreList(String url) {
        return this.ignoreList.contains(url.toLowerCase());
    }

    @Override
    public void removeFromQueue(UUID id) {
        this.messageMap.remove(id.toString());
        this.removeDeadMessage();
    }

    @Override
    public void removeFromQueue(String id) {
        this.messageMap.remove(id);
        this.removeDeadMessage();
    }

    @Override
    public void setRunning(boolean b) {
        this.running = b;
    }

    @Override
    public void setTransactionThreadId(Long ThreadId, String id) throws Exception {
        if (this.ThreadIdMap.containsKey(ThreadId)) {
            throw new Exception("attempting to set transaction thread id for thread " + id + " when an id has already been set");
        }
        this.ThreadIdMap.put(ThreadId, id);
    }

    @Override
    public boolean shouldAgentRecordRequestContent(String requesturl) {
        TransactionalWebServicePolicy GetPolicyIfAvailable = this.getPolicyIfAvailable(this.ipWrapAndCacher(requesturl));
        if (GetPolicyIfAvailable == null) {
            return true;
        }
        if (GetPolicyIfAvailable.isRecordRequestMessage() || GetPolicyIfAvailable.isRecordFaultsOnly()) {
            return true;
        }
        return this.containsSLAXpathOrUserIdentXpath(GetPolicyIfAvailable);
    }

    protected boolean doesSLAContainXpath(SLA get) {
        if (get == null) {
            return false;
        }
        return this.doesSLARuleContainXpath(get.getRule());
    }

    protected boolean doesSLARuleContainXpath(RuleBaseType rule) {
        SLARuleGeneric r;
        if (rule == null) {
            return false;
        }
        if (rule instanceof SLARuleGeneric && (r = (SLARuleGeneric)rule).getClassName().equalsIgnoreCase("org.miloss.fgsms.sla.rules.XPathExpression")) {
            return true;
        }
        if (rule instanceof AndOrNot) {
            AndOrNot t1 = (AndOrNot)rule;
            return this.doesSLARuleContainXpath(t1.getLHS()) || this.doesSLARuleContainXpath(t1.getRHS());
        }
        return false;
    }

    protected boolean containsSLAXpathOrUserIdentXpath(TransactionalWebServicePolicy pol) {
        int i;
        boolean found = false;
        if (pol.getUserIdentification() != null && !pol.getUserIdentification().getUserIdentity().isEmpty()) {
            for (i = 0; i < pol.getUserIdentification().getUserIdentity().size(); ++i) {
                if (pol.getUserIdentification().getUserIdentity().get(i).getXPaths() == null || pol.getUserIdentification().getUserIdentity().get(i).getXPaths() == null || pol.getUserIdentification().getUserIdentity().get(i).getXPaths().getXPathExpressionType().isEmpty()) continue;
                found = true;
            }
        }
        if (found) {
            return true;
        }
        if (pol.getServiceLevelAggrements() != null && !pol.getServiceLevelAggrements().getSLA().isEmpty()) {
            for (i = 0; i < pol.getServiceLevelAggrements().getSLA().size(); ++i) {
                found = found || this.doesSLAContainXpath(pol.getServiceLevelAggrements().getSLA().get(i));
            }
        }
        return found;
    }

    @Override
    public boolean shouldAgentRecordResponseContent(String requesturl) {
        TransactionalWebServicePolicy GetPolicyIfAvailable = this.getPolicyIfAvailable(this.ipWrapAndCacher(requesturl));
        if (GetPolicyIfAvailable == null) {
            return true;
        }
        if (GetPolicyIfAvailable.isRecordResponseMessage() || GetPolicyIfAvailable.isRecordFaultsOnly()) {
            return true;
        }
        return this.containsSLAXpathOrUserIdentXpath(GetPolicyIfAvailable);
    }

    @Override
    public void terminate() {
        for (int i = 0; i < this.pool.length; ++i) {
            if (this.pool[i] == null) continue;
            try {
                this.pool[i].interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pool[i] = null;
        }
        this.pool = null;
        this.outboundQueue.clear();
        this.messageMap.clear();
        this.policyCache.clear();
        log.log(Level.WARN, "Message Processor terminated");
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("org.miloss.fgsms.MessageProcessor:type=MessageProcessorAdapterMBean");
            mbs.unregisterMBean(name);
        }
        catch (Throwable ex) {
            log.log(Level.WARN, "unable to register MessageProcessor mbean", ex);
        }
    }

    @Override
    public Set<String> getIgnoreList() {
        return this.ignoreList;
    }

    @Override
    public Map<String, String> getURLaddressMap() {
        return this.URLaddressMap;
    }

    @Override
    public boolean isDependencyInjectionEnabled() {
        return this.isDependencyInjectionEnabled;
    }

    @Override
    public void setLastErrorMessage(String msg) {
        this.lasterror = msg;
    }
}

