/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore;

import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Level;
import org.miloss.fgsms.agentcore.ConfigLoader;
import org.miloss.fgsms.agentcore.ConfigurationException;
import org.miloss.fgsms.agentcore.HelperBase;
import org.miloss.fgsms.common.Constants;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.status.SetStatusRequestMsg;
import us.gov.ic.ism.v2.ClassificationType;

public class StatusHelper
extends HelperBase {
    static ConfigLoader cfg = null;
    static Logger log = Logger.getLogger("fgsms.Agents");

    private static void init() throws ConfigurationException {
        if (cfg == null) {
            cfg = new ConfigLoader();
        }
    }

    public static boolean tryUpdateStatus(boolean isrunning, String URI2, String message, boolean ispooled, PolicyType policyType, String domainname, String hostname) throws ConfigurationException {
        if (cfg == null) {
            StatusHelper.init();
        }
        StatusHelper.discoverEndpoints();
        SetStatusRequestMsg req = new SetStatusRequestMsg();
        req.setClassification(new SecurityWrapper(ClassificationType.U, ""));
        req.setDomainName(domainname);
        req.setHostname(hostname);
        req.setMessage(message);
        req.setOperational(isrunning);
        req.setURI(URI2);
        req.setPolicyType(policyType);
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTimeInMillis(System.currentTimeMillis());
        try {
            req.setTimeStamp(gcal);
            return StatusHelper.send(req);
        }
        catch (Exception ex) {
            log.log(Level.FATAL, "unable to send status alert", ex);
            return false;
        }
    }

    private static boolean send(SetStatusRequestMsg req) {
        int retrycount = 0;
        int urlcount = 0;
        boolean ok = false;
        switch (StatusHelper.cfg.SSalgo) {
            case FAILOVER: {
                urlcount = 0;
                ok = false;
                for (retrycount = 0; !ok && retrycount < StatusHelper.cfg.SSRetryCount; ++retrycount) {
                    for (urlcount = 0; !ok && urlcount < StatusHelper.cfg.SS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)StatusHelper.cfg.ssport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", StatusHelper.cfg.SS_URLS.get(urlcount));
                            if (StatusHelper.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", StatusHelper.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE(StatusHelper.cfg.password));
                            }
                            if (Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                context.put("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                                context.put("javax.net.ssl.trustStore", Utility.DE(cfg.getJavaxtruststore()));
                            }
                            try {
                                if (StatusHelper.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                    context.put("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                                    context.put("javax.net.ssl.keyStore", Utility.DE(cfg.getJavaxkeystore()));
                                }
                            }
                            catch (Exception ex) {
                                log.log(Level.FATAL, "error caught when referencing (get or set) System.properties for SSL communication. Check to ensure that this is enabled in your JAAS managemer", ex);
                            }
                            StatusHelper.cfg.ssport.setStatus(req);
                            ok = true;
                            return true;
                        }
                        catch (Exception ex) {
                            log.log(Level.WARN, "fgsms unable to set status SS at " + StatusHelper.cfg.SS_URLS.get(urlcount) + " will retry " + (StatusHelper.cfg.SSRetryCount - retrycount) + " times." + ex.getMessage(), ex);
                            continue;
                        }
                    }
                }
                if (ok) break;
                log.log(Level.FATAL, "fgsms unable to set status from any of the SS[" + StatusHelper.cfg.SS_URLS.size() + "] URLs, retry count exceeded.");
                return false;
            }
            case ROUNDROBIN: {
                urlcount = 0;
                ok = false;
                for (retrycount = 0; !ok && retrycount < StatusHelper.cfg.SSRetryCount; ++retrycount) {
                    for (urlcount = 0; !ok && urlcount < StatusHelper.cfg.SS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)StatusHelper.cfg.ssport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", StatusHelper.cfg.SS_URLS.get(urlcount));
                            if (StatusHelper.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", StatusHelper.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE(StatusHelper.cfg.password));
                            }
                            if (StatusHelper.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                System.setProperty("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                                System.setProperty("javax.net.ssl.keyStore", Utility.DE(cfg.getJavaxkeystore()));
                            }
                            if (Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                System.setProperty("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                                System.setProperty("javax.net.ssl.trustStore", Utility.DE(cfg.getJavaxtruststore()));
                            }
                            StatusHelper.cfg.ssport.setStatus(req);
                            ok = true;
                            return true;
                        }
                        catch (Exception ex) {
                            log.log(Level.WARN, "fgsms unable to set status  from SS at " + StatusHelper.cfg.SS_URLS.get(urlcount) + " will retry " + (StatusHelper.cfg.SSRetryCount - retrycount) + " times." + ex.getMessage(), ex);
                            continue;
                        }
                    }
                }
                if (ok) break;
                log.log(Level.FATAL, "fgsms unable tto set status from any of the SS[" + StatusHelper.cfg.SS_URLS.size() + "] URLs, retry count exceeded.");
                return false;
            }
        }
        return false;
    }
}

