/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore;

import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Level;
import org.miloss.fgsms.agentcore.ConfigLoader;
import org.miloss.fgsms.agentcore.ConfigurationException;
import org.miloss.fgsms.agentcore.HelperBase;
import org.miloss.fgsms.common.Constants;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.datacollector.AddStatisticalDataRequestMsg;
import org.miloss.fgsms.services.interfaces.datacollector.AddStatisticalDataResponseMsg;

public class StatisticalHelper
extends HelperBase {
    protected static ConfigLoader cfg = null;
    static Logger log = Logger.getLogger("fgsms.Agents");

    private static void Init() throws ConfigurationException {
        if (cfg == null) {
            cfg = new ConfigLoader();
        }
    }

    public static boolean send(AddStatisticalDataRequestMsg req) throws ConfigurationException {
        if (cfg == null) {
            StatisticalHelper.Init();
        }
        StatisticalHelper.discoverEndpoints();
        req.setClassification(StatisticalHelper.cfg.classlevel);
        int retrycount = 0;
        int urlcount = 0;
        switch (StatisticalHelper.cfg.DCSalgo) {
            case FAILOVER: {
                urlcount = 0;
                for (retrycount = 0; retrycount < StatisticalHelper.cfg.DCSRetryCount; ++retrycount) {
                    for (urlcount = 0; urlcount < StatisticalHelper.cfg.DCS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)StatisticalHelper.cfg.dcsport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", StatisticalHelper.cfg.DCS_URLS.get(urlcount));
                            if (StatisticalHelper.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", StatisticalHelper.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE(StatisticalHelper.cfg.password));
                            }
                            if (Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                context.put("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                                context.put("javax.net.ssl.trustStore", Utility.DE(cfg.getJavaxtruststore()));
                            }
                            try {
                                if (StatisticalHelper.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                    context.put("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                                    context.put("javax.net.ssl.keyStore", Utility.DE(cfg.getJavaxkeystore()));
                                }
                            }
                            catch (Exception ex) {
                                log.log(Level.FATAL, "error caught when referencing (get or set) System.properties for SSL communication. Check to ensure that this is enabled in your JAAS managemer", ex);
                            }
                            AddStatisticalDataResponseMsg addStatisticalData = StatisticalHelper.cfg.dcsport.addStatisticalData(req);
                            StatisticalHelper.cfg.classlevel = addStatisticalData.getClassification();
                            return true;
                        }
                        catch (Exception ex) {
                            log.log(Level.WARN, "fgsms unable to transmit to CS at " + StatisticalHelper.cfg.DCS_URLS.get(urlcount) + " will retry " + (StatisticalHelper.cfg.DCSRetryCount - retrycount) + " times." + ex.getMessage(), ex);
                            continue;
                        }
                    }
                }
                log.log(Level.FATAL, "fgsms unable to transmit to any of the DCS[" + StatisticalHelper.cfg.DCS_URLS.size() + "] URLs, retry count exceeded. Falling back to default policy");
                return false;
            }
            case ROUNDROBIN: {
                urlcount = 0;
                for (retrycount = 0; retrycount < StatisticalHelper.cfg.DCSRetryCount; ++retrycount) {
                    for (urlcount = 0; urlcount < StatisticalHelper.cfg.DCS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)StatisticalHelper.cfg.dcsport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", StatisticalHelper.cfg.DCS_URLS.get(urlcount));
                            if (StatisticalHelper.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", StatisticalHelper.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE(StatisticalHelper.cfg.password));
                            }
                            if (StatisticalHelper.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                System.setProperty("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                                System.setProperty("javax.net.ssl.keyStore", Utility.DE(cfg.getJavaxkeystore()));
                            }
                            if (Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                System.setProperty("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                                System.setProperty("javax.net.ssl.trustStore", Utility.DE(cfg.getJavaxtruststore()));
                            }
                            AddStatisticalDataResponseMsg addStatisticalData = StatisticalHelper.cfg.dcsport.addStatisticalData(req);
                            StatisticalHelper.cfg.classlevel = addStatisticalData.getClassification();
                            return true;
                        }
                        catch (Exception ex) {
                            log.log(Level.WARN, "fgsms unable to transmit to DCS at " + StatisticalHelper.cfg.DCS_URLS.get(urlcount) + " will retry " + (StatisticalHelper.cfg.DCSRetryCount - retrycount) + " times." + ex.getMessage(), ex);
                            continue;
                        }
                    }
                }
                log.log(Level.FATAL, "fgsms unable totransmit to any of the DCS[" + StatisticalHelper.cfg.DCS_URLS.size() + "] URLs, retry count exceeded.");
            }
        }
        return false;
    }
}

