/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.log4j.Level;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.w3c.dom.Document;

public class OneWayJudge {
    static final Logger log = Logger.getLogger("fgsms.Agents");
    static final Map<String, Boolean> cache = new HashMap<String, Boolean>();

    public static boolean determineOneWay(String requestURL, SOAPMessageContext messageContext, String action) {
        String actionLastPart = OneWayJudge.ToShortActionString(action);
        if (cache.containsKey(requestURL + "|" + actionLastPart)) {
            log.log(Level.DEBUG, "determined @OneWAY from cache");
            return cache.get(requestURL + "|" + actionLastPart);
        }
        log.log(Level.INFO, "Operation mappings not available for " + requestURL + " " + action + " attempting to load the wsdl and cache");
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(requestURL + "?wsdl").openConnection();
            conn.setRequestMethod("GET");
            InputStream inputStream = conn.getInputStream();
            conn.connect();
            WSDLReader newWSDLReader = WSDLFactory.newInstance().newWSDLReader();
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setNamespaceAware(true);
            Document doc = f.newDocumentBuilder().parse(inputStream);
            conn.disconnect();
            Definition readWSDL = newWSDLReader.readWSDL(null, doc);
            Map allPortTypes = readWSDL.getAllPortTypes();
            for (Object t : allPortTypes.keySet()) {
                PortType portType = (PortType)allPortTypes.get(t);
                List operations = portType.getOperations();
                for (int i = 0; i < operations.size(); ++i) {
                    Operation operation = (Operation)operations.get(i);
                    cache.put(requestURL + "|" + operation.getName(), operation.getOutput() == null || operation.getStyle().equals(OperationType.ONE_WAY));
                }
            }
            if (cache.containsKey(requestURL + "|" + actionLastPart)) {
                return cache.get(requestURL + "|" + actionLastPart);
            }
            log.log(Level.WARN, "the action " + action + " couldn't be found in the wsdl. I'm guessing that its NOT a one way transaction.");
            cache.put(requestURL + "|" + actionLastPart, false);
        }
        catch (Exception ex) {
            log.log(Level.WARN, "OneWAY  detected failed " + ex.getMessage());
            cache.put(requestURL + "|" + actionLastPart, false);
            return false;
        }
        return false;
    }

    private static String ToShortActionString(String action) {
        if (Utility.stringIsNullOrEmpty(action)) {
            return "";
        }
        String ret = action;
        int clip = 0;
        if (ret.lastIndexOf("/") > clip) {
            clip = ret.lastIndexOf("/");
        }
        if (ret.lastIndexOf("}") > clip) {
            clip = ret.lastIndexOf("}");
        }
        if (ret.lastIndexOf(":") > clip) {
            clip = ret.lastIndexOf(":");
        }
        if (ret.lastIndexOf("#") > clip) {
            clip = ret.lastIndexOf("#");
        }
        if (clip > 0) {
            ret = ret.substring(clip + 1);
        }
        return ret;
    }
}

