/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore;

import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Level;
import org.miloss.fgsms.agentcore.ConfigLoader;
import org.miloss.fgsms.agentcore.ConfigurationException;
import org.miloss.fgsms.agentcore.HelperBase;
import org.miloss.fgsms.common.Constants;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.datacollector.AddMachineAndProcessDataRequestMsg;
import org.miloss.fgsms.services.interfaces.datacollector.AddMachineAndProcessDataResponseMsg;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SetProcessListByMachineRequestMsg;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SetProcessListByMachineResponseMsg;

public class OSAgentHelper
extends HelperBase {
    static ConfigLoader cfg = null;
    static Logger log = Logger.getLogger("fgsms.Agents");

    private static void Init() throws ConfigurationException {
        if (cfg == null) {
            cfg = new ConfigLoader();
        }
    }

    public static SetProcessListByMachineResponseMsg SetMachineInfo(SetProcessListByMachineRequestMsg req) throws ConfigurationException {
        if (cfg == null) {
            OSAgentHelper.Init();
        }
        OSAgentHelper.discoverEndpoints();
        req.setClassification(OSAgentHelper.cfg.classlevel);
        try {
            return OSAgentHelper.Send(req);
        }
        catch (Exception ex) {
            log.log(Level.ERROR, "could not retrieve a policy for the specified url", ex);
            return null;
        }
    }

    private static SetProcessListByMachineResponseMsg Send(SetProcessListByMachineRequestMsg req) throws ConfigurationException {
        if (cfg == null) {
            OSAgentHelper.Init();
        }
        OSAgentHelper.discoverEndpoints();
        int retrycount = 0;
        int urlcount = 0;
        switch (OSAgentHelper.cfg.PCSalgo) {
            case FAILOVER: {
                urlcount = 0;
                for (retrycount = 0; retrycount < OSAgentHelper.cfg.PCSRetryCount; ++retrycount) {
                    for (urlcount = 0; urlcount < OSAgentHelper.cfg.PCS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)OSAgentHelper.cfg.pcsport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", OSAgentHelper.cfg.PCS_URLS.get(urlcount));
                            if (OSAgentHelper.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", OSAgentHelper.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE(OSAgentHelper.cfg.password));
                            }
                            if (Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                context.put("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                                context.put("javax.net.ssl.trustStore", Utility.DE(cfg.getJavaxtruststore()));
                            }
                            try {
                                if (OSAgentHelper.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                    context.put("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                                    context.put("javax.net.ssl.keyStore", Utility.DE(cfg.getJavaxkeystore()));
                                }
                            }
                            catch (Exception ex) {
                                log.log(Level.FATAL, "error caught when referencing (get or set) System.properties for SSL communication. Check to ensure that this is enabled in your JAAS managemer", ex);
                            }
                            SetProcessListByMachineResponseMsg servicePolicy = OSAgentHelper.cfg.pcsport.setProcessListByMachine(req);
                            OSAgentHelper.cfg.classlevel = servicePolicy.getClassification();
                            return servicePolicy;
                        }
                        catch (Exception ex) {
                            log.log(Level.WARN, "fgsms unable to fetch policy from PCS at " + OSAgentHelper.cfg.PCS_URLS.get(urlcount) + " will retry " + (OSAgentHelper.cfg.PCSRetryCount - retrycount) + " times." + ex.getMessage(), ex);
                            continue;
                        }
                    }
                }
                log.log(Level.FATAL, "fgsms unable to fetch policy from any of the PCS[" + OSAgentHelper.cfg.PCS_URLS.size() + "] URLs, retry count exceeded. Falling back to default policy");
                return null;
            }
            case ROUNDROBIN: {
                urlcount = 0;
                for (retrycount = 0; retrycount < OSAgentHelper.cfg.PCSRetryCount; ++retrycount) {
                    for (urlcount = 0; urlcount < OSAgentHelper.cfg.PCS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)OSAgentHelper.cfg.pcsport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", OSAgentHelper.cfg.PCS_URLS.get(urlcount));
                            if (OSAgentHelper.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", OSAgentHelper.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE(OSAgentHelper.cfg.password));
                            }
                            if (OSAgentHelper.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                System.setProperty("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                                System.setProperty("javax.net.ssl.keyStore", Utility.DE(cfg.getJavaxkeystore()));
                            }
                            if (Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                System.setProperty("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                                System.setProperty("javax.net.ssl.trustStore", Utility.DE(cfg.getJavaxtruststore()));
                            }
                            SetProcessListByMachineResponseMsg servicePolicy = OSAgentHelper.cfg.pcsport.setProcessListByMachine(req);
                            OSAgentHelper.cfg.classlevel = servicePolicy.getClassification();
                            return servicePolicy;
                        }
                        catch (Exception ex) {
                            log.log(Level.WARN, "fgsms unable to fetch policy from PCS at " + OSAgentHelper.cfg.PCS_URLS.get(urlcount) + " will retry " + (OSAgentHelper.cfg.PCSRetryCount - retrycount) + " times." + ex.getMessage(), ex);
                            continue;
                        }
                    }
                }
                log.log(Level.FATAL, "fgsms unable to fetch policy from any of the PCS[" + OSAgentHelper.cfg.PCS_URLS.size() + "] URLs, retry count exceeded.");
                return null;
            }
        }
        return null;
    }

    public static AddMachineAndProcessDataResponseMsg AddMachineAndProcessDataRequestMsg(AddMachineAndProcessDataRequestMsg req) throws ConfigurationException {
        if (cfg == null) {
            OSAgentHelper.Init();
        }
        OSAgentHelper.discoverEndpoints();
        int retrycount = 0;
        int urlcount = 0;
        switch (OSAgentHelper.cfg.DCSalgo) {
            case FAILOVER: {
                urlcount = 0;
                for (retrycount = 0; retrycount < OSAgentHelper.cfg.DCSRetryCount; ++retrycount) {
                    for (urlcount = 0; urlcount < OSAgentHelper.cfg.DCS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)OSAgentHelper.cfg.dcsport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", OSAgentHelper.cfg.DCS_URLS.get(urlcount));
                            if (OSAgentHelper.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", OSAgentHelper.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE(OSAgentHelper.cfg.password));
                            }
                            if (OSAgentHelper.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                System.setProperty("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                                System.setProperty("javax.net.ssl.keyStore", Utility.DE(cfg.getJavaxkeystore()));
                            }
                            if (Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                System.setProperty("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                                System.setProperty("javax.net.ssl.trustStore", Utility.DE(cfg.getJavaxtruststore()));
                            }
                            AddMachineAndProcessDataResponseMsg res = OSAgentHelper.cfg.dcsport.addMachineAndProcessData(req);
                            OSAgentHelper.cfg.classlevel = res.getClassification();
                            return res;
                        }
                        catch (Exception ex) {
                            log.log(Level.WARN, "fgsms unable to add data at the DCS at " + OSAgentHelper.cfg.DCS_URLS.get(urlcount) + " will retry " + (OSAgentHelper.cfg.DCSRetryCount - retrycount) + " times." + ex.getMessage(), ex);
                            continue;
                        }
                    }
                }
                log.log(Level.FATAL, "fgsms unable to add data at the from any of the DCS[" + OSAgentHelper.cfg.DCS_URLS.size() + "] URLs, retry count exceeded.");
                return null;
            }
            case ROUNDROBIN: {
                urlcount = 0;
                for (retrycount = 0; retrycount < OSAgentHelper.cfg.DCSRetryCount; ++retrycount) {
                    for (urlcount = 0; urlcount < OSAgentHelper.cfg.DCS_URLS.size(); ++urlcount) {
                        try {
                            BindingProvider bp = (BindingProvider)OSAgentHelper.cfg.dcsport;
                            Map context = bp.getRequestContext();
                            context.put("javax.xml.ws.service.endpoint.address", OSAgentHelper.cfg.DCS_URLS.get(urlcount));
                            if (OSAgentHelper.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                                context.put("javax.xml.ws.security.auth.username", OSAgentHelper.cfg.username);
                                context.put("javax.xml.ws.security.auth.password", Utility.DE(OSAgentHelper.cfg.password));
                            }
                            if (OSAgentHelper.cfg.mode_ == Constants.AuthMode.PKI && Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStorePassword"))) {
                                System.setProperty("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                                System.setProperty("javax.net.ssl.keyStore", Utility.DE(cfg.getJavaxkeystore()));
                            }
                            if (Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStore")) && !Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStorePassword"))) {
                                System.setProperty("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                                System.setProperty("javax.net.ssl.trustStore", Utility.DE(cfg.getJavaxtruststore()));
                            }
                            AddMachineAndProcessDataResponseMsg servicePolicy = OSAgentHelper.cfg.dcsport.addMachineAndProcessData(req);
                            OSAgentHelper.cfg.classlevel = servicePolicy.getClassification();
                            return servicePolicy;
                        }
                        catch (Exception ex) {
                            log.log(Level.WARN, "fgsms unable to add data at the DCS at " + OSAgentHelper.cfg.DCS_URLS.get(urlcount) + " will retry " + (OSAgentHelper.cfg.DCSRetryCount - retrycount) + " times." + ex.getMessage(), ex);
                            continue;
                        }
                    }
                }
                log.log(Level.FATAL, "fgsms unable to add data from any of the DCS[" + OSAgentHelper.cfg.DCS_URLS.size() + "] URLs, retry count exceeded.");
                return null;
            }
        }
        return null;
    }
}

