/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.log4j.Level;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DependencyHelper {
    public static String getThreadIdFromSoapHeader(SOAPMessageContext messageContext) {
        try {
            SOAPMessage message = messageContext.getMessage();
            SOAPHeader soapHeader = message.getSOAPHeader();
            if (soapHeader != null) {
                Node node;
                String t;
                NodeList elementsByTagNameNS;
                Iterator childElements = soapHeader.getChildElements(new QName("org.miloss.fgsms.headers", "fgsms.threadid"));
                if (childElements.hasNext()) {
                    SOAPElement e = (SOAPElement)childElements.next();
                    String t2 = e.getTextContent();
                    if (!Utility.stringIsNullOrEmpty(t2)) {
                        return t2;
                    }
                    t2 = e.getValue();
                    if (!Utility.stringIsNullOrEmpty(t2)) {
                        return t2;
                    }
                    Node c = e.getFirstChild();
                    if (c != null) {
                        t2 = c.getTextContent();
                        if (!Utility.stringIsNullOrEmpty(t2)) {
                            return t2;
                        }
                        t2 = e.getValue();
                        if (!Utility.stringIsNullOrEmpty(t2)) {
                            return t2;
                        }
                    }
                }
                if ((elementsByTagNameNS = soapHeader.getElementsByTagNameNS("org.miloss.fgsms.headers", "fgsms.threadid")).getLength() > 0 && !Utility.stringIsNullOrEmpty(t = (node = elementsByTagNameNS.item(0)).getTextContent())) {
                    return t;
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger("fgsms.Agents").log(Level.WARN, "unable to get soap header for dependency detection", ex);
        }
        return null;
    }

    public static String getRelatedMessageIdFromSoapHeader(SOAPMessageContext messageContext) {
        try {
            SOAPMessage message = messageContext.getMessage();
            SOAPHeader soapHeader = message.getSOAPHeader();
            if (soapHeader != null) {
                Node node;
                String t;
                NodeList elementsByTagNameNS;
                Iterator childElements = soapHeader.getChildElements(new QName("org.miloss.fgsms.headers", "fgsms.relatedmessage"));
                if (childElements.hasNext()) {
                    SOAPElement e = (SOAPElement)childElements.next();
                    String t2 = e.getTextContent();
                    if (!Utility.stringIsNullOrEmpty(t2)) {
                        return t2;
                    }
                    t2 = e.getValue();
                    if (!Utility.stringIsNullOrEmpty(t2)) {
                        return t2;
                    }
                    Node c = e.getFirstChild();
                    if (c != null) {
                        t2 = c.getTextContent();
                        if (!Utility.stringIsNullOrEmpty(t2)) {
                            return t2;
                        }
                        t2 = e.getValue();
                        if (!Utility.stringIsNullOrEmpty(t2)) {
                            return t2;
                        }
                    }
                }
                if ((elementsByTagNameNS = soapHeader.getElementsByTagNameNS("org.miloss.fgsms.headers", "fgsms.relatedmessage")).getLength() > 0 && !Utility.stringIsNullOrEmpty(t = (node = elementsByTagNameNS.item(0)).getTextContent())) {
                    return t;
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger("fgsms.Agents").log(Level.WARN, "unable to get soap header for dependency detection", ex);
        }
        return null;
    }

    public static void insertRelatedMessageHeader(String messageid, SOAPMessageContext messageContext) {
        try {
            SOAPMessage msg = messageContext.getMessage();
            SOAPHeader header = msg.getSOAPHeader();
            if (header == null) {
                SOAPPart soapPart = msg.getSOAPPart();
                SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
                header = soapEnvelope.addHeader();
            }
            SOAPElement soapElement = header.addChildElement(new QName("org.miloss.fgsms.headers", "fgsms.relatedmessage"));
            soapElement.addTextNode(messageid);
        }
        catch (Exception ex) {
            Logger.getLogger("fgsms.Agents").log(Level.WARN, "unable to insert soap header for dependency detection", ex);
        }
    }

    public static void insertThreadIdHeader(String transactionthreadid, SOAPMessageContext messageContext) {
        try {
            SOAPMessage msg = messageContext.getMessage();
            SOAPHeader header = msg.getSOAPHeader();
            if (header == null) {
                SOAPPart soapPart = msg.getSOAPPart();
                SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
                header = soapEnvelope.addHeader();
            }
            SOAPElement soapElement = header.addChildElement(new QName("org.miloss.fgsms.headers", "fgsms.threadid"));
            soapElement.addTextNode(transactionthreadid);
        }
        catch (Exception ex) {
            Logger.getLogger("fgsms.Agents").log(Level.WARN, "unable to insert soap header for dependency detection", ex);
        }
    }
}

