/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Level;
import org.miloss.fgsms.agentcore.ApacheCxfSslHelper;
import org.miloss.fgsms.agentcore.ConfigLoader;
import org.miloss.fgsms.agentcore.ConfigurationException;
import org.miloss.fgsms.agentcore.MessageCorrelator;
import org.miloss.fgsms.agentcore.MessageProcessor;
import org.miloss.fgsms.agentcore.PolicyHelper;
import org.miloss.fgsms.common.Constants;
import org.miloss.fgsms.common.IpAddressUtility;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.plugins.agents.IEndpointDiscovery;
import org.miloss.fgsms.services.interfaces.common.Header;
import org.miloss.fgsms.services.interfaces.common.PolicyType;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.datacollector.AddData;
import org.miloss.fgsms.services.interfaces.datacollector.AddDataRequestMsg;
import org.miloss.fgsms.services.interfaces.datacollector.AddDataResponseMsg;
import org.miloss.fgsms.services.interfaces.datacollector.AddMoreData;
import org.miloss.fgsms.services.interfaces.datacollector.DataResponseStatus;
import org.miloss.fgsms.services.interfaces.policyconfiguration.AndOrNot;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ArrayOfSLA;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SLA;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SLAAction;
import org.miloss.fgsms.services.interfaces.policyconfiguration.SLARuleGeneric;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ServicePolicy;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ServicePolicyRequestMsg;
import org.miloss.fgsms.services.interfaces.policyconfiguration.ServicePolicyResponseMsg;
import org.miloss.fgsms.services.interfaces.policyconfiguration.TransactionalWebServicePolicy;
import us.gov.ic.ism.v2.ClassificationType;

public class DataPusher
implements Runnable {
    static boolean DEBUG = false;
    private static ConcurrentLinkedQueue outboundQueue;
    private static HashMap policyCache;
    private static final Logger log;
    private static ConfigLoader cfg;
    private static boolean ErrorState;
    private static String LastErrorMessage;
    List<IEndpointDiscovery> endpointproviders = null;

    public DataPusher(HashMap cache, ConcurrentLinkedQueue queue) {
        this.Initializer(cache, queue);
    }

    private synchronized void Initializer(HashMap cache, ConcurrentLinkedQueue queue) {
        policyCache = cache;
        outboundQueue = queue;
    }

    protected DataPusher() {
        policyCache = new HashMap();
        outboundQueue = new ConcurrentLinkedQueue();
    }

    protected static synchronized void Init() {
        if (cfg == null) {
            try {
                if (cfg == null) {
                    cfg = MessageProcessor.getSingletonObject().getConfig();
                }
                if (cfg == null) {
                    throw new ConfigurationException("Config unavailable");
                }
            }
            catch (Exception ex) {
                cfg = null;
                ErrorState = true;
                LastErrorMessage = "could not initialize the configuration from fgsms.AgentCore.jar";
                log.log(Level.FATAL, "could not initialize the configuration from fgsms.AgentCore.jar", ex);
                return;
            }
            BindingProvider bp = (BindingProvider)DataPusher.cfg.dcsport;
            Map context = bp.getRequestContext();
            if (DataPusher.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                context.put("javax.xml.ws.security.auth.username", DataPusher.cfg.username);
                context.put("javax.xml.ws.security.auth.password", Utility.DE(DataPusher.cfg.password));
            }
            if (DataPusher.cfg.mode_ == Constants.AuthMode.PKI && (Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStore")) || Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStorePassword"))) && cfg.getJavaxkeystore() != null) {
                context.put("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                context.put("javax.net.ssl.keyStore", Utility.DE(cfg.getJavaxkeystore()));
                try {
                    System.setProperty("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                    System.setProperty("javax.net.ssl.keyStore", cfg.getJavaxkeystore());
                }
                catch (Exception ex) {
                    log.log(Level.WARN, "error caught when referencing (get or set) System.properties for SSL communication. Check to ensure that this is enabled in your JAAS managemer", ex);
                }
            }
            if (Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStore")) && Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStorePassword")) && cfg.getJavaxtruststore() != null) {
                context.put("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                context.put("javax.net.ssl.trustStore", cfg.getJavaxtruststore());
                try {
                    System.setProperty("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                    System.setProperty("javax.net.ssl.trustStore", cfg.getJavaxtruststore());
                }
                catch (Exception ex) {
                    log.log(Level.WARN, "error caught when referencing (get or set) System.properties for SSL communication. Check to ensure that this is enabled in your JAAS managemer", ex);
                }
            }
            ApacheCxfSslHelper.doCXF(DataPusher.cfg.dcsport, cfg);
            bp = (BindingProvider)DataPusher.cfg.pcsport;
            context = bp.getRequestContext();
            if (DataPusher.cfg.mode_ == Constants.AuthMode.UsernamePassword) {
                context.put("javax.xml.ws.security.auth.username", DataPusher.cfg.username);
                context.put("javax.xml.ws.security.auth.password", Utility.DE(DataPusher.cfg.password));
            }
            if ((Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStore")) || Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.trustStorePassword"))) && cfg.getJavaxtruststore() != null) {
                context.put("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                context.put("javax.net.ssl.trustStore", Utility.DE(cfg.getJavaxtruststore()));
                try {
                    System.setProperty("javax.net.ssl.trustStorePassword", Utility.DE(cfg.getJavaxtruststorepass()));
                    System.setProperty("javax.net.ssl.trustStore", cfg.getJavaxtruststore());
                }
                catch (Exception ex) {
                    log.log(Level.WARN, "error caught when referencing (get or set) System.properties for SSL communication. Check to ensure that this is enabled in your JAAS managemer", ex);
                }
            }
            if (DataPusher.cfg.mode_ == Constants.AuthMode.PKI && (Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStore")) || Utility.stringIsNullOrEmpty(System.getProperty("javax.net.ssl.keyStorePassword"))) && cfg.getJavaxkeystore() != null) {
                context.put("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                context.put("javax.net.ssl.keyStore", Utility.DE(cfg.getJavaxkeystore()));
                try {
                    System.setProperty("javax.net.ssl.keyStorePassword", Utility.DE(cfg.getJavaxkeystorepass()));
                    System.setProperty("javax.net.ssl.keyStore", cfg.getJavaxkeystore());
                }
                catch (Exception ex) {
                    log.log(Level.WARN, "error caught when referencing (get or set) System.properties for SSL communication. Check to ensure that this is enabled in your JAAS managemer", ex);
                }
            }
            ApacheCxfSslHelper.doCXF(DataPusher.cfg.pcsport, cfg);
        }
    }

    protected static String IpWrapAndCacher(String URL2, boolean isclient) {
        if (MessageProcessor.getSingletonObject().getURLaddressMap().containsKey(URL2)) {
            return MessageProcessor.getSingletonObject().getURLaddressMap().get(URL2);
        }
        String newurl = IpAddressUtility.modifyURL(URL2, isclient);
        MessageProcessor.getSingletonObject().getURLaddressMap().put(URL2, newurl);
        return newurl;
    }

    private static ServicePolicyResponseMsg FetchPolicy(String url, ConfigLoader.Algorithm style, boolean isclient) {
        boolean ok = false;
        int urlcount = 0;
        int retrycount = 0;
        BindingProvider bp = (BindingProvider)DataPusher.cfg.pcsport;
        Map context = bp.getRequestContext();
        switch (style) {
            case FAILOVER: {
                urlcount = 0;
                ok = false;
                for (retrycount = 0; !ok && retrycount < DataPusher.cfg.PCSRetryCount; ++retrycount) {
                    for (urlcount = 0; !ok && urlcount < DataPusher.cfg.PCS_URLS.size(); ++urlcount) {
                        try {
                            context.put("javax.xml.ws.service.endpoint.address", DataPusher.cfg.PCS_URLS.get(urlcount));
                            ServicePolicyRequestMsg request = new ServicePolicyRequestMsg();
                            request.setClassification(DataPusher.cfg.classlevel);
                            request.setURI(url);
                            request.setPolicytype(PolicyType.TRANSACTIONAL);
                            if (!isclient) {
                                request.setMachine(Utility.getHostName());
                            } else {
                                request.setMachine(new URL(url).getHost());
                            }
                            ServicePolicyResponseMsg result = DataPusher.cfg.pcsport.getServicePolicy(request);
                            ok = true;
                            return result;
                        }
                        catch (Exception ex) {
                            log.log(Level.WARN, "fgsms unable to fetch policy from PCS at " + DataPusher.cfg.PCS_URLS.get(urlcount) + " will retry " + (DataPusher.cfg.PCSRetryCount - retrycount) + " times." + ex.getMessage());
                            continue;
                        }
                    }
                }
                if (ok) break;
                log.log(Level.FATAL, "fgsms unable to fetch policy from any of the PCS[" + DataPusher.cfg.PCS_URLS.size() + "] URLs, retry count exceeded. Falling back to default policy");
                MessageProcessor.getSingletonObject().setLastErrorMessage("All PCS endpoints are either unreachable or are responding in error");
                break;
            }
            case ROUNDROBIN: {
                urlcount = 0;
                ok = false;
                for (retrycount = 0; !ok && retrycount < DataPusher.cfg.PCSRetryCount; ++retrycount) {
                    for (urlcount = 0; !ok && urlcount < DataPusher.cfg.PCS_URLS.size(); ++urlcount) {
                        try {
                            context.put("javax.xml.ws.service.endpoint.address", DataPusher.cfg.PCS_URLS.get(urlcount));
                            ServicePolicyRequestMsg request = new ServicePolicyRequestMsg();
                            request.setClassification(DataPusher.cfg.classlevel);
                            request.setURI(url);
                            request.setPolicytype(PolicyType.TRANSACTIONAL);
                            if (!isclient) {
                                request.setMachine(Utility.getHostName());
                            } else {
                                request.setMachine(new URL(url).getHost());
                            }
                            ServicePolicyResponseMsg result = DataPusher.cfg.pcsport.getServicePolicy(request);
                            result.getPolicy();
                            ok = true;
                            return result;
                        }
                        catch (Exception ex) {
                            log.log(Level.WARN, "fgsms unable to fetch policy from PCS at " + DataPusher.cfg.PCS_URLS.get(urlcount) + " will retry " + (DataPusher.cfg.PCSRetryCount - retrycount) + " times." + ex.getMessage());
                            continue;
                        }
                    }
                }
                if (ok) break;
                log.log(Level.FATAL, "fgsms unable to fetch policy from any of the PCS[" + DataPusher.cfg.PCS_URLS.size() + "] URLs, retry count exceeded. Falling back to default policy");
                MessageProcessor.getSingletonObject().setLastErrorMessage("All PCS endpoints are either unreachable or are responding in error");
            }
        }
        return null;
    }

    public static PolicyHelper LoadPolicy(String url, boolean isclient) {
        PolicyHelper p = (PolicyHelper)policyCache.get(url);
        if (p == null) {
            try {
                log.log(Level.INFO, "fgsms requesting policy for service " + url);
                p = new PolicyHelper();
                ServicePolicyResponseMsg result = DataPusher.FetchPolicy(url, DataPusher.cfg.PCSalgo, isclient);
                if (result == null) {
                    log.log(Level.WARN, "fgsms PCS is unavailable or returned an error, reverting to agent default policy");
                    result = DataPusher.LoadDefaultPolicy(url);
                    p.lastUpdate = 0L;
                } else {
                    p.lastUpdate = Calendar.getInstance().getTimeInMillis();
                }
                p.policy = (TransactionalWebServicePolicy)result.getPolicy();
                DataPusher.cfg.classlevel = result.getClassification();
                policyCache.put(url, p);
                log.log(Level.DEBUG, "fgsms obtained policy for service " + url + " and cached it.");
                return p;
            }
            catch (Exception ex) {
                log.log(Level.ERROR, "fgsms Error retrieving policy from PCS for service at " + url + " because it's either down or busy (check config). This transaction will be discarded.", ex);
            }
        } else {
            long expirationtime = p.policy.getPolicyRefreshRate().getTimeInMillis(Calendar.getInstance());
            if (p.lastUpdate + expirationtime < System.currentTimeMillis()) {
                try {
                    log.log(Level.INFO, "fgsms retrieved cached policy, but it has expired. Retrieving latest policy for service " + url);
                    policyCache.remove(url);
                    ServicePolicyResponseMsg result = DataPusher.FetchPolicy(url, DataPusher.cfg.PCSalgo, isclient);
                    p = new PolicyHelper();
                    p.lastUpdate = Calendar.getInstance().getTimeInMillis();
                    p.policy = (TransactionalWebServicePolicy)result.getPolicy();
                    DataPusher.cfg.classlevel = result.getClassification();
                    policyCache.put(url, p);
                    log.log(Level.INFO, "fgsms obtained policy for service " + url + " and cached it.");
                    return p;
                }
                catch (Exception ex) {
                    log.log(Level.WARN, "fgsms Error refreshing policy from PCS for service at " + url + " using expired policy", ex);
                    return p;
                }
            }
            log.log(Level.DEBUG, "fgsms retrieved cached policy " + url + ". It expires in " + (System.currentTimeMillis() - (p.lastUpdate + expirationtime)) + "ms");
            return p;
        }
        return null;
    }

    public static ServicePolicyResponseMsg LoadDefaultPolicy(String url) {
        try {
            InputStream in = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            in = loader.getResourceAsStream("org/miloss/fgsms/agentcore/defaultpolicy.xml");
            String pol = DataPusher.ReadAllText(in);
            in.close();
            JAXBContext jc = Utility.getSerializationContext();
            Unmarshaller u = jc.createUnmarshaller();
            ByteArrayInputStream bss = new ByteArrayInputStream(pol.getBytes("UTF-8"));
            XMLInputFactory xf = XMLInputFactory.newInstance();
            XMLStreamReader r = xf.createXMLStreamReader(bss);
            JAXBElement foo = u.unmarshal(r, TransactionalWebServicePolicy.class);
            if (foo == null || foo.getValue() == null) {
                log.log(Level.WARN, "ServicePolicy is unexpectedly null or empty");
                return null;
            }
            ServicePolicyResponseMsg ret = new ServicePolicyResponseMsg();
            ret.setPolicy((ServicePolicy)foo.getValue());
            ret.setClassification(DataPusher.cfg.classlevel);
            ret.getPolicy().setURL(url);
            return ret;
        }
        catch (Exception ex) {
            log.log(Level.ERROR, "error loading default policy from disk", ex);
            return null;
        }
    }

    private static AddDataRequestMsg PrepMessage(MessageCorrelator current, PolicyHelper p) {
        if (current == null) {
            return null;
        }
        AddDataRequestMsg req = new AddDataRequestMsg();
        req.setClassification(DataPusher.cfg.classlevel);
        req.setRequestURI(p.policy.getURL());
        req.setURI(current.URL);
        req.setAction(current.soapAction);
        req.setServiceHost(MessageProcessor.getSingletonObject().getHostName());
        req.setRequestSize(current.reqsize);
        req.setResponseSize(current.ressize);
        req.setMessage("Queue size:" + outboundQueue.size() + " PolicyCache:" + policyCache.size() + " MsgMap:" + current.currentMapsize + " CPUs:" + Runtime.getRuntime().availableProcessors());
        req.setAgentType(current.agent_class_name);
        req.setRequestURI(current.originalurl);
        req.setRelatedTransactionID(current.RelatedMsgId);
        req.setTransactionThreadID(current.TransactionThreadId);
        req.setTransactionID(current.MessageID);
        try {
            DatatypeFactory f = DatatypeFactory.newInstance();
            GregorianCalendar gcal = new GregorianCalendar();
            gcal.setTimeInMillis(current.RecievedAt);
            req.setRecordedat(gcal);
        }
        catch (Exception ex) {
            log.log(Level.ERROR, "unexpected error caught when preparing a message.", ex);
        }
        long diff = Math.abs(current.CompletedAt - current.RecievedAt);
        int x = (int)diff;
        req.setResponseTime(x);
        req.setSuccess(!current.IsFault);
        if (current.RequestMessage != null) {
            if (p.policy.isRecordRequestMessage() || p.policy.isRecordFaultsOnly() && current.IsFault) {
                if (p.policy.getRecordedMessageCap() >= current.RequestMessage.length()) {
                    req.setXmlRequest(current.RequestMessage);
                } else {
                    req.setXmlRequest(current.RequestMessage.substring(0, p.policy.getRecordedMessageCap()));
                }
            } else if (DEBUG) {
                log.info("skipping request payload " + p.policy.isRecordRequestMessage() + " " + p.policy.isRecordFaultsOnly() + " " + current.IsFault);
            }
        }
        if (current.ResponseMessage != null) {
            if (p.policy.isRecordResponseMessage() || p.policy.isRecordFaultsOnly() && current.IsFault) {
                if (p.policy.getRecordedMessageCap() >= current.ResponseMessage.length()) {
                    req.setXmlResponse(current.ResponseMessage);
                } else {
                    req.setXmlResponse(current.ResponseMessage.substring(0, p.policy.getRecordedMessageCap()));
                }
            } else if (DEBUG) {
                log.info("skipping response payload " + p.policy.isRecordRequestMessage() + " " + p.policy.isRecordFaultsOnly() + " " + current.IsFault);
            }
        }
        ArrayList<String> s2 = MessageProcessor.getSingletonObject().getUserIdentities(p.policy, current);
        req.getIdentity().addAll(s2);
        if (current.Headers != null && !current.Headers.isEmpty() && p.policy.isRecordHeaders()) {
            int k;
            Object value2;
            String s;
            Header h;
            Iterator<String> e = current.Headers.keySet().iterator();
            while (e.hasNext()) {
                h = new Header();
                s = e.next();
                h.setName(s);
                try {
                    value2 = (String)current.Headers.get(s);
                    h.getValue().add((String)value2);
                    req.getHeadersRequest().add(h);
                }
                catch (Exception value2) {
                    // empty catch block
                }
                try {
                    value2 = (List)current.Headers.get(s);
                    for (k = 0; k < value2.size(); ++k) {
                        h.getValue().add((String)value2.get(k));
                    }
                    req.getHeadersRequest().add(h);
                }
                catch (Exception value3) {}
            }
            if (current.Header_Response != null && !current.Header_Response.isEmpty()) {
                e = current.Header_Response.keySet().iterator();
                while (e.hasNext()) {
                    h = new Header();
                    s = e.next();
                    h.setName(s);
                    try {
                        value2 = (String)current.Header_Response.get(s);
                        h.getValue().add((String)value2);
                        req.getHeadersRequest().add(h);
                    }
                    catch (Exception value4) {
                        // empty catch block
                    }
                    try {
                        value2 = (List)current.Header_Response.get(s);
                        for (k = 0; k < value2.size(); ++k) {
                            h.getValue().add((String)value2.get(k));
                        }
                        req.getHeadersRequest().add(h);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return req;
    }

    @Override
    public void run() {
        MessageProcessor.getSingletonObject().removeDeadMessage();
        DataPusher.Init();
        if (ErrorState) {
            log.log(Level.FATAL, "fgsms Data Pusher is in an error state. Recorded data cannot be sent and will be discarded. Check the configuration file and log for reason. Last error message was " + LastErrorMessage);
            outboundQueue.clear();
            return;
        }
        this.DoDiscovery();
        AddDataRequestMsg PreppedMessage = null;
        boolean enabled = true;
        block10: while (!outboundQueue.isEmpty()) {
            log.log(Level.DEBUG, "fgsms entering publish loop " + outboundQueue.size() + " items to publish.");
            AddMoreData req = new AddMoreData();
            int count = 0;
            int totalbody = 0;
            while (count < 40 && !outboundQueue.isEmpty() && enabled && totalbody < 1024000) {
                MessageCorrelator current = null;
                PreppedMessage = null;
                try {
                    Object j = outboundQueue.remove();
                    if (j instanceof MessageCorrelator) {
                        current = (MessageCorrelator)j;
                    }
                    if (j instanceof AddDataRequestMsg) {
                        PreppedMessage = (AddDataRequestMsg)j;
                    }
                }
                catch (Exception e) {
                    log.log(Level.DEBUG, "fgsms publish loop, error removing item from the queue, another thread must have grabbed the last item. Queue size is currently " + outboundQueue.size());
                }
                boolean isclient = false;
                if (current != null) {
                    isclient = current.agent_class_name != null && (current.agent_class_name.contains("client") || current.agent_class_name.contains("Client"));
                    current.URL = isclient ? DataPusher.IpWrapAndCacher(current.URL, true) : DataPusher.IpWrapAndCacher(current.URL, false);
                    if (MessageProcessor.getSingletonObject().getIgnoreList().contains(current.URL.toLowerCase())) {
                        current = null;
                        continue;
                    }
                }
                if (PreppedMessage != null) {
                    if (!Utility.stringIsNullOrEmpty(PreppedMessage.getXmlRequest())) {
                        totalbody += PreppedMessage.getXmlRequest().length();
                    }
                    if (!Utility.stringIsNullOrEmpty(PreppedMessage.getXmlResponse())) {
                        totalbody += PreppedMessage.getXmlResponse().length();
                    }
                    req.getReq().add(PreppedMessage);
                    ++count;
                }
                if (current == null) continue;
                PolicyHelper p = DataPusher.LoadPolicy(current.URL, isclient);
                if (p == null || p.policy == null) {
                    log.log(Level.WARN, "Unable to obtain policy for URL " + current.URL + ", transaction data will be lost.");
                    continue;
                }
                if (p.policy.isAgentsEnabled()) {
                    if (current != null) {
                        PreppedMessage = DataPusher.PrepMessage(current, p);
                    }
                    if (PreppedMessage != null && !Utility.stringIsNullOrEmpty(PreppedMessage.getXmlRequest())) {
                        totalbody += PreppedMessage.getXmlRequest().length();
                    }
                    if (PreppedMessage != null && !Utility.stringIsNullOrEmpty(PreppedMessage.getXmlResponse())) {
                        totalbody += PreppedMessage.getXmlResponse().length();
                    }
                    req.getReq().add(PreppedMessage);
                    ++count;
                    continue;
                }
                enabled = false;
                log.log(Level.WARN, "fgsms PCS reports that all agents are disabled!");
                MessageProcessor.getSingletonObject().setLastErrorMessage("Agents centrally disabled");
                outboundQueue.clear();
            }
            if (!enabled) continue;
            BindingProvider bp = (BindingProvider)DataPusher.cfg.dcsport;
            Map context = bp.getRequestContext();
            int retrycount = 0;
            int urlcount = 0;
            boolean ok = false;
            if (req.getReq().isEmpty()) continue;
            switch (DataPusher.cfg.DCSalgo) {
                case ROUNDROBIN: {
                    urlcount = 0;
                    ok = false;
                    for (retrycount = 0; !ok && retrycount < DataPusher.cfg.DCSRetryCount; ++retrycount) {
                        for (urlcount = 0; !ok && urlcount < DataPusher.cfg.DCS_URLS.size(); ++urlcount) {
                            try {
                                AddDataResponseMsg addMoreData;
                                context.put("javax.xml.ws.service.endpoint.address", DataPusher.cfg.DCS_URLS.get(urlcount));
                                if (DEBUG) {
                                    JAXB.marshal((Object)req, (OutputStream)System.out);
                                }
                                if ((addMoreData = DataPusher.cfg.dcsport.addMoreData(req.getReq())) != null && addMoreData.getStatus() != null && addMoreData.getStatus() == DataResponseStatus.SUCCESS) {
                                    ok = true;
                                    log.log(Level.DEBUG, "fgsms successfully sent transaction data for " + req.getReq().size() + " transactions. Items still to process: " + outboundQueue.size());
                                    MessageProcessor.getSingletonObject().incMessagesProcessed(req.getReq().size());
                                    continue;
                                }
                                ok = false;
                                log.log(Level.WARN, "fgsms failed to sent transaction data for " + req.getReq().size() + " transactions. 1 or more items couldn't be saved. Items still to process: " + outboundQueue.size());
                                continue;
                            }
                            catch (Exception ex) {
                                log.log(Level.WARN, "fgsms Error sending performance data to DCS for service at " + DataPusher.cfg.DCS_URLS.get(urlcount) + " will retry " + (DataPusher.cfg.DCSRetryCount - retrycount) + " times.", ex);
                            }
                        }
                    }
                    if (ok) break;
                    log.log(Level.ERROR, "fgsms unable to send performance data to DCS, retry count exceeded.");
                    MessageProcessor.getSingletonObject().setLastErrorMessage("retry count exceeded");
                    if (DataPusher.cfg.behavior == ConfigLoader.UnavailableBehavior.HOLD) {
                        for (int i = 0; i < req.getReq().size(); ++i) {
                            outboundQueue.add(req.getReq());
                        }
                        continue block10;
                    }
                    if (DataPusher.cfg.behavior == ConfigLoader.UnavailableBehavior.HOLDPERSIST) {
                        for (int i = 0; i < req.getReq().size(); ++i) {
                            DataPusher.StorePersist(req);
                        }
                        continue block10;
                    }
                    if (DataPusher.cfg.behavior == ConfigLoader.UnavailableBehavior.PURGE) {
                        req.getReq().clear();
                        req = null;
                        break;
                    }
                    throw new IllegalArgumentException("agent unavailable behavior");
                }
                case FAILOVER: {
                    retrycount = 0;
                    ok = false;
                    for (urlcount = 0; !ok && urlcount < DataPusher.cfg.DCS_URLS.size(); ++urlcount) {
                        while (!ok && retrycount < DataPusher.cfg.DCSRetryCount) {
                            try {
                                AddDataResponseMsg addMoreData;
                                context.put("javax.xml.ws.service.endpoint.address", DataPusher.cfg.DCS_URLS.get(urlcount));
                                if (DEBUG) {
                                    JAXB.marshal((Object)req, (OutputStream)System.out);
                                }
                                if ((addMoreData = DataPusher.cfg.dcsport.addMoreData(req.getReq())) != null && addMoreData.getStatus() != null && addMoreData.getStatus() == DataResponseStatus.SUCCESS) {
                                    ok = true;
                                    log.log(Level.DEBUG, "fgsms successfully sent transaction data for " + req.getReq().size() + " transactions. Items still to process: " + outboundQueue.size());
                                    MessageProcessor.getSingletonObject().incMessagesProcessed(req.getReq().size());
                                } else {
                                    ok = false;
                                    log.log(Level.WARN, "fgsms failed to sent transaction data for " + req.getReq().size() + " transactions. 1 or more items couldn't be saved. Items still to process: " + outboundQueue.size());
                                }
                            }
                            catch (Exception ex) {
                                log.log(Level.WARN, "fgsms Error sending performance data to DCS for service at " + DataPusher.cfg.DCS_URLS.get(urlcount) + " will retry " + (DataPusher.cfg.DCSRetryCount - retrycount) + " times.", ex);
                            }
                            ++retrycount;
                        }
                    }
                    if (ok) break;
                    log.log(Level.ERROR, "fgsms unable to send performance data to DCS, retry count exceeded.");
                    MessageProcessor.getSingletonObject().setLastErrorMessage("retry count exceeded");
                    if (DataPusher.cfg.behavior == ConfigLoader.UnavailableBehavior.HOLD) {
                        for (int i = 0; i < req.getReq().size(); ++i) {
                            outboundQueue.add(req.getReq());
                        }
                        continue block10;
                    }
                    if (DataPusher.cfg.behavior == ConfigLoader.UnavailableBehavior.HOLDPERSIST) {
                        for (int i = 0; i < req.getReq().size(); ++i) {
                            DataPusher.StorePersist(req);
                        }
                        continue block10;
                    }
                    if (DataPusher.cfg.behavior == ConfigLoader.UnavailableBehavior.PURGE) {
                        req.getReq().clear();
                        req = null;
                        break;
                    }
                    throw new IllegalArgumentException("agent unavailable behavior");
                }
            }
        }
        log.log(Level.DEBUG, "fgsms Data Pusher thread is terminating, no data available to send.");
    }

    protected static AddMoreData CheckPersistStore() {
        File[] list;
        DataPusher.Init();
        if (Utility.stringIsNullOrEmpty(DataPusher.cfg.offlinestorage) || DataPusher.cfg.behavior != ConfigLoader.UnavailableBehavior.HOLDPERSIST) {
            return null;
        }
        File f = new File(DataPusher.cfg.offlinestorage);
        if (f.exists() && f.isDirectory() && (list = f.listFiles()) != null) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ArrayOfSLA.class, SLA.class, SLAAction.class, SLARuleGeneric.class, AndOrNot.class, AddDataRequestMsg.class, AddMoreData.class, AddData.class, String.class, Duration.class, Long.class, SecurityWrapper.class, ClassificationType.class, List.class, Header.class});
            Unmarshaller u = jc.createUnmarshaller();
            for (int i = 0; i < list.length; ++i) {
                try {
                    boolean delete;
                    String s = DataPusher.ReadAllText(f.getPath() + File.separator + f.getName());
                    s = Utility.DE(s);
                    ByteArrayInputStream bss = new ByteArrayInputStream(s.getBytes("UTF-8"));
                    XMLStreamReader r = XMLInputFactory.newFactory().createXMLStreamReader(bss);
                    JAXBElement foo = u.unmarshal(r, AddMoreData.class);
                    if (foo == null || foo.getValue() == null) {
                        log.log(Level.WARN, "Add request is unexpectedly null or empty when     reading it in from disk                        ");
                    }
                    if (!(delete = f.delete())) {
                        log.log(Level.ERROR, "Unable to delete file " + f.getPath() + File.separator + f.getName() + " this may cause unintented consequences, even infinite looping. Ensure that" + "this process has delete access to the folder");
                    }
                    if (foo != null) {
                        return (AddMoreData)foo.getValue();
                    }
                    return null;
                }
                catch (Exception ex) {
                    try {
                        log.log(Level.WARN, "error caught reading performance data from disk", ex);
                        continue;
                    }
                    catch (Exception ex2) {
                        log.log(Level.WARN, "error caught reading performance data from disk", ex2);
                        break;
                    }
                }
            }
        }
        return null;
    }

    protected static void EnsureFolderExists(String folder) {
        File f = null;
        try {
            f = new File(folder);
            if (f.exists()) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new File(folder).mkdirs();
        }
        catch (Exception ex) {
            log.log(Level.WARN, "Cannot ensure that the folder " + folder + " exists");
        }
    }

    protected static void StorePersist(AddMoreData req) {
        if (req == null || req.getReq() == null || req.getReq().isEmpty()) {
            return;
        }
        DataPusher.Init();
        for (int i = 0; i < req.getReq().size(); ++i) {
            JAXBContext jc = null;
            try {
                jc = JAXBContext.newInstance((Class[])new Class[]{AddDataRequestMsg.class, AddDataRequestMsg.class, AddMoreData.class, AddData.class, String.class, Duration.class, Long.class, SecurityWrapper.class, ClassificationType.class, List.class, Header.class});
                Marshaller m = jc.createMarshaller();
                StringWriter sw = new StringWriter();
                m.marshal((Object)req.getReq().get(i), (Writer)sw);
                String s = sw.toString();
                s = Utility.EN(s);
                DataPusher.WriteAllText(DataPusher.cfg.offlinestorage + File.separator + UUID.randomUUID().toString(), s);
                continue;
            }
            catch (Exception ex) {
                log.log(Level.WARN, "Unable to marshall or store to disk service performance record", ex);
            }
        }
    }

    protected static String ReadAllText(InputStream in) {
        try {
            InputStreamReader sr = new InputStreamReader(in, "UTF-8");
            StringBuilder fileData = new StringBuilder(1000);
            BufferedReader reader = new BufferedReader(sr);
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
            sr.close();
            return fileData.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String ReadAllText(String pathandfile) {
        try {
            StringBuilder fileData = new StringBuilder(1000);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pathandfile), "UTF-8"));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
            return fileData.toString();
        }
        catch (Exception e) {
            log.log(Level.ERROR, "ReadAllText, ", e);
            return "";
        }
    }

    private static void WriteAllText(String filename, String text) {
        try {
            File f = new File(filename);
            log.log(Level.INFO, "WriteAllText Current Dir = " + f.getName() + f.getAbsolutePath());
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            out.write(text);
            out.close();
        }
        catch (Exception e) {
            log.log(Level.INFO, filename + " WriteAllText, ", e);
        }
    }

    private void DoDiscovery() {
        int i;
        if (cfg == null || DataPusher.cfg.prop == null) {
            throw new NullPointerException("fgsms properties file is not available.");
        }
        if (this.endpointproviders == null) {
            this.endpointproviders = DataPusher.LoadEndpointProviders(cfg);
        }
        ArrayList<String> endpointspcs = new ArrayList<String>();
        ArrayList<String> endpointsdcs = new ArrayList<String>();
        boolean ran = false;
        for (i = 0; i < this.endpointproviders.size(); ++i) {
            try {
                if (System.currentTimeMillis() - DataPusher.cfg.discoveryInterval <= this.endpointproviders.get(i).GetLastLookup() || !this.endpointproviders.get(i).IsEnabled()) continue;
                endpointspcs.addAll(this.endpointproviders.get(i).GetPCSURLs());
                endpointsdcs.addAll(this.endpointproviders.get(i).GetDCSURLs());
                ran = true;
                this.endpointproviders.get(i).SetLastLookup(System.currentTimeMillis());
                continue;
            }
            catch (Exception ex) {
                log.fatal("The discovery provery " + this.endpointproviders.getClass().getCanonicalName() + " is faulty and threw an exception", ex);
            }
        }
        if (ran) {
            for (i = 0; i < endpointspcs.size(); ++i) {
                if (DataPusher.cfg.PCS_URLS.contains(endpointspcs.get(i))) continue;
                DataPusher.cfg.PCS_URLS.add((String)endpointspcs.get(i));
            }
            for (i = 0; i < endpointspcs.size(); ++i) {
                if (DataPusher.cfg.DCS_URLS.contains(endpointsdcs.get(i))) continue;
                DataPusher.cfg.DCS_URLS.add((String)endpointsdcs.get(i));
            }
        }
    }

    public static List<IEndpointDiscovery> LoadEndpointProviders(ConfigLoader cl) {
        if (cl == null || cl.prop == null) {
            throw new NullPointerException("fgsms properties file is not available.");
        }
        List<String> discovery_providers = cl.getDiscovery_providers();
        ArrayList<IEndpointDiscovery> eps = new ArrayList<IEndpointDiscovery>();
        for (int i = 0; i < discovery_providers.size(); ++i) {
            try {
                Class<?> t = Class.forName(discovery_providers.get(i));
                IEndpointDiscovery newInstance = (IEndpointDiscovery)t.newInstance();
                newInstance.LoadConfig(cl.prop);
                eps.add(newInstance);
                continue;
            }
            catch (Exception ex) {
                log.warn("Unable to load endpoint provider " + discovery_providers.get(i), ex);
            }
        }
        return eps;
    }

    static {
        log = Logger.getLogger("fgsms.Agents");
        cfg = null;
        ErrorState = false;
        LastErrorMessage = "";
    }
}

