/*
 * Decompiled with CFR 0.152.
 */
package org.miloss.fgsms.agentcore;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Level;
import org.miloss.fgsms.agentcore.ConfigurationException;
import org.miloss.fgsms.common.Constants;
import org.miloss.fgsms.common.Logger;
import org.miloss.fgsms.common.PropertyLoader;
import org.miloss.fgsms.common.Utility;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.AutomatedReportingService;
import org.miloss.fgsms.services.interfaces.automatedreportingservice.AutomatedReportingService_Service;
import org.miloss.fgsms.services.interfaces.common.SecurityWrapper;
import org.miloss.fgsms.services.interfaces.dataaccessservice.DataAccessService;
import org.miloss.fgsms.services.interfaces.dataaccessservice.DataAccessService_Service;
import org.miloss.fgsms.services.interfaces.datacollector.DCS;
import org.miloss.fgsms.services.interfaces.datacollector.DataCollectorService;
import org.miloss.fgsms.services.interfaces.policyconfiguration.PCS;
import org.miloss.fgsms.services.interfaces.policyconfiguration.PolicyConfigurationService;
import org.miloss.fgsms.services.interfaces.reportingservice.ReportingService;
import org.miloss.fgsms.services.interfaces.reportingservice.ReportingService_Service;
import org.miloss.fgsms.services.interfaces.status.StatusService;
import org.miloss.fgsms.services.interfaces.status.StatusServiceService;
import us.gov.ic.ism.v2.ClassificationType;

public class ConfigLoader {
    public static final String PROP_MESSAGE_PROCESSOR_IMPL = "message.processor.impl";
    static Logger log = Logger.getLogger("fgsms.Agents");
    protected SecurityWrapper classlevel = new SecurityWrapper(ClassificationType.U, "None");
    protected StatusService ssport = null;
    protected StatusServiceService ss = null;
    protected Algorithm SSalgo = Algorithm.FAILOVER;
    protected int SSRetryCount = 2;
    protected List<String> SS_URLS = new ArrayList<String>();
    protected PolicyConfigurationService pcsservice = null;
    protected PCS pcsport = null;
    protected List<String> PCS_URLS = new ArrayList<String>();
    protected Algorithm PCSalgo = Algorithm.FAILOVER;
    protected int PCSRetryCount = 2;
    protected DataCollectorService dcsservice = null;
    protected DCS dcsport = null;
    protected Algorithm DCSalgo = Algorithm.FAILOVER;
    protected List<String> DCS_URLS = new ArrayList<String>();
    protected int DCSRetryCount = 2;
    protected Algorithm ACSalgo = Algorithm.FAILOVER;
    protected int ACSRetryCount = 2;
    protected List<String> ACS_URLS = new ArrayList<String>();
    protected Algorithm ACSAalgo = Algorithm.FAILOVER;
    protected int ACSARetryCount = 2;
    protected List<String> ACSA_URLS = new ArrayList<String>();
    protected ReportingService rsport = null;
    protected ReportingService_Service rs = null;
    protected DataAccessService dasport = null;
    protected DataAccessService_Service das = null;
    protected Algorithm RSAalgo = Algorithm.FAILOVER;
    protected int RSRetryCount = 2;
    protected List<String> RS_URLS = new ArrayList<String>();
    protected AutomatedReportingService arsport = null;
    protected AutomatedReportingService_Service ars = null;
    protected Algorithm ARSAalgo = Algorithm.FAILOVER;
    protected int ARSRetryCount = 2;
    protected List<String> ARS_URLS = new ArrayList<String>();
    protected Properties prop = null;
    protected String username = "";
    protected String password = "";
    protected String certinfo = "";
    protected Constants.AuthMode mode_ = Constants.AuthMode.None;
    protected long discoveryInterval = 600000L;
    protected String offlinestorage = "";
    protected UnavailableBehavior behavior = UnavailableBehavior.PURGE;
    protected String javaxtruststore = null;
    protected String javaxtruststorepass = null;
    protected String javaxkeystore = null;
    protected String javaxkeystorepass = null;
    List<String> discover_providers = new ArrayList<String>();

    public ConfigLoader(Properties p) throws ConfigurationException {
        this.prop = p;
        this.load();
    }

    public ConfigLoader(boolean p) throws ConfigurationException {
        this.createClientProxies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties() throws ConfigurationException {
        Properties prop;
        block35: {
            block34: {
                prop = null;
                try {
                    if (!System.getProperties().containsKey("org.miloss.fgsms.agentConfigFileOverride")) break block34;
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(System.getProperty("org.miloss.fgsms.agentConfigFileOverride"));
                        prop = new Properties();
                        prop.load(is);
                        log.log(Level.INFO, "Agent configuration loaded from System Property Override at " + System.getProperty("org.miloss.fgsms.agentConfigFileOverride") + "7.0.0  2017.03.11 21:51.");
                    }
                    catch (Exception ex) {
                        log.log(Level.DEBUG, "", ex);
                        prop = null;
                    }
                    finally {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Exception ex) {
                                log.log(Level.DEBUG, "", ex);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    prop = null;
                }
            }
            if (prop == null) {
                try {
                    prop = new Properties();
                    URL file = ClassLoader.getSystemClassLoader().getResource("fgsms-agent.properties");
                    if (file != null) {
                        InputStream is = null;
                        try {
                            is = file.openStream();
                            prop.load(is);
                            log.log(Level.INFO, "Agent configuration loaded from System classloader at " + file.toString() + "7.0.0  2017.03.11 21:51.");
                            is.close();
                            break block35;
                        }
                        catch (Exception ex) {
                            log.log(Level.DEBUG, "", ex);
                            break block35;
                        }
                        finally {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Exception e2) {
                                    log.log(Level.DEBUG, "", e2);
                                }
                            }
                        }
                    }
                    prop = null;
                }
                catch (Exception ex) {
                    log.log(Level.DEBUG, "", ex);
                    prop = null;
                }
            }
        }
        if (prop == null) {
            try {
                prop = PropertyLoader.loadProperties("org/miloss/fgsms/agentcore/fgsms-agent");
                log.log(Level.INFO, "Agent configuration loaded from embedded config file within fgsms-agentCore.jar. Use -Dorg.miloss.fgsms.agentConfigFileOverride=path/to/config.properties to override or include the file fgsms-agent.properties in the classpath.7.0.0  2017.03.11 21:51.");
            }
            catch (Exception ex) {
                log.log(Level.FATAL, "Could not load the fgsms-agent.properties files (embedded)7.0.0  2017.03.11 21:51.", ex);
            }
        }
        if (prop == null) {
            throw new ConfigurationException("Cannot locate the fgsms-agent.properties file");
        }
        return prop;
    }

    public ConfigLoader() throws ConfigurationException {
        this.prop = ConfigLoader.loadProperties();
        this.load();
    }

    public Algorithm getRSAalgo() {
        return this.RSAalgo;
    }

    public int getRSRetryCount() {
        return this.RSRetryCount;
    }

    public List<String> getRS_URLS() {
        return this.RS_URLS;
    }

    public int getACSARetryCount() {
        return this.ACSARetryCount;
    }

    public List<String> getACSA_URLS() {
        return this.ACSA_URLS;
    }

    public Algorithm getACSAalgo() {
        return this.ACSAalgo;
    }

    public int getACSRetryCount() {
        return this.ACSRetryCount;
    }

    public List<String> getACS_URLS() {
        return this.ACS_URLS;
    }

    public Algorithm getACSalgo() {
        return this.ACSalgo;
    }

    public Algorithm getARSAalgo() {
        return this.ARSAalgo;
    }

    public int getARSRetryCount() {
        return this.ARSRetryCount;
    }

    public List<String> getARS_URLS() {
        return this.ARS_URLS;
    }

    public AutomatedReportingService getArsport() {
        return this.arsport;
    }

    public ReportingService getRsport() {
        return this.rsport;
    }

    public String getJavaxkeystore() {
        return this.javaxkeystore;
    }

    public String getJavaxkeystorepass() {
        return this.javaxkeystorepass;
    }

    public String getJavaxtruststore() {
        return this.javaxtruststore;
    }

    public String getJavaxtruststorepass() {
        return this.javaxtruststorepass;
    }

    public int getDCSRetryCount() {
        return this.DCSRetryCount;
    }

    public List<String> getDCS_URLS() {
        return this.DCS_URLS;
    }

    public Algorithm getDCSalgo() {
        return this.DCSalgo;
    }

    public int getPCSRetryCount() {
        return this.PCSRetryCount;
    }

    public List<String> getPCS_URLS() {
        return this.PCS_URLS;
    }

    public Algorithm getPCSalgo() {
        return this.PCSalgo;
    }

    public int getSSRetryCount() {
        return this.SSRetryCount;
    }

    public List<String> getSS_URLS() {
        return this.SS_URLS;
    }

    public Algorithm getSSalgo() {
        return this.SSalgo;
    }

    public UnavailableBehavior getBehavior() {
        return this.behavior;
    }

    public String getCertinfo() {
        return this.certinfo;
    }

    public SecurityWrapper getClasslevel() {
        return this.classlevel;
    }

    public DCS getDcsport() {
        return this.dcsport;
    }

    public DataCollectorService getDcsservice() {
        return this.dcsservice;
    }

    public long getDiscoveryInterval() {
        return this.discoveryInterval;
    }

    public Constants.AuthMode getMode_() {
        return this.mode_;
    }

    public String getOfflinestorage() {
        return this.offlinestorage;
    }

    public String getPassword() {
        return this.password;
    }

    public PCS getPcsport() {
        return this.pcsport;
    }

    public PolicyConfigurationService getPcsservice() {
        return this.pcsservice;
    }

    public Properties getProp() {
        return this.prop;
    }

    public StatusServiceService getSs() {
        return this.ss;
    }

    public StatusService getSsport() {
        return this.ssport;
    }

    public String getUsername() {
        return this.username;
    }

    private void createClientProxies() throws ConfigurationException {
        String LastErrorMessage = "";
        boolean fatalerror = false;
        try {
            this.pcsservice = new PolicyConfigurationService();
            this.pcsport = this.pcsservice.getPCSPort();
        }
        catch (Exception ex) {
            fatalerror = true;
            LastErrorMessage = "fgsms config loader, error caught initializing PCS client proxies. Unable to send data. Check the fgsms Agent properties file and ensure that the PCS WSDL location URL is defined and that the JAX-WS runtime is installed and configured within this container." + ex.getMessage();
            log.log(Level.WARN, null, ex);
        }
        try {
            this.dcsservice = new DataCollectorService();
            this.dcsport = this.dcsservice.getDCSPort();
        }
        catch (Exception ex) {
            fatalerror = true;
            LastErrorMessage = "fgsms config loader, error caught initializing DCS client proxies. Unable to send data. Check the fgsms Agent properties file and ensure that the DCS WSDL location URL is defined and that the JAX-WS runtime is installed and configured within this container." + ex.getMessage();
            log.log(Level.WARN, null, ex);
        }
        try {
            this.ss = new StatusServiceService();
            this.ssport = this.ss.getStatusServicePort();
        }
        catch (Exception ex) {
            LastErrorMessage = "fgsms config loader, error caught initializing SS client proxies. Unable to send data. Check the fgsms Agent properties file and ensure that the DCS WSDL location URL is defined and that the JAX-WS runtime is installed and configured within this container." + ex.getMessage();
            log.log(Level.WARN, null, ex);
        }
        try {
            this.rs = new ReportingService_Service();
            this.rsport = this.rs.getReportingServicePort();
        }
        catch (Exception ex) {
            LastErrorMessage = "fgsms config loader, error caught initializing RS client proxies. Unable to send data. Check the fgsms Agent properties file and ensure that the JAX-WS runtime is installed and configured within this container." + ex.getMessage();
            log.log(Level.WARN, null, ex);
        }
        try {
            this.ars = new AutomatedReportingService_Service();
            this.arsport = this.ars.getAutomatedReportingServicePort();
        }
        catch (Exception ex) {
            LastErrorMessage = "fgsms config loader, error caught initializing ARS client proxies. Unable to send data. Check the fgsms Agent properties file and ensure that the JAX-WS runtime is installed and configured within this container." + ex.getMessage();
            log.log(Level.WARN, null, ex);
        }
        try {
            this.das = new DataAccessService_Service();
            this.dasport = this.das.getDASPort();
        }
        catch (Exception ex) {
            LastErrorMessage = "fgsms config loader, error caught initializing DAS client proxies. Unable to send data. Check the fgsms Agent properties file and ensure that the JAX-WS runtime is installed and configured within this container." + ex.getMessage();
            log.log(Level.WARN, null, ex);
        }
        if (!Utility.stringIsNullOrEmpty(LastErrorMessage)) {
            log.log(Level.WARN, LastErrorMessage);
        }
        if (fatalerror) {
            throw new ConfigurationException(LastErrorMessage);
        }
    }

    private void load() throws ConfigurationException {
        URL url;
        int i;
        String[] ts;
        if (this.prop == null) {
            throw new ConfigurationException("Cannot locate the fgsms-agent.properties file");
        }
        this.createClientProxies();
        try {
            this.behavior = UnavailableBehavior.valueOf(this.prop.getProperty("agent.unavailablebehavior").trim());
        }
        catch (Exception ex) {
            log.log(Level.WARN, null, ex);
            this.behavior = UnavailableBehavior.PURGE;
        }
        try {
            this.username = this.prop.getProperty("fgsms.AuthMode.Username").trim();
        }
        catch (Exception ex) {
            log.log(Level.WARN, null, ex);
        }
        try {
            this.password = this.prop.getProperty("fgsms.AuthMode.Password").trim();
        }
        catch (Exception ex) {
            log.log(Level.WARN, null, ex);
        }
        try {
            this.certinfo = this.prop.getProperty("fgsms.AuthMode.PKICert");
        }
        catch (Exception ex) {
            log.log(Level.WARN, null, ex);
        }
        try {
            this.mode_ = Constants.AuthMode.valueOf(this.prop.getProperty("fgsms.AuthMode").trim());
        }
        catch (Exception ex) {
            this.mode_ = Constants.AuthMode.UsernamePassword;
            log.log(Level.WARN, null, ex);
        }
        try {
            this.offlinestorage = this.prop.getProperty("agent.offlinestorage").trim();
            if (this.behavior == UnavailableBehavior.HOLDPERSIST) {
                this.EnsureFolderExists(this.offlinestorage);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARN, null, ex);
        }
        try {
            this.PCSalgo = Algorithm.valueOf(this.prop.getProperty("policyconfigurationservice.algorithm").trim());
        }
        catch (Exception ex) {
            this.PCSalgo = Algorithm.FAILOVER;
            log.log(Level.WARN, null, ex);
        }
        try {
            this.DCSalgo = Algorithm.valueOf(this.prop.getProperty("datacollectorservice.algorithm").trim());
        }
        catch (Exception ex) {
            this.DCSalgo = Algorithm.FAILOVER;
            log.log(Level.WARN, null, ex);
        }
        try {
            this.SSalgo = Algorithm.valueOf(this.prop.getProperty("statusservice.algorithm").trim());
        }
        catch (Exception ex) {
            this.SSalgo = Algorithm.FAILOVER;
            log.log(Level.WARN, null, ex);
        }
        try {
            this.DCSRetryCount = Integer.parseInt(this.prop.getProperty("datacollectorservice.retry").trim());
        }
        catch (Exception ex) {
            this.DCSRetryCount = 2;
            log.log(Level.WARN, null, ex);
        }
        try {
            this.SSRetryCount = Integer.parseInt(this.prop.getProperty("statusservice.retry").trim());
        }
        catch (Exception ex) {
            this.SSRetryCount = 2;
            log.log(Level.WARN, null, ex);
        }
        try {
            this.PCSRetryCount = Integer.parseInt(this.prop.getProperty("policyconfigurationservice.retry").trim());
        }
        catch (Exception ex) {
            this.PCSRetryCount = 2;
            log.log(Level.WARN, null, ex);
        }
        try {
            this.discoveryInterval = Integer.parseInt(this.prop.getProperty("discovery.interval").trim());
        }
        catch (Exception ex) {
            log.log(Level.WARN, null, ex);
        }
        String t = this.prop.getProperty("policyconfigurationservice.URL");
        if (t.contains("|")) {
            ts = t.split("\\|");
            for (i = 0; i < ts.length; ++i) {
                this.PCS_URLS.add(ts[i]);
            }
        } else {
            this.PCS_URLS.add(t);
        }
        t = this.prop.getProperty("datacollectorservice.URL");
        if (t.contains("|")) {
            ts = t.split("\\|");
            for (i = 0; i < ts.length; ++i) {
                this.DCS_URLS.add(ts[i]);
            }
        } else {
            this.DCS_URLS.add(t);
        }
        t = this.prop.getProperty("statusservice.URL");
        if (t.contains("|")) {
            ts = t.split("\\|");
            for (i = 0; i < ts.length; ++i) {
                this.SS_URLS.add(ts[i]);
            }
        } else {
            this.SS_URLS.add(t);
        }
        t = this.prop.getProperty("fgsms.TrustStore.Password");
        if (!Utility.stringIsNullOrEmpty(t)) {
            this.javaxtruststorepass = t;
            url = null;
            try {
                url = Thread.currentThread().getContextClassLoader().getResource("/META-INF/truststore.jks");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (url == null) {
                try {
                    url = Thread.currentThread().getContextClassLoader().getResource("META-INF/truststore.jks");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (url != null) {
                this.javaxtruststore = url.toString();
                log.log(Level.INFO, "Loading truststore from " + this.javaxtruststore);
            }
        }
        this.discover_providers = new ArrayList<String>();
        t = this.prop.getProperty("discovery.impl");
        if (!Utility.stringIsNullOrEmpty(t)) {
            String[] s = t.split(",");
            this.discover_providers.addAll(Arrays.asList(s));
        }
        if (!Utility.stringIsNullOrEmpty(t = this.prop.getProperty("fgsms.KeyStore.Password"))) {
            this.javaxkeystorepass = t;
            url = null;
            try {
                url = Thread.currentThread().getContextClassLoader().getResource("/META-INF/key.jks");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (url == null) {
                try {
                    url = Thread.currentThread().getContextClassLoader().getResource("META-INF/key.jks");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (url != null) {
                this.javaxkeystore = url.toString();
                log.log(Level.INFO, "Loading keystore from " + this.javaxkeystore);
            }
        }
    }

    public List<String> getDiscovery_providers() {
        return this.discover_providers;
    }

    public long getDeadMessageQueueDuration() {
        String s = this.prop.getProperty("message.processor.dead.message.queue.duration");
        long ret = 10000L;
        if (!Utility.stringIsNullOrEmpty(s)) {
            try {
                ret = Long.parseLong(s);
            }
            catch (Exception ex) {
                log.warn("error parsing message.processor.dead.message.queue.duration");
            }
        }
        if (ret < 10000L) {
            ret = 10000L;
        }
        return ret;
    }

    public boolean isDependencyInjectionEnabled() {
        try {
            return Boolean.parseBoolean(this.prop.getProperty("agent.dependencyinjection.enabled"));
        }
        catch (Exception ex) {
            log.warn("error parsing agent.dependencyinjection.enabled");
            return false;
        }
    }

    HashMap getWSAgentIgnoreList() {
        HashMap<String, Boolean> IgnoreList = new HashMap<String, Boolean>();
        String t = this.prop.getProperty("message.processor.ignoreList");
        if (!Utility.stringIsNullOrEmpty(t)) {
            if (t.contains("|")) {
                String[] ts = t.split("\\|");
                for (int i = 0; i < ts.length; ++i) {
                    IgnoreList.put(ts[i].toLowerCase(), false);
                }
            } else {
                IgnoreList.put(t.toLowerCase(), false);
            }
        }
        return IgnoreList;
    }

    private void EnsureFolderExists(String folder) throws ConfigurationException {
        File f = null;
        try {
            f = new File(folder);
            if (f.exists()) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new File(folder).mkdirs();
        }
        catch (Exception ex) {
            throw new ConfigurationException("Cannot ensure that the folder " + folder + " exists");
        }
    }

    public static enum UnavailableBehavior {
        PURGE,
        HOLD,
        HOLDPERSIST;

    }

    public static enum Algorithm {
        FAILOVER,
        ROUNDROBIN;

    }
}

