/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport.wrapper;

import java.io.StringWriter;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Holder;
import org.apache.juddi.jaxb.JAXBMarshaller;
import org.uddi.api_v3.AssertionStatusReport;
import org.uddi.api_v3.CompletionStatus;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.GetAssertionStatusReport;
import org.uddi.api_v3.GetPublisherAssertions;
import org.uddi.api_v3.PublisherAssertions;
import org.uddi.api_v3.PublisherAssertionsResponse;
import org.uddi.api_v3.SetPublisherAssertions;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestHandler {
    private static DocumentBuilder docBuilder = null;
    private volatile String version;
    private volatile String operation;
    private volatile Remote portType;
    private volatile String methodName;
    private volatile Class<?> operationClass;
    private static TransformerFactory transFactory = null;

    public String getOperation(Element uddiReq) throws Exception {
        if (uddiReq == null) {
            throw new UnsupportedOperationException("UDDI Request is null");
        }
        String operation = uddiReq.getLocalName();
        if (operation == null || operation.trim().length() == 0) {
            throw new UnsupportedOperationException("operation " + operation + " not supported");
        }
        this.setOperation(operation);
        return operation;
    }

    public String getVersion(Element uddiReq, String operation) throws Exception {
        String version = uddiReq.getAttribute("generic");
        if ((version == null || "".equals(version)) && "urn:uddi-org:api_v3".equals(uddiReq.getNamespaceURI())) {
            version = "3.0";
        }
        if (!"3.0".equals(version)) {
            throw new UnsupportedOperationException("version needs to be 3.0");
        }
        this.setVersion(version);
        return version;
    }

    public static synchronized String getText(Element element) throws TransformerException {
        if (transFactory == null) {
            transFactory = TransformerFactory.newInstance();
        }
        Transformer trans = transFactory.newTransformer();
        StringWriter sw = new StringWriter();
        trans.transform(new DOMSource(element), new StreamResult(sw));
        return new String(sw.toString());
    }

    public Node invoke(Element uddiReq) throws Exception {
        Document response = null;
        DocumentBuilder docBuilder = this.getDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element element = document.createElement("temp");
        try {
            Object uddiReqObj = JAXBMarshaller.unmarshallFromElement(uddiReq, "org.uddi.api_v3");
            Object result = null;
            if (this.operationClass.equals(GetAssertionStatusReport.class)) {
                GetAssertionStatusReport getAssertionStatusReport = (GetAssertionStatusReport)uddiReqObj;
                Method method = this.portType.getClass().getMethod(this.methodName, String.class, CompletionStatus.class);
                result = method.invoke((Object)this.portType, getAssertionStatusReport.getAuthInfo(), getAssertionStatusReport.getCompletionStatus());
                AssertionStatusReport assertionStatusReport = new AssertionStatusReport();
                assertionStatusReport.getAssertionStatusItem().addAll((List)result);
                result = assertionStatusReport;
            } else if (this.operationClass.equals(SetPublisherAssertions.class)) {
                SetPublisherAssertions setPublisherAssertions = (SetPublisherAssertions)uddiReqObj;
                Method method = this.portType.getClass().getMethod(this.methodName, String.class, Holder.class);
                Holder holder = new Holder(setPublisherAssertions.getPublisherAssertion());
                result = method.invoke((Object)this.portType, setPublisherAssertions.getAuthInfo(), holder);
                PublisherAssertions assertions = new PublisherAssertions();
                if (holder.value != null) {
                    assertions.getPublisherAssertion().addAll((Collection)holder.value);
                }
                result = assertions;
            } else if (this.operationClass.equals(GetPublisherAssertions.class)) {
                GetPublisherAssertions getPublisherAssertions = (GetPublisherAssertions)uddiReqObj;
                Method method = this.portType.getClass().getMethod(this.methodName, String.class);
                result = method.invoke((Object)this.portType, getPublisherAssertions.getAuthInfo());
                List assertionList = (List)result;
                PublisherAssertionsResponse publisherAssertionsResponse = new PublisherAssertionsResponse();
                if (assertionList != null) {
                    publisherAssertionsResponse.getPublisherAssertion().addAll(assertionList);
                }
                result = publisherAssertionsResponse;
            } else {
                Method method = this.portType.getClass().getMethod(this.methodName, this.operationClass);
                result = method.invoke((Object)this.portType, uddiReqObj);
            }
            if (result != null) {
                JAXBMarshaller.marshallToElement(result, "org.uddi.api_v3", element);
                document.appendChild(element.getFirstChild());
            }
            response = document;
        }
        catch (Exception e) {
            DispositionReport dr = DispositionReportFaultMessage.getDispositionReport(e);
            if (dr != null) {
                JAXBMarshaller.marshallToElement(dr, "org.uddi.api_v3", element);
                document.appendChild(element.getFirstChild());
                response = document;
            }
            throw e;
        }
        return response;
    }

    private DocumentBuilder getDocumentBuilder() {
        if (docBuilder == null) {
            docBuilder = this.createDocumentBuilder();
        }
        return docBuilder;
    }

    private synchronized DocumentBuilder createDocumentBuilder() {
        if (docBuilder != null) {
            return docBuilder;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcex) {
            pcex.printStackTrace();
        }
        return docBuilder;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public Remote getPortType() {
        return this.portType;
    }

    public void setPortType(Remote portType) {
        this.portType = portType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Class<?> getOperationClass() {
        return this.operationClass;
    }

    public void setOperationClass(Class<?> operationClass) {
        this.operationClass = operationClass;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

