/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport.wrapper;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Holder;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.juddi.v3.client.UDDIServiceV2;
import org.apache.juddi.v3.client.mapping.MapUDDIv2Tov3;
import org.apache.juddi.v3.client.mapping.MapUDDIv3Tov2;
import org.uddi.api_v2.AssertionStatusReport;
import org.uddi.api_v2.PublisherAssertions;
import org.uddi.api_v2.SetPublisherAssertions;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.AssertionStatusItem;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.CompletionStatus;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.RegisteredInfo;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.TModelDetail;
import org.uddi.v2_service.DispositionReport;
import org.uddi.v2_service.Publish;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIPublicationPortType;

public class Publish3to2
implements UDDIPublicationPortType,
BindingProvider {
    Publish publishService = null;

    public Publish3to2() {
        UDDIServiceV2 service = new UDDIServiceV2();
        this.publishService = service.getPublish();
    }

    public Publish getUDDIv2PublishWebServiceClient() {
        return this.publishService;
    }

    @Override
    public void addPublisherAssertions(AddPublisherAssertions body) throws DispositionReportFaultMessage, RemoteException {
        try {
            this.publishService.addPublisherAssertions(MapUDDIv3Tov2.MapAddPublisherAssertions(body));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public void deleteBinding(DeleteBinding body) throws DispositionReportFaultMessage, RemoteException {
        try {
            this.publishService.deleteBinding(MapUDDIv3Tov2.MapDeleteBinding(body));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public void deleteBusiness(DeleteBusiness body) throws DispositionReportFaultMessage, RemoteException {
        try {
            this.publishService.deleteBusiness(MapUDDIv3Tov2.MapDeleteBusiness(body));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public void deletePublisherAssertions(DeletePublisherAssertions body) throws DispositionReportFaultMessage, RemoteException {
        try {
            this.publishService.deletePublisherAssertions(MapUDDIv3Tov2.MapDeletePublisherAssertions(body));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public void deleteService(DeleteService body) throws DispositionReportFaultMessage, RemoteException {
        try {
            this.publishService.deleteService(MapUDDIv3Tov2.MapDeleteService(body));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public void deleteTModel(DeleteTModel body) throws DispositionReportFaultMessage, RemoteException {
        try {
            this.publishService.deleteTModel(MapUDDIv3Tov2.MapDeleteTModel(body));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public List<AssertionStatusItem> getAssertionStatusReport(String authInfo, CompletionStatus completionStatus) throws DispositionReportFaultMessage, RemoteException {
        try {
            AssertionStatusReport assertionStatusReport = this.publishService.getAssertionStatusReport(MapUDDIv3Tov2.MapGetAssertionStatusReport(authInfo, completionStatus));
            return MapUDDIv2Tov3.MapAssertionStatusItems(assertionStatusReport);
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public List<PublisherAssertion> getPublisherAssertions(String authInfo) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapListPublisherAssertion(this.publishService.getPublisherAssertions(MapUDDIv3Tov2.MapGetPublisherAssertions(authInfo)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public RegisteredInfo getRegisteredInfo(GetRegisteredInfo body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapListRegisteredInfo(this.publishService.getRegisteredInfo(MapUDDIv3Tov2.MapGetRegisteredInfo(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public BindingDetail saveBinding(SaveBinding body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapBindingDetail(this.publishService.saveBinding(MapUDDIv3Tov2.MapSaveBinding(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public BusinessDetail saveBusiness(SaveBusiness body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapBusinessDetail(this.publishService.saveBusiness(MapUDDIv3Tov2.MapSaveBusiness(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public ServiceDetail saveService(SaveService body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapServiceDetail(this.publishService.saveService(MapUDDIv3Tov2.MapSaveService(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public TModelDetail saveTModel(SaveTModel body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapTModelDetail(this.publishService.saveTModel(MapUDDIv3Tov2.MapSaveTModel(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    @Override
    public void setPublisherAssertions(String authInfo, Holder<List<PublisherAssertion>> publisherAssertion) throws DispositionReportFaultMessage, RemoteException {
        try {
            SetPublisherAssertions req = MapUDDIv3Tov2.MapSetPublisherAssertions((List)publisherAssertion.value);
            req.setAuthInfo(authInfo);
            PublisherAssertions setPublisherAssertions = this.publishService.setPublisherAssertions(req);
            publisherAssertion.value = MapUDDIv2Tov3.MapListPublisherAssertion(setPublisherAssertions);
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    public Map<String, Object> getRequestContext() {
        return ((BindingProvider)this.publishService).getRequestContext();
    }

    public Map<String, Object> getResponseContext() {
        return ((BindingProvider)this.publishService).getResponseContext();
    }

    public Binding getBinding() {
        return ((BindingProvider)this.publishService).getBinding();
    }

    public EndpointReference getEndpointReference() {
        return ((BindingProvider)this.publishService).getEndpointReference();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        return (T)((BindingProvider)this.publishService).getEndpointReference(clazz);
    }
}

