/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport;

import java.net.URI;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class RMITransport
extends Transport {
    InitialContext context = null;
    private Log logger = LogFactory.getLog(this.getClass());
    private String nodeName = null;
    private String clientName = null;
    private UDDIInquiryPortType inquiryService = null;
    private UDDISecurityPortType securityService = null;
    private UDDIPublicationPortType publishService = null;
    private UDDISubscriptionPortType subscriptionService = null;
    private UDDISubscriptionListenerPortType subscriptionListenerService = null;
    private UDDICustodyTransferPortType custodyTransferService = null;
    private JUDDIApiPortType publisherService = null;

    public RMITransport() {
        this.nodeName = "default";
    }

    public RMITransport(String nodeName) throws NamingException, ConfigurationException {
        this.nodeName = nodeName;
        this.initContext();
    }

    public RMITransport(String clientName, String nodeName) throws NamingException, ConfigurationException {
        this.nodeName = nodeName;
        this.clientName = clientName;
        this.initContext();
    }

    private void initContext() throws NamingException, ConfigurationException {
        Properties env = new Properties();
        UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
        String factoryInitial = client.getClientConfig().getHomeNode().getFactoryInitial();
        String factoryURLPkgs = client.getClientConfig().getHomeNode().getFactoryURLPkgs();
        String factoryNamingProvider = client.getClientConfig().getHomeNode().getFactoryNamingProvider();
        if (factoryInitial != null && !"".equals(factoryInitial)) {
            env.setProperty("java.naming.factory.initial", factoryInitial);
        }
        if (factoryURLPkgs != null && !"".equals(factoryURLPkgs)) {
            env.setProperty("java.naming.factory.url.pkgs", factoryURLPkgs);
        }
        if (factoryNamingProvider != null && !"".equals(factoryNamingProvider)) {
            env.setProperty("java.naming.provider.url", factoryNamingProvider);
        }
        this.logger.debug("Initial Context using env=" + env.toString());
        this.context = new InitialContext(env);
    }

    @Override
    public UDDIInquiryPortType getUDDIInquiryService(String endpointURL) throws TransportException {
        if (this.inquiryService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getInquiryUrl();
                }
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug("Looking up service=" + service);
                Object requestHandler = this.context.lookup(service);
                this.inquiryService = (UDDIInquiryPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.inquiryService;
    }

    @Override
    public UDDISecurityPortType getUDDISecurityService(String endpointURL) throws TransportException {
        if (this.securityService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getSecurityUrl();
                }
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug("Looking up service=" + service);
                Object requestHandler = this.context.lookup(service);
                this.securityService = (UDDISecurityPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.securityService;
    }

    @Override
    public UDDIPublicationPortType getUDDIPublishService(String endpointURL) throws TransportException {
        if (this.publishService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getPublishUrl();
                }
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug("Looking up service=" + service);
                Object requestHandler = this.context.lookup(service);
                this.publishService = (UDDIPublicationPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publishService;
    }

    @Override
    public UDDISubscriptionPortType getUDDISubscriptionService(String endpointURL) throws TransportException {
        if (this.subscriptionService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getSubscriptionUrl();
                }
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug("Looking up service=" + service);
                Object requestHandler = this.context.lookup(service);
                this.subscriptionService = (UDDISubscriptionPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionService;
    }

    @Override
    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerService(String endpointURL) throws TransportException {
        if (this.subscriptionListenerService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getSubscriptionListenerUrl();
                }
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug("Looking up service=" + service);
                Object requestHandler = this.context.lookup(service);
                this.subscriptionListenerService = (UDDISubscriptionListenerPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.subscriptionListenerService;
    }

    @Override
    public UDDICustodyTransferPortType getUDDICustodyTransferService(String endpointURL) throws TransportException {
        if (this.custodyTransferService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getCustodyTransferUrl();
                }
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug("Looking up service=" + service);
                Object requestHandler = this.context.lookup(service);
                this.custodyTransferService = (UDDICustodyTransferPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.custodyTransferService;
    }

    @Override
    public JUDDIApiPortType getJUDDIApiService(String endpointURL) throws TransportException {
        if (this.publisherService == null) {
            try {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getJuddiApiUrl();
                }
                URI endpointURI = new URI(endpointURL);
                String service = endpointURI.getPath();
                this.logger.debug("Looking up service=" + service);
                Object requestHandler = this.context.lookup(service);
                this.publisherService = (JUDDIApiPortType)requestHandler;
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        return this.publisherService;
    }
}

