/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport;

import java.util.Map;
import java.util.Properties;
import javax.xml.ws.BindingProvider;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.JUDDIApiService;
import org.apache.juddi.v3.client.UDDIService;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.cryptor.CryptorFactory;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class JAXWSTransport
extends Transport {
    private static Log logger = LogFactory.getLog(JAXWSTransport.class);
    String nodeName = null;
    String clientName = null;
    UDDIInquiryPortType inquiryService = null;
    UDDISecurityPortType securityService = null;
    UDDIPublicationPortType publishService = null;
    UDDISubscriptionPortType subscriptionService = null;
    UDDISubscriptionListenerPortType subscriptionListenerService = null;
    UDDICustodyTransferPortType custodyTransferService = null;
    JUDDIApiPortType publisherService = null;

    public JAXWSTransport() {
        this.nodeName = "default";
    }

    public JAXWSTransport(String nodeName) {
        this.nodeName = nodeName;
    }

    public JAXWSTransport(String clientName, String nodeName) {
        this.clientName = clientName;
        this.nodeName = nodeName;
    }

    @Override
    public UDDIInquiryPortType getUDDIInquiryService(String endpointURL) throws TransportException {
        try {
            if (this.inquiryService == null) {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getInquiryUrl();
                }
                UDDIService service = new UDDIService();
                this.inquiryService = service.getUDDIInquiryPort();
            }
            Map requestContext = ((BindingProvider)this.inquiryService).getRequestContext();
            if (endpointURL != null) {
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
            }
            this.setCredentials(requestContext);
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.inquiryService;
    }

    @Override
    public UDDISecurityPortType getUDDISecurityService(String endpointURL) throws TransportException {
        try {
            if (this.securityService == null) {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getSecurityUrl();
                }
                UDDIService service = new UDDIService();
                this.securityService = service.getUDDISecurityPort();
            }
            if (endpointURL != null) {
                if (endpointURL.toLowerCase().startsWith("http:")) {
                    logger.warn("You should consider use a secure protocol (https) when sending your password!");
                }
                Map requestContext = ((BindingProvider)this.securityService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.securityService;
    }

    @Override
    public UDDIPublicationPortType getUDDIPublishService(String endpointURL) throws TransportException {
        try {
            if (this.publishService == null) {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getPublishUrl();
                }
                UDDIService service = new UDDIService();
                this.publishService = service.getUDDIPublicationPort();
            }
            Map requestContext = ((BindingProvider)this.publishService).getRequestContext();
            if (endpointURL != null) {
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
            }
            this.setCredentials(requestContext);
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.publishService;
    }

    @Override
    public UDDISubscriptionPortType getUDDISubscriptionService(String endpointURL) throws TransportException {
        try {
            if (this.subscriptionService == null) {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getSubscriptionUrl();
                }
                UDDIService service = new UDDIService();
                this.subscriptionService = service.getUDDISubscriptionPort();
            }
            if (endpointURL != null) {
                Map requestContext = ((BindingProvider)this.subscriptionService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.subscriptionService;
    }

    @Override
    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerService(String endpointURL) throws TransportException {
        try {
            if (this.subscriptionListenerService == null) {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getSubscriptionListenerUrl();
                }
                UDDIService service = new UDDIService();
                this.subscriptionListenerService = service.getUDDISubscriptionListenerPort();
            }
            if (endpointURL != null) {
                Map requestContext = ((BindingProvider)this.subscriptionListenerService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.subscriptionListenerService;
    }

    @Override
    public UDDICustodyTransferPortType getUDDICustodyTransferService(String endpointURL) throws TransportException {
        try {
            if (this.custodyTransferService == null) {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getCustodyTransferUrl();
                }
                UDDIService service = new UDDIService();
                this.custodyTransferService = service.getUDDICustodyPort();
            }
            if (endpointURL != null) {
                Map requestContext = ((BindingProvider)this.custodyTransferService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.custodyTransferService;
    }

    @Override
    public JUDDIApiPortType getJUDDIApiService(String endpointURL) throws TransportException {
        try {
            if (this.publisherService == null) {
                if (endpointURL == null) {
                    UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                    endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getJuddiApiUrl();
                }
                JUDDIApiService service = new JUDDIApiService();
                this.publisherService = (JUDDIApiPortType)service.getPort(JUDDIApiPortType.class);
            }
            if (endpointURL != null) {
                Map requestContext = ((BindingProvider)this.publisherService).getRequestContext();
                requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
                this.setCredentials(requestContext);
            }
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.publisherService;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    private void setCredentials(Map<String, Object> requestContext) throws ConfigurationException {
        UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
        Properties properties = client.getClientConfig().getUDDINode(this.nodeName).getProperties();
        if (properties != null) {
            String username = null;
            String password = null;
            if (properties.containsKey("basicAuthUsername")) {
                username = properties.getProperty("basicAuthUsername");
            }
            if (properties.containsKey("basicAuthPassword")) {
                password = properties.getProperty("basicAuthPassword");
            }
            String cipher = null;
            boolean isEncrypted = false;
            if (properties.containsKey("basicAuthPasswordCryptoProvider")) {
                cipher = properties.getProperty("basicAuthPasswordCryptoProvider");
            }
            if (properties.containsKey("basicAuthPasswordIsEncrypted")) {
                isEncrypted = Boolean.parseBoolean(properties.getProperty("basicAuthPasswordIsEncrypted"));
            }
            if (username != null && password != null) {
                requestContext.put("javax.xml.ws.security.auth.username", username);
                if (isEncrypted) {
                    try {
                        requestContext.put("javax.xml.ws.security.auth.password", CryptorFactory.getCryptor(cipher).decrypt(password));
                    }
                    catch (Exception ex) {
                        logger.error("Unable to decrypt password!", ex);
                    }
                } else {
                    requestContext.put("javax.xml.ws.security.auth.password", password);
                }
            }
        }
    }
}

