/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.subscription;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.cryptor.DigSigUtil;
import org.apache.juddi.v3.client.subscription.ISubscriptionCallback;
import org.apache.juddi.v3.client.subscription.RegistrationAbortedException;
import org.apache.juddi.v3.client.subscription.ServiceAlreadyStartedException;
import org.apache.juddi.v3.client.subscription.UnableToSignException;
import org.apache.juddi.v3.client.subscription.UnexpectedResponseException;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.TransportException;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.Result;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.subr_v3.NotifySubscriptionListener;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;

@WebService(serviceName="UDDISubscriptionListenerClientService", endpointInterface="org.uddi.v3_service.UDDISubscriptionListenerPortType", targetNamespace="urn:uddi-org:v3_service")
public class SubscriptionCallbackListener
implements UDDISubscriptionListenerPortType,
Runnable {
    private static final Log log = LogFactory.getLog(SubscriptionCallbackListener.class);
    private static List<ISubscriptionCallback> callbacks = new ArrayList<ISubscriptionCallback>();
    private static SubscriptionCallbackListener instance = null;
    private static Endpoint ep = null;
    private static String callback = null;
    public static final String PROPERTY_LISTENURL = "client.subscriptionCallbacks.listenUrl";
    public static final String PROPERTY_NODE = "client.subscriptionCallbacks.node";
    public static final String PROPERTY_KEYDOMAIN = "client.subscriptionCallbacks.keyDomain";
    public static final String PROPERTY_AUTOREG_BT = "client.subscriptionCallbacks.autoRegisterBindingTemplate";
    public static final String PROPERTY_AUTOREG_SERVICE_KEY = "client.subscriptionCallbacks.autoRegisterBusinessServiceKey";
    public static final String PROPERTY_SIGNATURE_BEHAVIOR = "client.subscriptionCallbacks.signatureBehavior";

    public SubscriptionCallbackListener() {
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(this));
    }

    protected static SubscriptionCallbackListener getInstance() {
        return instance;
    }

    public static synchronized BindingTemplate start(UDDIClient client, String cfg_node_name, String endpoint, String keydomain, boolean autoregister, String serviceKey, SignatureBehavior behavior) throws ServiceAlreadyStartedException, SecurityException, ConfigurationException, TransportException, DispositionReportFaultMessage, RemoteException, UnexpectedException, RegistrationAbortedException, UnableToSignException, MalformedURLException {
        if (instance == null) {
            instance = new SubscriptionCallbackListener();
        }
        if (ep != null && ep.isPublished()) {
            throw new ServiceAlreadyStartedException();
        }
        URL url = null;
        try {
            url = new URL(endpoint);
        }
        catch (Exception ex) {
            log.warn("Callback endpoint couldn't be parsed, generating a random one: " + ex.getMessage());
            url = new URL("http://" + SubscriptionCallbackListener.GetHostname() + ":" + SubscriptionCallbackListener.GetRandomPort(4000) + "/" + UUID.randomUUID().toString());
        }
        endpoint = url.toString();
        int attempts = 5;
        if (ep == null) {
            while (!(ep != null && ep.isPublished() || attempts <= 0)) {
                try {
                    ep = Endpoint.publish((String)endpoint, (Object)instance);
                    callback = endpoint;
                }
                catch (Exception be) {
                    log.info("trouble starting callback at " + endpoint + ", trying again with a random port: " + be.getMessage());
                    log.debug(be);
                    --attempts;
                    url = new URL("http://" + url.getHost() + ":" + SubscriptionCallbackListener.GetRandomPort(url.getPort()) + "/" + url.getPath());
                    endpoint = url.toString();
                }
            }
        }
        if (ep == null || !ep.isPublished()) {
            log.warn("Unable to start callback endpoint, aborting");
            throw new SecurityException("unable to start endpoint, view previous errors for reason");
        }
        log.info("Endpoint started at " + callback);
        BindingTemplate bt = new BindingTemplate();
        bt.setAccessPoint(new AccessPoint());
        bt.getAccessPoint().setValue(callback);
        bt.getAccessPoint().setUseType("endPoint");
        TModelInstanceInfo instanceInfo = new TModelInstanceInfo();
        instanceInfo.setTModelKey("uddi:uddi.org:transport:http");
        bt.setTModelInstanceDetails(new TModelInstanceDetails());
        bt.getTModelInstanceDetails().getTModelInstanceInfo().add(instanceInfo);
        bt.setServiceKey(serviceKey);
        if (keydomain.endsWith(":")) {
            bt.setBindingKey(keydomain + SubscriptionCallbackListener.GetHostname() + "_subscription_callback");
        } else {
            bt.setBindingKey(keydomain + ":" + SubscriptionCallbackListener.GetHostname() + "_subscription_callback");
        }
        if (autoregister) {
            bt = SubscriptionCallbackListener.registerBinding(client, cfg_node_name, bt, behavior);
        }
        return bt;
    }

    public static synchronized BindingTemplate start(UDDIClient client) throws ServiceAlreadyStartedException, SecurityException, ConfigurationException, TransportException, DispositionReportFaultMessage, UnexpectedException, RemoteException, RegistrationAbortedException, UnableToSignException, MalformedURLException {
        return SubscriptionCallbackListener.start(client, client.getClientConfig().getConfiguration().getString(PROPERTY_NODE, "default"));
    }

    public static synchronized BindingTemplate start(UDDIClient client, String cfg_node_name) throws ServiceAlreadyStartedException, SecurityException, ConfigurationException, TransportException, DispositionReportFaultMessage, UnexpectedException, RemoteException, RegistrationAbortedException, UnableToSignException, MalformedURLException {
        try {
            boolean reg = client.getClientConfig().getConfiguration().getBoolean(PROPERTY_AUTOREG_BT, false);
            String endpoint = client.getClientConfig().getConfiguration().getString(PROPERTY_LISTENURL);
            String kd = client.getClientConfig().getConfiguration().getString(PROPERTY_KEYDOMAIN);
            String key = client.getClientConfig().getConfiguration().getString(PROPERTY_AUTOREG_SERVICE_KEY);
            String sbs = client.getClientConfig().getConfiguration().getString(PROPERTY_SIGNATURE_BEHAVIOR);
            SignatureBehavior sb = SignatureBehavior.DoNothing;
            try {
                sb = SignatureBehavior.valueOf(sbs);
            }
            catch (Exception ex) {
                log.warn("Unable to parse config setting for SignatureBehavior, defaulting to DoNothing", ex);
            }
            return SubscriptionCallbackListener.start(client, cfg_node_name, endpoint, kd, reg, key, sb);
        }
        catch (ConfigurationException ex) {
            throw new ConfigurationException("failed to some critical settings from the juddi client config file. I won't be able to fire up the subscription callback endpoint ", ex);
        }
    }

    public static String getCallbackURL() {
        return callback;
    }

    public static synchronized void registerCallback(ISubscriptionCallback callback) {
        if (callback != null && !callbacks.contains(callback)) {
            callbacks.add(callback);
        }
    }

    public static synchronized void unRegisterCallback(ISubscriptionCallback callback) {
        if (callback != null && callbacks.contains(callback)) {
            callbacks.remove(callback);
        }
    }

    private static boolean CheckExistingBindingForSignature(String bindingKey, UDDIInquiryPortType uddiInquiryService, String token, SignatureBehavior behavior) {
        GetBindingDetail gbd = new GetBindingDetail();
        gbd.setAuthInfo(token);
        gbd.getBindingKey().add(bindingKey);
        try {
            BindingDetail bindingDetail = uddiInquiryService.getBindingDetail(gbd);
            if (bindingDetail != null && !bindingDetail.getBindingTemplate().isEmpty() && !bindingDetail.getBindingTemplate().get(0).getSignature().isEmpty()) {
                log.info("the binding template with key=" + bindingKey + " exists and is digitally signed");
            }
            return true;
        }
        catch (Exception ex) {
            log.debug("Error caught checking for the existence of and if a signature is present for binding key " + bindingKey + " this may be ignorable", ex);
            return false;
        }
    }

    private static boolean CheckServiceAndParentForSignature(String serviceKey, UDDIInquiryPortType uddiInquiryService, String token) throws UnexpectedResponseException {
        GetServiceDetail gsd = new GetServiceDetail();
        gsd.setAuthInfo(token);
        gsd.getServiceKey().add(serviceKey);
        String bizkey = null;
        try {
            ServiceDetail serviceDetail = uddiInquiryService.getServiceDetail(gsd);
            if (serviceDetail != null && !serviceDetail.getBusinessService().isEmpty()) {
                bizkey = serviceDetail.getBusinessService().get(0).getBusinessKey();
                if (!serviceDetail.getBusinessService().get(0).getSignature().isEmpty()) {
                    log.info("the service with key=" + serviceKey + " exists and is digitally signed");
                    return true;
                }
            }
        }
        catch (Exception ex) {
            log.info("Error caught checking for the existence of and if a signature is present for service key " + serviceKey, ex);
            throw new UnexpectedResponseException("Error caught checking for the existence of and if a signature is present for service key " + serviceKey, ex);
        }
        if (bizkey == null) {
            throw new UnexpectedResponseException("The service with key " + serviceKey + " parent's business key could not be determined. This is unexpected");
        }
        GetBusinessDetail gbd = new GetBusinessDetail();
        gbd.setAuthInfo(token);
        gbd.getBusinessKey().add(bizkey);
        try {
            BusinessDetail businessDetail = uddiInquiryService.getBusinessDetail(gbd);
            if (businessDetail != null && !businessDetail.getBusinessEntity().isEmpty() && !businessDetail.getBusinessEntity().get(0).getSignature().isEmpty()) {
                log.info("the business with key=" + bizkey + " exists and is digitally signed");
                return true;
            }
        }
        catch (Exception ex) {
            log.info("Error caught checking for the existence of and if a signature is present for business key " + bizkey, ex);
            throw new UnexpectedResponseException("Error caught checking for the existence of and if a signature is present for business key " + bizkey, ex);
        }
        return false;
    }

    private static int GetRandomPort(int oldport) {
        if (oldport <= 0) {
            oldport = 4000;
        }
        return oldport + new Random().nextInt(99);
    }

    @Override
    public void run() {
        this.shutdown();
    }

    private synchronized void shutdown() {
        if (ep != null && !ep.isPublished()) {
            log.fatal("Hey, someone should tell the developer to call SubscriptionCallbackListern.stop(...) before ending the program. Stopping endpoint at " + callback);
            SubscriptionCallbackListener.unregisterAllCallbacks();
            ep.stop();
            ep = null;
            callback = null;
        }
    }

    public static BindingTemplate registerBinding(UDDIClient client, String cfg_node_name, BindingTemplate bt, SignatureBehavior behavior) throws ServiceAlreadyStartedException, SecurityException, ConfigurationException, TransportException, DispositionReportFaultMessage, RemoteException, UnexpectedException, RegistrationAbortedException, UnableToSignException {
        UDDIClerk clerk = client.getClerk(cfg_node_name);
        Transport tp = client.getTransport(cfg_node_name);
        UDDIInquiryPortType uddiInquiryService = tp.getUDDIInquiryService();
        UDDIPublicationPortType uddiPublishService = tp.getUDDIPublishService();
        String token = clerk.getAuthToken(clerk.getUDDINode().getSecurityUrl());
        switch (behavior) {
            case AbortIfSigned: {
                if (SubscriptionCallbackListener.CheckExistingBindingForSignature(bt.getBindingKey(), uddiInquiryService, token, behavior)) {
                    throw new RegistrationAbortedException("Aborting, Either the item exists and is signed");
                }
                if (!SubscriptionCallbackListener.CheckServiceAndParentForSignature(bt.getServiceKey(), uddiInquiryService, token)) break;
                throw new RegistrationAbortedException("Aborting, Either the service or busness is signed");
            }
            case DoNothing: {
                break;
            }
            case SignAlways: {
                DigSigUtil ds;
                try {
                    ds = new DigSigUtil(client.getClientConfig().getDigitalSignatureConfiguration());
                    bt = ds.signUddiEntity(bt);
                    break;
                }
                catch (Exception ex) {
                    log.error("Unable to sign", ex);
                    throw new UnableToSignException(ex);
                }
            }
            case SignOnlyIfParentIsntSigned: {
                DigSigUtil ds;
                if (SubscriptionCallbackListener.CheckServiceAndParentForSignature(bt.getServiceKey(), uddiInquiryService, token)) break;
                try {
                    ds = new DigSigUtil(client.getClientConfig().getDigitalSignatureConfiguration());
                    bt = ds.signUddiEntity(bt);
                    break;
                }
                catch (Exception ex) {
                    log.error("Unable to sign", ex);
                    throw new UnableToSignException(ex);
                }
            }
        }
        SaveBinding sb = new SaveBinding();
        sb.setAuthInfo(token);
        sb.getBindingTemplate().add(bt);
        BindingDetail saveBinding = uddiPublishService.saveBinding(sb);
        if (saveBinding.getBindingTemplate().isEmpty() || saveBinding.getBindingTemplate().size() > 1) {
            throw new UnexpectedResponseException("The number of binding templates returned was unexpected, count=" + saveBinding.getBindingTemplate().size());
        }
        return saveBinding.getBindingTemplate().get(0);
    }

    protected static synchronized void unregisterAllCallbacks() {
        if (callbacks != null) {
            log.info("Notifying all subscribing classes, count=" + callbacks.size());
            for (int i = 0; i < callbacks.size(); ++i) {
                if (callbacks.get(i) == null) continue;
                try {
                    callbacks.get(i).NotifyEndpointStopped();
                    continue;
                }
                catch (Exception ex) {
                    log.warn("Your implementation on ISubscriptionCallback is faulty and threw an error, contact the developer", ex);
                }
            }
            callbacks.clear();
        }
    }

    public static synchronized void stop(UDDIClient client, String cfg_node_name, String bindingKey) throws ConfigurationException {
        if (ep != null && ep.isPublished()) {
            log.warn("Stopping jUDDI Subscription callback endpoint at " + callback);
            ep.stop();
            if (ep.isPublished()) {
                log.fatal("Unable to stop the endpoint. the port may be locked until this java process terminates");
            }
            ep = null;
            callback = null;
        }
        SubscriptionCallbackListener.unregisterAllCallbacks();
        if (client.getClientConfig().getConfiguration().getBoolean(PROPERTY_AUTOREG_BT, false) && bindingKey != null) {
            try {
                UDDIClerk clerk = client.getClerk(cfg_node_name);
                Transport tp = client.getTransport(cfg_node_name);
                String token = clerk.getAuthToken(clerk.getUDDINode().getSecurityUrl());
                UDDIPublicationPortType uddiPublishService = tp.getUDDIPublishService();
                DeleteBinding db = new DeleteBinding();
                db.setAuthInfo(token);
                db.getBindingKey().add(bindingKey);
                uddiPublishService.deleteBinding(db);
                log.info("Subscription callback binding unregistered.");
            }
            catch (Exception ex) {
                log.error("Unable to unregister binding " + bindingKey, ex);
            }
        }
    }

    private static String GetHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return "HOST_UNKNOWN";
        }
    }

    @Override
    public DispositionReport notifySubscriptionListener(NotifySubscriptionListener body) throws DispositionReportFaultMessage, RemoteException {
        for (int i = 0; i < callbacks.size(); ++i) {
            try {
                callbacks.get(i).HandleCallback(body.getSubscriptionResultsList());
                continue;
            }
            catch (Exception ex) {
                log.warn("Your implementation on ISubscriptionCallback is faulty and threw an error, contact the developer", ex);
            }
        }
        DispositionReport r = new DispositionReport();
        r.getResult().add(new Result());
        return r;
    }

    public static enum SignatureBehavior {
        AbortIfSigned,
        SignAlways,
        SignOnlyIfParentIsntSigned,
        DoNothing;

    }
}

