/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import javax.wsdl.xml.WSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.juddi.v3.client.mapping.MockSSLSocketFactory;
import org.xml.sax.InputSource;

public class WSDLLocatorImpl
implements WSDLLocator {
    private Exception lastException = null;
    private final Log log = LogFactory.getLog(this.getClass());
    private InputStream inputStream = null;
    private URI baseURI;
    private boolean ignoreSSLErrors = false;
    private String latestImportURI;
    private String username = null;
    private String password = null;

    public WSDLLocatorImpl(URI baseURI) {
        this.baseURI = baseURI;
        this.ignoreSSLErrors = false;
    }

    public WSDLLocatorImpl(URI baseURI, String username, String password, boolean ignoreSSLErrors) {
        this.baseURI = baseURI;
        this.username = username;
        this.password = password;
        this.ignoreSSLErrors = ignoreSSLErrors;
    }

    @Override
    public InputSource getBaseInputSource() {
        return this.getImportFromUrl(this.baseURI.toString());
    }

    protected URL constructImportUrl(String parentLocation, String importLocation) {
        URL importUrl = null;
        try {
            URI importLocationURI = new URI(importLocation);
            if (importLocationURI.getScheme() != null || parentLocation == null) {
                importUrl = importLocationURI.toURL();
            } else {
                String parentDir = parentLocation.substring(0, parentLocation.lastIndexOf("/"));
                URI uri = new URI(parentDir + "/" + importLocation);
                importUrl = uri.normalize().toURL();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
        }
        if (importUrl != null) {
            this.log.debug("importUrl: " + importUrl.toExternalForm());
        } else {
            this.log.error("importUrl is null!");
        }
        return importUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputSource getImportFromUrl(String url) {
        InputSource inputSource = null;
        AbstractHttpClient httpclient = null;
        try {
            URL url2 = new URL(url);
            if (!url.toLowerCase().startsWith("http")) {
                InputSource inputSource2 = this.getImportFromFile(url);
                return inputSource2;
            }
            boolean usessl = false;
            int port = 80;
            if (url.toLowerCase().startsWith("https://")) {
                port = 443;
                usessl = true;
            }
            if (url2.getPort() > 0) {
                port = url2.getPort();
            }
            if (this.ignoreSSLErrors && usessl) {
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(new Scheme("https", port, new MockSSLSocketFactory()));
                BasicClientConnectionManager cm = new BasicClientConnectionManager(schemeRegistry);
                httpclient = new DefaultHttpClient(cm);
            } else {
                httpclient = new DefaultHttpClient();
            }
            if (this.username != null && this.username.length() > 0 && this.password != null && this.password.length() > 0) {
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(url2.getHost(), port), new UsernamePasswordCredentials(this.username, this.password));
            }
            HttpGet httpGet = new HttpGet(url);
            try {
                HttpResponse response1 = httpclient.execute(httpGet);
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                String handleResponse = (String)responseHandler.handleResponse(response1);
                StringReader sr = new StringReader(handleResponse);
                inputSource = new InputSource(sr);
            }
            finally {
                httpGet.releaseConnection();
            }
            this.latestImportURI = url;
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.log.debug(e.getMessage(), e);
            this.lastException = e;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        return inputSource;
    }

    @Override
    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        InputSource inputSource = null;
        try {
            URL importUrl = this.constructImportUrl(parentLocation, importLocation);
            return this.getImportFromUrl(importUrl.toExternalForm());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
            this.lastException = e;
            return inputSource;
        }
    }

    @Override
    public String getBaseURI() {
        String baseURIStr = null;
        try {
            baseURIStr = this.baseURI.toURL().toExternalForm();
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
            this.log.debug(e.getMessage(), e);
            this.lastException = e;
        }
        return baseURIStr;
    }

    @Override
    public String getLatestImportURI() {
        return this.latestImportURI;
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), e);
                this.lastException = e;
            }
        }
    }

    private InputSource getImportFromFile(String url) {
        InputSource inputSource = null;
        try {
            URL importUrl = new URL(url);
            this.inputStream = importUrl.openStream();
            inputSource = new InputSource(this.inputStream);
            this.latestImportURI = importUrl.toExternalForm();
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            this.log.debug(e.getMessage(), e);
            this.lastException = e;
        }
        return inputSource;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

