/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping.wsdl;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.jaxb.PrintUDDI;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.config.UDDIKeyConvention;
import org.apache.juddi.v3.client.mapping.Common2UDDI;
import org.apache.juddi.v3.client.mapping.ServiceRegistrationResponse;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.transport.TransportException;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.w3c.dom.Element;

public class WSDL2UDDI {
    private static final Log log = LogFactory.getLog(WSDL2UDDI.class);
    private String keyDomainURI;
    private String businessKey;
    private String lang;
    private UDDIClerk clerk = null;
    private Properties properties = null;
    private URLLocalizer urlLocalizer;

    public WSDL2UDDI(UDDIClerk clerk, URLLocalizer urlLocalizer, Properties properties) throws ConfigurationException {
        if (properties == null) {
            throw new IllegalArgumentException("properties");
        }
        this.clerk = clerk;
        this.urlLocalizer = urlLocalizer;
        this.properties = properties;
        if (clerk != null) {
            if (!properties.containsKey("keyDomain")) {
                throw new ConfigurationException("Property keyDomain is a required property when using WSDL2UDDI.");
            }
            if (!properties.containsKey("businessKey") && !properties.containsKey("businessName")) {
                throw new ConfigurationException("Either property businessKey, or businessName, is a required property when using WSDL2UDDI.");
            }
            if (!properties.containsKey("nodeName")) {
                if (properties.containsKey("serverName") && properties.containsKey("serverPort")) {
                    String nodeName = properties.getProperty("serverName") + "_" + properties.getProperty("serverPort");
                    properties.setProperty("nodeName", nodeName);
                } else {
                    throw new ConfigurationException("Property nodeName is not defined and is a required property when using WSDL2UDDI.");
                }
            }
        }
        this.keyDomainURI = "uddi:" + properties.getProperty("keyDomain") + ":";
        this.businessKey = properties.contains("businessKey") ? properties.getProperty("businessKey") : UDDIKeyConvention.getBusinessKey(properties);
        this.lang = properties.getProperty("lang", "en");
    }

    public BusinessServices registerBusinessServices(Definition wsdlDefinition) throws RemoteException, ConfigurationException, TransportException, WSDLException, MalformedURLException {
        BusinessServices businessServices = new BusinessServices();
        for (Object serviceName : wsdlDefinition.getAllServices().keySet()) {
            QName serviceQName = (QName)serviceName;
            Service service = wsdlDefinition.getService(serviceQName);
            BusinessService businessService = null;
            URL serviceUrl = null;
            if (service.getPorts() != null && service.getPorts().size() > 0) {
                for (Object portName : service.getPorts().keySet()) {
                    businessService = this.registerBusinessService(serviceQName, (String)portName, serviceUrl, wsdlDefinition).getBusinessService();
                }
            }
            if (businessService == null) continue;
            businessServices.getBusinessService().add(businessService);
        }
        return businessServices;
    }

    public ServiceRegistrationResponse registerBusinessService(QName serviceQName, String portName, URL serviceUrl, Definition wsdlDefinition) throws RemoteException, ConfigurationException, TransportException, WSDLException, MalformedURLException {
        BindingTemplate binding;
        String genericWSDLURL = wsdlDefinition.getDocumentBaseURI();
        ServiceRegistrationResponse response = new ServiceRegistrationResponse();
        String serviceKey = UDDIKeyConvention.getServiceKey(this.properties, serviceQName.getLocalPart());
        BusinessService businessService = this.lookupService(serviceKey);
        if (businessService == null) {
            ArrayList<TModel> tModels = new ArrayList<TModel>();
            Map portTypes = wsdlDefinition.getAllPortTypes();
            tModels.addAll(this.createWSDLPortTypeTModels(genericWSDLURL, portTypes));
            Map bindings = wsdlDefinition.getAllBindings();
            tModels.addAll(this.createWSDLBindingTModels(genericWSDLURL, bindings));
            for (TModel tModel : tModels) {
                this.clerk.register(tModel);
            }
            businessService = this.createBusinessService(serviceQName, wsdlDefinition);
            this.clerk.register(businessService);
        }
        if ((binding = this.createWSDLBinding(serviceQName, portName, serviceUrl, wsdlDefinition)).getAccessPoint() != null) {
            this.clerk.register(binding);
            if (businessService.getBindingTemplates() == null) {
                businessService.setBindingTemplates(new BindingTemplates());
            }
            businessService.getBindingTemplates().getBindingTemplate().add(binding);
            response.setBindingKey(binding.getBindingKey());
        }
        response.setBusinessService(businessService);
        return response;
    }

    public String[] unRegisterBusinessServices(Definition wsdlDefinition) throws RemoteException, ConfigurationException, TransportException, MalformedURLException {
        String[] businessServices = new String[wsdlDefinition.getAllServices().size()];
        int i = 0;
        for (Object serviceName : wsdlDefinition.getAllServices().keySet()) {
            QName serviceQName = (QName)serviceName;
            Service service = wsdlDefinition.getService(serviceQName);
            URL serviceUrl = null;
            if (service.getPorts() == null || service.getPorts().size() <= 0) continue;
            for (Object portName : service.getPorts().keySet()) {
                serviceUrl = new URL(this.getBindingURL((Port)service.getPorts().get(portName)));
                businessServices[i++] = this.unRegisterBusinessService(serviceQName, (String)portName, serviceUrl);
            }
        }
        return businessServices;
    }

    public String unRegisterBusinessService(QName serviceName, String portName, URL serviceUrl) throws RemoteException, ConfigurationException, TransportException {
        String serviceKey = UDDIKeyConvention.getServiceKey(this.properties, serviceName.getLocalPart());
        BusinessService service = this.lookupService(serviceKey);
        boolean isRemoveServiceIfNoTemplates = true;
        String bindingKey = UDDIKeyConvention.getBindingKey(this.properties, serviceName, portName, serviceUrl);
        for (BindingTemplate bindingTemplate : service.getBindingTemplates().getBindingTemplate()) {
            if (!bindingKey.equals(bindingTemplate.getBindingKey())) continue;
            this.clerk.unRegisterBinding(bindingKey);
            if (service.getBindingTemplates().getBindingTemplate().size() != 1 || !isRemoveServiceIfNoTemplates) continue;
            this.clerk.unRegisterService(serviceKey);
            if (bindingTemplate.getTModelInstanceDetails() == null || bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfo() == null) continue;
            for (TModelInstanceInfo tModelInstanceInfo : bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfo()) {
                String tModelKey = tModelInstanceInfo.getTModelKey();
                TModelDetail tModelDetail = this.clerk.getTModelDetail(tModelKey);
                if (tModelDetail.getTModel() == null || tModelDetail.getTModel().size() <= 0) continue;
                for (TModel tModel : tModelDetail.getTModel()) {
                    if (!tModel.getTModelKey().startsWith("uddi:uddi.org:")) {
                        this.clerk.unRegisterTModel(tModel.getTModelKey());
                        continue;
                    }
                    log.info("Skipping the removal of " + tModel.getTModelKey() + " because it starts with uddi.org");
                }
            }
        }
        return serviceKey;
    }

    public String getKeyDomainURI() {
        return this.keyDomainURI;
    }

    public void setKeyDomain(String keyDomainURI) {
        this.keyDomainURI = keyDomainURI;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Set<TModel> createWSDLBindingTModels(String wsdlURL, Map<QName, Binding> bindings) throws WSDLException {
        HashSet<TModel> tModels = new HashSet<TModel>();
        for (QName qName : bindings.keySet()) {
            String localpart = qName.getLocalPart();
            String namespace = qName.getNamespaceURI();
            TModel tModel = new TModel();
            tModel.setTModelKey(this.keyDomainURI + localpart);
            Name name = new Name();
            name.setLang(this.lang);
            name.setValue(localpart);
            tModel.setName(name);
            OverviewURL overviewURL = new OverviewURL();
            overviewURL.setUseType(AccessPointType.WSDL_DEPLOYMENT.toString());
            overviewURL.setValue(wsdlURL);
            OverviewDoc overviewDoc = new OverviewDoc();
            overviewDoc.setOverviewURL(overviewURL);
            tModel.getOverviewDoc().add(overviewDoc);
            CategoryBag categoryBag = new CategoryBag();
            if (namespace != null && !"".equals(namespace)) {
                KeyedReference namespaceReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:xml:namespace", "uddi-org:xml:namespace", namespace);
                categoryBag.getKeyedReference().add(namespaceReference);
            }
            KeyedReference typesReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:types", "uddi-org:wsdl:types", "binding");
            categoryBag.getKeyedReference().add(typesReference);
            Binding binding = bindings.get(qName);
            String portTypeKey = this.keyDomainURI + binding.getPortType().getQName().getLocalPart();
            KeyedReference namespaceReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:porttypereference", "uddi-org:wsdl:portTypeReference", portTypeKey);
            categoryBag.getKeyedReference().add(namespaceReference);
            KeyedReference typesReferenceBackwardsCompatible = WSDL2UDDI.newKeyedReference("uddi:uddi.org:categorization:types", "uddi-org:types", "wsdlSpec");
            categoryBag.getKeyedReference().add(typesReferenceBackwardsCompatible);
            for (Object object : binding.getExtensibilityElements()) {
                KeyedReference soapProtocol;
                SOAPBinding sb = null;
                SOAP12Binding sb12 = null;
                HTTPBinding hb = null;
                try {
                    hb = (HTTPBinding)object;
                }
                catch (Exception x) {
                    // empty catch block
                }
                try {
                    sb = (SOAPBinding)object;
                }
                catch (Exception x) {
                    // empty catch block
                }
                try {
                    sb12 = (SOAP12Binding)object;
                }
                catch (Exception x) {
                    // empty catch block
                }
                if (sb != null) {
                    SOAPBinding soapBinding = sb;
                    KeyedReference soapProtocol2 = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:categorization:protocol", "uddi-org:protocol:soap", "uddi:uddi.org:protocol:soap");
                    categoryBag.getKeyedReference().add(soapProtocol2);
                    if ("http://schemas.xmlsoap.org/soap/http".equals(soapBinding.getTransportURI())) {
                        KeyedReference httpTransport = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:categorization:transport", "uddi-org:http", "uddi:uddi.org:transport:http");
                        categoryBag.getKeyedReference().add(httpTransport);
                        continue;
                    }
                    if (soapBinding.getTransportURI() == null) continue;
                    log.warn("not implemented, binding transport is " + soapBinding.getTransportURI());
                    continue;
                }
                if (hb != null) {
                    soapProtocol = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:categorization:protocol", "uddi-org:protocol:http", "uddi:uddi.org:protocol:http");
                    categoryBag.getKeyedReference().add(soapProtocol);
                    continue;
                }
                if (sb12 != null) {
                    soapProtocol = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:categorization:protocol", "uddi-org:protocol:soap", "uddi:uddi.org:protocol:soap");
                    categoryBag.getKeyedReference().add(soapProtocol);
                    if ("http://schemas.xmlsoap.org/soap/http".equals(sb12.getTransportURI())) {
                        KeyedReference httpTransport = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:categorization:transport", "uddi-org:http", "uddi:uddi.org:transport:http");
                        categoryBag.getKeyedReference().add(httpTransport);
                        continue;
                    }
                    if (sb12.getTransportURI() == null) continue;
                    log.warn("not implemented, binding transport is " + sb12.getTransportURI());
                    continue;
                }
                log.warn("Unrecongnized binding type: " + object.getClass().getCanonicalName() + ". Generated" + "binding tModel may be missing the required (according to WSDL2UDDI spec) " + "uddi:uddi.org:wsdl:categorization:protocol keyedReference.");
            }
            tModel.setCategoryBag(categoryBag);
            tModels.add(tModel);
        }
        return tModels;
    }

    public Set<TModel> createWSDLPortTypeTModels(String wsdlURL, Map<QName, PortType> portTypes) throws WSDLException {
        HashSet<TModel> tModels = new HashSet<TModel>();
        for (QName qName : portTypes.keySet()) {
            TModel tModel = new TModel();
            String localpart = qName.getLocalPart();
            String namespace = qName.getNamespaceURI();
            tModel.setTModelKey(this.keyDomainURI + localpart);
            Name name = new Name();
            name.setLang(this.lang);
            name.setValue(localpart);
            tModel.setName(name);
            OverviewURL overviewURL = new OverviewURL();
            overviewURL.setUseType(AccessPointType.WSDL_DEPLOYMENT.toString());
            overviewURL.setValue(wsdlURL);
            OverviewDoc overviewDoc = new OverviewDoc();
            overviewDoc.setOverviewURL(overviewURL);
            tModel.getOverviewDoc().add(overviewDoc);
            CategoryBag categoryBag = new CategoryBag();
            KeyedReference typesReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:types", "uddi-org:wsdl:types", "portType");
            categoryBag.getKeyedReference().add(typesReference);
            if (namespace != null && !"".equals(namespace)) {
                KeyedReference namespaceReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:xml:namespace", "uddi-org:xml:namespace", namespace);
                categoryBag.getKeyedReference().add(namespaceReference);
            }
            tModel.setCategoryBag(categoryBag);
            tModels.add(tModel);
        }
        return tModels;
    }

    protected static KeyedReference newKeyedReference(String tModelKey, String keyName, String value) {
        KeyedReference typesReference = new KeyedReference();
        typesReference.setTModelKey(tModelKey);
        typesReference.setKeyName(keyName);
        typesReference.setKeyValue(value);
        return typesReference;
    }

    public static FindTModel createFindBindingTModelForPortType(String portType, String namespace) {
        FindTModel findTModel = new FindTModel();
        CategoryBag categoryBag = new CategoryBag();
        if (namespace != null && namespace.length() != 0) {
            KeyedReference namespaceReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:xml:namespace", "uddi-org:xml:namespace", namespace);
            categoryBag.getKeyedReference().add(namespaceReference);
        }
        KeyedReference bindingReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:types", "uddi-org:wsdl:types", "binding");
        categoryBag.getKeyedReference().add(bindingReference);
        KeyedReference portTypeReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:porttypereference", "uddi-org:wsdl:portTypeReference", portType);
        categoryBag.getKeyedReference().add(portTypeReference);
        findTModel.setCategoryBag(categoryBag);
        if (log.isDebugEnabled()) {
            log.debug(new PrintUDDI<FindTModel>().print(findTModel));
        }
        return findTModel;
    }

    public static FindTModel createFindPortTypeTModelForPortType(String portTypeName, String namespace) {
        FindTModel findTModel = new FindTModel();
        Name name = new Name();
        name.setLang("en");
        name.setValue(portTypeName);
        findTModel.setName(name);
        CategoryBag categoryBag = new CategoryBag();
        if (namespace != null && namespace.length() != 0) {
            KeyedReference namespaceReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:xml:namespace", "uddi-org:xml:namespace", namespace);
            categoryBag.getKeyedReference().add(namespaceReference);
        }
        KeyedReference bindingReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:types", "uddi-org:wsdl:types", "portType");
        categoryBag.getKeyedReference().add(bindingReference);
        findTModel.setCategoryBag(categoryBag);
        if (log.isDebugEnabled()) {
            log.debug(new PrintUDDI<FindTModel>().print(findTModel));
        }
        return findTModel;
    }

    private BusinessService lookupService(String serviceKey) throws RemoteException, ConfigurationException, TransportException {
        BusinessService service = this.clerk.getServiceDetail(serviceKey);
        return service;
    }

    public BusinessServices createBusinessServices(Definition wsdlDefinition) throws MalformedURLException {
        if (wsdlDefinition == null) {
            throw new IllegalArgumentException();
        }
        BusinessServices businessServices = new BusinessServices();
        for (Object serviceName : wsdlDefinition.getAllServices().keySet()) {
            QName serviceQName = (QName)serviceName;
            Service service = wsdlDefinition.getService(serviceQName);
            BusinessService businessService = this.createBusinessService(serviceQName, wsdlDefinition);
            URL serviceUrl = null;
            if (service.getPorts() != null && service.getPorts().size() > 0) {
                businessService.setBindingTemplates(new BindingTemplates());
                for (Object portName : service.getPorts().keySet()) {
                    BindingTemplate bindingTemplate = this.createWSDLBinding(serviceQName, (String)portName, serviceUrl, wsdlDefinition);
                    businessService.getBindingTemplates().getBindingTemplate().add(bindingTemplate);
                }
            }
            businessServices.getBusinessService().add(businessService);
        }
        return businessServices;
    }

    protected BusinessService createBusinessService(QName serviceQName, Definition wsdlDefinition) {
        Element docElement;
        log.debug("Constructing Service UDDI Information for " + serviceQName);
        BusinessService service = new BusinessService();
        service.setBusinessKey(this.businessKey);
        service.setServiceKey(UDDIKeyConvention.getServiceKey(this.properties, serviceQName.getLocalPart()));
        String serviceDescription = this.properties.getProperty("serviceDescription", "Default service description when no <wsdl:document> element is defined inside the <wsdl:service> element.");
        if (wsdlDefinition.getService(serviceQName) != null && (docElement = wsdlDefinition.getService(serviceQName).getDocumentationElement()) != null && docElement.getTextContent() != null) {
            serviceDescription = docElement.getTextContent();
        }
        service.getDescription().addAll(Common2UDDI.mapDescription(serviceDescription, this.lang));
        Name sName = new Name();
        sName.setLang(this.lang);
        sName.setValue(serviceQName.getLocalPart());
        service.getName().add(sName);
        CategoryBag categoryBag = new CategoryBag();
        String namespace = serviceQName.getNamespaceURI();
        if (namespace != null && namespace.length() != 0) {
            KeyedReference namespaceReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:xml:namespace", "uddi-org:xml:namespace", namespace);
            categoryBag.getKeyedReference().add(namespaceReference);
        }
        KeyedReference serviceReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:wsdl:types", "uddi-org:wsdl:types", "service");
        categoryBag.getKeyedReference().add(serviceReference);
        KeyedReference localNameReference = WSDL2UDDI.newKeyedReference("uddi:uddi.org:xml:localname", "uddi-org:xml:localName", serviceQName.getLocalPart());
        categoryBag.getKeyedReference().add(localNameReference);
        service.setCategoryBag(categoryBag);
        return service;
    }

    protected BindingTemplate createWSDLBinding(QName serviceQName, String portName, URL serviceUrl, Definition wsdlDefinition) throws MalformedURLException {
        Service service;
        BindingTemplate bindingTemplate = new BindingTemplate();
        bindingTemplate.setServiceKey(UDDIKeyConvention.getServiceKey(this.properties, serviceQName.getLocalPart()));
        if (serviceUrl != null) {
            AccessPoint accessPoint = new AccessPoint();
            accessPoint.setUseType(AccessPointType.END_POINT.toString());
            accessPoint.setValue(this.urlLocalizer.rewrite(serviceUrl));
            bindingTemplate.setAccessPoint(accessPoint);
            String bindingKey = UDDIKeyConvention.getBindingKey(this.properties, serviceQName, portName, serviceUrl);
            bindingTemplate.setBindingKey(bindingKey);
        }
        if ((service = wsdlDefinition.getService(serviceQName)) != null) {
            TModelInstanceDetails tModelInstanceDetails = new TModelInstanceDetails();
            Port port = service.getPort(portName);
            if (port != null) {
                if (serviceUrl == null) {
                    for (Object element : port.getExtensibilityElements()) {
                        ExtensibilityElement address;
                        String location = null;
                        if (element instanceof SOAPAddress) {
                            address = (SOAPAddress)element;
                            location = this.urlLocalizer.rewrite(new URL(address.getLocationURI()));
                        } else if (element instanceof HTTPAddress) {
                            address = (HTTPAddress)element;
                            location = address.getLocationURI();
                            this.urlLocalizer.rewrite(new URL(location));
                        } else if (element instanceof SOAP12Address) {
                            address = (SOAP12Address)element;
                            location = this.urlLocalizer.rewrite(new URL(address.getLocationURI()));
                        }
                        if (location == null) continue;
                        try {
                            URL locationURI = new URL(location);
                            AccessPoint accessPoint = new AccessPoint();
                            accessPoint.setUseType(AccessPointType.END_POINT.toString());
                            accessPoint.setValue(this.urlLocalizer.rewrite(locationURI));
                            bindingTemplate.setAccessPoint(accessPoint);
                            String bindingKey = UDDIKeyConvention.getBindingKey(this.properties, serviceQName, portName, locationURI);
                            bindingTemplate.setBindingKey(bindingKey);
                            break;
                        }
                        catch (MalformedURLException e) {
                            log.error(e.getMessage());
                        }
                    }
                }
                Binding binding = port.getBinding();
                String bindingDescription = this.properties.getProperty("bindingDescription", "Default binding description when no <wsdl:document> element is defined inside the <wsdl:binding> element.");
                Element docElement = binding.getDocumentationElement();
                if (docElement != null && docElement.getTextContent() != null) {
                    bindingDescription = docElement.getTextContent();
                }
                bindingTemplate.getDescription().addAll(Common2UDDI.mapDescription(bindingDescription, this.lang));
                TModelInstanceInfo tModelInstanceInfoBinding = new TModelInstanceInfo();
                tModelInstanceInfoBinding.setTModelKey(this.keyDomainURI + binding.getQName().getLocalPart());
                InstanceDetails instanceDetails = new InstanceDetails();
                instanceDetails.setInstanceParms(portName);
                tModelInstanceInfoBinding.setInstanceDetails(instanceDetails);
                tModelInstanceInfoBinding.getDescription().addAll(Common2UDDI.mapDescription("The wsdl:binding that this wsdl:port implements. " + bindingDescription + " The instanceParms specifies the port local name.", this.lang));
                tModelInstanceDetails.getTModelInstanceInfo().add(tModelInstanceInfoBinding);
                PortType portType = binding.getPortType();
                TModelInstanceInfo tModelInstanceInfoPortType = new TModelInstanceInfo();
                tModelInstanceInfoPortType.setTModelKey(this.keyDomainURI + portType.getQName().getLocalPart());
                String portTypeDescription = "";
                docElement = portType.getDocumentationElement();
                if (docElement != null && docElement.getTextContent() != null) {
                    portTypeDescription = docElement.getTextContent();
                }
                tModelInstanceInfoPortType.getDescription().addAll(Common2UDDI.mapDescription("The wsdl:portType that this wsdl:port implements." + portTypeDescription, this.lang));
                tModelInstanceDetails.getTModelInstanceInfo().add(tModelInstanceInfoPortType);
                bindingTemplate.setTModelInstanceDetails(tModelInstanceDetails);
            } else {
                log.error("Could not find Port with portName: " + portName);
            }
        } else {
            log.error("Could not find Service with serviceName: " + serviceQName.getLocalPart());
        }
        return UDDIClient.addSOAPtModels(bindingTemplate);
    }

    private String getBindingURL(Port port) throws MalformedURLException {
        String bindingUrl = null;
        for (Object element : port.getExtensibilityElements()) {
            SOAPAddress address;
            URL locationURI;
            if (!(element instanceof SOAPAddress) || (locationURI = new URL((address = (SOAPAddress)element).getLocationURI())) == null) continue;
            bindingUrl = this.urlLocalizer.rewrite(locationURI);
            break;
        }
        return bindingUrl;
    }
}

