/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping.wsdl;

import com.ibm.wsdl.factory.WSDLFactoryImpl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.mapping.wsdl.WSDLLocatorImpl;

public class ReadWSDL {
    private boolean IgnoreSSLErrors = false;
    private final Log log = LogFactory.getLog(this.getClass());

    public Definition readWSDL(String fileName) throws WSDLException {
        Definition wsdlDefinition = null;
        WSDLFactory factory = WSDLFactoryImpl.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        try {
            File f = new File(fileName);
            URL url = null;
            if (f.exists()) {
                this.log.info(fileName + " as a local file doesn't exist.");
                url = f.toURI().toURL();
            } else {
                url = ClassUtil.getResource(fileName, this.getClass());
            }
            if (url == null) {
                this.log.info(fileName + " as a class path resource doesn't exist.");
                throw new WSDLException("null input", fileName);
            }
            URI uri = url.toURI();
            WSDLLocatorImpl locator = new WSDLLocatorImpl(uri);
            wsdlDefinition = reader.readWSDL(locator);
        }
        catch (URISyntaxException e) {
            this.log.error(e.getMessage(), e);
        }
        catch (MalformedURLException ex) {
            this.log.error(ex.getMessage(), ex);
        }
        return wsdlDefinition;
    }

    public Definition readWSDL(URL wsdlUrl, String username, String password) throws WSDLException, Exception {
        Definition wsdlDefinition = null;
        WSDLFactory factory = WSDLFactoryImpl.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        URI uri = null;
        try {
            uri = wsdlUrl.toURI();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
            throw new WSDLException("Unable to parse the URL", null, e);
        }
        WSDLLocatorImpl locator = new WSDLLocatorImpl(uri, username, password, this.IgnoreSSLErrors);
        try {
            wsdlDefinition = reader.readWSDL(locator);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
            if (locator.getLastException() != null) {
                this.log.error(e.getMessage(), locator.getLastException());
                throw locator.getLastException();
            }
            throw e;
        }
        return wsdlDefinition;
    }

    public Definition readWSDL(URL wsdlUrl) throws Exception {
        return this.readWSDL(wsdlUrl, null, null);
    }

    public boolean isIgnoreSSLErrors() {
        return this.IgnoreSSLErrors;
    }

    public void setIgnoreSSLErrors(boolean IgnoreSSLErrors) {
        this.IgnoreSSLErrors = IgnoreSSLErrors;
    }
}

