/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping.wadl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXB;
import javax.xml.namespace.QName;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIKeyConvention;
import org.apache.juddi.v3.client.mapping.Common2UDDI;
import org.apache.juddi.v3.client.mapping.MockSSLSocketFactory;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.mapping.wadl.Application;
import org.apache.juddi.v3.client.mapping.wadl.Doc;
import org.apache.juddi.v3.client.mapping.wadl.Resources;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;

public class WADL2UDDI {
    private static Log log = LogFactory.getLog(WADL2UDDI.class);
    private String keyDomainURI;
    private String businessKey;
    private String lang;
    private UDDIClerk clerk = null;
    private Properties properties = null;
    private URLLocalizer urlLocalizer;
    public static final String PACKAGE = "org.apache.juddi.v3.client.mapping.wadl";

    public WADL2UDDI(UDDIClerk clerk, URLLocalizer urlLocalizer, Properties properties) throws ConfigurationException {
        this.clerk = clerk;
        this.urlLocalizer = urlLocalizer;
        this.properties = properties;
        if (clerk != null) {
            if (!properties.containsKey("keyDomain")) {
                throw new ConfigurationException("Property keyDomain is a required property when using WADL2UDDI.");
            }
            if (!properties.containsKey("businessKey") && !properties.containsKey("businessName")) {
                throw new ConfigurationException("Either property businessKey, or businessName, is a required property when using WADL2UDDI.");
            }
            if (!properties.containsKey("nodeName")) {
                if (properties.containsKey("serverName") && properties.containsKey("serverPort")) {
                    String nodeName = properties.getProperty("serverName") + "_" + properties.getProperty("serverPort");
                    properties.setProperty("nodeName", nodeName);
                } else {
                    throw new ConfigurationException("Property nodeName is not defined and is a required property when using WADL2UDDI.");
                }
            }
        }
        this.keyDomainURI = "uddi:" + properties.getProperty("keyDomain") + ":";
        this.businessKey = properties.contains("businessKey") ? properties.getProperty("businessKey") : UDDIKeyConvention.getBusinessKey(properties);
        this.lang = properties.getProperty("lang", "en");
    }

    public Set<TModel> createWADLTModels(String wadlURL, Application app) throws Exception {
        HashSet<TModel> tModels = new HashSet<TModel>();
        TModel binding = new TModel();
        binding.setTModelKey(this.keyDomainURI + "binding");
        Name sName = new Name();
        sName.setLang(this.lang);
        if (!app.getDoc().isEmpty()) {
            sName.setValue(app.getDoc().get(0).getTitle());
        }
        if (sName.getValue() == null) {
            sName.setValue(this.keyDomainURI + " Binding tModel");
        }
        binding.setName(sName);
        tModels.add(binding);
        binding = new TModel();
        binding.setTModelKey(this.keyDomainURI + "rest");
        sName = new Name();
        sName.setLang(this.lang);
        if (!app.getDoc().isEmpty()) {
            sName.setValue(app.getDoc().get(0).getTitle());
        }
        if (sName.getValue() == null) {
            sName.setValue(this.keyDomainURI + " Rest tModel");
        }
        binding.setName(sName);
        tModels.add(binding);
        return tModels;
    }

    public Set<TModel> createWADLPortTypeTModels(String wadlURL, Application app) throws Exception {
        HashSet<TModel> tModels = new HashSet<TModel>();
        return tModels;
    }

    public String getKeyDomainURI() {
        return this.keyDomainURI;
    }

    public void setKeyDomain(String keyDomainURI) {
        this.keyDomainURI = keyDomainURI;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    private static String ContentToString(List<Object> content) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < content.size(); ++i) {
            sb.append(content.get(i).toString()).append(" ");
        }
        return sb.toString().trim();
    }

    public BusinessService createBusinessService(QName serviceQName, Application wadlDefinition) throws MalformedURLException {
        log.debug("Constructing Service UDDI Information for " + serviceQName);
        BusinessService service = new BusinessService();
        service.setBusinessKey(this.businessKey);
        service.setServiceKey(UDDIKeyConvention.getServiceKey(this.properties, serviceQName.getLocalPart()));
        String serviceDescription = this.properties.getProperty("serviceDescription", "Default service description when no <wsdl:document> element is defined inside the <wsdl:service> element.");
        boolean lengthwarn = false;
        if (!wadlDefinition.getDoc().isEmpty()) {
            for (int i = 0; i < wadlDefinition.getDoc().size(); ++i) {
                String locallang = this.lang;
                if (wadlDefinition.getDoc().get(i).getLang() != null) {
                    locallang = wadlDefinition.getDoc().get(i).getLang();
                }
                if (locallang.length() > 26) {
                    lengthwarn = true;
                    locallang = locallang.substring(0, 25);
                }
                StringBuilder sb = new StringBuilder();
                sb.append(wadlDefinition.getDoc().get(i).getTitle()).append(" ");
                sb.append(WADL2UDDI.ContentToString(wadlDefinition.getDoc().get(i).getContent()));
                service.getDescription().addAll(Common2UDDI.mapDescription(sb.toString(), locallang));
            }
        } else {
            service.getDescription().addAll(Common2UDDI.mapDescription(serviceDescription, this.lang));
        }
        Name sName = new Name();
        sName.setLang(this.lang);
        if (!wadlDefinition.getDoc().isEmpty()) {
            sName.setValue(wadlDefinition.getDoc().get(0).getTitle());
        }
        if (sName.getValue() == null) {
            sName.setValue(serviceQName.getLocalPart());
        }
        service.getName().add(sName);
        CategoryBag categoryBag = new CategoryBag();
        String namespace = serviceQName.getNamespaceURI();
        if (namespace != null && namespace.length() != 0) {
            KeyedReference namespaceReference = WADL2UDDI.newKeyedReference("uddi:uddi.org:xml:namespace", "uddi-org:xml:namespace", namespace);
            categoryBag.getKeyedReference().add(namespaceReference);
        }
        KeyedReference serviceReference = WADL2UDDI.newKeyedReference("uddi:uddi.org:wadl:types", "uddi-org:wadl:types", "service");
        categoryBag.getKeyedReference().add(serviceReference);
        KeyedReference localNameReference = WADL2UDDI.newKeyedReference("uddi:uddi.org:xml:localname", "uddi-org:xml:localName", serviceQName.getLocalPart());
        categoryBag.getKeyedReference().add(localNameReference);
        service.setCategoryBag(categoryBag);
        for (int i = 0; i < wadlDefinition.getResources().size(); ++i) {
            BindingTemplate bindingTemplate = this.createWADLBinding(serviceQName, this.getDocTitle(wadlDefinition.getResources().get(i).getDoc()), new URL(wadlDefinition.getResources().get(i).getBase()), wadlDefinition.getResources().get(i));
            service.setBindingTemplates(new BindingTemplates());
            service.getBindingTemplates().getBindingTemplate().add(bindingTemplate);
        }
        if (lengthwarn) {
            log.warn("Some object descriptions are longer than the maximum allowed by UDDI and have been truncated.");
        }
        return service;
    }

    public static List<URL> getBaseAddresses(Application app) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (app == null) {
            return urls;
        }
        for (int i = 0; i < app.getResources().size(); ++i) {
            try {
                urls.add(new URL(app.getResources().get(i).getBase()));
                continue;
            }
            catch (MalformedURLException ex) {
                log.warn("The base URL " + app.getResources().get(i).getBase() + " is invalid or could not be parsed", ex);
            }
        }
        return urls;
    }

    protected static KeyedReference newKeyedReference(String tModelKey, String keyName, String value) {
        KeyedReference typesReference = new KeyedReference();
        typesReference.setTModelKey(tModelKey);
        typesReference.setKeyName(keyName);
        typesReference.setKeyValue(value);
        return typesReference;
    }

    protected BindingTemplate createWADLBinding(QName serviceQName, String portName, URL serviceUrl, Resources res) {
        BindingTemplate bindingTemplate = new BindingTemplate();
        bindingTemplate.setServiceKey(UDDIKeyConvention.getServiceKey(this.properties, serviceQName.getLocalPart()));
        if (serviceUrl != null) {
            AccessPoint accessPoint = new AccessPoint();
            accessPoint.setUseType(AccessPointType.END_POINT.toString());
            accessPoint.setValue(this.urlLocalizer.rewrite(serviceUrl));
            bindingTemplate.setAccessPoint(accessPoint);
            String bindingKey = UDDIKeyConvention.getBindingKey(this.properties, serviceQName, portName, serviceUrl);
            bindingTemplate.setBindingKey(bindingKey);
            bindingTemplate.getDescription().addAll(Common2UDDI.mapDescription(this.getDescription(res.getDoc()), this.lang));
            TModelInstanceInfo tModelInstanceInfoBinding = new TModelInstanceInfo();
            tModelInstanceInfoBinding.setTModelKey(this.keyDomainURI + "binding");
            InstanceDetails instanceDetails = new InstanceDetails();
            instanceDetails.setInstanceParms(portName);
            tModelInstanceInfoBinding.setInstanceDetails(instanceDetails);
            tModelInstanceInfoBinding.getDescription().addAll(Common2UDDI.mapDescription("The binding that this endpoint implements. " + bindingTemplate.getDescription().get(0).getValue() + " The instanceParms specifies the \" port local name.", this.lang));
            TModelInstanceDetails tModelInstanceDetails = new TModelInstanceDetails();
            tModelInstanceDetails.getTModelInstanceInfo().add(tModelInstanceInfoBinding);
            TModelInstanceInfo tModelInstanceInfoPortType = new TModelInstanceInfo();
            tModelInstanceInfoPortType.setTModelKey(this.keyDomainURI + "rest");
            Description descriptionPT = new Description();
            descriptionPT.setLang(this.lang);
            descriptionPT.setValue("The wadl:Resource:base implements.");
            tModelInstanceInfoPortType.getDescription().add(descriptionPT);
            tModelInstanceDetails.getTModelInstanceInfo().add(tModelInstanceInfoPortType);
            bindingTemplate.setTModelInstanceDetails(tModelInstanceDetails);
        }
        return bindingTemplate;
    }

    public static Application parseWadl(InputStream stream) {
        Application unmarshal = (Application)JAXB.unmarshal((InputStream)stream, Application.class);
        return unmarshal;
    }

    public static Application parseWadl(URL file) {
        Application unmarshal = (Application)JAXB.unmarshal((URL)file, Application.class);
        return unmarshal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Application parseWadl(URL weburl, String username, String password, boolean ignoreSSLErrors) {
        AbstractHttpClient httpclient = null;
        Application unmarshal = null;
        try {
            String url = weburl.toString();
            if (!url.toLowerCase().startsWith("http")) {
                Application application = WADL2UDDI.parseWadl(weburl);
                return application;
            }
            boolean usessl = false;
            int port = 80;
            if (url.toLowerCase().startsWith("https://")) {
                port = 443;
                usessl = true;
            }
            if (weburl.getPort() > 0) {
                port = weburl.getPort();
            }
            if (ignoreSSLErrors && usessl) {
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(new Scheme("https", port, new MockSSLSocketFactory()));
                BasicClientConnectionManager cm = new BasicClientConnectionManager(schemeRegistry);
                httpclient = new DefaultHttpClient(cm);
            } else {
                httpclient = new DefaultHttpClient();
            }
            if (username != null && username.length() > 0 && password != null && password.length() > 0) {
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(weburl.getHost(), port), new UsernamePasswordCredentials(username, password));
            }
            HttpGet httpGet = new HttpGet(url);
            try {
                HttpResponse response1 = httpclient.execute(httpGet);
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                String handleResponse = (String)responseHandler.handleResponse(response1);
                StringReader sr = new StringReader(handleResponse);
                unmarshal = (Application)JAXB.unmarshal((Reader)sr, Application.class);
            }
            finally {
                httpGet.releaseConnection();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        return unmarshal;
    }

    public static Application parseWadl(File file) throws FileNotFoundException, IOException {
        Application unmarshal = (Application)JAXB.unmarshal((File)file, Application.class);
        return unmarshal;
    }

    private String getDocTitle(List<Doc> doc) {
        if (doc.isEmpty() || doc.get(0) == null || doc.get(0).getTitle() == null) {
            return "A resource base URL without a description";
        }
        return doc.get(0).getTitle();
    }

    private String getDescription(List<Doc> doc) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < doc.size(); ++i) {
            sb.append(doc.get(i).getTitle()).append(" ");
            sb.append(WADL2UDDI.ContentToString(doc.get(i).getContent()));
        }
        String ret = sb.toString().trim();
        if (ret.length() == 0) {
            return "No Description";
        }
        return ret;
    }
}

