/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.mapping.URLLocalizer;

public class URLLocalizerDefaultImpl
implements URLLocalizer {
    URL baseUrl;
    private Log log = LogFactory.getLog(this.getClass());

    public URLLocalizerDefaultImpl() {
    }

    public URLLocalizerDefaultImpl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public String rewrite(URL urlIn) {
        return this.rewriteURL(urlIn).toExternalForm();
    }

    @Override
    public String rewriteToWSDLURL(URL urlIn) {
        URL url = this.rewriteURL(urlIn);
        return url.toExternalForm() + "?wsdl";
    }

    @Override
    public URL rewriteURL(URL urlIn) {
        URL url = null;
        if (this.baseUrl != null && url == null) {
            try {
                url = new URL(this.baseUrl.getProtocol(), this.baseUrl.getHost(), this.baseUrl.getPort(), urlIn.getPath());
            }
            catch (MalformedURLException e) {
                this.log.error(e.getMessage(), e);
            }
        } else {
            url = urlIn;
        }
        return url;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }
}

