/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.io.StringWriter;
import java.io.Writer;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.mapping.UDDIServiceCache;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.Result;
import org.uddi.subr_v3.NotifySubscriptionListener;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;

@WebService(serviceName="UDDIClientSubscriptionListenerService", endpointInterface="org.uddi.v3_service.UDDISubscriptionListenerPortType", targetNamespace="urn:uddi-org:v3_service")
public class UDDIClientSubscriptionListenerImpl
implements UDDISubscriptionListenerPortType {
    private static final Log logger = LogFactory.getLog(UDDIClientSubscriptionListenerImpl.class);
    private UDDIServiceCache serviceCache = null;

    public UDDIClientSubscriptionListenerImpl() {
    }

    public UDDIClientSubscriptionListenerImpl(String bindingKey, UDDIServiceCache serviceCache) {
        this.serviceCache = serviceCache;
    }

    @Override
    public DispositionReport notifySubscriptionListener(NotifySubscriptionListener body) throws DispositionReportFaultMessage {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{body.getClass()});
            Marshaller marshaller = context.createMarshaller();
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)body, (Writer)sw);
            logger.info("Notification received by UDDISubscriptionListenerService : " + sw.toString());
            if (this.serviceCache != null) {
                this.serviceCache.removeAll();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        DispositionReport dr = new DispositionReport();
        Result res = new Result();
        dr.getResult().add(res);
        return dr;
    }
}

