/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.uddi.api_v2.Address;
import org.uddi.api_v2.AddressLine;
import org.uddi.api_v2.AssertionStatusReport;
import org.uddi.api_v2.BindingDetail;
import org.uddi.api_v2.BindingTemplate;
import org.uddi.api_v2.BusinessService;
import org.uddi.api_v2.Contact;
import org.uddi.api_v2.Contacts;
import org.uddi.api_v2.DeleteBusiness;
import org.uddi.api_v2.DeletePublisherAssertions;
import org.uddi.api_v2.DeleteService;
import org.uddi.api_v2.DeleteTModel;
import org.uddi.api_v2.Description;
import org.uddi.api_v2.FindBusiness;
import org.uddi.api_v2.GetBusinessDetail;
import org.uddi.api_v2.GetBusinessDetailExt;
import org.uddi.api_v2.GetServiceDetail;
import org.uddi.api_v2.GetTModelDetail;
import org.uddi.api_v2.IdentifierBag;
import org.uddi.api_v2.Name;
import org.uddi.api_v2.OverviewDoc;
import org.uddi.api_v2.Phone;
import org.uddi.api_v2.PublisherAssertion;
import org.uddi.api_v2.PublisherAssertions;
import org.uddi.api_v2.RegisteredInfo;
import org.uddi.api_v2.SaveBinding;
import org.uddi.api_v2.SaveBusiness;
import org.uddi.api_v2.SaveTModel;
import org.uddi.api_v2.ServiceDetail;
import org.uddi.api_v2.ServiceInfos;
import org.uddi.api_v2.ServiceList;
import org.uddi.api_v2.SetPublisherAssertions;
import org.uddi.api_v2.TModel;
import org.uddi.api_v2.TModelBag;
import org.uddi.api_v2.TModelInstanceInfo;
import org.uddi.api_v2.TModelList;
import org.uddi.api_v2.Truncated;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.AssertionStatusItem;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.CompletionStatus;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.Direction;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.Email;
import org.uddi.api_v3.ErrInfo;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.HostingRedirector;
import org.uddi.api_v3.InfoSelection;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyType;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.KeysOwned;
import org.uddi.api_v3.ListDescription;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.RelatedBusinessInfo;
import org.uddi.api_v3.RelatedBusinessInfos;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.Result;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.SharedRelationships;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.v2_service.DispositionReport;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class MapUDDIv2Tov3 {
    private static Log logger = LogFactory.getLog(MapUDDIv2Tov3.class);

    public static BusinessEntity MapBusiness(org.uddi.api_v2.BusinessEntity be) {
        if (be == null) {
            return null;
        }
        BusinessEntity item = new BusinessEntity();
        item.setBusinessKey(be.getBusinessKey());
        item.getName().addAll(MapUDDIv2Tov3.MapName(be.getName()));
        item.setCategoryBag(MapUDDIv2Tov3.MapCategoryBag(be.getCategoryBag()));
        item.setDiscoveryURLs(MapUDDIv2Tov3.MapDiscoveryURLs(be.getDiscoveryURLs()));
        item.getDescription().addAll(MapUDDIv2Tov3.MapDescription(be.getDescription()));
        item.setContacts(MapUDDIv2Tov3.MapContacts(be.getContacts()));
        item.setIdentifierBag(MapUDDIv2Tov3.MapIdentBag(be.getIdentifierBag()));
        if (be.getBusinessServices() != null && !be.getBusinessServices().getBusinessService().isEmpty()) {
            item.setBusinessServices(new BusinessServices());
            item.getBusinessServices().getBusinessService().addAll(MapUDDIv2Tov3.MapService(be.getBusinessServices().getBusinessService()));
        }
        return item;
    }

    public static org.uddi.api_v3.BusinessService MapService(BusinessService be) {
        if (be == null) {
            return null;
        }
        org.uddi.api_v3.BusinessService item = new org.uddi.api_v3.BusinessService();
        item.setBusinessKey(be.getBusinessKey());
        item.setServiceKey(be.getServiceKey());
        item.getName().addAll(MapUDDIv2Tov3.MapName(be.getName()));
        if (be.getBindingTemplates() != null && !be.getBindingTemplates().getBindingTemplate().isEmpty()) {
            item.setBindingTemplates(new BindingTemplates());
            item.getBindingTemplates().getBindingTemplate().addAll(MapUDDIv2Tov3.MapBinding(be.getBindingTemplates().getBindingTemplate()));
        }
        item.setCategoryBag(MapUDDIv2Tov3.MapCategoryBag(be.getCategoryBag()));
        item.getDescription().addAll(MapUDDIv2Tov3.MapDescription(be.getDescription()));
        return item;
    }

    public static List<org.uddi.api_v3.BusinessService> MapService(List<BusinessService> be) {
        if (be == null) {
            return null;
        }
        ArrayList<org.uddi.api_v3.BusinessService> item = new ArrayList<org.uddi.api_v3.BusinessService>();
        for (int i = 0; i < be.size(); ++i) {
            item.add(MapUDDIv2Tov3.MapService(be.get(i)));
        }
        return item;
    }

    public static org.uddi.api_v3.BindingTemplate MapBinding(BindingTemplate be) {
        if (be == null) {
            return null;
        }
        org.uddi.api_v3.BindingTemplate item = new org.uddi.api_v3.BindingTemplate();
        item.setBindingKey(be.getBindingKey());
        item.setServiceKey(be.getServiceKey());
        item.setAccessPoint(MapUDDIv2Tov3.MapAccessPoint(be.getAccessPoint()));
        item.setHostingRedirector(MapUDDIv2Tov3.MapHostingRedir(be.getHostingRedirector()));
        item.getDescription().addAll(MapUDDIv2Tov3.MapDescription(be.getDescription()));
        item.setTModelInstanceDetails(MapUDDIv2Tov3.MapTModelInstanceDetails(be.getTModelInstanceDetails()));
        return item;
    }

    public static List<org.uddi.api_v3.BindingTemplate> MapBinding(List<BindingTemplate> be) {
        if (be == null) {
            return null;
        }
        ArrayList<org.uddi.api_v3.BindingTemplate> item = new ArrayList<org.uddi.api_v3.BindingTemplate>();
        for (int i = 0; i < be.size(); ++i) {
            item.add(MapUDDIv2Tov3.MapBinding(be.get(i)));
        }
        return item;
    }

    public static org.uddi.api_v3.TModel MapTModel(TModel be) {
        if (be == null) {
            return null;
        }
        org.uddi.api_v3.TModel item = new org.uddi.api_v3.TModel();
        item.setTModelKey(be.getTModelKey());
        item.setName(new org.uddi.api_v3.Name(be.getName().getValue(), be.getName().getLang()));
        item.setCategoryBag(MapUDDIv2Tov3.MapCategoryBag(be.getCategoryBag()));
        item.setIdentifierBag(MapUDDIv2Tov3.MapIdentBag(be.getIdentifierBag()));
        item.getDescription().addAll(MapUDDIv2Tov3.MapDescription(be.getDescription()));
        org.uddi.api_v3.OverviewDoc MapOverviewDoc = MapUDDIv2Tov3.MapOverviewDoc(be.getOverviewDoc());
        if (MapOverviewDoc != null) {
            item.getOverviewDoc().add(MapOverviewDoc);
        }
        return item;
    }

    private static List<org.uddi.api_v3.Name> MapName(List<Name> name) {
        ArrayList<org.uddi.api_v3.Name> items = new ArrayList<org.uddi.api_v3.Name>();
        for (int i = 0; i < name.size(); ++i) {
            org.uddi.api_v3.Name n = new org.uddi.api_v3.Name(name.get(i).getValue(), name.get(i).getLang());
            items.add(n);
        }
        return items;
    }

    private static CategoryBag MapCategoryBag(org.uddi.api_v2.CategoryBag categoryBag) {
        if (categoryBag == null) {
            return null;
        }
        CategoryBag c = new CategoryBag();
        c.getKeyedReference().addAll(MapUDDIv2Tov3.MapKeyedReference(categoryBag.getKeyedReference()));
        return c;
    }

    private static List<org.uddi.api_v3.Description> MapDescription(List<Description> description) {
        ArrayList<org.uddi.api_v3.Description> ret = new ArrayList<org.uddi.api_v3.Description>();
        if (description == null || description.isEmpty()) {
            return ret;
        }
        for (int i = 0; i < description.size(); ++i) {
            ret.add(new org.uddi.api_v3.Description(description.get(i).getValue(), description.get(i).getLang()));
        }
        return ret;
    }

    private static org.uddi.api_v3.IdentifierBag MapIdentBag(IdentifierBag identifierBag) {
        if (identifierBag == null) {
            return null;
        }
        org.uddi.api_v3.IdentifierBag r = new org.uddi.api_v3.IdentifierBag();
        r.getKeyedReference().addAll(MapUDDIv2Tov3.MapKeyedReference(identifierBag.getKeyedReference()));
        return r;
    }

    private static org.uddi.api_v3.OverviewDoc MapOverviewDoc(OverviewDoc overviewDoc) {
        if (overviewDoc == null) {
            return null;
        }
        org.uddi.api_v3.OverviewDoc r = new org.uddi.api_v3.OverviewDoc();
        r.getDescription().addAll(MapUDDIv2Tov3.MapDescription(overviewDoc.getDescription()));
        if (overviewDoc.getOverviewURL() != null) {
            r.setOverviewURL(new OverviewURL());
            overviewDoc.getDescription();
            r.getOverviewURL().setValue(overviewDoc.getOverviewURL());
        }
        return r;
    }

    private static AccessPoint MapAccessPoint(org.uddi.api_v2.AccessPoint accessPoint) {
        if (accessPoint == null) {
            return null;
        }
        return new AccessPoint(accessPoint.getValue(), MapUDDIv2Tov3.MapURLType(accessPoint.getValue()));
    }

    private static HostingRedirector MapHostingRedir(org.uddi.api_v2.HostingRedirector hostingRedirector) {
        if (hostingRedirector == null) {
            return null;
        }
        HostingRedirector r = new HostingRedirector();
        r.setBindingKey(hostingRedirector.getBindingKey());
        return r;
    }

    private static TModelInstanceDetails MapTModelInstanceDetails(org.uddi.api_v2.TModelInstanceDetails tModelInstanceDetails) {
        if (tModelInstanceDetails == null | tModelInstanceDetails.getTModelInstanceInfo().isEmpty()) {
            return null;
        }
        TModelInstanceDetails r = new TModelInstanceDetails();
        r.getTModelInstanceInfo().addAll(MapUDDIv2Tov3.MapTModelInstanceInfo(tModelInstanceDetails.getTModelInstanceInfo()));
        return r;
    }

    private static List<KeyedReference> MapKeyedReference(List<org.uddi.api_v2.KeyedReference> keyedReference) {
        ArrayList<KeyedReference> r = new ArrayList<KeyedReference>();
        if (keyedReference == null) {
            return r;
        }
        for (int i = 0; i < keyedReference.size(); ++i) {
            r.add(new KeyedReference(keyedReference.get(i).getTModelKey(), keyedReference.get(i).getKeyName(), keyedReference.get(i).getKeyValue()));
        }
        return r;
    }

    private static String MapURLType(String url) {
        if (url == null) {
            return null;
        }
        if (url.toLowerCase().endsWith("wsdl")) {
            return AccessPointType.WSDL_DEPLOYMENT.toString();
        }
        return AccessPointType.END_POINT.toString();
    }

    private static List<org.uddi.api_v3.TModelInstanceInfo> MapTModelInstanceInfo(List<TModelInstanceInfo> tModelInstanceInfo) {
        ArrayList<org.uddi.api_v3.TModelInstanceInfo> r = new ArrayList<org.uddi.api_v3.TModelInstanceInfo>();
        if (tModelInstanceInfo == null) {
            return r;
        }
        for (int i = 0; i < tModelInstanceInfo.size(); ++i) {
            org.uddi.api_v3.TModelInstanceInfo t = new org.uddi.api_v3.TModelInstanceInfo();
            t.setTModelKey(tModelInstanceInfo.get(i).getTModelKey());
            t.getDescription().addAll(MapUDDIv2Tov3.MapDescription(tModelInstanceInfo.get(i).getDescription()));
            if (tModelInstanceInfo.get(i).getInstanceDetails() != null) {
                t.setInstanceDetails(new InstanceDetails());
                t.getInstanceDetails().getDescription().addAll(MapUDDIv2Tov3.MapDescription(tModelInstanceInfo.get(i).getInstanceDetails().getDescription()));
                t.getInstanceDetails().setInstanceParms(tModelInstanceInfo.get(i).getInstanceDetails().getInstanceParms());
                t.getInstanceDetails().getOverviewDoc().add(MapUDDIv2Tov3.MapOverviewDoc(tModelInstanceInfo.get(i).getInstanceDetails().getOverviewDoc()));
            }
            r.add(t);
        }
        return r;
    }

    public static org.uddi.api_v3.BindingDetail MapBindingDetail(BindingDetail findBinding) {
        org.uddi.api_v3.BindingDetail r = new org.uddi.api_v3.BindingDetail();
        for (int i = 0; i < findBinding.getBindingTemplate().size(); ++i) {
            r.getBindingTemplate().addAll(MapUDDIv2Tov3.MapBinding(findBinding.getBindingTemplate()));
        }
        r.setTruncated(findBinding.getTruncated() == Truncated.TRUE);
        return r;
    }

    public static BusinessList MapBusinessList(org.uddi.api_v2.BusinessList findBinding) {
        BusinessList r = new BusinessList();
        r.setListDescription(new ListDescription());
        r.getListDescription().setActualCount(0);
        r.getListDescription().setIncludeCount(0);
        r.getListDescription().setListHead(0);
        if (findBinding.getBusinessInfos() != null) {
            r.getListDescription().setIncludeCount(findBinding.getBusinessInfos().getBusinessInfo().size());
            r.getListDescription().setActualCount(findBinding.getBusinessInfos().getBusinessInfo().size());
            r.setBusinessInfos(new BusinessInfos());
            r.getBusinessInfos().getBusinessInfo().addAll(MapUDDIv2Tov3.MapBusinessInfo(findBinding.getBusinessInfos().getBusinessInfo()));
        }
        r.setTruncated(findBinding.getTruncated() == Truncated.TRUE);
        return r;
    }

    public static DispositionReportFaultMessage MapException(DispositionReport ex) {
        org.uddi.api_v3.DispositionReport r = new org.uddi.api_v3.DispositionReport();
        r.setTruncated(ex.getFaultInfo().getTruncated() == Truncated.TRUE);
        r.getResult().addAll(MapUDDIv2Tov3.MapResult(ex.getFaultInfo().getResult()));
        DispositionReportFaultMessage x = new DispositionReportFaultMessage(ex.getMessage(), r);
        return x;
    }

    public static RelatedBusinessesList MapRelatedBusinessesList(org.uddi.api_v2.RelatedBusinessesList findRelatedBusinesses) {
        if (findRelatedBusinesses == null) {
            return null;
        }
        RelatedBusinessesList r = new RelatedBusinessesList();
        r.setTruncated(findRelatedBusinesses.getTruncated() == Truncated.TRUE);
        r.setBusinessKey(findRelatedBusinesses.getBusinessKey());
        if (findRelatedBusinesses.getRelatedBusinessInfos() != null) {
            r.setRelatedBusinessInfos(new RelatedBusinessInfos());
            for (int i = 0; i < findRelatedBusinesses.getRelatedBusinessInfos().getRelatedBusinessInfo().size(); ++i) {
                RelatedBusinessInfo x = new RelatedBusinessInfo();
                x.setBusinessKey(findRelatedBusinesses.getRelatedBusinessInfos().getRelatedBusinessInfo().get(i).getBusinessKey());
                x.getDescription().addAll(MapUDDIv2Tov3.MapDescription(findRelatedBusinesses.getRelatedBusinessInfos().getRelatedBusinessInfo().get(i).getDescription()));
                x.getName().addAll(MapUDDIv2Tov3.MapName(findRelatedBusinesses.getRelatedBusinessInfos().getRelatedBusinessInfo().get(i).getName()));
                x.getSharedRelationships().addAll(MapUDDIv2Tov3.MapSharedRelationship(findRelatedBusinesses.getRelatedBusinessInfos().getRelatedBusinessInfo().get(i).getSharedRelationships()));
                r.getRelatedBusinessInfos().getRelatedBusinessInfo().add(x);
            }
        }
        return r;
    }

    public static org.uddi.api_v3.ServiceList MapServiceList(ServiceList serviceDetail) {
        if (serviceDetail == null) {
            return null;
        }
        org.uddi.api_v3.ServiceList r = new org.uddi.api_v3.ServiceList();
        r.setListDescription(new ListDescription());
        r.getListDescription().setActualCount(0);
        r.getListDescription().setIncludeCount(0);
        r.getListDescription().setListHead(0);
        if (serviceDetail.getServiceInfos() != null) {
            r.setServiceInfos(new org.uddi.api_v3.ServiceInfos());
            r.getListDescription().setIncludeCount(serviceDetail.getServiceInfos().getServiceInfo().size());
            r.getListDescription().setActualCount(serviceDetail.getServiceInfos().getServiceInfo().size());
            for (int i = 0; i < serviceDetail.getServiceInfos().getServiceInfo().size(); ++i) {
                ServiceInfo x = new ServiceInfo();
                x.setBusinessKey(serviceDetail.getServiceInfos().getServiceInfo().get(i).getBusinessKey());
                x.setServiceKey(serviceDetail.getServiceInfos().getServiceInfo().get(i).getServiceKey());
                x.getName().addAll(MapUDDIv2Tov3.MapName(serviceDetail.getServiceInfos().getServiceInfo().get(i).getName()));
                r.getServiceInfos().getServiceInfo().add(x);
            }
        }
        r.setTruncated(serviceDetail.getTruncated() == Truncated.TRUE);
        return r;
    }

    public static BusinessDetail MapBusinessDetail(org.uddi.api_v2.BusinessDetail businessDetail) {
        if (businessDetail == null) {
            return null;
        }
        BusinessDetail r = new BusinessDetail();
        for (int i = 0; i < businessDetail.getBusinessEntity().size(); ++i) {
            r.getBusinessEntity().add(MapUDDIv2Tov3.MapBusiness(businessDetail.getBusinessEntity().get(i)));
        }
        r.setTruncated(businessDetail.getTruncated() == Truncated.TRUE);
        return r;
    }

    public static org.uddi.api_v3.ServiceDetail MapServiceDetail(ServiceDetail serviceDetail) {
        if (serviceDetail == null) {
            return null;
        }
        org.uddi.api_v3.ServiceDetail r = new org.uddi.api_v3.ServiceDetail();
        for (int i = 0; i < serviceDetail.getBusinessService().size(); ++i) {
            r.getBusinessService().add(MapUDDIv2Tov3.MapService(serviceDetail.getBusinessService().get(i)));
        }
        r.setTruncated(serviceDetail.getTruncated() == Truncated.TRUE);
        return r;
    }

    public static TModelDetail MapTModelDetail(org.uddi.api_v2.TModelDetail tModelDetail) {
        if (tModelDetail == null) {
            return null;
        }
        TModelDetail r = new TModelDetail();
        for (int i = 0; i < tModelDetail.getTModel().size(); ++i) {
            r.getTModel().add(MapUDDIv2Tov3.MapTModel(tModelDetail.getTModel().get(i)));
        }
        r.setTruncated(tModelDetail.getTruncated() == Truncated.TRUE);
        return r;
    }

    public static org.uddi.api_v3.TModelList MapTModelList(TModelList findTModel) {
        org.uddi.api_v3.TModelList r = new org.uddi.api_v3.TModelList();
        r.setListDescription(new ListDescription());
        r.getListDescription().setActualCount(0);
        r.getListDescription().setIncludeCount(0);
        r.getListDescription().setListHead(0);
        if (findTModel.getTModelInfos() != null && !findTModel.getTModelInfos().getTModelInfo().isEmpty()) {
            r.setTModelInfos(new TModelInfos());
            r.getListDescription().setIncludeCount(findTModel.getTModelInfos().getTModelInfo().size());
            r.getListDescription().setActualCount(findTModel.getTModelInfos().getTModelInfo().size());
            for (int i = 0; i < findTModel.getTModelInfos().getTModelInfo().size(); ++i) {
                TModelInfo x = new TModelInfo();
                x.setName(new org.uddi.api_v3.Name(findTModel.getTModelInfos().getTModelInfo().get(i).getName().getValue(), findTModel.getTModelInfos().getTModelInfo().get(i).getName().getLang()));
                x.setTModelKey(findTModel.getTModelInfos().getTModelInfo().get(i).getTModelKey());
                r.getTModelInfos().getTModelInfo().add(x);
            }
        }
        r.setTruncated(findTModel.getTruncated() == Truncated.TRUE);
        return r;
    }

    public static List<org.uddi.api_v3.PublisherAssertion> MapListPublisherAssertion(List<PublisherAssertion> publisherAssertions) {
        ArrayList<org.uddi.api_v3.PublisherAssertion> r = new ArrayList<org.uddi.api_v3.PublisherAssertion>();
        if (publisherAssertions == null) {
            return r;
        }
        for (int i = 0; i < publisherAssertions.size(); ++i) {
            org.uddi.api_v3.PublisherAssertion x = new org.uddi.api_v3.PublisherAssertion();
            x.setFromKey(publisherAssertions.get(i).getFromKey());
            x.setToKey(publisherAssertions.get(i).getToKey());
            if (publisherAssertions.get(i).getKeyedReference() != null) {
                x.setKeyedReference(new KeyedReference(publisherAssertions.get(i).getKeyedReference().getTModelKey(), publisherAssertions.get(i).getKeyedReference().getKeyName(), publisherAssertions.get(i).getKeyedReference().getKeyValue()));
            }
            r.add(x);
        }
        return r;
    }

    public static List<org.uddi.api_v3.PublisherAssertion> MapListPublisherAssertion(PublisherAssertions publisherAssertions) {
        ArrayList<org.uddi.api_v3.PublisherAssertion> r = new ArrayList<org.uddi.api_v3.PublisherAssertion>();
        if (publisherAssertions == null) {
            return r;
        }
        r.addAll(MapUDDIv2Tov3.MapListPublisherAssertion(publisherAssertions.getPublisherAssertion()));
        return r;
    }

    public static org.uddi.api_v3.RegisteredInfo MapListRegisteredInfo(RegisteredInfo registeredInfo) {
        if (registeredInfo == null) {
            return null;
        }
        org.uddi.api_v3.RegisteredInfo r = new org.uddi.api_v3.RegisteredInfo();
        if (registeredInfo.getBusinessInfos() != null) {
            r.setBusinessInfos(new BusinessInfos());
            r.getBusinessInfos().getBusinessInfo().addAll(MapUDDIv2Tov3.MapBusinessInfo(registeredInfo.getBusinessInfos().getBusinessInfo()));
        }
        if (registeredInfo.getTModelInfos() != null) {
            r.setTModelInfos(new TModelInfos());
            for (int i = 0; i < registeredInfo.getTModelInfos().getTModelInfo().size(); ++i) {
                TModelInfo x = new TModelInfo();
                x.setTModelKey(registeredInfo.getTModelInfos().getTModelInfo().get(i).getTModelKey());
                x.setName(new org.uddi.api_v3.Name(registeredInfo.getTModelInfos().getTModelInfo().get(i).getName().getValue(), registeredInfo.getTModelInfos().getTModelInfo().get(i).getName().getValue()));
                r.getTModelInfos().getTModelInfo().add(x);
            }
        }
        r.setTruncated(registeredInfo.getTruncated() == Truncated.TRUE);
        return r;
    }

    private static List<BusinessInfo> MapBusinessInfo(List<org.uddi.api_v2.BusinessInfo> businessInfo) {
        ArrayList<BusinessInfo> r = new ArrayList<BusinessInfo>();
        if (businessInfo == null) {
            return r;
        }
        for (int i = 0; i < businessInfo.size(); ++i) {
            BusinessInfo x = new BusinessInfo();
            x.setBusinessKey(businessInfo.get(i).getBusinessKey());
            x.setServiceInfos(MapUDDIv2Tov3.MapServiceInfo(businessInfo.get(i).getServiceInfos()));
            x.getName().addAll(MapUDDIv2Tov3.MapName(businessInfo.get(i).getName()));
            x.getDescription().addAll(MapUDDIv2Tov3.MapDescription(businessInfo.get(i).getDescription()));
            r.add(x);
        }
        return r;
    }

    private static org.uddi.api_v3.ServiceInfos MapServiceInfo(ServiceInfos serviceInfos) {
        if (serviceInfos == null) {
            return null;
        }
        org.uddi.api_v3.ServiceInfos r = new org.uddi.api_v3.ServiceInfos();
        for (int i = 0; i < serviceInfos.getServiceInfo().size(); ++i) {
            ServiceInfo x = new ServiceInfo();
            x.setBusinessKey(serviceInfos.getServiceInfo().get(i).getBusinessKey());
            x.setServiceKey(serviceInfos.getServiceInfo().get(i).getServiceKey());
            x.getName().addAll(MapUDDIv2Tov3.MapName(serviceInfos.getServiceInfo().get(i).getName()));
            r.getServiceInfo().add(x);
        }
        return r;
    }

    private static List<Result> MapResult(List<org.uddi.api_v2.Result> result) {
        ArrayList<Result> r = new ArrayList<Result>();
        if (result == null) {
            return r;
        }
        for (int i = 0; i < result.size(); ++i) {
            Result x = new Result();
            x.setErrno(result.get(i).getErrno());
            if (result.get(i).getKeyType() != null) {
                switch (result.get(i).getKeyType()) {
                    case BINDING_KEY: {
                        x.setKeyType(KeyType.BINDING_KEY);
                        break;
                    }
                    case BUSINESS_KEY: {
                        x.setKeyType(KeyType.BUSINESS_KEY);
                        break;
                    }
                    case SERVICE_KEY: {
                        x.setKeyType(KeyType.SERVICE_KEY);
                        break;
                    }
                    case T_MODEL_KEY: {
                        x.setKeyType(KeyType.T_MODEL_KEY);
                    }
                }
            }
            if (result.get(i).getErrInfo() != null) {
                x.setErrInfo(new ErrInfo());
                x.getErrInfo().setErrCode(result.get(i).getErrInfo().getErrCode());
                x.getErrInfo().setValue(result.get(i).getErrInfo().getValue());
            }
            r.add(x);
        }
        return r;
    }

    public static DispositionReportFaultMessage MapException(SOAPFaultException ex) {
        org.uddi.api_v3.DispositionReport r = new org.uddi.api_v3.DispositionReport();
        r.setTruncated(false);
        r.getResult().addAll(MapUDDIv2Tov3.MapFault(ex.getFault()));
        DispositionReportFaultMessage x = new DispositionReportFaultMessage(ex.getMessage(), r);
        return x;
    }

    private static List<Result> MapFault(SOAPFault result) {
        ArrayList<Result> r = new ArrayList<Result>();
        if (result == null) {
            return r;
        }
        if (result.getDetail() != null) {
            while (result.getDetail().getDetailEntries().hasNext()) {
                Object next = result.getDetail().getDetailEntries().next();
                if (next instanceof DispositionReport) {
                    DispositionReport z = (DispositionReport)next;
                    Result x = new Result();
                    r.addAll(MapUDDIv2Tov3.MapResult(z.getFaultInfo().getResult()));
                }
                logger.warn("unable to parse fault detail, type:" + next.getClass().getCanonicalName() + " " + next.toString());
            }
        }
        return r;
    }

    public static FindBinding MapFindBinding(org.uddi.api_v2.FindBinding body) {
        if (body == null) {
            return null;
        }
        FindBinding r = new FindBinding();
        r.setServiceKey(body.getServiceKey());
        r.setFindQualifiers(MapUDDIv2Tov3.MapFindQualifiers(body.getFindQualifiers(), true));
        r.setMaxRows(body.getMaxRows());
        r.setTModelBag(MapUDDIv2Tov3.MapTModelBag(body.getTModelBag()));
        return r;
    }

    private static org.uddi.api_v3.TModelBag MapTModelBag(TModelBag tModelBag) {
        if (tModelBag == null || tModelBag.getTModelKey().isEmpty()) {
            return null;
        }
        org.uddi.api_v3.TModelBag r = new org.uddi.api_v3.TModelBag();
        r.getTModelKey().addAll(tModelBag.getTModelKey());
        return r;
    }

    private static FindQualifiers MapFindQualifiers(org.uddi.api_v2.FindQualifiers findQualifiers, boolean isBinding) {
        if (findQualifiers == null || findQualifiers.getFindQualifier().isEmpty()) {
            return null;
        }
        FindQualifiers r = new FindQualifiers();
        for (int i = 0; i < findQualifiers.getFindQualifier().size(); ++i) {
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uuid:68DE9E80-AD09-469D-8A37-088422BFBC36")) {
                r.getFindQualifier().add("uddi:uddi.org:transport:http");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uuid:93335D49-3EFB-48A0-ACEA-EA102B60DDC6")) {
                r.getFindQualifier().add("uddi:uddi.org:transport:smtp");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uuid:5FCF5CD0-629A-4C50-8B16-F94E9CF2A674")) {
                r.getFindQualifier().add("uddi:uddi.org:transport:ftp");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uuid:1A2B00BE-6E2C-42F5-875B-56F32686E0E7")) {
                r.getFindQualifier().add("uddi:uddi.org:transport:fax");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uuid:38E12427-5536-4260-A6F9-B5B530E63A07")) {
                r.getFindQualifier().add("uddi:uddi.org:transport:telephone");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uuid:E59AE320-77A5-11D5-B898-0004AC49CC1E")) {
                r.getFindQualifier().add("uddi:uddi.org:identifier:isreplacedby");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uuid:4064C064-6D14-4F35-8953-9652106476A9")) {
                r.getFindQualifier().add("uddi:uddi.org:categorization:owningbusiness");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uuid:807A2C6A-EE22-470D-ADC7-E0424A337C03")) {
                r.getFindQualifier().add("uddi:uddi.org:relationships");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uuid:327A56F0-3299-4461-BC23-5CD513E95C55")) {
                r.getFindQualifier().add("uddi:uddi.org:categorization:nodes");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uuid:A035A07C-F362-44dd-8F95-E2B134BF43B4")) {
                r.getFindQualifier().add("uddi:uddi.org:categorization:general_keywords");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4")) {
                r.getFindQualifier().add("uddi:uddi.org:categorization:types");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("exactNameMatch")) {
                r.getFindQualifier().add("exactMatch");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("exactMatch")) {
                r.getFindQualifier().add("exactMatch");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("caseSensitiveMatch")) {
                r.getFindQualifier().add("caseSensitiveMatch");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("orAllKeys")) {
                r.getFindQualifier().add("orAllKeys");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("orLikeKeys")) {
                r.getFindQualifier().add("orLikeKeys");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("andAllKeys")) {
                r.getFindQualifier().add("andAllKeys");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("sortByDateAsc")) {
                r.getFindQualifier().add("sortByDateAsc");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("sortByDateDesc")) {
                r.getFindQualifier().add("sortByDateDesc");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("sortByNameAsc")) {
                r.getFindQualifier().add("sortByNameAsc");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("sortByNameDesc")) {
                r.getFindQualifier().add("sortByNameDesc");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("serviceSubset")) {
                r.getFindQualifier().add("serviceSubset");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("combineCategoryBags")) {
                r.getFindQualifier().add("combineCategoryBags");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("exactNameMatch")) {
                r.getFindQualifier().add("exactMatch");
            }
            if (findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("approximateMatch")) {
                r.getFindQualifier().add("approximateMatch");
            }
            if (!findQualifiers.getFindQualifier().get(i).equalsIgnoreCase("uddi:uddi.org:findqualifier:approximatematch")) continue;
            r.getFindQualifier().add("approximateMatch");
        }
        if (!(r.getFindQualifier().contains("caseInsensitiveMatch") || r.getFindQualifier().contains("uddi:uddi.org:findqualifier:caseinsensitivematch") || r.getFindQualifier().contains("caseSensitiveMatch") || r.getFindQualifier().contains("exactMatch") || isBinding)) {
            r.getFindQualifier().add("caseInsensitiveMatch");
        }
        if (!(r.getFindQualifier().contains("approximateMatch") || r.getFindQualifier().contains("uddi:uddi.org:findqualifier:approximatematch") || r.getFindQualifier().contains("exactMatch") || isBinding)) {
            r.getFindQualifier().add("approximateMatch");
        }
        HashSet<String> s = new HashSet<String>(r.getFindQualifier());
        r.getFindQualifier().clear();
        r.getFindQualifier().addAll(s);
        return r;
    }

    public static org.uddi.api_v3.FindBusiness MapFindBusiness(FindBusiness body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.FindBusiness r = new org.uddi.api_v3.FindBusiness();
        r.setCategoryBag(MapUDDIv2Tov3.MapCategoryBag(body.getCategoryBag()));
        r.setDiscoveryURLs(MapUDDIv2Tov3.MapDiscoveryURLs(body.getDiscoveryURLs()));
        r.setFindQualifiers(MapUDDIv2Tov3.MapFindQualifiers(body.getFindQualifiers(), false));
        r.setTModelBag(MapUDDIv2Tov3.MapTModelBag(body.getTModelBag()));
        r.setMaxRows(body.getMaxRows());
        r.getName().addAll(MapUDDIv2Tov3.MapName(body.getName()));
        if (MapUDDIv2Tov3.ContainsWildCard(r.getName())) {
            r.setFindQualifiers(MapUDDIv2Tov3.AddApproximateMatch(r.getFindQualifiers()));
        }
        return r;
    }

    private static FindQualifiers AddApproximateMatch(FindQualifiers findQualifiers) {
        if (findQualifiers == null) {
            findQualifiers = new FindQualifiers();
        }
        HashSet<String> s = new HashSet<String>(findQualifiers.getFindQualifier());
        s.add("approximateMatch");
        findQualifiers.getFindQualifier().clear();
        findQualifiers.getFindQualifier().addAll(s);
        return findQualifiers;
    }

    private static boolean ContainsWildCard(List<org.uddi.api_v3.Name> name) {
        for (int i = 0; i < name.size(); ++i) {
            if (name.get(i).getValue() != null && name.get(i).getValue().contains("%")) {
                return true;
            }
            if (name.get(i).getValue() != null && name.get(i).getValue().contains("_")) {
                return true;
            }
            if (name.get(i).getLang() != null && name.get(i).getLang().contains("%")) {
                return true;
            }
            if (name.get(i).getLang() == null || !name.get(i).getLang().contains("_")) continue;
            return true;
        }
        return false;
    }

    private static DiscoveryURLs MapDiscoveryURLs(org.uddi.api_v2.DiscoveryURLs discoveryURLs) {
        if (discoveryURLs == null) {
            return null;
        }
        DiscoveryURLs r = new DiscoveryURLs();
        for (int i = 0; i < discoveryURLs.getDiscoveryURL().size(); ++i) {
            DiscoveryURL x = new DiscoveryURL(discoveryURLs.getDiscoveryURL().get(i).getUseType(), discoveryURLs.getDiscoveryURL().get(i).getValue());
            r.getDiscoveryURL().add(x);
        }
        return r;
    }

    public static FindRelatedBusinesses MapFindRelatedBusiness(org.uddi.api_v2.FindRelatedBusinesses body) {
        if (body == null) {
            return null;
        }
        FindRelatedBusinesses r = new FindRelatedBusinesses();
        r.setBusinessKey(body.getBusinessKey());
        r.setFindQualifiers(MapUDDIv2Tov3.MapFindQualifiers(body.getFindQualifiers(), false));
        if (body.getKeyedReference() != null) {
            r.setKeyedReference(new KeyedReference(body.getKeyedReference().getTModelKey(), body.getKeyedReference().getKeyName(), body.getKeyedReference().getKeyValue()));
        }
        r.setMaxRows(body.getMaxRows());
        return r;
    }

    public static FindService MapFindService(org.uddi.api_v2.FindService body) {
        if (body == null) {
            return null;
        }
        FindService r = new FindService();
        r.setBusinessKey(body.getBusinessKey());
        r.setCategoryBag(MapUDDIv2Tov3.MapCategoryBag(body.getCategoryBag()));
        r.setFindQualifiers(MapUDDIv2Tov3.MapFindQualifiers(body.getFindQualifiers(), false));
        r.setMaxRows(body.getMaxRows());
        r.setTModelBag(MapUDDIv2Tov3.MapTModelBag(body.getTModelBag()));
        r.getName().addAll(MapUDDIv2Tov3.MapName(body.getName()));
        if (MapUDDIv2Tov3.ContainsWildCard(r.getName())) {
            r.setFindQualifiers(MapUDDIv2Tov3.AddApproximateMatch(r.getFindQualifiers()));
        }
        return r;
    }

    public static FindTModel MapFindTModel(org.uddi.api_v2.FindTModel body) {
        if (body == null) {
            return null;
        }
        FindTModel r = new FindTModel();
        r.setCategoryBag(MapUDDIv2Tov3.MapCategoryBag(body.getCategoryBag()));
        r.setFindQualifiers(MapUDDIv2Tov3.MapFindQualifiers(body.getFindQualifiers(), false));
        r.setMaxRows(body.getMaxRows());
        if (body.getName() != null) {
            r.setName(new org.uddi.api_v3.Name(body.getName().getValue(), body.getName().getLang()));
        }
        if (MapUDDIv2Tov3.ContainsWildCardSingle(r.getName())) {
            r.setFindQualifiers(MapUDDIv2Tov3.AddApproximateMatch(r.getFindQualifiers()));
        }
        return r;
    }

    public static org.uddi.api_v3.GetBusinessDetail MapGetBusinessDetailExt(GetBusinessDetailExt body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.GetBusinessDetail r = new org.uddi.api_v3.GetBusinessDetail();
        r.getBusinessKey().addAll(body.getBusinessKey());
        return r;
    }

    public static org.uddi.api_v3.GetServiceDetail MapGetServiceDetail(GetServiceDetail body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.GetServiceDetail r = new org.uddi.api_v3.GetServiceDetail();
        r.getServiceKey().addAll(body.getServiceKey());
        return r;
    }

    public static org.uddi.api_v3.GetTModelDetail MapGetTModelDetail(GetTModelDetail body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.GetTModelDetail r = new org.uddi.api_v3.GetTModelDetail();
        r.getTModelKey().addAll(body.getTModelKey());
        return r;
    }

    public static GetBindingDetail MapGetBindingDetail(org.uddi.api_v2.GetBindingDetail body) {
        if (body == null) {
            return null;
        }
        GetBindingDetail r = new GetBindingDetail();
        r.getBindingKey().addAll(body.getBindingKey());
        return r;
    }

    public static org.uddi.api_v3.GetBusinessDetail MapGetBusinessDetail(GetBusinessDetail body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.GetBusinessDetail r = new org.uddi.api_v3.GetBusinessDetail();
        r.getBusinessKey().addAll(body.getBusinessKey());
        return r;
    }

    private static List<SharedRelationships> MapSharedRelationship(List<org.uddi.api_v2.SharedRelationships> sharedRelationships) {
        if (sharedRelationships == null) {
            return null;
        }
        ArrayList<SharedRelationships> r = new ArrayList<SharedRelationships>();
        for (int i = 0; i < sharedRelationships.size(); ++i) {
            SharedRelationships x = new SharedRelationships();
            switch (sharedRelationships.get(i).getDirection()) {
                case FROM_KEY: {
                    x.setDirection(Direction.FROM_KEY);
                    break;
                }
                case TO_KEY: {
                    x.setDirection(Direction.TO_KEY);
                }
            }
            x.getKeyedReference().addAll(MapUDDIv2Tov3.MapKeyedReference(sharedRelationships.get(i).getKeyedReference()));
            r.add(x);
        }
        return r;
    }

    public static DeleteBinding MapDeleteBinding(org.uddi.api_v2.DeleteBinding body) {
        if (body == null) {
            return null;
        }
        DeleteBinding r = new DeleteBinding();
        r.setAuthInfo(body.getAuthInfo());
        r.getBindingKey().addAll(body.getBindingKey());
        return r;
    }

    public static org.uddi.api_v3.DeleteBusiness MapDeleteBusiness(DeleteBusiness body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.DeleteBusiness r = new org.uddi.api_v3.DeleteBusiness();
        r.setAuthInfo(body.getAuthInfo());
        r.getBusinessKey().addAll(body.getBusinessKey());
        return r;
    }

    public static org.uddi.api_v3.DeletePublisherAssertions MapDeletePublisherAssertion(DeletePublisherAssertions body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.DeletePublisherAssertions r = new org.uddi.api_v3.DeletePublisherAssertions();
        r.setAuthInfo(body.getAuthInfo());
        r.getPublisherAssertion().addAll(MapUDDIv2Tov3.MapListPublisherAssertion(body.getPublisherAssertion()));
        return r;
    }

    public static org.uddi.api_v3.DeleteService MapDeleteService(DeleteService body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.DeleteService r = new org.uddi.api_v3.DeleteService();
        r.setAuthInfo(body.getAuthInfo());
        r.getServiceKey().addAll(body.getServiceKey());
        return r;
    }

    public static org.uddi.api_v3.DeleteTModel MapDeleteTModel(DeleteTModel body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.DeleteTModel r = new org.uddi.api_v3.DeleteTModel();
        r.setAuthInfo(body.getAuthInfo());
        r.getTModelKey().addAll(body.getTModelKey());
        return r;
    }

    public static org.uddi.api_v3.SaveTModel MapSaveTModel(SaveTModel body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.SaveTModel r = new org.uddi.api_v3.SaveTModel();
        r.setAuthInfo(body.getAuthInfo());
        for (int i = 0; i < body.getTModel().size(); ++i) {
            r.getTModel().add(MapUDDIv2Tov3.MapTModel(body.getTModel().get(i)));
        }
        return r;
    }

    public static SaveService MapSaveService(org.uddi.api_v2.SaveService body) {
        if (body == null) {
            return null;
        }
        SaveService r = new SaveService();
        r.setAuthInfo(body.getAuthInfo());
        for (int i = 0; i < body.getBusinessService().size(); ++i) {
            r.getBusinessService().add(MapUDDIv2Tov3.MapService(body.getBusinessService().get(i)));
        }
        return r;
    }

    public static org.uddi.api_v3.SaveBusiness MapSaveBusiness(SaveBusiness body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.SaveBusiness r = new org.uddi.api_v3.SaveBusiness();
        r.setAuthInfo(body.getAuthInfo());
        for (int i = 0; i < body.getBusinessEntity().size(); ++i) {
            r.getBusinessEntity().add(MapUDDIv2Tov3.MapBusiness(body.getBusinessEntity().get(i)));
        }
        return r;
    }

    public static GetRegisteredInfo MapGetRegisteredInfo(org.uddi.api_v2.GetRegisteredInfo body) {
        if (body == null) {
            return null;
        }
        GetRegisteredInfo r = new GetRegisteredInfo();
        r.setAuthInfo(body.getAuthInfo());
        r.setInfoSelection(InfoSelection.ALL);
        return r;
    }

    public static org.uddi.api_v3.SaveBinding MapSaveBinding(SaveBinding body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v3.SaveBinding r = new org.uddi.api_v3.SaveBinding();
        r.setAuthInfo(body.getAuthInfo());
        for (int i = 0; i < body.getBindingTemplate().size(); ++i) {
            r.getBindingTemplate().add(MapUDDIv2Tov3.MapBinding(body.getBindingTemplate().get(i)));
        }
        return r;
    }

    public static List<org.uddi.api_v3.PublisherAssertion> MapSetPublisherAssertions(SetPublisherAssertions body) {
        if (body == null) {
            return null;
        }
        return MapUDDIv2Tov3.MapListPublisherAssertion(body.getPublisherAssertion());
    }

    private static boolean ContainsWildCardSingle(org.uddi.api_v3.Name name) {
        if (name != null) {
            if (name.getValue() != null && name.getValue().contains("%")) {
                return true;
            }
            if (name.getValue() != null && name.getValue().contains("_")) {
                return true;
            }
            if (name.getLang() != null && name.getLang().contains("%")) {
                return true;
            }
            if (name.getLang() != null && name.getLang().contains("_")) {
                return true;
            }
        }
        return false;
    }

    public static List<AssertionStatusItem> MapAssertionStatusItems(AssertionStatusReport assertionStatusReport) {
        ArrayList<AssertionStatusItem> r = new ArrayList<AssertionStatusItem>();
        if (assertionStatusReport == null) {
            return r;
        }
        for (int i = 0; i < assertionStatusReport.getAssertionStatusItem().size(); ++i) {
            AssertionStatusItem x = new AssertionStatusItem();
            x.setFromKey(assertionStatusReport.getAssertionStatusItem().get(i).getFromKey());
            x.setToKey(assertionStatusReport.getAssertionStatusItem().get(i).getToKey());
            x.setCompletionStatus(MapUDDIv2Tov3.MapCompletionStatus(assertionStatusReport.getAssertionStatusItem().get(i).getCompletionStatus()));
            x.setKeysOwned(MapUDDIv2Tov3.MapKeysOwned(assertionStatusReport.getAssertionStatusItem().get(i).getKeysOwned()));
            if (assertionStatusReport.getAssertionStatusItem().get(i).getKeyedReference() == null) continue;
            x.setKeyedReference(new KeyedReference(assertionStatusReport.getAssertionStatusItem().get(i).getKeyedReference().getTModelKey(), assertionStatusReport.getAssertionStatusItem().get(i).getKeyedReference().getKeyName(), assertionStatusReport.getAssertionStatusItem().get(i).getKeyedReference().getKeyValue()));
        }
        return r;
    }

    private static KeysOwned MapKeysOwned(org.uddi.api_v2.KeysOwned keysOwned) {
        if (keysOwned == null) {
            return null;
        }
        KeysOwned r = new KeysOwned();
        r.setFromKey(keysOwned.getFromKey());
        r.setToKey(keysOwned.getToKey());
        return r;
    }

    private static org.uddi.api_v3.Contacts MapContacts(Contacts contacts) {
        if (contacts == null) {
            return null;
        }
        org.uddi.api_v3.Contacts c = new org.uddi.api_v3.Contacts();
        c.getContact().addAll(MapUDDIv2Tov3.MapContactList(contacts.getContact()));
        return c;
    }

    private static List<org.uddi.api_v3.Contact> MapContactList(List<Contact> contact) {
        ArrayList<org.uddi.api_v3.Contact> r = new ArrayList<org.uddi.api_v3.Contact>();
        if (contact == null) {
            return r;
        }
        for (int i = 0; i < contact.size(); ++i) {
            org.uddi.api_v3.Contact c = new org.uddi.api_v3.Contact();
            c.setUseType(contact.get(i).getUseType());
            if (contact.get(i).getPersonName() != null) {
                c.getPersonName().add(new PersonName(contact.get(i).getPersonName(), null));
            }
            c.getAddress().addAll(MapUDDIv2Tov3.MapAddress(contact.get(i).getAddress()));
            c.getDescription().addAll(MapUDDIv2Tov3.MapDescription(contact.get(i).getDescription()));
            c.getEmail().addAll(MapUDDIv2Tov3.MapEmail(contact.get(i).getEmail()));
            c.getPhone().addAll(MapUDDIv2Tov3.MapPhone(contact.get(i).getPhone()));
            r.add(c);
        }
        return r;
    }

    private static Collection<? extends org.uddi.api_v3.Address> MapAddress(List<Address> address) {
        ArrayList<org.uddi.api_v3.Address> r = new ArrayList<org.uddi.api_v3.Address>();
        if (address == null) {
            return r;
        }
        for (int i = 0; i < address.size(); ++i) {
            org.uddi.api_v3.Address x = new org.uddi.api_v3.Address();
            x.setSortCode(address.get(i).getSortCode());
            x.setTModelKey(address.get(i).getTModelKey());
            x.setUseType(address.get(i).getUseType());
            x.getAddressLine().addAll(MapUDDIv2Tov3.MapAddressLine(address.get(i).getAddressLine()));
            r.add(x);
        }
        return r;
    }

    private static Collection<? extends Email> MapEmail(List<org.uddi.api_v2.Email> email) {
        ArrayList<Email> r = new ArrayList<Email>();
        if (email == null) {
            return r;
        }
        for (int i = 0; i < email.size(); ++i) {
            Email x = new Email();
            x.setUseType(email.get(i).getUseType());
            x.setValue(email.get(i).getValue());
            r.add(x);
        }
        return r;
    }

    private static Collection<? extends org.uddi.api_v3.Phone> MapPhone(List<Phone> phone) {
        ArrayList<org.uddi.api_v3.Phone> r = new ArrayList<org.uddi.api_v3.Phone>();
        if (phone == null) {
            return r;
        }
        for (int i = 0; i < phone.size(); ++i) {
            org.uddi.api_v3.Phone x = new org.uddi.api_v3.Phone();
            x.setUseType(phone.get(i).getUseType());
            x.setValue(phone.get(i).getValue());
            r.add(x);
        }
        return r;
    }

    private static List<org.uddi.api_v3.AddressLine> MapAddressLine(List<AddressLine> addressLine) {
        ArrayList<org.uddi.api_v3.AddressLine> r = new ArrayList<org.uddi.api_v3.AddressLine>();
        if (addressLine == null) {
            return r;
        }
        for (int i = 0; i < addressLine.size(); ++i) {
            org.uddi.api_v3.AddressLine x = new org.uddi.api_v3.AddressLine();
            x.setKeyName(addressLine.get(i).getKeyName());
            x.setKeyValue(addressLine.get(i).getKeyValue());
            x.setValue(addressLine.get(i).getValue());
            r.add(x);
        }
        return r;
    }

    public static AddPublisherAssertions MapAddPublisherAssertions(org.uddi.api_v2.AddPublisherAssertions body) {
        if (body == null) {
            return null;
        }
        AddPublisherAssertions r = new AddPublisherAssertions();
        r.setAuthInfo(body.getAuthInfo());
        r.getPublisherAssertion().addAll(MapUDDIv2Tov3.MapListPublisherAssertion(body.getPublisherAssertion()));
        return r;
    }

    public static CompletionStatus MapCompletionStatus(String completionStatus) {
        if ("status:complete".equalsIgnoreCase(completionStatus)) {
            return CompletionStatus.STATUS_COMPLETE;
        }
        if ("status:toKey_incomplete".equalsIgnoreCase(completionStatus)) {
            return CompletionStatus.STATUS_TO_KEY_INCOMPLETE;
        }
        if ("status:fromKey_incomplete".equalsIgnoreCase(completionStatus)) {
            return CompletionStatus.STATUS_FROM_KEY_INCOMPLETE;
        }
        return CompletionStatus.STATUS_BOTH_INCOMPLETE;
    }
}

