/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cryptor;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.juddi.v3.client.cryptor.Cryptor;
import org.apache.juddi.v3.client.cryptor.CryptorFactory;

public class TripleDESCrytor
implements Cryptor {
    private static final String UNICODE_FORMAT = "UTF8";
    private static final String DESEDE_ENCRYPTION_SCHEME = "DESede";
    private KeySpec ks;
    private SecretKeyFactory skf;
    private Cipher cipher;
    byte[] arrayBytes;
    private String myEncryptionKey;
    private String myEncryptionScheme;
    SecretKey key;

    public TripleDESCrytor() throws Exception {
        String keyfromfile = CryptorFactory.loadKeyFromFile("TripleDESCrytor");
        this.myEncryptionKey = keyfromfile != null ? keyfromfile : "rioTEBCe/RAHRs6tTyYxDqettnVbZA6z";
        this.myEncryptionScheme = DESEDE_ENCRYPTION_SCHEME;
        this.arrayBytes = this.myEncryptionKey.getBytes(UNICODE_FORMAT);
        this.ks = new DESedeKeySpec(this.arrayBytes);
        this.skf = SecretKeyFactory.getInstance(this.myEncryptionScheme);
        this.cipher = Cipher.getInstance(this.myEncryptionScheme);
        this.key = this.skf.generateSecret(this.ks);
    }

    @Override
    public String encrypt(String clear) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String encryptedString = null;
        try {
            this.cipher.init(1, this.key);
            byte[] plainText = clear.getBytes(UNICODE_FORMAT);
            byte[] encryptedText = this.cipher.doFinal(plainText);
            encryptedString = new String(Base64.encodeBase64(encryptedText));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptedString;
    }

    public static String GEN() {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(DESEDE_ENCRYPTION_SCHEME);
            kgen.init(168);
            SecretKey skey = kgen.generateKey();
            byte[] raw = skey.getEncoded();
            return new String(Base64.encodeBase64(raw));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String decrypt(String str) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String encryptedString = str;
        try {
            this.cipher.init(2, this.key);
            byte[] encryptedText = Base64.decodeBase64(str.getBytes());
            byte[] plainTest = this.cipher.doFinal(encryptedText);
            encryptedString = new String(plainTest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptedString;
    }

    @Override
    public String newKey() {
        return TripleDESCrytor.GEN();
    }
}

