/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cryptor;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.ws.BindingProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportSecurityHelper {
    private static final Log log = LogFactory.getLog(TransportSecurityHelper.class);

    public static boolean applyTransportSecurity(BindingProvider webServicePort) {
        try {
            File currentdir = new File(".");
            String s = System.getProperty("javax.net.ssl.keyStore");
            String st = System.getProperty("javax.net.ssl.trustStore");
            log.info("Attempting to initialize keystore and truststore from " + s + " " + st);
            if (s == null) {
                log.warn("keystore isn't defined! " + s);
                return false;
            }
            if (st == null) {
                log.warn("truststore isn't defined! " + s);
                return false;
            }
            File keystore = new File(s);
            if (keystore == null || !keystore.exists()) {
                log.warn("keystore doesn't exist! input was " + s + " working dir is " + currentdir.getAbsolutePath());
                return false;
            }
            String pwd = System.getProperty("javax.net.ssl.keyStorePassword");
            if (pwd == null) {
                log.warn("keystore password isn't defined!");
                return false;
            }
            File truststore = new File(st);
            if (truststore == null || !truststore.exists()) {
                log.warn("truststore doesn't exist! input was " + s + " working dir is " + currentdir.getAbsolutePath());
                return false;
            }
            String pwdt = System.getProperty("javax.net.ssl.trustStorePassword");
            if (pwdt == null) {
                log.warn("truststore password isn't defined!");
                return false;
            }
            if (keystore.exists()) {
                try {
                    log.info("Using keystore from " + keystore.getAbsolutePath() + " current dir is " + currentdir.getAbsolutePath());
                    log.info("Using truststore from " + truststore.getAbsolutePath() + " current dir is " + currentdir.getAbsolutePath());
                    SSLContext sc = SSLContext.getInstance("SSLv3");
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    ks.load(new FileInputStream(keystore), pwd.toCharArray());
                    kmf.init(ks, pwd.toCharArray());
                    String alg = TrustManagerFactory.getDefaultAlgorithm();
                    TrustManagerFactory tmFact = TrustManagerFactory.getInstance(alg);
                    FileInputStream fis = new FileInputStream(st);
                    KeyStore kst = KeyStore.getInstance("jks");
                    kst.load(fis, pwdt.toCharArray());
                    fis.close();
                    tmFact.init(kst);
                    TrustManager[] tms = tmFact.getTrustManagers();
                    sc.init(kmf.getKeyManagers(), null, null);
                    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                    webServicePort.getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", sc.getSocketFactory());
                    webServicePort.getRequestContext().put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", sc.getSocketFactory());
                    return true;
                }
                catch (Exception ex) {
                    log.warn("unable to establish ssl settings", ex);
                }
            }
            return false;
        }
        catch (Exception x) {
            log.error("unexpected error", x);
            return false;
        }
    }
}

