/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cryptor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.JAXB;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.security.provider.certpath.OCSP;

public class DigSigUtil {
    public static final String SIGNATURE_KEYSTORE_KEY_PASSWORD_PROVIDER = "signatureKeystoreKeyPassENCProvider";
    public static final String SIGNATURE_KEYSTORE_KEY_PASSWORD_WAS_ENC = "signatureKeystoreKeyPassENC";
    public static final String SIGNATURE_KEYSTORE_KEY_PASSWORD_CIPHER = "signatureKeyStoreCipherPass";
    public static final String SIGNATURE_KEYSTORE_FILE_PASSWORD_WASENC = "signatureKeystoreFilePassENC";
    public static final String SIGNATURE_KEYSTORE_FILE_PASSWORD_PROVIDER = "signatureKeystoreFileENCProvider";
    public static final String TRUSTSTORE_FILE_PASSWORD_WASENC = "truststoreFilePassENC";
    public static final String TRUSTSTORE_FILE_PASSWORD_PROVIDER = "truststoreFilePassENCProvider";
    public static final String SIGNATURE_KEYSTORE_FILE_PASSWORD_CIPHER = "signatureKeystoreFileKeyPass";
    public static final String TRUSTSTORE_FILE_PASSWORD_CIPHER = "truststoreFilePass";
    private Log logger = LogFactory.getLog(this.getClass());
    private Properties map = new Properties();
    public static final String SIGNATURE_KEYSTORE_FILE = "keyStorePath";
    public static final String SIGNATURE_KEYSTORE_FILETYPE = "keyStoreType";
    public static final String SIGNATURE_KEYSTORE_FILE_PASSWORD = "filePassword";
    public static final String SIGNATURE_KEYSTORE_KEY_PASSWORD = "keyPassword";
    public static final String SIGNATURE_KEYSTORE_KEY_ALIAS = "keyAlias";
    public static final String TRUSTSTORE_FILE = "trustStorePath";
    public static final String TRUSTSTORE_FILETYPE = "trustStoreType";
    public static final String TRUSTSTORE_FILE_PASSWORD = "trustStorePassword";
    public static final String CANONICALIZATIONMETHOD = "CanonicalizationMethod";
    public static final String SIGNATURE_METHOD = "SignatureMethod";
    public static final String SIGNATURE_OPTION_CERT_INCLUSION_BASE64 = "BASE64";
    public static final String SIGNATURE_OPTION_CERT_INCLUSION_SERIAL = "SERIAL";
    public static final String SIGNATURE_OPTION_CERT_INCLUSION_SUBJECTDN = "SUBJECTDN";
    public static final String XML_DIGSIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String SIGNATURE_OPTION_DIGEST_METHOD = "digestMethod";
    public static final String CHECK_TIMESTAMPS = "checkTimestamps";
    private CertificateFactory cf = CertificateFactory.getInstance("X.509");
    public static final String CHECK_REVOCATION_STATUS_OCSP = "checkRevocationOCSP";
    public static final String CHECK_REVOCATION_STATUS_CRL = "checkRevocationCRL";
    public static final String CHECK_TRUST_CHAIN = "checkTrust";

    public DigSigUtil(Properties config) throws CertificateException {
        this.map = config;
    }

    public DigSigUtil() throws CertificateException {
    }

    public void put(String key, String value) {
        this.map.put(key, value);
    }

    public void clear() {
        this.map.clear();
    }

    public <T> T signUddiEntity(T jaxbObj) {
        DOMResult domResult = new DOMResult();
        JAXB.marshal(jaxbObj, (Result)domResult);
        Document doc = (Document)domResult.getNode();
        Element docElement = doc.getDocumentElement();
        try {
            KeyStore ks = KeyStore.getInstance(this.map.getProperty(SIGNATURE_KEYSTORE_FILETYPE));
            URL url = Thread.currentThread().getContextClassLoader().getResource(this.map.getProperty(SIGNATURE_KEYSTORE_FILE));
            if (url == null) {
                try {
                    url = new File(this.map.getProperty(SIGNATURE_KEYSTORE_FILE)).toURI().toURL();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (url == null) {
                try {
                    url = this.getClass().getClassLoader().getResource(this.map.getProperty(SIGNATURE_KEYSTORE_FILE));
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            KeyStore.PrivateKeyEntry keyEntry = null;
            if (!this.map.getProperty(SIGNATURE_KEYSTORE_FILETYPE).equalsIgnoreCase("WINDOWS-MY")) {
                ks.load(url.openStream(), this.map.getProperty(SIGNATURE_KEYSTORE_FILE_PASSWORD).toCharArray());
                keyEntry = this.map.getProperty(SIGNATURE_KEYSTORE_KEY_PASSWORD) == null ? (KeyStore.PrivateKeyEntry)ks.getEntry(this.map.getProperty(SIGNATURE_KEYSTORE_KEY_ALIAS), new KeyStore.PasswordProtection(this.map.getProperty(SIGNATURE_KEYSTORE_FILE_PASSWORD).toCharArray())) : (KeyStore.PrivateKeyEntry)ks.getEntry(this.map.getProperty(SIGNATURE_KEYSTORE_KEY_ALIAS), new KeyStore.PasswordProtection(this.map.getProperty(SIGNATURE_KEYSTORE_KEY_PASSWORD).toCharArray()));
            } else {
                ks.load(null, null);
                keyEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(this.map.getProperty(SIGNATURE_KEYSTORE_KEY_ALIAS), null);
            }
            PrivateKey privateKey = keyEntry.getPrivateKey();
            Certificate origCert = keyEntry.getCertificate();
            this.signDOM(docElement, privateKey, origCert);
            DOMSource domSource = new DOMSource(doc);
            Object result = JAXB.unmarshal((Source)domSource, jaxbObj.getClass());
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Signature failure due to: " + e.getMessage(), e);
        }
    }

    public <T> T signUddiEntity(T jaxbObj, Certificate publicKey, PrivateKey privateKey) {
        DOMResult domResult = new DOMResult();
        JAXB.marshal(jaxbObj, (Result)domResult);
        Document doc = (Document)domResult.getNode();
        Element docElement = doc.getDocumentElement();
        try {
            this.signDOM(docElement, privateKey, publicKey);
            DOMSource domSource = new DOMSource(doc);
            Object result = JAXB.unmarshal((Source)domSource, jaxbObj.getClass());
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Signature failure due to: " + e.getMessage(), e);
        }
    }

    public static void JAXB_ToStdOut(Object obj) {
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)obj, (Writer)sw);
        System.out.println(sw.toString());
    }

    public static String JAXB_ToString(Object obj) {
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)obj, (Writer)sw);
        return sw.toString();
    }

    public X509Certificate getSigningCertificatePublicKey(Object obj) throws IllegalArgumentException, CertificateException {
        DOMResult domResult = new DOMResult();
        JAXB.marshal((Object)obj, (Result)domResult);
        Document doc = (Document)domResult.getNode();
        Element docElement = doc.getDocumentElement();
        return this.getSigningCertificatePublicKey(docElement);
    }

    private X509Certificate getSigningCertificatePublicKey(Element docElement) throws IllegalArgumentException, CertificateException {
        if (docElement == null) {
            throw new IllegalArgumentException();
        }
        NodeList childNodes = docElement.getChildNodes();
        block0: for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!childNodes.item(i).getNamespaceURI().equalsIgnoreCase(XML_DIGSIG_NS) || !childNodes.item(i).getLocalName().equalsIgnoreCase("Signature")) continue;
            Node sig = childNodes.item(i);
            for (int k = 0; k < sig.getChildNodes().getLength(); ++k) {
                if (!"KeyInfo".equalsIgnoreCase(sig.getChildNodes().item(k).getLocalName())) continue;
                for (int j = 0; j < sig.getChildNodes().item(k).getChildNodes().getLength(); ++j) {
                    if (!"X509Data".equalsIgnoreCase(sig.getChildNodes().item(k).getChildNodes().item(j).getLocalName())) continue;
                    Node X509Data = sig.getChildNodes().item(k).getChildNodes().item(j);
                    for (int x = 0; x < X509Data.getChildNodes().getLength(); ++x) {
                        if (!"X509Certificate".equalsIgnoreCase(X509Data.getChildNodes().item(x).getLocalName())) continue;
                        String c = "-----BEGIN CERTIFICATE-----\n" + X509Data.getChildNodes().item(x).getTextContent() + "\n-----END CERTIFICATE-----";
                        ByteArrayInputStream is = new ByteArrayInputStream(c.getBytes());
                        X509Certificate cert = (X509Certificate)this.cf.generateCertificate(is);
                        this.logger.info("embedded certificate found, X509 public key " + cert.getSubjectDN().toString());
                        return cert;
                    }
                    X509Certificate cert = this.FindCert(X509Data.getChildNodes());
                    if (cert == null) continue;
                    this.logger.info("certificate loaded from local trust store, X509 public key " + cert.getSubjectDN().toString());
                    return cert;
                }
                break block0;
            }
            break;
        }
        return null;
    }

    public boolean verifySignedUddiEntity(Object obj, AtomicReference<String> OutErrorMessage) throws IllegalArgumentException {
        if (OutErrorMessage == null) {
            OutErrorMessage = new AtomicReference();
            OutErrorMessage.set("");
        }
        if (obj == null) {
            throw new IllegalArgumentException("obj");
        }
        try {
            DOMResult domResult = new DOMResult();
            JAXB.marshal((Object)obj, (Result)domResult);
            Document doc = (Document)domResult.getNode();
            Element docElement = doc.getDocumentElement();
            X509Certificate signingcert = this.getSigningCertificatePublicKey(docElement);
            if (signingcert != null) {
                this.logger.info("verifying signature based on X509 public key " + signingcert.getSubjectDN().toString());
                if (this.map.containsKey(CHECK_TIMESTAMPS) && Boolean.parseBoolean(this.map.getProperty(CHECK_TIMESTAMPS))) {
                    signingcert.checkValidity();
                }
                if (this.map.containsKey(CHECK_REVOCATION_STATUS_OCSP) && Boolean.parseBoolean(this.map.getProperty(CHECK_REVOCATION_STATUS_OCSP))) {
                    this.logger.info("verifying revocation status via OSCP for X509 public key " + signingcert.getSubjectDN().toString());
                    X500Principal issuerX500Principal = signingcert.getIssuerX500Principal();
                    this.logger.info("certificate " + signingcert.getSubjectDN().toString() + " was issued by " + issuerX500Principal.getName() + ", attempting to retrieve certificate");
                    Security.setProperty("ocsp.enable", "false");
                    X509Certificate issuer = this.FindCertByDN(issuerX500Principal);
                    if (issuer == null) {
                        OutErrorMessage.set("Unable to verify certificate status from OCSP because the issuer of the certificate is not in the trust store. " + OutErrorMessage.get());
                    } else {
                        OCSP.RevocationStatus check = OCSP.check((X509Certificate)signingcert, (X509Certificate)issuer);
                        this.logger.info("certificate " + signingcert.getSubjectDN().toString() + " revocation status is " + check.getCertStatus().toString() + " reason " + check.getRevocationReason().toString());
                        if (check.getCertStatus() != OCSP.RevocationStatus.CertStatus.GOOD) {
                            OutErrorMessage.set("Certificate status is " + check.getCertStatus().toString() + " reason " + check.getRevocationReason().toString() + "." + OutErrorMessage.get());
                        }
                    }
                }
                if (this.map.containsKey(CHECK_REVOCATION_STATUS_CRL) && Boolean.parseBoolean(this.map.getProperty(CHECK_REVOCATION_STATUS_CRL))) {
                    this.logger.info("verifying revokation status via CRL for X509 public key " + signingcert.getSubjectDN().toString());
                    Security.setProperty("ocsp.enable", "false");
                    System.setProperty("com.sun.security.enableCRLDP", "true");
                    X509CertSelector targetConstraints = new X509CertSelector();
                    targetConstraints.setCertificate(signingcert);
                    PKIXParameters params = new PKIXParameters(this.GetTrustStore());
                    params.setRevocationEnabled(true);
                    CertPath certPath = this.cf.generateCertPath(Arrays.asList(signingcert));
                    CertPathValidator certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
                    CertPathValidatorResult result = certPathValidator.validate(certPath, params);
                    try {
                        PKIXCertPathValidatorResult pkixResult = (PKIXCertPathValidatorResult)result;
                        this.logger.info("revokation status via CRL PASSED for X509 public key " + signingcert.getSubjectDN().toString());
                    }
                    catch (Exception ex) {
                        OutErrorMessage.set("Certificate status is via CRL Failed: " + ex.getMessage() + "." + OutErrorMessage.get());
                    }
                }
                if (this.map.containsKey(CHECK_TRUST_CHAIN) && Boolean.parseBoolean(this.map.getProperty(CHECK_TRUST_CHAIN))) {
                    this.logger.info("verifying trust chain X509 public key " + signingcert.getSubjectDN().toString());
                    try {
                        PKIXParameters params = new PKIXParameters(this.GetTrustStore());
                        params.setRevocationEnabled(false);
                        CertPath certPath = this.cf.generateCertPath(Arrays.asList(signingcert));
                        CertPathValidator certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
                        CertPathValidatorResult result = certPathValidator.validate(certPath, params);
                        PKIXCertPathValidatorResult pkixResult = (PKIXCertPathValidatorResult)result;
                        TrustAnchor ta = pkixResult.getTrustAnchor();
                        X509Certificate cert = ta.getTrustedCert();
                        this.logger.info("trust chain validated X509 public key " + signingcert.getSubjectDN().toString());
                    }
                    catch (Exception ex) {
                        OutErrorMessage.set("Certificate status Trust validation failed: " + ex.getMessage() + "." + OutErrorMessage.get());
                    }
                }
                boolean b = this.verifySignature(docElement, signingcert.getPublicKey(), OutErrorMessage);
                return (OutErrorMessage.get() == null || OutErrorMessage.get().length() == 0) && b;
            }
            this.logger.info("signature did not have an embedded X509 public key. reverting to user specified certificate");
            KeyStore ks = KeyStore.getInstance(this.map.getProperty(SIGNATURE_KEYSTORE_FILETYPE));
            URL url = Thread.currentThread().getContextClassLoader().getResource(this.map.getProperty(SIGNATURE_KEYSTORE_FILE));
            if (url == null) {
                try {
                    url = new File(this.map.getProperty(SIGNATURE_KEYSTORE_FILE)).toURI().toURL();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (url == null) {
                try {
                    url = this.getClass().getClassLoader().getResource(this.map.getProperty(SIGNATURE_KEYSTORE_FILE));
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (url == null) {
                this.logger.error("");
                OutErrorMessage.set("The signed entity is signed but does not have a certificate attached andyou didn't specify a keystore for me to look it up in. " + OutErrorMessage.get());
                return false;
            }
            KeyStore.PrivateKeyEntry keyEntry = null;
            ks.load(url.openStream(), this.map.getProperty(SIGNATURE_KEYSTORE_FILE_PASSWORD).toCharArray());
            keyEntry = this.map.getProperty(SIGNATURE_KEYSTORE_KEY_PASSWORD) == null ? (KeyStore.PrivateKeyEntry)ks.getEntry(this.map.getProperty(SIGNATURE_KEYSTORE_KEY_ALIAS), new KeyStore.PasswordProtection(this.map.getProperty(SIGNATURE_KEYSTORE_FILE_PASSWORD).toCharArray())) : (KeyStore.PrivateKeyEntry)ks.getEntry(this.map.getProperty(SIGNATURE_KEYSTORE_KEY_ALIAS), new KeyStore.PasswordProtection(this.map.getProperty(SIGNATURE_KEYSTORE_KEY_PASSWORD).toCharArray()));
            Certificate origCert = keyEntry.getCertificate();
            if (this.map.containsKey(CHECK_TIMESTAMPS) && origCert.getPublicKey() instanceof X509Certificate) {
                X509Certificate x = (X509Certificate)((Object)origCert.getPublicKey());
                x.checkValidity();
            }
            PublicKey validatingKey = origCert.getPublicKey();
            return this.verifySignature(docElement, validatingKey, OutErrorMessage);
        }
        catch (Exception e) {
            this.logger.error("Error caught validating signature", e);
            OutErrorMessage.set(e.getMessage());
            return false;
        }
    }

    private KeyStore GetTrustStore() throws Exception {
        URL cacerts;
        URL url;
        String type = this.map.getProperty(TRUSTSTORE_FILETYPE);
        if (type == null) {
            type = "JKS";
        }
        KeyStore ks = KeyStore.getInstance(type);
        boolean ksLoaded = false;
        if (!ksLoaded) {
            String truststore = System.getProperty("javax.net.ssl.keyStore");
            try {
                String pwd = System.getProperty("javax.net.ssl.keyStorePassword");
                if (truststore != null && pwd != null) {
                    ks.load(new File(truststore).toURI().toURL().openStream(), pwd.toCharArray());
                    ksLoaded = true;
                    this.logger.info("trust store loaded from sysprop " + truststore);
                }
            }
            catch (Exception ex) {
                this.logger.warn("unable to load truststore from sysprop " + truststore + " " + ex.getMessage());
                this.logger.debug("unable to load truststore from sysprop " + ex.getMessage(), ex);
            }
        }
        File f = new File(this.map.getProperty(TRUSTSTORE_FILE));
        if (!ksLoaded) {
            try {
                if (f.exists()) {
                    url = f.toURI().toURL();
                    ks.load(url.openStream(), this.map.getProperty(TRUSTSTORE_FILE_PASSWORD).toCharArray());
                    ksLoaded = true;
                    this.logger.info("trust store loaded from file " + this.map.getProperty(TRUSTSTORE_FILE));
                }
            }
            catch (Exception x) {
                this.logger.warn("unable to load truststore from file " + this.map.getProperty(TRUSTSTORE_FILE) + " " + x.getMessage());
                this.logger.debug("unable to load truststore from file " + x.getMessage(), x);
            }
        }
        if (!ksLoaded) {
            try {
                if (f.exists()) {
                    FileInputStream fis = new FileInputStream(f);
                    ks.load(fis, this.map.getProperty(TRUSTSTORE_FILE_PASSWORD).toCharArray());
                    fis.close();
                    ksLoaded = true;
                    this.logger.info("trust store loaded from file " + this.map.getProperty(TRUSTSTORE_FILE));
                }
            }
            catch (Exception x) {
                this.logger.warn("unable to load truststore from file " + this.map.getProperty(TRUSTSTORE_FILE) + " " + x.getMessage());
                this.logger.debug("unable to load truststore from file " + x.getMessage(), x);
            }
        }
        if (!ksLoaded) {
            try {
                url = Thread.currentThread().getContextClassLoader().getResource(this.map.getProperty(TRUSTSTORE_FILE));
                ks.load(url.openStream(), this.map.getProperty(TRUSTSTORE_FILE_PASSWORD).toCharArray());
                ksLoaded = true;
                this.logger.info("trust store loaded from classpath(1) " + this.map.getProperty(TRUSTSTORE_FILE));
            }
            catch (Exception x) {
                this.logger.warn("unable to load truststore from classpath" + this.map.getProperty(TRUSTSTORE_FILE) + " " + x.getMessage());
                this.logger.debug("unable to load truststore from classpath", x);
            }
        }
        if (!ksLoaded) {
            try {
                url = this.getClass().getClassLoader().getResource(this.map.getProperty(TRUSTSTORE_FILE));
                ks.load(url.openStream(), this.map.getProperty(TRUSTSTORE_FILE_PASSWORD).toCharArray());
                ksLoaded = true;
                this.logger.info("trust store loaded from classpath(2) " + this.map.getProperty(TRUSTSTORE_FILE));
            }
            catch (Exception x) {
                this.logger.warn("unable to load truststore from classpath " + this.map.getProperty(TRUSTSTORE_FILE) + " " + x.getMessage());
                this.logger.debug("unable to load truststore from classpath", x);
            }
        }
        if (!ksLoaded) {
            try {
                cacerts = new File(System.getenv("JAVA_HOME") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts").toURI().toURL();
                ks.load(cacerts.openStream(), "changeit".toCharArray());
                this.logger.info("trust store loaded from JRE " + cacerts.toExternalForm());
                ksLoaded = true;
            }
            catch (Exception c) {
                this.logger.warn("unable to load default JDK truststore " + c.getMessage());
                this.logger.debug("unable to load default JDK truststore", c);
            }
        }
        try {
            if (this.map.getProperty(TRUSTSTORE_FILETYPE).equalsIgnoreCase("WINDOWS-ROOT")) {
                ks.load(null, null);
                ksLoaded = true;
                this.logger.info("trust store loaded from windows");
            }
        }
        catch (Exception ex) {
            this.logger.warn("unable to load truststore from windows " + ex.getMessage());
            this.logger.debug("unable to load truststore from windows", ex);
        }
        if (!ksLoaded) {
            try {
                cacerts = new File(System.getenv("JAVA_HOME") + File.separator + "jre" + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts").toURI().toURL();
                ks.load(cacerts.openStream(), "changeit".toCharArray());
                this.logger.info("trust store loaded from JRE " + cacerts.toExternalForm());
                ksLoaded = true;
            }
            catch (Exception c) {
                this.logger.warn("unable to load default jdk/jre truststore " + c.getMessage());
                this.logger.debug("unable to load default jdk/jre truststore", c);
            }
        }
        if (!ksLoaded) {
            this.logger.warn("unable to load trust store!");
        }
        return ks;
    }

    private XMLSignatureFactory initXMLSigFactory() {
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance();
        return fac;
    }

    private Reference initReference(XMLSignatureFactory fac) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ArrayList<Transform> transformers = new ArrayList<Transform>();
        transformers.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        String dm = this.map.getProperty(SIGNATURE_OPTION_DIGEST_METHOD);
        if (dm == null) {
            dm = "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        Reference ref = fac.newReference("", fac.newDigestMethod(dm, null), transformers, null, null);
        return ref;
    }

    private SignedInfo initSignedInfo(XMLSignatureFactory fac) throws Exception {
        Reference ref = this.initReference(fac);
        String cm = null;
        cm = this.map.getProperty(CANONICALIZATIONMETHOD);
        String sigmethod = null;
        sigmethod = this.map.getProperty(SIGNATURE_METHOD);
        if (sigmethod == null) {
            sigmethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        if (cm == null) {
            cm = "http://www.w3.org/2001/10/xml-exc-c14n#";
        }
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod(cm, (C14NMethodParameterSpec)null), fac.newSignatureMethod(sigmethod, null), Collections.singletonList(ref));
        return si;
    }

    private boolean verifySignature(Element element, PublicKey validatingKey, AtomicReference<String> OutReadableErrorMessage) {
        if (OutReadableErrorMessage == null) {
            OutReadableErrorMessage = new AtomicReference();
        }
        XMLSignatureFactory fac = this.initXMLSigFactory();
        NodeList nl = element.getElementsByTagNameNS(XML_DIGSIG_NS, "Signature");
        if (nl.getLength() == 0) {
            throw new RuntimeException("Cannot find Signature element");
        }
        DOMValidateContext valContext = new DOMValidateContext(validatingKey, nl.item(0));
        try {
            valContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            boolean coreValidity = signature.validate(valContext);
            if (!coreValidity) {
                this.logger.warn("Signature failed core validation");
                boolean sv = signature.getSignatureValue().validate(valContext);
                this.logger.debug("signature validation status: " + sv);
                OutReadableErrorMessage.set("signature validation failed: " + sv + "." + OutReadableErrorMessage.get());
                Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    Reference ref = i.next();
                    boolean refValid = ref.validate(valContext);
                    this.logger.debug(j);
                    this.logger.debug("ref[" + j + "] validity status: " + refValid);
                    if (!refValid) {
                        OutReadableErrorMessage.set("signature reference " + j + " invalid. " + OutReadableErrorMessage.get());
                    }
                    this.logger.debug("Ref type: " + ref.getType() + ", URI: " + ref.getURI());
                    for (Transform xform : ref.getTransforms()) {
                        this.logger.debug("Transform: " + xform);
                    }
                    String calcDigValStr = this.digestToString(ref.getCalculatedDigestValue());
                    String expectedDigValStr = this.digestToString(ref.getDigestValue());
                    this.logger.warn("    Calc Digest: " + calcDigValStr);
                    this.logger.warn("Expected Digest: " + expectedDigValStr);
                    if (!calcDigValStr.equalsIgnoreCase(expectedDigValStr)) {
                        OutReadableErrorMessage.set("digest mismatch for signature ref " + j + "." + OutReadableErrorMessage.get());
                    }
                    ++j;
                }
            } else {
                this.logger.info("Signature passed core validation");
            }
            return coreValidity;
        }
        catch (Exception e) {
            OutReadableErrorMessage.set("signature validation failed: " + e.getMessage() + OutReadableErrorMessage.get());
            this.logger.fatal(e);
            return false;
        }
    }

    private String digestToString(byte[] digest) {
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private void signDOM(Node node, PrivateKey privateKey, Certificate origCert) {
        X509Data xd;
        XMLSignatureFactory fac = this.initXMLSigFactory();
        X509Certificate cert = (X509Certificate)origCert;
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Object> x509Content = null;
        ArrayList<X509Data> data = new ArrayList<X509Data>();
        if (this.map.containsKey(SIGNATURE_OPTION_CERT_INCLUSION_SUBJECTDN)) {
            x509Content = new ArrayList<Object>();
            x509Content.add(cert.getSubjectDN().getName());
            xd = kif.newX509Data(x509Content);
            data.add(xd);
        }
        if (this.map.containsKey(SIGNATURE_OPTION_CERT_INCLUSION_BASE64)) {
            x509Content = new ArrayList();
            x509Content.add(cert);
            xd = kif.newX509Data(x509Content);
            data.add(xd);
        }
        if (this.map.containsKey(SIGNATURE_OPTION_CERT_INCLUSION_SERIAL)) {
            x509Content = new ArrayList();
            X509IssuerSerial issuer = kif.newX509IssuerSerial(cert.getIssuerX500Principal().getName(), cert.getSerialNumber());
            x509Content.add(issuer);
            X509Data xd2 = kif.newX509Data(x509Content);
            data.add(xd2);
        }
        KeyInfo ki = kif.newKeyInfo(data);
        DOMSignContext dsc = new DOMSignContext(privateKey, node);
        dsc.putNamespacePrefix(XML_DIGSIG_NS, "ns2");
        try {
            SignedInfo si = this.initSignedInfo(fac);
            XMLSignature signature = fac.newXMLSignature(si, ki);
            signature.sign(dsc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private X509Certificate FindCert(NodeList childNodes) {
        try {
            for (int x = 0; x < childNodes.getLength(); ++x) {
                if (childNodes.item(x).getLocalName().equalsIgnoreCase("X509SubjectName")) {
                    String dn = childNodes.item(x).getTextContent().trim();
                    return this.FindCertByDN(new X500Principal(dn));
                }
                if (!childNodes.item(x).getLocalName().equalsIgnoreCase("X509IssuerSerial")) continue;
                String X509IssuerName = null;
                String X509SerialNumber = null;
                for (int k = 0; k < childNodes.item(x).getChildNodes().getLength(); ++k) {
                    if (childNodes.item(x).getChildNodes().item(x).getLocalName().equalsIgnoreCase("X509IssuerName")) {
                        X509IssuerName = childNodes.item(x).getTextContent().trim();
                    }
                    if (!childNodes.item(x).getChildNodes().item(x).getLocalName().equalsIgnoreCase("X509SerialNumber")) continue;
                    X509SerialNumber = childNodes.item(x).getTextContent().trim();
                }
                if (X509IssuerName == null || X509SerialNumber == null) continue;
                return this.FindCertByIssuer(X509IssuerName, X509SerialNumber);
            }
        }
        catch (Exception ex) {
            this.logger.warn("error caught searching for a certificate", ex);
        }
        return null;
    }

    private X509Certificate FindCertByDN(X500Principal name) throws Exception {
        KeyStore ks = this.GetTrustStore();
        if (ks == null) {
            return null;
        }
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String nextElement = aliases.nextElement();
            Certificate certificate = ks.getCertificate(nextElement);
            X509Certificate x = (X509Certificate)certificate;
            if (!x.getSubjectX500Principal().equals(name)) continue;
            return x;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509CRL downloadCRLFromWeb(String crlURL) throws MalformedURLException, IOException, CertificateException, CRLException {
        URL url = new URL(crlURL);
        try (InputStream crlStream = url.openStream();){
            X509CRL crl;
            X509CRL x509CRL = crl = (X509CRL)this.cf.generateCRL(crlStream);
            return x509CRL;
        }
    }

    private X509Certificate FindCertByIssuer(String X509IssuerName, String X509SerialNumber) throws Exception {
        KeyStore ks = this.GetTrustStore();
        if (ks == null) {
            return null;
        }
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String nextElement = aliases.nextElement();
            Certificate certificate = ks.getCertificate(nextElement);
            X509Certificate x = (X509Certificate)certificate;
            if (!x.getIssuerDN().getName().equals(X509IssuerName) || !x.getSerialNumber().toString().equalsIgnoreCase(X509SerialNumber)) continue;
            return x;
        }
        return null;
    }
}

