/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.io.Serializable;
import java.util.Properties;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.TransportException;

public class UDDINode
implements Serializable {
    private static final long serialVersionUID = 5721040459195558161L;
    private Properties properties;
    private Transport transport;
    private boolean isHomeJUDDI;
    private String name;
    private String clientName;
    private String description;
    private String custodyTransferUrl;
    private String inquiryUrl;
    private String inquiryRESTUrl;
    private String publishUrl;
    private String securityUrl;
    private String replicationUrl;
    private String subscriptionUrl;
    private String subscriptionListenerUrl;
    private String juddiApiUrl;
    private String proxyTransport;
    private String factoryInitial;
    private String factoryURLPkgs;
    private String factoryNamingProvider;

    public UDDINode() {
    }

    public UDDINode(Node node) {
        this.name = node.getName();
        this.clientName = node.getClientName();
        this.description = node.getDescription();
        this.custodyTransferUrl = node.getCustodyTransferUrl();
        this.inquiryUrl = node.getInquiryUrl();
        this.publishUrl = node.getPublishUrl();
        this.securityUrl = node.getSecurityUrl();
        this.subscriptionUrl = node.getSubscriptionUrl();
        this.subscriptionListenerUrl = node.getSubscriptionListenerUrl();
        this.replicationUrl = node.getReplicationUrl();
        this.juddiApiUrl = node.getJuddiApiUrl();
        this.proxyTransport = node.getProxyTransport();
        this.factoryInitial = node.getFactoryInitial();
        this.factoryURLPkgs = node.getFactoryURLPkgs();
        this.factoryNamingProvider = node.getFactoryNamingProvider();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Node getApiNode() {
        Node apiNode = new Node();
        apiNode.setClientName(this.clientName);
        apiNode.setCustodyTransferUrl(this.custodyTransferUrl);
        apiNode.setDescription(this.description);
        apiNode.setFactoryInitial(this.factoryInitial);
        apiNode.setFactoryNamingProvider(this.factoryNamingProvider);
        apiNode.setFactoryURLPkgs(this.factoryURLPkgs);
        apiNode.setInquiryUrl(this.inquiryUrl);
        apiNode.setJuddiApiUrl(this.juddiApiUrl);
        apiNode.setName(this.name);
        apiNode.setProxyTransport(this.proxyTransport);
        apiNode.setPublishUrl(this.publishUrl);
        apiNode.setReplicationUrl(this.replicationUrl);
        apiNode.setSecurityUrl(this.securityUrl);
        apiNode.setSubscriptionUrl(this.subscriptionUrl);
        apiNode.setSubscriptionListenerUrl(this.subscriptionListenerUrl);
        return apiNode;
    }

    public Transport getTransport() throws TransportException {
        if (this.transport == null) {
            String clazz = this.getProxyTransport();
            try {
                Class<?> transportClass = ClassUtil.forName(clazz, this.getClass());
                this.transport = (Transport)transportClass.getConstructor(String.class, String.class).newInstance(this.clientName, this.name);
            }
            catch (Exception e) {
                throw new TransportException(e.getMessage() + " node " + this.name + " transport class: " + clazz, e);
            }
        }
        return this.transport;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCustodyTransferUrl() {
        return this.custodyTransferUrl;
    }

    public void setCustodyTransferUrl(String custodyTransferUrl) {
        this.custodyTransferUrl = custodyTransferUrl;
    }

    public String getInquiryUrl() {
        return this.inquiryUrl;
    }

    public String getReplicationUrl() {
        return this.replicationUrl;
    }

    public void setReplicationUrl(String value) {
        this.replicationUrl = value;
    }

    public void setInquiryRESTUrl(String url) {
        this.inquiryRESTUrl = url;
    }

    public String getInquiry_REST_Url() {
        return this.inquiryRESTUrl;
    }

    public void setInquiryUrl(String inquiryUrl) {
        this.inquiryUrl = inquiryUrl;
    }

    public String getPublishUrl() {
        return this.publishUrl;
    }

    public void setPublishUrl(String publishUrl) {
        this.publishUrl = publishUrl;
    }

    public String getSecurityUrl() {
        return this.securityUrl;
    }

    public void setSecurityUrl(String securityUrl) {
        this.securityUrl = securityUrl;
    }

    public String getSubscriptionUrl() {
        return this.subscriptionUrl;
    }

    public void setSubscriptionUrl(String subscriptionUrl) {
        this.subscriptionUrl = subscriptionUrl;
    }

    public String getSubscriptionListenerUrl() {
        return this.subscriptionListenerUrl;
    }

    public void setSubscriptionListenerUrl(String subscriptionListenerUrl) {
        this.subscriptionListenerUrl = subscriptionListenerUrl;
    }

    public String getJuddiApiUrl() {
        return this.juddiApiUrl;
    }

    public void setJuddiApiUrl(String juddiApiUrl) {
        this.juddiApiUrl = juddiApiUrl;
    }

    public String getProxyTransport() {
        return this.proxyTransport;
    }

    public void setProxyTransport(String proxyTransport) {
        this.proxyTransport = proxyTransport;
    }

    public String getFactoryInitial() {
        return this.factoryInitial;
    }

    public void setFactoryInitial(String factoryInitial) {
        this.factoryInitial = factoryInitial;
    }

    public String getFactoryURLPkgs() {
        return this.factoryURLPkgs;
    }

    public void setFactoryURLPkgs(String factoryURLPkgs) {
        this.factoryURLPkgs = factoryURLPkgs;
    }

    public String getFactoryNamingProvider() {
        return this.factoryNamingProvider;
    }

    public void setFactoryNamingProvider(String factoryNamingProvider) {
        this.factoryNamingProvider = factoryNamingProvider;
    }

    public boolean isHomeJUDDI() {
        return this.isHomeJUDDI;
    }

    public void setHomeJUDDI(boolean isHomeJUDDI) {
        this.isHomeJUDDI = isHomeJUDDI;
    }
}

