/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.Definition;
import javax.xml.ws.Holder;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.api_v3.Clerk;
import org.apache.juddi.api_v3.ClerkDetail;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.api_v3.NodeDetail;
import org.apache.juddi.api_v3.SaveClerk;
import org.apache.juddi.api_v3.SaveNode;
import org.apache.juddi.v3.client.config.UDDINode;
import org.apache.juddi.v3.client.cryptor.CryptorFactory;
import org.apache.juddi.v3.client.mapping.URLLocalizerDefaultImpl;
import org.apache.juddi.v3.client.mapping.wsdl.ReadWSDL;
import org.apache.juddi.v3.client.mapping.wsdl.WSDL2UDDI;
import org.apache.juddi.v3.client.transport.TransportException;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.BusinessServices;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DiscardAuthToken;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.Result;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.api_v3.TModelList;
import org.uddi.sub_v3.DeleteSubscription;
import org.uddi.sub_v3.Subscription;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class UDDIClerk
implements Serializable {
    private static final long serialVersionUID = -8597375975981358134L;
    private Log log = LogFactory.getLog(this.getClass());
    protected String name;
    protected UDDINode uddiNode;
    protected String publisher;
    protected String password;
    private Date tokenBirthDate;
    private String authToken;
    private String cryptoProvider;
    private boolean isencrypted = false;
    private String[] classWithAnnotations;
    private WSDL[] wsdls;
    private String managerName;
    private Map<String, Properties> services = new HashMap<String, Properties>();
    Map<String, UDDINode> nodecache = new HashMap<String, UDDINode>();

    public UDDIClerk() {
    }

    public UDDIClerk(Clerk clerk) {
        this.name = clerk.getName();
        this.password = clerk.getPassword();
        this.publisher = clerk.getPublisher();
        this.uddiNode = new UDDINode(clerk.getNode());
    }

    public String[] getClassWithAnnotations() {
        return this.classWithAnnotations;
    }

    public UDDINode getUDDINode() {
        return this.uddiNode;
    }

    public UDDINode getUDDINode(Node apinode) {
        if (apinode == null) {
            return this.uddiNode;
        }
        if (this.nodecache.containsKey(apinode.getClientName() + apinode + this.getName())) {
            return this.nodecache.get(apinode.getClientName() + apinode + this.getName());
        }
        UDDINode node = new UDDINode(apinode);
        this.nodecache.put(apinode.getClientName() + apinode + this.getName(), node);
        return node;
    }

    public void setClassWithAnnotations(String[] classWithAnnotations) {
        this.classWithAnnotations = classWithAnnotations;
    }

    @Deprecated
    public Map<String, Properties> getServices() {
        return this.services;
    }

    @Deprecated
    public void setServices(Map<String, Properties> services) {
        this.services = services;
    }

    public String getManagerName() {
        return this.managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public void registerWsdls() {
        this.registerWsdls(null);
    }

    public void registerWsdls(URL localizerBaseUrl) {
        if (this.getWsdls() != null) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.getUDDINode().getProperties());
            for (WSDL wsdl : this.getWsdls()) {
                try {
                    URL wsdlUrl = this.getClass().getClassLoader().getResource(wsdl.getFileName());
                    ReadWSDL rw = new ReadWSDL();
                    Definition wsdlDefinition = rw.readWSDL(wsdlUrl);
                    if (wsdl.keyDomain != null) {
                        properties.setProperty("keyDomain", wsdl.keyDomain);
                    }
                    if (wsdl.businessKey != null) {
                        properties.setProperty("businessKey", wsdl.getBusinessKey());
                    }
                    WSDL2UDDI wsdl2UDDI = new WSDL2UDDI(this, new URLLocalizerDefaultImpl(localizerBaseUrl), properties);
                    wsdl2UDDI.registerBusinessServices(wsdlDefinition);
                }
                catch (Exception e) {
                    this.log.error("Unable to register wsdl " + wsdl.getFileName() + " ." + e.getMessage(), e);
                }
                catch (Throwable t) {
                    this.log.error("Unable to register wsdl " + wsdl.getFileName() + " ." + t.getMessage(), t);
                }
            }
        }
    }

    public void registerWsdls(Definition wsdlDefinition, String keyDomain, String businessKey) {
        try {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.getUDDINode().getProperties());
            if (keyDomain != null) {
                properties.setProperty("keyDomain", keyDomain);
            }
            if (businessKey != null) {
                properties.setProperty("businessKey", businessKey);
            }
            WSDL2UDDI wsdl2UDDI = new WSDL2UDDI(this, new URLLocalizerDefaultImpl(), properties);
            wsdl2UDDI.registerBusinessServices(wsdlDefinition);
        }
        catch (Exception e) {
            this.log.error("Unable to register wsdl  ." + e.getMessage(), e);
        }
        catch (Throwable t) {
            this.log.error("Unable to register wsdl  ." + t.getMessage(), t);
        }
    }

    public void unRegisterWsdls() {
        if (this.getWsdls() != null) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.getUDDINode().getProperties());
            for (WSDL wsdl : this.getWsdls()) {
                try {
                    URL wsdlUrl = this.getClass().getClassLoader().getResource(wsdl.getFileName());
                    ReadWSDL rw = new ReadWSDL();
                    Definition wsdlDefinition = rw.readWSDL(wsdlUrl);
                    if (wsdl.keyDomain != null) {
                        properties.setProperty("keyDomain", wsdl.keyDomain);
                    }
                    if (wsdl.businessKey != null) {
                        properties.setProperty("businessKey", wsdl.getBusinessKey());
                    }
                    WSDL2UDDI wsdl2UDDI = new WSDL2UDDI(this, new URLLocalizerDefaultImpl(), properties);
                    wsdl2UDDI.unRegisterBusinessServices(wsdlDefinition);
                }
                catch (Exception e) {
                    this.log.error("Unable to register wsdl " + wsdl.getFileName() + " ." + e.getMessage(), e);
                }
                catch (Throwable t) {
                    this.log.error("Unable to register wsdl " + wsdl.getFileName() + " ." + t.getMessage(), t);
                }
            }
        }
    }

    public Subscription register(Subscription subscription) {
        return this.register(subscription, this.getUDDINode().getApiNode());
    }

    public Subscription register(Subscription subscription, Node node) {
        this.log.info("Registering subscription with key " + subscription.getSubscriptionKey());
        Holder holder = new Holder();
        try {
            ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
            subscriptions.add(subscription);
            holder.value = subscriptions;
            this.getUDDINode(node).getTransport().getUDDISubscriptionService(node.getSubscriptionUrl()).saveSubscription(this.getAuthToken(node.getSecurityUrl()), (Holder<List<Subscription>>)holder);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registering subscription " + subscription.getSubscriptionKey() + " completed.");
            }
        }
        catch (Exception e) {
            this.log.error("Unable to register subscription " + subscription.getSubscriptionKey() + " ." + e.getMessage(), e);
        }
        catch (Throwable t) {
            this.log.error("Unable to register subscriptionl " + subscription.getSubscriptionKey() + " ." + t.getMessage(), t);
        }
        subscription = (Subscription)((List)holder.value).get(0);
        return subscription;
    }

    public TModelDetail register(TModel tModel) {
        return this.register(tModel, this.getUDDINode().getApiNode());
    }

    public TModelDetail register(TModel tModel, Node node) {
        TModelDetail tModelDetail = null;
        this.log.info("Registering tModel with key " + tModel.getTModelKey());
        try {
            SaveTModel saveTModel = new SaveTModel();
            saveTModel.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
            saveTModel.getTModel().add(tModel);
            tModelDetail = this.getUDDINode(node).getTransport().getUDDIPublishService(node.getPublishUrl()).saveTModel(saveTModel);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registering tModel " + tModel.getTModelKey() + " completed.");
            }
        }
        catch (Exception e) {
            this.log.error("Unable to register tModel " + tModel.getTModelKey() + " ." + e.getMessage(), e);
        }
        catch (Throwable t) {
            this.log.error("Unable to register tModel " + tModel.getTModelKey() + " ." + t.getMessage(), t);
        }
        return tModelDetail;
    }

    public BindingTemplate register(BindingTemplate binding) {
        return this.register(binding, this.getUDDINode().getApiNode());
    }

    public BindingTemplate register(BindingTemplate binding, Node node) {
        BindingTemplate bindingTemplate = null;
        this.log.info("Registering bindingTemplate with key " + binding.getBindingKey());
        try {
            SaveBinding saveBinding = new SaveBinding();
            saveBinding.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
            saveBinding.getBindingTemplate().add(binding);
            BindingDetail bindingDetail = this.getUDDINode(node).getTransport().getUDDIPublishService(node.getPublishUrl()).saveBinding(saveBinding);
            bindingTemplate = bindingDetail.getBindingTemplate().get(0);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registering template binding " + bindingTemplate.getBindingKey() + " completed.");
            }
        }
        catch (Exception e) {
            this.log.error("Unable to register template binding " + binding.getBindingKey() + " ." + e.getMessage(), e);
        }
        catch (Throwable t) {
            this.log.error("Unable to register template binding " + binding.getBindingKey() + " ." + t.getMessage(), t);
        }
        return bindingTemplate;
    }

    public BusinessService register(BusinessService service) {
        return this.register(service, this.getUDDINode().getApiNode());
    }

    public BusinessService register(BusinessService service, Node node) {
        BusinessService businessService = null;
        if (service.getName().isEmpty()) {
            this.log.error("Unable to register service, a 'name' element is required");
            return null;
        }
        this.log.info("Registering service " + service.getName().get(0).getValue() + " with key " + service.getServiceKey());
        try {
            SaveService saveService = new SaveService();
            saveService.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
            saveService.getBusinessService().add(service);
            ServiceDetail serviceDetail = this.getUDDINode(node).getTransport().getUDDIPublishService(node.getPublishUrl()).saveService(saveService);
            businessService = serviceDetail.getBusinessService().get(0);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registering service " + service.getName().get(0).getValue() + " completed.");
            }
        }
        catch (Exception e) {
            this.log.error("Unable to register service " + service.getName().get(0).getValue() + " ." + e.getMessage(), e);
        }
        catch (Throwable t) {
            this.log.error("Unable to register service " + service.getName().get(0).getValue() + " ." + t.getMessage(), t);
        }
        return businessService;
    }

    public BusinessEntity register(BusinessEntity business) {
        return this.register(business, this.getUDDINode().getApiNode());
    }

    public BusinessEntity register(BusinessEntity business, Node node) {
        if (business.getName().get(0) == null) {
            this.log.error("Unable to register business because no Name elements have been added.");
            return null;
        }
        BusinessEntity businessEntity = null;
        this.log.info("Registering business " + business.getName().get(0).getValue() + " with key " + business.getBusinessKey());
        try {
            SaveBusiness saveBusiness = new SaveBusiness();
            saveBusiness.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
            saveBusiness.getBusinessEntity().add(business);
            BusinessDetail businessDetail = this.getUDDINode(node).getTransport().getUDDIPublishService(node.getPublishUrl()).saveBusiness(saveBusiness);
            businessEntity = businessDetail.getBusinessEntity().get(0);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registering businessEntity " + businessEntity.getName().get(0).getValue() + " completed.");
            }
        }
        catch (Exception e) {
            this.log.error("Unable to register business " + business.getName().get(0).getValue() + " ." + e.getMessage(), e);
        }
        catch (Throwable t) {
            this.log.error("Unable to register business " + business.getName().get(0).getValue() + " ." + t.getMessage(), t);
        }
        return businessEntity;
    }

    public void unRegisterBusiness(String businessKey) {
        this.unRegisterBusiness(businessKey, this.getUDDINode().getApiNode());
    }

    public void unRegisterBusiness(String businessKey, Node node) {
        this.log.info("UnRegistering the business " + businessKey);
        try {
            DeleteBusiness deleteBusiness = new DeleteBusiness();
            deleteBusiness.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
            deleteBusiness.getBusinessKey().add(businessKey);
            this.getUDDINode(node).getTransport().getUDDIPublishService(node.getPublishUrl()).deleteBusiness(deleteBusiness);
        }
        catch (Exception e) {
            this.log.error("Unable to register service " + businessKey + " ." + e.getMessage(), e);
        }
    }

    public void unRegisterService(String serviceKey) {
        this.unRegisterService(serviceKey, this.getUDDINode().getApiNode());
    }

    public void unRegisterService(String serviceKey, Node node) {
        this.log.info("UnRegistering the service " + serviceKey);
        try {
            DeleteService deleteService = new DeleteService();
            deleteService.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
            deleteService.getServiceKey().add(serviceKey);
            this.getUDDINode(node).getTransport().getUDDIPublishService(node.getPublishUrl()).deleteService(deleteService);
        }
        catch (Exception e) {
            this.log.error("Unable to register service " + serviceKey + " ." + e.getMessage(), e);
        }
    }

    public void unRegisterBinding(String bindingKey) {
        this.unRegisterBinding(bindingKey, this.getUDDINode().getApiNode());
    }

    public void unRegisterBinding(String bindingKey, Node node) {
        this.log.info("UnRegistering binding key " + bindingKey);
        try {
            DeleteBinding deleteBinding = new DeleteBinding();
            deleteBinding.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
            deleteBinding.getBindingKey().add(bindingKey);
            this.getUDDINode(node).getTransport().getUDDIPublishService(node.getPublishUrl()).deleteBinding(deleteBinding);
        }
        catch (Exception e) {
            this.log.error("Unable to unregister bindingkey " + bindingKey + " ." + e.getMessage(), e);
        }
    }

    public void unRegisterTModel(String tModelKey) {
        this.unRegisterTModel(tModelKey, this.getUDDINode().getApiNode());
    }

    public void unRegisterTModel(String tModelKey, Node node) {
        this.log.info("UnRegistering tModel key " + tModelKey);
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            DeleteTModel deleteTModel = new DeleteTModel();
            deleteTModel.setAuthInfo(authToken);
            deleteTModel.getTModelKey().add(tModelKey);
            this.getUDDINode(node).getTransport().getUDDIPublishService(node.getPublishUrl()).deleteTModel(deleteTModel);
        }
        catch (Exception e) {
            this.log.error("Unable to unregister tModelkey " + tModelKey + " ." + e.getMessage(), e);
        }
    }

    public void unRegisterSubscription(String subscriptionKey) {
        this.unRegisterSubscription(subscriptionKey, this.getUDDINode().getApiNode());
    }

    public void unRegisterSubscription(String subscriptionKey, Node node) {
        this.log.info("UnRegistering subscription with key " + subscriptionKey);
        try {
            String authToken = this.getAuthToken(node.getSecurityUrl());
            DeleteSubscription deleteSubscription = new DeleteSubscription();
            deleteSubscription.setAuthInfo(authToken);
            deleteSubscription.getSubscriptionKey().add(subscriptionKey);
            this.getUDDINode(node).getTransport().getUDDISubscriptionService(node.getSubscriptionUrl()).deleteSubscription(deleteSubscription);
        }
        catch (Exception e) {
            this.log.error("Unable to unregister subscription key " + subscriptionKey + " ." + e.getMessage(), e);
        }
    }

    public TModelList findTModel(FindTModel findTModel) throws RemoteException, ConfigurationException, TransportException {
        return this.findTModel(findTModel, this.getUDDINode().getApiNode());
    }

    public TModelList findTModel(FindTModel findTModel, Node node) throws RemoteException, TransportException, ConfigurationException {
        findTModel.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
        try {
            TModelList tModelList = this.getUDDINode(node).getTransport().getUDDIInquiryService(node.getInquiryUrl()).findTModel(findTModel);
            return tModelList;
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(dr);
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(ute);
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (Throwable t) {
            throw new RemoteException("Unhandled exception", t);
        }
        return null;
    }

    public TModelDetail getTModelDetail(String tModelKey) throws RemoteException, ConfigurationException, TransportException {
        GetTModelDetail getTModelDetail = new GetTModelDetail();
        getTModelDetail.getTModelKey().add(tModelKey);
        return this.getTModelDetail(getTModelDetail);
    }

    public TModelDetail getTModelDetail(GetTModelDetail getTModelDetail) throws RemoteException, ConfigurationException, TransportException {
        return this.getTModelDetail(getTModelDetail, this.getUDDINode().getApiNode());
    }

    public TModelDetail getTModelDetail(GetTModelDetail getTModelDetail, Node node) throws RemoteException, TransportException, ConfigurationException {
        getTModelDetail.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
        try {
            TModelDetail tModelDetail = this.getUDDINode(node).getTransport().getUDDIInquiryService(node.getInquiryUrl()).getTModelDetail(getTModelDetail);
            return tModelDetail;
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(dr);
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(ute);
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (Throwable t) {
            throw new RemoteException("Unhandled exception", t);
        }
        return null;
    }

    public BusinessService getServiceDetail(String serviceKey) throws RemoteException, TransportException, ConfigurationException {
        return this.getServiceDetail(serviceKey, this.getUDDINode().getApiNode());
    }

    @Deprecated
    public BusinessService findService(String serviceKey) throws RemoteException, TransportException, ConfigurationException {
        return this.getServiceDetail(serviceKey, this.getUDDINode().getApiNode());
    }

    @Deprecated
    public BusinessService findService(String serviceKey, Node node) throws RemoteException, TransportException, ConfigurationException {
        return this.getServiceDetail(serviceKey, node);
    }

    public BusinessService getServiceDetail(String serviceKey, Node node) throws RemoteException, TransportException, ConfigurationException {
        GetServiceDetail getServiceDetail = new GetServiceDetail();
        getServiceDetail.getServiceKey().add(serviceKey);
        getServiceDetail.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
        try {
            ServiceDetail sd = this.getUDDINode(node).getTransport().getUDDIInquiryService(node.getInquiryUrl()).getServiceDetail(getServiceDetail);
            List<BusinessService> businessServiceList = sd.getBusinessService();
            if (businessServiceList.size() == 0) {
                throw new ConfigurationException("Could not find Service with key=" + serviceKey);
            }
            return businessServiceList.get(0);
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(dr);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", serviceKey);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", serviceKey);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(ute);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", serviceKey);
        }
        catch (Throwable t) {
            throw new RemoteException("Unhandled exception", t);
        }
        return null;
    }

    @Deprecated
    public BindingTemplate findServiceBinding(String bindingKey) throws DispositionReportFaultMessage, RemoteException, TransportException, ConfigurationException {
        return this.getServiceBindingDetail(bindingKey, this.getUDDINode().getApiNode());
    }

    public BindingTemplate getServiceBindingDetail(String bindingKey) throws DispositionReportFaultMessage, RemoteException, TransportException, ConfigurationException {
        return this.getServiceBindingDetail(bindingKey, this.getUDDINode().getApiNode());
    }

    @Deprecated
    public BindingTemplate findServiceBinding(String bindingKey, Node node) throws DispositionReportFaultMessage, RemoteException, TransportException, ConfigurationException {
        return this.getServiceBindingDetail(bindingKey, node);
    }

    public BindingTemplate getServiceBindingDetail(String bindingKey, Node node) throws DispositionReportFaultMessage, RemoteException, TransportException, ConfigurationException {
        GetBindingDetail getBindingDetail = new GetBindingDetail();
        getBindingDetail.getBindingKey().add(bindingKey);
        getBindingDetail.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
        try {
            BindingDetail bd = this.getUDDINode(node).getTransport().getUDDIInquiryService(node.getInquiryUrl()).getBindingDetail(getBindingDetail);
            List<BindingTemplate> bindingTemplateList = bd.getBindingTemplate();
            if (bindingTemplateList.size() == 0) {
                throw new ConfigurationException("Could not find ServiceBinding with key=" + bindingKey);
            }
            return bindingTemplateList.get(0);
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(dr);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", bindingKey);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", bindingKey);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(ute);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", bindingKey);
        }
        catch (Throwable t) {
            throw new RemoteException("Unhandled exception", t);
        }
        return null;
    }

    @Deprecated
    public BusinessEntity findBusiness(String businessKey) throws RemoteException, TransportException, ConfigurationException {
        return this.getBusinessDetail(businessKey, this.getUDDINode().getApiNode());
    }

    @Deprecated
    public BusinessEntity findBusiness(String businessKey, Node node) throws RemoteException, TransportException, ConfigurationException {
        return this.getBusinessDetail(businessKey, node);
    }

    public BusinessEntity getBusinessDetail(String businessKey) throws RemoteException, TransportException, ConfigurationException {
        return this.getBusinessDetail(businessKey, this.getUDDINode().getApiNode());
    }

    public BusinessEntity getBusinessDetail(String businessKey, Node node) throws RemoteException, TransportException, ConfigurationException {
        GetBusinessDetail getBusinessDetail = new GetBusinessDetail();
        getBusinessDetail.getBusinessKey().add(businessKey);
        getBusinessDetail.setAuthInfo(node.getSecurityUrl());
        try {
            BusinessDetail bd = this.getUDDINode(node).getTransport().getUDDIInquiryService(node.getInquiryUrl()).getBusinessDetail(getBusinessDetail);
            return bd.getBusinessEntity().get(0);
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(dr);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(ute);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        catch (Throwable t) {
            throw new RemoteException("Unhandled exception", t);
        }
        return null;
    }

    public RelatedBusinessesList findRelatedBusinesses(String businessKey, Node node) throws RemoteException, TransportException, ConfigurationException {
        FindRelatedBusinesses findRelatedBusinesses = new FindRelatedBusinesses();
        findRelatedBusinesses.setBusinessKey(businessKey);
        findRelatedBusinesses.setAuthInfo(node.getSecurityUrl());
        try {
            RelatedBusinessesList rbl = this.getUDDINode(node).getTransport().getUDDIInquiryService(node.getInquiryUrl()).findRelatedBusinesses(findRelatedBusinesses);
            return rbl;
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(dr);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(ute);
            this.checkForErrorInDispositionReport(report, "E_invalidKeyPassed", businessKey);
        }
        catch (Throwable t) {
            throw new RemoteException("Unhandled exception", t);
        }
        return null;
    }

    private void checkForErrorInDispositionReport(DispositionReport report, String Error2, String entityKey) {
        if (entityKey != null && report != null && report.countainsErrorCode("E_invalidKeyPassed")) {
            this.log.info("entityKey " + entityKey + " was not found in the registry");
        } else if (report == null) {
            this.log.info("Missing DispositionReport");
        } else {
            for (Result result : report.getResult()) {
                this.log.error(result.getErrInfo().getErrCode() + " " + result.getErrInfo().getValue());
            }
        }
    }

    public void discardAuthToken() {
        this.discardAuthToken(this.authToken);
    }

    public void discardAuthToken(String token) {
        if (token != null) {
            try {
                DiscardAuthToken discardAuthToken = new DiscardAuthToken();
                discardAuthToken.setAuthInfo(token);
                this.getUDDINode().getTransport().getUDDISecurityService(this.getUDDINode().getSecurityUrl()).discardAuthToken(discardAuthToken);
                token = null;
            }
            catch (Exception ex) {
                this.log.warn("Error discarding auth token: " + ex.getMessage());
                this.log.debug("Error discarding auth token: " + ex.getMessage(), ex);
            }
        }
    }

    public void discardAuthToken(String token, String endpoint) {
        if (token != null) {
            try {
                DiscardAuthToken discardAuthToken = new DiscardAuthToken();
                discardAuthToken.setAuthInfo(token);
                this.getUDDINode().getTransport().getUDDISecurityService(endpoint).discardAuthToken(discardAuthToken);
                token = null;
            }
            catch (Exception ex) {
                this.log.warn("Error discarding auth token: " + ex.getMessage());
                this.log.debug("Error discarding auth token: " + ex.getMessage(), ex);
            }
        }
    }

    public String getAuthToken() throws TransportException, DispositionReportFaultMessage, RemoteException {
        return this.getAuthToken(this.getUDDINode().getSecurityUrl());
    }

    public String getAuthToken(String endpointURL) throws TransportException, DispositionReportFaultMessage, RemoteException {
        if (this.authToken != null && !"".equals(this.authToken) && this.tokenBirthDate != null && System.currentTimeMillis() > this.tokenBirthDate.getTime() + 600000L) {
            DiscardAuthToken discardAuthToken = new DiscardAuthToken();
            discardAuthToken.setAuthInfo(this.authToken);
            this.getUDDINode().getTransport().getUDDISecurityService(endpointURL).discardAuthToken(discardAuthToken);
            this.authToken = null;
        }
        if (this.authToken == null || "".equals(this.authToken)) {
            if (this.getPublisher() == null || this.getPassword() == null) {
                this.log.warn("No credentials provided for login!");
                return null;
            }
            this.tokenBirthDate = new Date();
            GetAuthToken getAuthToken = new GetAuthToken();
            getAuthToken.setUserID(this.getPublisher());
            if (this.isencrypted) {
                if (this.cryptoProvider == null) {
                    this.log.fatal("Credentials are encrypted but no cryptoProvider was defined in the config file!");
                } else {
                    try {
                        getAuthToken.setCred(CryptorFactory.getCryptor(this.cryptoProvider).decrypt(this.getPassword()));
                    }
                    catch (Exception ex) {
                        this.log.fatal("Unable to decrypt credentials! sending it as is", ex);
                        getAuthToken.setCred(this.getPassword());
                    }
                }
            } else {
                this.log.warn("Hey, I couldn't help but notice that your credentials aren't encrypted. Please consider doing so");
                getAuthToken.setCred(this.getPassword());
            }
            this.authToken = this.getUDDINode().getTransport().getUDDISecurityService(endpointURL).getAuthToken(getAuthToken).getAuthInfo();
        }
        return this.authToken;
    }

    public NodeDetail saveNode(Node node) {
        NodeDetail nodeDetail = null;
        try {
            this.log.info("Sending Node " + node.getName() + " info to jUDDI " + this.getUDDINode(node).getName());
            SaveNode saveNode = new SaveNode();
            saveNode.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
            saveNode.getNode().add(node);
            nodeDetail = this.getUDDINode(node).getTransport().getJUDDIApiService(node.getJuddiApiUrl()).saveNode(saveNode);
        }
        catch (Exception e) {
            this.log.error("Unable to save node " + node.getName() + " ." + e.getMessage(), e);
        }
        catch (Throwable t) {
            this.log.error("Unable to save node " + node.getName() + " ." + t.getMessage(), t);
        }
        return nodeDetail;
    }

    public ClerkDetail saveClerk(UDDIClerk senderClerk) {
        ClerkDetail clerkDetail = null;
        try {
            this.log.debug("Sending Clerk " + senderClerk.getName() + " info to jUDDI " + this.getUDDINode().getName());
            SaveClerk saveClerk = new SaveClerk();
            saveClerk.setAuthInfo(this.getAuthToken(senderClerk.getUDDINode().getSecurityUrl()));
            saveClerk.getClerk().add(this.getApiClerk());
            clerkDetail = this.getUDDINode().getTransport().getJUDDIApiService(senderClerk.getUDDINode().getJuddiApiUrl()).saveClerk(saveClerk);
        }
        catch (Exception e) {
            this.log.error("Unable to save clerk " + this.getName() + " ." + e.getMessage(), e);
        }
        catch (Throwable t) {
            this.log.error("Unable to save clerk " + this.getName() + " ." + t.getMessage(), t);
        }
        return clerkDetail;
    }

    public Clerk getApiClerk() {
        Clerk apiClerk = new Clerk();
        apiClerk.setName(this.name);
        apiClerk.setNode(this.uddiNode.getApiNode());
        apiClerk.setPassword(this.password);
        apiClerk.setPublisher(this.publisher);
        return apiClerk;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUDDINode(UDDINode uddiNode) {
        this.uddiNode = uddiNode;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getPassword() {
        if (this.isencrypted) {
            try {
                return CryptorFactory.getCryptor(this.cryptoProvider).decrypt(this.password);
            }
            catch (Exception ex) {
                this.log.fatal("Unable to decrypt the password", ex);
            }
        }
        return this.password;
    }

    public String getRawPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public WSDL[] getWsdls() {
        return this.wsdls;
    }

    public void setWsdls(WSDL[] wsdls) {
        this.wsdls = wsdls;
    }

    public void setCryptoProvider(String clazz) {
        this.cryptoProvider = clazz;
    }

    public void setIsPasswordEncrypted(boolean option) {
        this.isencrypted = option;
    }

    public String getCryptoProvider() {
        return this.cryptoProvider;
    }

    public boolean getIsPasswordEncrypted() {
        return this.isencrypted;
    }

    public static TModel createKeyGenator(String partitionName, String DescriptiveName, String DescriptiveNameLanguage) {
        if (partitionName == null || partitionName.length() == 0 || partitionName.length() > 255) {
            throw new IllegalArgumentException();
        }
        if (DescriptiveName == null || DescriptiveName.length() == 0 || DescriptiveName.length() > 255) {
            throw new IllegalArgumentException();
        }
        if (!partitionName.startsWith("uddi:")) {
            partitionName = "uddi:" + partitionName;
        }
        if (!partitionName.endsWith(":keygenerator")) {
            partitionName = partitionName + ":keygenerator";
        }
        TModel tm = new TModel();
        tm.setName(new Name());
        tm.getName().setValue(DescriptiveName);
        tm.getName().setLang(DescriptiveNameLanguage);
        tm.setCategoryBag(new CategoryBag());
        KeyedReference kr = new KeyedReference();
        kr.setTModelKey("uddi:uddi.org:keygenerator");
        kr.setKeyName("uddi.org:keygenerator");
        kr.setKeyValue("keyGenerator");
        tm.getCategoryBag().getKeyedReference().add(kr);
        OverviewDoc overviewDoc = new OverviewDoc();
        OverviewURL overviewUrl = new OverviewURL();
        overviewUrl.setUseType("text");
        overviewUrl.setValue("http://uddi.org/pubs/uddi_v3.htm#keyGen");
        overviewDoc.setOverviewURL(overviewUrl);
        tm.getOverviewDoc().add(overviewDoc);
        tm.setTModelKey(partitionName.toLowerCase());
        return tm;
    }

    public static TModelInstanceInfo createServiceInterfaceVersion(String version, String lang) throws IllegalArgumentException {
        if (version == null) {
            throw new IllegalArgumentException();
        }
        TModelInstanceInfo tt = new TModelInstanceInfo();
        tt.setTModelKey("urn:uddi:uddi.org:version");
        tt.setInstanceDetails(new InstanceDetails());
        tt.getInstanceDetails().setInstanceParms(version);
        OverviewDoc doc = new OverviewDoc();
        doc.setOverviewURL(new OverviewURL("http://www.ibm.com/developerworks/webservices/library/ws-version/", "text"));
        doc.getDescription().add(new Description("Describes a version associated with either a service interface, a bindingTemplate service instance.", lang));
        tt.getDescription().add(new Description("Describes a version associated with either a service interface, a bindingTemplate service instance.", lang));
        tt.getInstanceDetails().getOverviewDoc().add(doc);
        return tt;
    }

    public static Set<BindingTemplate> getBindingByVersion(String version, List<BindingTemplate> bindingTemplate) throws IllegalArgumentException {
        if (version == null) {
            throw new IllegalArgumentException();
        }
        if (bindingTemplate == null) {
            throw new IllegalArgumentException();
        }
        HashSet<BindingTemplate> ret = new HashSet<BindingTemplate>();
        block0: for (int i = 0; i < bindingTemplate.size(); ++i) {
            if (bindingTemplate.get(i).getTModelInstanceDetails() == null) continue;
            for (int k = 0; k < bindingTemplate.get(i).getTModelInstanceDetails().getTModelInstanceInfo().size(); ++k) {
                if (!bindingTemplate.get(i).getTModelInstanceDetails().getTModelInstanceInfo().get(k).getTModelKey().equalsIgnoreCase("urn:uddi:uddi.org:version") || bindingTemplate.get(i).getTModelInstanceDetails().getTModelInstanceInfo().get(k).getInstanceDetails() == null || bindingTemplate.get(i).getTModelInstanceDetails().getTModelInstanceInfo().get(k).getInstanceDetails().getInstanceParms() == null || !bindingTemplate.get(i).getTModelInstanceDetails().getTModelInstanceInfo().get(k).getInstanceDetails().getInstanceParms().trim().equalsIgnoreCase(version.trim())) continue;
                ret.add(bindingTemplate.get(i));
                continue block0;
            }
        }
        return ret;
    }

    public List<String> getEndpoints(String serviceKey) {
        ArrayList<String> items = new ArrayList<String>();
        BusinessService serviceDetail = null;
        try {
            serviceDetail = this.getServiceDetail(serviceKey);
        }
        catch (Exception ex) {
            this.log.error("Unable to fetch the specified service's details", ex);
        }
        if (serviceDetail == null) {
            return items;
        }
        if (serviceDetail.getBindingTemplates() != null) {
            for (int k = 0; k < serviceDetail.getBindingTemplates().getBindingTemplate().size(); ++k) {
                try {
                    items.addAll(this.ParseBinding(serviceDetail.getBindingTemplates().getBindingTemplate().get(k)));
                    continue;
                }
                catch (Exception ex) {
                    this.log.warn(ex);
                }
            }
        }
        return items;
    }

    private List<String> GetBindingInfo(String value) throws Exception {
        ArrayList<String> items = new ArrayList<String>();
        if (value == null) {
            return items;
        }
        GetBindingDetail b = new GetBindingDetail();
        b.setAuthInfo(this.getAuthToken(this.getApiClerk().getNode().getSecurityUrl()));
        b.getBindingKey().add(value);
        BindingDetail bindingDetail = this.getUDDINode().getTransport().getUDDIInquiryService(this.getApiClerk().getNode().getInquiryUrl()).getBindingDetail(b);
        for (int i = 0; i < bindingDetail.getBindingTemplate().size(); ++i) {
            items.addAll(this.ParseBinding(bindingDetail.getBindingTemplate().get(i)));
        }
        return items;
    }

    private List<String> ParseBinding(BindingTemplate get) throws Exception {
        ArrayList<String> items = new ArrayList<String>();
        if (get == null || get.getAccessPoint() == null) {
            return items;
        }
        if (get.getHostingRedirector() != null) {
            items.addAll(this.GetBindingInfo(get.getHostingRedirector().getBindingKey()));
        }
        if (get.getAccessPoint() != null) {
            String usetype = get.getAccessPoint().getUseType();
            if (usetype == null) {
                items.add(get.getAccessPoint().getValue());
            } else if (usetype.equalsIgnoreCase(AccessPointType.BINDING_TEMPLATE.toString())) {
                items.addAll(this.GetBindingInfo(get.getAccessPoint().getValue()));
            } else if (usetype.equalsIgnoreCase(AccessPointType.HOSTING_REDIRECTOR.toString())) {
                items.addAll(this.GetBindingInfo(get.getAccessPoint().getValue()));
            } else if (usetype.equalsIgnoreCase(AccessPointType.WSDL_DEPLOYMENT.toString())) {
                items.addAll(this.FetchWSDL(get.getAccessPoint().getValue()));
            } else if (usetype.equalsIgnoreCase(AccessPointType.END_POINT.toString())) {
                items.add(get.getAccessPoint().getValue());
            } else {
                this.log.info("Unable to figure out the useType for " + get.getAccessPoint().getValue());
                items.add(get.getAccessPoint().getValue());
            }
        }
        return items;
    }

    private List<String> FetchWSDL(String value) {
        ArrayList<String> items = new ArrayList<String>();
        if (value.startsWith("http://") || value.startsWith("https://")) {
            ReadWSDL r = new ReadWSDL();
            r.setIgnoreSSLErrors(true);
            try {
                Definition wsdlDefinition = r.readWSDL(new URL(value));
                Properties properties = new Properties();
                properties.put("keyDomain", "domain");
                properties.put("businessName", "biz");
                properties.put("serverName", "localhost");
                properties.put("serverPort", "80");
                WSDL2UDDI wsdl2UDDI = new WSDL2UDDI(null, new URLLocalizerDefaultImpl(), properties);
                BusinessServices businessServices = wsdl2UDDI.createBusinessServices(wsdlDefinition);
                for (int i = 0; i < businessServices.getBusinessService().size(); ++i) {
                    if (businessServices.getBusinessService().get(i).getBindingTemplates() == null) continue;
                    for (int k = 0; k < businessServices.getBusinessService().get(i).getBindingTemplates().getBindingTemplate().size(); ++k) {
                        items.addAll(this.ParseBinding(businessServices.getBusinessService().get(i).getBindingTemplates().getBindingTemplate().get(k)));
                    }
                }
            }
            catch (Exception ex) {
                this.log.error(ex);
            }
        }
        return items;
    }

    public ServiceDetail getServiceDetail(GetServiceDetail getDetail) throws RemoteException, ConfigurationException, TransportException {
        return this.getServiceDetail(getDetail, this.getUDDINode().getApiNode());
    }

    public ServiceDetail getServiceDetail(GetServiceDetail getDetail, Node node) throws RemoteException, TransportException, ConfigurationException {
        getDetail.setAuthInfo(this.getAuthToken(node.getSecurityUrl()));
        try {
            ServiceDetail tModelDetail = this.getUDDINode(node).getTransport().getUDDIInquiryService(node.getInquiryUrl()).getServiceDetail(getDetail);
            return tModelDetail;
        }
        catch (DispositionReportFaultMessage dr) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(dr);
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (SOAPFaultException sfe) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)((Object)sfe));
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (UndeclaredThrowableException ute) {
            DispositionReport report = DispositionReportFaultMessage.getDispositionReport(ute);
            this.checkForErrorInDispositionReport(report, null, null);
        }
        catch (Throwable t) {
            throw new RemoteException("Unhandled exception", t);
        }
        return null;
    }

    public class WSDL {
        private String businessKey;
        private String keyDomain;
        private String fileName;

        public String getBusinessKey() {
            return this.businessKey;
        }

        public void setBusinessKey(String businessKey) {
            this.businessKey = businessKey;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getKeyDomain() {
            return this.keyDomain;
        }

        public void setKeyDomain(String keyDomain) {
            this.keyDomain = keyDomain;
        }
    }
}

