/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.compare;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.TModelInstanceDetails;

public class TModelInstanceDetailsComparator {
    DatatypeFactory fac = null;
    String compareField = null;
    boolean isNumber = false;
    boolean isDate = false;
    boolean isDuration = false;

    public TModelInstanceDetailsComparator(String TModelKey, boolean number, boolean XMLdate, boolean XMLduration) throws DatatypeConfigurationException, IllegalArgumentException {
        if (TModelKey == null || TModelKey.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.compareField = TModelKey;
        if (!(number || XMLdate || XMLduration)) {
            throw new IllegalArgumentException("only one data type can be selected");
        }
        if (number && XMLdate && !XMLduration) {
            throw new IllegalArgumentException("only one data type can be selected");
        }
        if (number && !XMLdate && XMLduration) {
            throw new IllegalArgumentException("only one data type can be selected");
        }
        if (!number && XMLdate && XMLduration) {
            throw new IllegalArgumentException("only one data type can be selected");
        }
        if (number && XMLdate && XMLduration) {
            throw new IllegalArgumentException("only one data type can be selected");
        }
        this.fac = DatatypeFactory.newInstance();
        this.isNumber = number;
        this.isDate = XMLdate;
        this.isDuration = XMLduration;
    }

    public int compare(TModelInstanceDetails lhs, TModelInstanceDetails rhs) throws IllegalArgumentException, NumberFormatException, NullPointerException, ArrayIndexOutOfBoundsException {
        int i;
        if (lhs == null) {
            throw new IllegalArgumentException("lhs");
        }
        if (rhs == null) {
            throw new IllegalArgumentException("rhs");
        }
        if (lhs.getTModelInstanceInfo().isEmpty() || rhs.getTModelInstanceInfo().isEmpty()) {
            throw new IllegalArgumentException("no data to compare");
        }
        InstanceDetails lhsc = null;
        InstanceDetails rhsc = null;
        for (i = 0; i < lhs.getTModelInstanceInfo().size(); ++i) {
            if (!lhs.getTModelInstanceInfo().get(i).getTModelKey().equalsIgnoreCase(this.compareField)) continue;
            lhsc = lhs.getTModelInstanceInfo().get(i).getInstanceDetails();
        }
        for (i = 0; i < rhs.getTModelInstanceInfo().size(); ++i) {
            if (!rhs.getTModelInstanceInfo().get(i).getTModelKey().equalsIgnoreCase(this.compareField)) continue;
            rhsc = rhs.getTModelInstanceInfo().get(i).getInstanceDetails();
        }
        if (lhsc == null) {
            throw new IllegalArgumentException(this.compareField + " not found for lhs");
        }
        if (rhsc == null) {
            throw new IllegalArgumentException(this.compareField + " not found for rhs");
        }
        if (lhsc.getInstanceParms() == null) {
            throw new IllegalArgumentException(this.compareField + " found lhs, but no data");
        }
        if (rhsc.getInstanceParms() == null) {
            throw new IllegalArgumentException(this.compareField + " found rhs, but no data");
        }
        if (this.isNumber) {
            Double l = Double.parseDouble(lhsc.getInstanceParms());
            Double r = Double.parseDouble(rhsc.getInstanceParms());
            return l.compareTo(r);
        }
        if (this.isDate) {
            XMLGregorianCalendar r;
            XMLGregorianCalendar l = this.fac.newXMLGregorianCalendar(lhsc.getInstanceParms());
            int x = l.compare(r = this.fac.newXMLGregorianCalendar(rhsc.getInstanceParms()));
            if (x == -1) {
                return -1;
            }
            if (x == 1) {
                return 1;
            }
            if (x == 0) {
                return 0;
            }
            throw new ArrayIndexOutOfBoundsException("cannot compare, result was " + x);
        }
        if (this.isDuration) {
            Duration r;
            Duration l = this.fac.newDuration(lhsc.getInstanceParms());
            int x = l.compare(r = this.fac.newDuration(rhsc.getInstanceParms()));
            if (x == -1) {
                return -1;
            }
            if (x == 1) {
                return 1;
            }
            if (x == 0) {
                return 0;
            }
            throw new ArrayIndexOutOfBoundsException("cannot compare, result was " + x);
        }
        return 0;
    }
}

