/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.quarkus;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.microshed.testing.ManuallyStartedConfiguration;
import org.microshed.testing.jupiter.MicroShedTest;
import org.microshed.testing.jwt.JwtBuilder;
import org.microshed.testing.testcontainers.config.TestcontainersConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class QuarkusConfiguration
extends TestcontainersConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(QuarkusConfiguration.class);

    public boolean isAvailable() {
        try {
            Class.forName("io.quarkus.test.junit.QuarkusTest");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int getPriority() {
        return -5;
    }

    public boolean configureRestAssured() {
        return false;
    }

    public String getApplicationURL() {
        try {
            String testUrl = System.getProperty("test.url", "");
            if (!testUrl.isEmpty()) {
                return testUrl;
            }
            Properties props = new Properties();
            props.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("application.properties"));
            String testPort = props.getProperty("quarkus.http.test-port", "");
            if (!testPort.isEmpty()) {
                return "http://localhost:" + testPort;
            }
            testPort = props.getProperty("%test.quarkus.http.port", "");
            if (!testPort.isEmpty()) {
                return "http://localhost:" + testPort;
            }
            return "http://localhost:8081/";
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to determine Quarkus application URL", e);
            }
            return "";
        }
    }

    public void applyConfiguration(Class<?> testClass) {
        if (this.allContainers().size() > 0) {
            boolean foundQuarkusTest = false;
            for (Annotation anno : testClass.getAnnotations()) {
                if (anno.annotationType().getCanonicalName().equals("io.quarkus.test.junit.QuarkusTest")) {
                    foundQuarkusTest = true;
                    continue;
                }
                if (!foundQuarkusTest || !anno.annotationType().equals(MicroShedTest.class)) continue;
                throw new ExtensionConfigurationException("Must speciy @MicroShedTest annotation before @QuarkusTest so external services can be started and discovered before Quarkus starts.");
            }
        }
        String appUrl = this.getApplicationURL();
        LOG.info("Using Quarkus application URL: " + appUrl);
        ManuallyStartedConfiguration.setRuntimeURL((String)appUrl);
        super.applyConfiguration(testClass);
    }

    public void start() {
        super.start();
        this.autoConfigureDatabases();
        this.autoConfigureKafka();
        this.autoConfigureMongoDB();
    }

    private void autoConfigureJwt() {
        if (System.getProperty("mp.jwt.verify.publickey") != null || System.getProperty("mp.jwt.verify.publickey.location") != null) {
            return;
        }
        try {
            Class.forName("org.eclipse.microprofile.jwt.JsonWebToken");
        }
        catch (Throwable ignore) {
            return;
        }
        System.setProperty("mp.jwt.verify.publickey", JwtBuilder.getPublicKey());
        System.setProperty("mp.jwt.verify.issuer", "http://testissuer.com");
        System.setProperty("quarkus.smallrye-jwt.enabled", "true");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring mp.jwt.verify.publickey=" + JwtBuilder.getPublicKey());
        }
    }

    private void autoConfigureDatabases() {
        if (System.getProperty("quarkus.datasource.url") != null || System.getProperty("quarkus.datasource.username") != null || System.getProperty("quarkus.datasource.password") != null) {
            return;
        }
        try {
            Class<?> JdbcContainerClass = Class.forName("org.testcontainers.containers.JdbcDatabaseContainer");
            List jdbcContainers = this.allContainers().stream().filter(c -> JdbcContainerClass.isAssignableFrom(c.getClass())).collect(Collectors.toList());
            if (jdbcContainers.size() == 1) {
                GenericContainer db = (GenericContainer)jdbcContainers.get(0);
                String jdbcUrl = (String)JdbcContainerClass.getMethod("getJdbcUrl", new Class[0]).invoke((Object)db, new Object[0]);
                System.setProperty("quarkus.datasource.url", jdbcUrl);
                System.setProperty("quarkus.datasource.username", (String)JdbcContainerClass.getMethod("getUsername", new Class[0]).invoke((Object)db, new Object[0]));
                System.setProperty("quarkus.datasource.password", (String)JdbcContainerClass.getMethod("getPassword", new Class[0]).invoke((Object)db, new Object[0]));
                if (LOG.isInfoEnabled()) {
                    LOG.info("Set quarkus.datasource.url to: " + jdbcUrl);
                }
            } else if (jdbcContainers.size() > 1) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Located multiple JdbcDatabaseContainer instances. Unable to auto configure quarkus.datasource.* properties");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No JdbcDatabaseContainer instances found in configuration");
            }
        }
        catch (ClassNotFoundException | LinkageError JdbcContainerClass) {
        }
        catch (Exception e) {
            LOG.debug("Unable to configure Quarkus with JDBC container", (Throwable)e);
        }
    }

    private void autoConfigureKafka() {
        String KAFKA_PROP = "kafka.bootstrap.servers";
        if (System.getProperty("kafka.bootstrap.servers") != null) {
            return;
        }
        try {
            Class<?> KafkaContainerClass = Class.forName("org.testcontainers.containers.KafkaContainer");
            List kafkaContainers = this.allContainers().stream().filter(c -> KafkaContainerClass.isAssignableFrom(c.getClass())).collect(Collectors.toList());
            if (kafkaContainers.size() == 1) {
                GenericContainer kafka = (GenericContainer)kafkaContainers.get(0);
                String bootstrapServers = (String)KafkaContainerClass.getMethod("getBootstrapServers", new Class[0]).invoke((Object)kafka, new Object[0]);
                System.setProperty("kafka.bootstrap.servers", bootstrapServers);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Set kafka.bootstrap.servers=" + bootstrapServers);
                }
            } else if (kafkaContainers.size() > 1) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Located multiple KafkaContainer instances. Unable to auto configure 'kafka.bootstrap.servers' property");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No KafkaContainer instances found in configuration");
            }
        }
        catch (ClassNotFoundException | LinkageError KafkaContainerClass) {
        }
        catch (Exception e) {
            LOG.debug("Unable to configure Quarkus with Kafka container", (Throwable)e);
        }
    }

    private void autoConfigureMongoDB() {
        if (System.getProperty("quarkus.mongodb.connection-string") != null || System.getProperty("quarkus.mongodb.hosts") != null) {
            return;
        }
        try {
            List mongoContainers = this.allContainers().stream().filter(c -> c.getClass().equals(GenericContainer.class)).filter(c -> c.getDockerImageName().startsWith("mongo:")).collect(Collectors.toList());
            if (mongoContainers.size() == 1) {
                GenericContainer mongo = (GenericContainer)mongoContainers.get(0);
                String mongoHost = mongo.getContainerIpAddress() + ':' + mongo.getFirstMappedPort();
                System.setProperty("quarkus.mongodb.hosts", mongoHost);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Set quarkus.mongodb.hosts=" + mongoHost);
                }
            } else if (mongoContainers.size() > 1) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Located multiple MongoDB instances. Unable to auto configure 'quarkus.mongodb.hosts' property");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No KafkaContainer instances found in configuration");
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to configure Quarkus with MongoDB container", (Throwable)e);
        }
    }
}

