/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.jupiter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.microshed.testing.ApplicationEnvironment;
import org.microshed.testing.SharedContainerConfig;
import org.microshed.testing.internal.InternalLogger;
import org.microshed.testing.jaxrs.BasicAuthConfig;
import org.microshed.testing.jaxrs.RESTClient;
import org.microshed.testing.jaxrs.RestClientBuilder;
import org.microshed.testing.jupiter.KafkaConfigAnnotationProcessor;
import org.microshed.testing.jwt.JwtBuilder;
import org.microshed.testing.jwt.JwtConfig;
import org.microshed.testing.kafka.KafkaConsumerClient;
import org.microshed.testing.kafka.KafkaProducerClient;

public class MicroShedTestExtension
implements BeforeAllCallback {
    private static final InternalLogger LOG = InternalLogger.get(MicroShedTestExtension.class);

    public void beforeAll(ExtensionContext context) throws Exception {
        this.beforeAll(context.getRequiredTestClass());
    }

    public void beforeAll(Class<?> testClass) throws Exception {
        if (testClass.isAnnotationPresent(SharedContainerConfig.class)) {
            Class.forName(testClass.getAnnotation(SharedContainerConfig.class).value().getName());
        }
        ApplicationEnvironment config = ApplicationEnvironment.Resolver.load();
        LOG.info("Using ApplicationEnvironment class: " + config.getClass().getCanonicalName());
        config.preConfigure(testClass);
        config.start();
        MicroShedTestExtension.postConfigure(testClass, config);
    }

    public static void postConfigure(Class<?> testClass, ApplicationEnvironment env) {
        MicroShedTestExtension.configureRestAssured(env);
        MicroShedTestExtension.injectRestClients(testClass);
        MicroShedTestExtension.injectKafkaClients(testClass);
        env.postConfigure(testClass);
    }

    private static void injectRestClients(Class<?> clazz) {
        ArrayList restClientFields = new ArrayList();
        restClientFields.addAll(AnnotationSupport.findAnnotatedFields(clazz, RESTClient.class));
        MicroShedTestExtension.getMpRestClient().ifPresent(mpRestClient -> restClientFields.addAll(AnnotationSupport.findAnnotatedFields((Class)clazz, (Class)mpRestClient)));
        if (restClientFields.size() == 0) {
            return;
        }
        for (Field restClientField : restClientFields) {
            if (!Modifier.isPublic(restClientField.getModifiers()) || !Modifier.isStatic(restClientField.getModifiers()) || Modifier.isFinal(restClientField.getModifiers())) {
                throw new ExtensionConfigurationException("REST client field must be public, static, and non-final: " + restClientField);
            }
            RestClientBuilder rcBuilder = new RestClientBuilder();
            JwtConfig jwtAnno = restClientField.getDeclaredAnnotation(JwtConfig.class);
            BasicAuthConfig basicAnno = restClientField.getDeclaredAnnotation(BasicAuthConfig.class);
            if (jwtAnno != null && basicAnno != null) {
                throw new ExtensionConfigurationException("Can only use one of @JwtConfig or @BasicAuthConfig on REST client field: " + restClientField);
            }
            if (jwtAnno != null) {
                try {
                    String jwt = JwtBuilder.buildJwt(jwtAnno.subject(), jwtAnno.issuer(), jwtAnno.claims());
                    rcBuilder.withJwt(jwt);
                }
                catch (Exception e) {
                    throw new ExtensionConfigurationException("Error while building JWT for field " + restClientField + " with JwtConfig: " + jwtAnno, (Throwable)e);
                }
            }
            if (basicAnno != null) {
                rcBuilder.withBasicAuth(basicAnno.user(), basicAnno.password());
            }
            Object restClient = rcBuilder.build(restClientField.getType());
            try {
                restClientField.set(null, restClient);
                LOG.debug("Injected rest client for " + restClientField);
            }
            catch (Exception e) {
                throw new ExtensionConfigurationException("Unable to inject field " + restClientField, (Throwable)e);
            }
        }
    }

    private static void injectKafkaClients(Class<?> clazz) {
        Class<?> KafkaProducer = MicroShedTestExtension.tryLoad("org.apache.kafka.clients.producer.KafkaProducer");
        Class<?> KafkaConsumer = MicroShedTestExtension.tryLoad("org.apache.kafka.clients.consumer.KafkaConsumer");
        if (KafkaProducer == null || KafkaConsumer == null) {
            return;
        }
        KafkaConfigAnnotationProcessor kafkaProcessor = new KafkaConfigAnnotationProcessor();
        List kafkaProducerFields = AnnotationSupport.findAnnotatedFields(clazz, KafkaProducerClient.class);
        for (Field producerField : kafkaProducerFields) {
            if (!KafkaProducer.isAssignableFrom(producerField.getType())) {
                throw new ExtensionConfigurationException("Fields annotated with @KafkaProducerClient must be of the type " + KafkaProducer.getName());
            }
            if (!Modifier.isPublic(producerField.getModifiers()) || !Modifier.isStatic(producerField.getModifiers()) || Modifier.isFinal(producerField.getModifiers())) {
                throw new ExtensionConfigurationException("The KafkaProducer field annotated with @KafkaProducerClient must be public, static, and non-final: " + producerField);
            }
            Properties properties = kafkaProcessor.getProducerProperties(producerField);
            try {
                Object producer = KafkaProducer.getConstructor(Properties.class).newInstance(properties);
                producerField.set(null, producer);
                LOG.debug("Injected kafka producer for " + producerField + " with config " + producerField.getAnnotation(KafkaProducerClient.class));
            }
            catch (Exception e) {
                throw new ExtensionConfigurationException("Unable to inject field " + producerField, (Throwable)e);
            }
        }
        List kafkaConsumerFields = AnnotationSupport.findAnnotatedFields(clazz, KafkaConsumerClient.class);
        for (Field consumerField : kafkaConsumerFields) {
            if (!KafkaConsumer.isAssignableFrom(consumerField.getType())) {
                throw new ExtensionConfigurationException("Fields annotated with @KafkaConsumerClient must be of the type " + KafkaConsumer.getName());
            }
            if (!Modifier.isPublic(consumerField.getModifiers()) || !Modifier.isStatic(consumerField.getModifiers()) || Modifier.isFinal(consumerField.getModifiers())) {
                throw new ExtensionConfigurationException("The KafkaProducer field annotated with @KafkaConsumerClient must be public, static, and non-final: " + consumerField);
            }
            Properties properties = kafkaProcessor.getConsumerProperties(consumerField);
            KafkaConsumerClient consumerConfig = consumerField.getAnnotation(KafkaConsumerClient.class);
            try {
                Object consumer = KafkaConsumer.getConstructor(Properties.class).newInstance(properties);
                consumerField.set(null, consumer);
                LOG.debug("Injected kafka consumer for " + consumerField + " with config " + consumerConfig);
                if (consumerConfig.topics().length <= 0) continue;
                List<String> topics = Arrays.asList(consumerConfig.topics());
                KafkaConsumer.getMethod("subscribe", Collection.class).invoke(consumer, topics);
                LOG.debug("Subscribed kafka consumer for " + consumerField + " to topics " + topics);
            }
            catch (Exception e) {
                throw new ExtensionConfigurationException("Unable to inject field " + consumerField, (Throwable)e);
            }
        }
    }

    private static void configureRestAssured(ApplicationEnvironment config) {
        if (!config.configureRestAssured()) {
            return;
        }
        Class<?> RestAssured = MicroShedTestExtension.tryLoad("io.restassured.RestAssured");
        if (RestAssured == null) {
            return;
        }
        try {
            URL appURL = new URL(config.getApplicationURL());
            String baseURI = appURL.getProtocol() + "://" + appURL.getHost();
            int port = appURL.getPort();
            String basePath = appURL.getPath();
            LOG.info("Configuring RestAssured with baseURI=" + baseURI + "  port=" + port + "  basePath=" + basePath);
            RestAssured.getField("baseURI").set(null, baseURI);
            RestAssured.getField("basePath").set(null, basePath);
            RestAssured.getField("port").set(null, port);
        }
        catch (Exception e) {
            LOG.warn("Unable to configure REST Assured because of: " + e.getMessage(), e);
        }
        try {
            ClassLoader cl = MicroShedTestExtension.class.getClassLoader();
            Class<?> ObjectMapperType = Class.forName("io.restassured.mapper.ObjectMapperType", false, cl);
            Object JSONB = Enum.valueOf(ObjectMapperType, "JSONB");
            Class<?> ObjectMapperConfig = Class.forName("io.restassured.config.ObjectMapperConfig", false, cl);
            Object omConfig = ObjectMapperConfig.getMethod("objectMapperConfig", new Class[0]).invoke(null, new Object[0]);
            omConfig = omConfig.getClass().getMethod("defaultObjectMapperType", ObjectMapperType).invoke(omConfig, JSONB);
            Class<?> RestAssuredConfig = Class.forName("io.restassured.config.RestAssuredConfig", false, cl);
            Object raConfig = RestAssured.getField("config").get(null);
            raConfig = RestAssuredConfig.getMethod("objectMapperConfig", ObjectMapperConfig).invoke(raConfig, omConfig);
            RestAssured.getField("config").set(null, raConfig);
            LOG.debug("Regsitered JSONB ObjectMapper for REST Assured");
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Unable to configure JSON-B object mapper for REST Assured due to: " + e.getMessage());
        }
        catch (Exception e) {
            LOG.warn("Unable to configure JSON-B object mapper for REST Assured", e);
        }
    }

    private static Optional<Class<? extends Annotation>> getMpRestClient() {
        return Optional.ofNullable(MicroShedTestExtension.tryLoad("org.eclipse.microprofile.rest.client.inject.RestClient"));
    }

    private static Class<?> tryLoad(String clazz) {
        try {
            return Class.forName(clazz, false, MicroShedTestExtension.class.getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError e) {
            return null;
        }
    }
}

