/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.jupiter;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.microshed.testing.kafka.KafkaConsumerClient;
import org.microshed.testing.kafka.KafkaProducerClient;

class KafkaConfigAnnotationProcessor {
    private final Map<Class<?>, String> defaultSerailizers = new HashMap();
    private final Map<Class<?>, String> defaultDeserailizers = new HashMap();
    private final String globalBootstrapServers = System.getProperty("org.microshed.kafka.bootstrap.servers");

    KafkaConfigAnnotationProcessor() {
        this.defaultSerailizers.put(byte[].class, "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.defaultSerailizers.put(ByteBuffer.class, "org.apache.kafka.common.serialization.ByteBufferSerializer");
        this.defaultSerailizers.put(Double.class, "org.apache.kafka.common.serialization.DoubleSerializer");
        this.defaultSerailizers.put(Float.class, "org.apache.kafka.common.serialization.FloatSerializer");
        this.defaultSerailizers.put(Integer.class, "org.apache.kafka.common.serialization.IntegerSerializer");
        this.defaultSerailizers.put(Long.class, "org.apache.kafka.common.serialization.LongSerializer");
        this.defaultSerailizers.put(Short.class, "org.apache.kafka.common.serialization.ShortSerializer");
        this.defaultSerailizers.put(String.class, "org.apache.kafka.common.serialization.StringSerializer");
        this.defaultSerailizers.put(UUID.class, "org.apache.kafka.common.serialization.UUIDSerializer");
        this.defaultDeserailizers.put(byte[].class, "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        this.defaultDeserailizers.put(ByteBuffer.class, "org.apache.kafka.common.serialization.ByteBufferDeserializer");
        this.defaultDeserailizers.put(Double.class, "org.apache.kafka.common.serialization.DoubleDeserializer");
        this.defaultDeserailizers.put(Float.class, "org.apache.kafka.common.serialization.FloatDeserializer");
        this.defaultDeserailizers.put(Integer.class, "org.apache.kafka.common.serialization.IntegerDeserializer");
        this.defaultDeserailizers.put(Long.class, "org.apache.kafka.common.serialization.LongDeserializer");
        this.defaultDeserailizers.put(Short.class, "org.apache.kafka.common.serialization.ShortDeserializer");
        this.defaultDeserailizers.put(String.class, "org.apache.kafka.common.serialization.StringDeserializer");
        this.defaultDeserailizers.put(UUID.class, "org.apache.kafka.common.serialization.UUIDDeserializer");
    }

    Properties getProducerProperties(Field producerField) {
        String bootstrapServers;
        KafkaProducerClient producerConfig = producerField.getAnnotation(KafkaProducerClient.class);
        Properties properties = new Properties();
        String string = bootstrapServers = producerConfig.bootstrapServers().isEmpty() ? this.globalBootstrapServers : producerConfig.bootstrapServers();
        if (bootstrapServers.isEmpty()) {
            throw new ExtensionConfigurationException("To use @KafkaProducerClient on a KafkaProducer a bootstrap server must be defined in the @KafkaProducerClient annotation or using the 'org.microshed.kafka.bootstrap.servers' system property");
        }
        properties.put("bootstrap.servers", bootstrapServers);
        if (KafkaConfigAnnotationProcessor.isClassPropertySet(producerConfig.keySerializer().getName())) {
            properties.put("key.serializer", producerConfig.keySerializer().getName());
        }
        if (KafkaConfigAnnotationProcessor.isClassPropertySet(producerConfig.valueSerializer().getName())) {
            properties.put("value.serializer", producerConfig.valueSerializer().getName());
        }
        for (String prop : producerConfig.properties()) {
            int split = prop.indexOf("=");
            if (split < 2) {
                throw new ExtensionConfigurationException("The property '" + prop + "' for field " + producerField + " must be in the format 'key=value'");
            }
            properties.put(prop.substring(0, split), prop.substring(split + 1));
        }
        if (producerField.getGenericType() instanceof ParameterizedType) {
            Type valueType;
            Type keyType;
            if (!properties.containsKey("key.serializer") && this.defaultSerailizers.containsKey(keyType = ((ParameterizedType)producerField.getGenericType()).getActualTypeArguments()[0])) {
                properties.put("key.serializer", this.defaultSerailizers.get(keyType));
            }
            if (!properties.containsKey("value.serializer") && this.defaultSerailizers.containsKey(valueType = ((ParameterizedType)producerField.getGenericType()).getActualTypeArguments()[1])) {
                properties.put("value.serializer", this.defaultSerailizers.get(valueType));
            }
        }
        return properties;
    }

    Properties getConsumerProperties(Field consumerField) {
        String bootstrapServers;
        KafkaConsumerClient consumerConfig = consumerField.getAnnotation(KafkaConsumerClient.class);
        Properties properties = new Properties();
        String string = bootstrapServers = consumerConfig.bootstrapServers().isEmpty() ? this.globalBootstrapServers : consumerConfig.bootstrapServers();
        if (bootstrapServers.isEmpty()) {
            throw new ExtensionConfigurationException("To use @KafkaConsumerClient on a KafkaConsumer a bootstrap server must be defined in the @KafkaConsumerClient annotation or using the 'org.microshed.kafka.bootstrap.servers' system property");
        }
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("group.id", consumerConfig.groupId());
        if (KafkaConfigAnnotationProcessor.isClassPropertySet(consumerConfig.keyDeserializer().getName())) {
            properties.put("key.deserializer", consumerConfig.keyDeserializer().getName());
        }
        if (KafkaConfigAnnotationProcessor.isClassPropertySet(consumerConfig.valueDeserializer().getName())) {
            properties.put("value.deserializer", consumerConfig.valueDeserializer().getName());
        }
        for (String prop : consumerConfig.properties()) {
            int split = prop.indexOf("=");
            if (split < 2) {
                throw new ExtensionConfigurationException("The property '" + prop + "' for field " + consumerField + " must be in the format 'key=value'");
            }
            properties.put(prop.substring(0, split), prop.substring(split + 1));
        }
        if (consumerField.getGenericType() instanceof ParameterizedType) {
            Type valueType;
            Type keyType;
            if (!properties.containsKey("key.deserializer") && this.defaultDeserailizers.containsKey(keyType = ((ParameterizedType)consumerField.getGenericType()).getActualTypeArguments()[0])) {
                properties.put("key.deserializer", this.defaultDeserailizers.get(keyType));
            }
            if (!properties.containsKey("value.deserializer") && this.defaultDeserailizers.containsKey(valueType = ((ParameterizedType)consumerField.getGenericType()).getActualTypeArguments()[1])) {
                properties.put("value.deserializer", this.defaultDeserailizers.get(valueType));
            }
        }
        return properties;
    }

    private static boolean isClassPropertySet(String prop) {
        return !"java.lang.Object".equals(prop);
    }
}

