/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.jaxrs;

import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.lang.reflect.AnnotatedElement;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.microshed.testing.ApplicationEnvironment;
import org.microshed.testing.internal.InternalLogger;
import org.microshed.testing.jaxrs.JsonBProvider;

public class RestClientBuilder {
    private static final InternalLogger LOG = InternalLogger.get(RestClientBuilder.class);
    private String appContextRoot;
    private String jaxrsPath;
    private String jwt;
    private String basicAuth;
    private List<Class<?>> providers;
    private final Map<String, String> headers = new HashMap<String, String>();

    public RestClientBuilder withAppContextRoot(String appContextRoot) {
        Objects.requireNonNull(appContextRoot, "Supplied 'appContextRoot' must not be null");
        this.appContextRoot = appContextRoot;
        return this;
    }

    public RestClientBuilder withJaxrsPath(String jaxrsPath) {
        Objects.requireNonNull(jaxrsPath, "Supplied 'jaxrsPath' must not be null");
        this.jaxrsPath = jaxrsPath;
        return this;
    }

    public RestClientBuilder withJwt(String jwt) {
        Objects.requireNonNull(jwt, "Supplied 'jwt' must not be null");
        if (this.basicAuth != null) {
            throw new IllegalArgumentException("Cannot configure JWT and Basic Auth on the same REST client");
        }
        this.jwt = jwt;
        this.headers.put("Authorization", "Bearer " + jwt);
        LOG.debug("Using provided JWT auth header: " + jwt);
        return this;
    }

    public RestClientBuilder withBasicAuth(String user, String password) {
        Objects.requireNonNull(user, "Supplied 'user' must not be null");
        Objects.requireNonNull(password, "Supplied 'password' must not be null");
        if (this.jwt != null) {
            throw new IllegalArgumentException("Cannot configure JWT and Basic Auth on the same REST client");
        }
        String unEncoded = user + ":" + password;
        this.basicAuth = Base64.getEncoder().encodeToString(unEncoded.getBytes(StandardCharsets.UTF_8));
        this.headers.put("Authorization", "Basic " + this.basicAuth);
        LOG.debug("Using provided Basic auth header: " + unEncoded + " --> " + this.basicAuth);
        return this;
    }

    public RestClientBuilder withHeader(String key, String value) {
        Objects.requireNonNull(key, "Supplied header 'key' must not be null");
        Objects.requireNonNull(value, "Supplied header 'value' must not be null");
        if (this.jwt != null) {
            throw new IllegalArgumentException("Cannot configure JWT and Basic Auth on the same REST client");
        }
        this.headers.put(key, value);
        LOG.debug("Using provided header " + key + "=" + value);
        return this;
    }

    public RestClientBuilder withProviders(Class<?> ... providers) {
        this.providers = Arrays.asList(providers);
        return this;
    }

    public <T> T build(Class<T> clazz) {
        if (this.appContextRoot == null) {
            this.appContextRoot = ApplicationEnvironment.Resolver.load().getApplicationURL();
        }
        if (this.jaxrsPath == null) {
            this.jaxrsPath = RestClientBuilder.locateApplicationPath(clazz);
        }
        if (this.providers == null) {
            this.providers = Collections.singletonList(JsonBProvider.class);
        }
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        String basePath = RestClientBuilder.join(this.appContextRoot, this.jaxrsPath);
        LOG.info("Building rest client for " + clazz + " with base path: " + basePath + " and providers: " + this.providers);
        bean.setResourceClass(clazz);
        bean.setProviders(this.providers);
        bean.setAddress(basePath);
        bean.setHeaders(this.headers);
        return (T)bean.create(clazz, new Object[0]);
    }

    private static String locateApplicationPath(Class<?> clazz) {
        String resourcePackage = clazz.getPackage().getName();
        if (AnnotationSupport.isAnnotated(clazz, ApplicationPath.class)) {
            return ((ApplicationPath)AnnotationSupport.findAnnotation(clazz, ApplicationPath.class).get()).value();
        }
        List appClasses = ReflectionSupport.findAllClassesInPackage((String)resourcePackage, c -> Application.class.isAssignableFrom((Class<?>)c) && AnnotationSupport.isAnnotated((AnnotatedElement)c, ApplicationPath.class), n -> true);
        if (appClasses.size() == 0) {
            LOG.debug("no classes implementing Application found in pkg: " + resourcePackage);
            String[] pkgs = resourcePackage.split("\\.");
            if (pkgs.length > 3) {
                String checkPkg = pkgs[0] + "." + pkgs[1] + "." + pkgs[2];
                LOG.debug("checking in pkg: " + checkPkg);
                appClasses = ReflectionSupport.findAllClassesInPackage((String)checkPkg, c -> Application.class.isAssignableFrom((Class<?>)c) && AnnotationSupport.isAnnotated((AnnotatedElement)c, ApplicationPath.class), n -> true);
            }
        }
        if (appClasses.size() == 0) {
            LOG.info("No classes implementing 'jakarta.ws.rs.core.Application' found on classpath to set base path from " + clazz + ". Defaulting base path to '/'");
            return "";
        }
        Class selectedClass = (Class)appClasses.stream().sorted((c1, c2) -> c1.getName().compareTo(c2.getName())).findFirst().get();
        ApplicationPath appPath = (ApplicationPath)AnnotationSupport.findAnnotation((AnnotatedElement)selectedClass, ApplicationPath.class).get();
        if (appClasses.size() > 1) {
            LOG.warn("Found multiple classes implementing 'jakarta.ws.rs.core.Application' on classpath: " + appClasses + ". Setting base path from the first class discovered (" + selectedClass.getCanonicalName() + ") with path: " + appPath.value());
        }
        LOG.debug("Using base ApplicationPath of '" + appPath.value() + "'");
        return appPath.value();
    }

    private static String join(String firstPart, String secondPart) {
        if (firstPart.endsWith("/") && secondPart.startsWith("/")) {
            return firstPart + secondPart.substring(1);
        }
        if (firstPart.endsWith("/") || secondPart.startsWith("/")) {
            return firstPart + secondPart;
        }
        return firstPart + "/" + secondPart;
    }
}

