/*
 * Decompiled with CFR 0.152.
 */
package org.microshed.testing.jaxrs;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Scanner;
import org.microshed.testing.internal.InternalLogger;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class JsonBProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private static final Jsonb jsonb = JsonbBuilder.create();
    private static final InternalLogger LOG = InternalLogger.get(JsonBProvider.class);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class<Object> clazz, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String stringResult = JsonBProvider.convertStreamToString(entityStream);
        LOG.info("Response from server: " + stringResult);
        return jsonb.fromJson(stringResult, genericType);
    }

    private static String convertStreamToString(InputStream is) {
        try (Scanner s = new Scanner(is).useDelimiter("\\A");){
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public void writeTo(Object obj, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String strData = jsonb.toJson(obj);
        LOG.info("Sending data to server: " + strData);
        jsonb.toJson(obj, entityStream);
    }
}

